<?php
/**
 * List performance view.
 *
 * @param object $current
 * @param object $stats
 * @return void
 */
function pa_include_wocommerce_lists_performance( $current, $stats ) {

	if ( isset( $stats['rows'] ) && isset( $stats['rows'][0][0] ) ) {
		$famous = $stats['rows'][0][0]; 
	} ?>

    <div class="analytify_general_status analytify_status_box_wraper">
      <div class="analytify_status_header">
	  	<h3>
          <?php esc_html_e( 'Product lists Analysis', 'wp-analytify-woocommerce' ); ?>
          <a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="product-lists-analysis">
            <span class="analytify_tooltiptext"><?php _e( 'Export Product lists Analysis', 'wp-analytify-pro' ) ?></span>
          </a>
          <img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
        </h3>
      </div>
      <div class="analytify_status_body">

        <table class="analytify_data_tables">
          <thead>
            <tr>
              <th class="wd_1">
                #
              </th>
              <th>
                <?php esc_html_e( 'List Name', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th>
                <?php esc_html_e( 'Product List Views', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Product List Clicks', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Product List CTR', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Product Adds to Cart', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Product Checkouts', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Unique Purchases', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Product Revenue', 'wp-analytify-woocommerce' ); ?>
              </th>
            </tr>
          </thead>
          <tbody>

            <?php if ( ! empty( $stats['rows'] ) ) {
              $i = 0;
              foreach ( $stats['rows'] as $stat ) {
                $i++;
                ?>
                <tr>
                  <td>
                    <?php echo $i; ?>
                  </td>
                  <td>
                    <?php echo $stat[0]; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat[1]; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat[2]; ?>
                  </td>
                  <td>
                    <?php $percent_quantity = number_format( $stat[3], 2 );?>
                    <?php echo $percent_quantity; ?> %
                    <span class="analytify_bar_graph">
                      <span style="width: <?php echo $percent_quantity ?>%;"></span>
                    </span>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat[4]; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat[5]; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat[6]; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo get_woocommerce_currency_symbol() . number_format( $stat[7], 2 ) ?>
                  </td>
                </tr>
                <?php
              }
            } else { ?>
              <tr>
                <td class="analytify_td_error_msg" colspan="9">
                  <?php $current->no_records(); ?>
                </td>
              </tr>
              <?php }
              ?>
            </tbody>
          </table>
        </div>
        <div class="analytify_status_footer">

	<?php if ( isset( $stat[0] ) ) : ?>
	<span class="analytify_info_stats">
		<?php
		echo sprintf( esc_html__( 'Did you know the big Revenue generated from Product List in your store is %1$s %2$s %3$s?', 'wp-analytify-woocommerce' ), '<strong>' , $famous , '</strong>' );
		?>
	</span>
	<?php endif; ?>

	</div>
</div>

<?php 
}
