<?php
/**
 * Measuring roi view.
 * 
 * @param object $current Analytify Free object.
 * @param object $stats   Contains stats that are fetch from google.
 * @param string $report_url
 * @param string $report_date_range
 * @return void
 * @since  2.0.6
 */
function wpa_woo_measuring_roi( $current, $stats, $report_url, $report_date_range ) {

	if ( isset( $stats['rows'] ) && isset( $stats['rows'][0]['sourceMedium'] ) ) {
		$famous = $stats['rows'][0]['sourceMedium']; 
	} ?>

	<div class="analytify_general_status analytify_status_box_wraper">
	<div class="analytify_status_header">
		<h3>
		<?php esc_html_e( 'Measuring ROI', 'wp-analytify-woocommerce' ); ?>
		<a href="<?php echo method_exists( 'WPANALYTIFY_Utils', 'get_all_stats_link' ) ? WPANALYTIFY_Utils::get_all_stats_link( $report_url, 'source_medium', $report_date_range ) : '#'; ?>" target="_blank" class="analytify_tooltip"><span class="analytify_tooltiptext"><?php _e( 'View All Top ROI', 'wp-analytify-woocommerce' ); ?></span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>
		<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="measuring-roi">
			<span class="analytify_tooltiptext"><?php _e( 'Export Measuring ROI', 'wp-analytify-pro' ) ?></span>
		</a>
		<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
		</h3>
	</div>
	<div class="analytify_status_body">

		<table class="analytify_data_tables wp_analytify_paginated" data-product-per-page="10">
		<thead>
			<tr>
			<th class="analytify_table_header_no_events">
				#
			</th>
			<th>
				<?php esc_html_e( 'Source/Medium', 'wp-analytify-woocommerce' ); ?>
			</th>
			<th>
				<?php esc_html_e( 'Session', 'wp-analytify-woocommerce' ); ?>
			</th>
			<th >
				<?php esc_html_e( 'Bounce Rate', 'wp-analytify-woocommerce' ); ?>
			</th>
			<th >
				<?php esc_html_e( 'Transactions Revenue', 'wp-analytify-woocommerce' ); ?>
			</th>
			</tr>
		</thead>
		<tbody>
			<?php if ( ! empty( $stats['rows'] ) ) {
				$i = 0;
				foreach ( $stats['rows'] as $stat ) {
					$i++;
					?>
					<tr>
					<td>
						<?php echo $i; ?>
					</td>
					<td>
						<?php echo $stat['sourceMedium'] ; ?>
					</td>
					<td class="analytify_txt_center">
						<?php echo WPANALYTIFY_Utils::pretty_numbers( $stat['sessions'] ) ; ?>
					</td>
					<td class="analytify_txt_center">
						<?php echo WPANALYTIFY_Utils::pretty_numbers( $stat['bounceRate'] ) . '%'; ?>
					</td>
					<td class="analytify_txt_center">
					<?php
					$currency_code = ( isset( $stat['currencyCode'] ) && $stat['currencyCode'] !== '(not set)' ) ? $stat['currencyCode'] : '';
					echo WP_Analytify_WooCommerce_Addon::analytify_format_currency($stat['purchaseRevenue'], $currency_code);
					?>
					</td>
					</tr>
					<?php
				}
			} else { ?>
			<tr>
				<td class='analytify_td_error_msg' colspan='6'>
				<?php $current->no_records(); ?>
				</td>
			</tr>
			<?php } ?>
		</tbody>
		</table>
	</div>
	<div class="analytify_status_footer">
		<span class="analytify_info_stats">
		<?php
		if ( isset( $stat['sourceMedium'] ) ) :
		echo sprintf( esc_html__( 'Did you know the famous Source of Sale is %1$s %2$s %3$s?', 'wp-analytify-woocommerce' ), '<strong>' , trim($famous) , '</strong>' );
		else :
		esc_html_e( 'List of all the sources of sale.', 'wp-analytify-woocommerce' );
		endif;
		?>
		</span>
			<div class="wp_analytify_pagination"></div>
		</div>
	</div>
		
<?php 
}