<?php
/**
 * Shopping analysis stats.
 *
 * @param object $current
 * @param object $stats
 * @return void
 */
function pa_include_woocommerce( $current, $stats ) { 
	ob_start();
	?>

    <div class="analytify_general_status analytify_status_box_wraper">
        <div class="analytify_status_header">
            <h3><?php esc_html_e( 'Overview', 'wp-analytify-woocommerce' ) ?></h3>
        </div>
        <div class="analytify_status_body">
            <div class="analytify_general_status_boxes_wraper">
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Transactions', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo number_format($stats->totalsForAllResults['ga:transactions']); ?></div>
                    <p><?php esc_html_e( 'Transactions is the total number of completed purchases on your site', 'wp-analytify-woocommerce' ) ?>.</p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Transaction Revenues', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo get_woocommerce_currency_symbol() . number_format( $stats->totalsForAllResults['ga:transactionRevenue'], 2 ); ?></div>
                    <p><?php esc_html_e( 'The total sale revenue provided in the transaction including or excluding shipping and tax.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Average Order Value', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo get_woocommerce_currency_symbol() . number_format( $stats->totalsForAllResults['ga:revenuePerTransaction'], 2 ); ?></div>
                    <p><?php esc_html_e( 'Average Value of transactions.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Product Adds To Cart', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo $stats->totalsForAllResults['ga:productAddsToCart']; ?></div>
                    <p><?php esc_html_e( 'The total number of items Added in cart whether it is purchased or not.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Product Removes From Cart', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo $stats->totalsForAllResults['ga:productRemovesFromCart']; ?></div>
                    <p><?php esc_html_e( 'The total number of items Removed from cart whether it is purchased or not.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Product Checkouts', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo $stats->totalsForAllResults['ga:productCheckouts']; ?></div>
                    <p><?php esc_html_e( 'The total number of checkouts.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Unique Purchases', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo $stats->totalsForAllResults['ga:uniquePurchases']; ?></div>
                    <p><?php esc_html_e( 'The total number of items purchased. For example, if users purchase 2 frisbees and 5 tennis balls, 2 unique products have been purchased.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Product Clicks', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value"><?php echo $stats->totalsForAllResults['ga:productListClicks']; ?></div>
                    <p><?php esc_html_e( 'The total number of user Clicks on your item.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
                <div class="analytify_general_status_boxes">
                    <h4><?php esc_html_e( 'Product Detail Views', 'wp-analytify-woocommerce' ) ?></h4>
                    <div class="analytify_general_stats_value">  <?php echo $stats->totalsForAllResults['ga:productDetailViews']; ?></div>
                    <p><?php esc_html_e( 'Number of times users viewed the product detail page.', 'wp-analytify-woocommerce' ) ?></p>
                </div>
            </div>
        </div>
        <div class="analytify_status_footer">
            <span class="analytify_info_stats">    <?php
            echo sprintf( esc_html__( 'Did you know that the Conversion Rate in your store is %1$s', 'wp-analytify-woocommerce' ), number_format( $stats->totalsForAllResults['ga:transactionsPerSession'], 2) ) . '%?'; ?></span>
        </div>
    </div>
<?php 
wp_send_json( array( 
	'body' => ob_get_clean()
) );
}
