<?php
// Display World Map at front-side.
function pa_include_worldmap($current, $worldmap_stats)
{
  // Apply the filter to get the colors
  $colors = apply_filters('analytify_world_map_shortcode_colors', false);

?>
  <div class="data_boxes">
    <div class="data_boxes_title"><?php _e('Top Countries', 'wp-analytify'); ?> <div class="arrow_btn"></div>
    </div>
    <div class="data_container">
      <?php
      if (!empty($worldmap_stats["rows"])) {
        // Load the Google Charts library (recommended approach)
        wp_enqueue_script('jsapi', 'https://www.google.com/jsapi', array(), null, true);
      ?>
        <div id="wm_chart_div" style="width: 600px; margin:0 auto; aspect-ratio: 4/3; max-width: 100%;"></div>

        <script>
          document.addEventListener('DOMContentLoaded', function() {
            google.charts.load('current', {
              packages: ['geochart'],
              callback: drawRegionsMap
            });
			let previousWidth = 0, previousHeight = 0;
			// Debounce function to limit the number of redraws on resize
			function debounce(func, wait) {
			let timeout;
			return function() {
				clearTimeout(timeout);
				timeout = setTimeout(func, wait);
			};
			}

			// Check if the canvas size has changed
			function checkCanvasSizeChanged() {
			const container = document.getElementById('wm_chart_div');
			const currentWidth = container.offsetWidth;
			const currentHeight = container.offsetHeight;

			// Only redraw if size has changed
			if (currentWidth !== previousWidth || currentHeight !== previousHeight) {
				previousWidth = currentWidth;
				previousHeight = currentHeight;
				drawRegionsMap();
			}
			}

			// Attach the debounced function to window resize, with canvas size check
			window.addEventListener('resize', debounce(checkCanvasSizeChanged, 250));
			
            function drawRegionsMap() {
              var data = google.visualization.arrayToDataTable([
                ['Country', 'Visitors'],
                <?php
                foreach ($worldmap_stats["rows"] as $c_stats) {
                  echo "['" . esc_js($c_stats['country']) . "', " . esc_js($c_stats['sessions']) . "],";
                }
                ?>
              ]);

              var options = {
                displayMode: 'regions',
				responsive: true,
              };

              // PHP variable to JavaScript
              var colors = <?php echo json_encode($colors); ?>;
              if (colors) {
                options.colorAxis = {
                  colors: colors
                };
              }

              var formatter = new google.visualization.NumberFormat({
                fractionDigits: 0
              });
              formatter.format(data, 1);

              var chart = new google.visualization.GeoChart(document.getElementById('wm_chart_div'));
              chart.draw(data, options);
            }
          });
        </script>
      <?php
      } ?>
    </div>
  </div>
<?php
}
