<?php
/**
 * Plugin Name: Custom Multisite Plugin Manager
 * Description: Plugin to manage and customize allowed plugins for multisite sub-sites.
 * Version: 2.0
 * Author: يوسف رضا
 */

// منع الوصول المباشر
if (!defined('ABSPATH')) {
    exit;
}

// 1. إضافة إعدادات للشبكة لإدارة أسماء البلجنز والسماح بإضافة بلجنز جديدة
add_action('network_admin_menu', 'custom_multisite_plugin_menu');
function custom_multisite_plugin_menu() {
    add_menu_page(
        'Manage Allowed Plugins',
        'Allowed Plugins',
        'manage_network_options',
        'custom-allowed-plugins',
        'custom_allowed_plugins_page'
    );
}

function custom_allowed_plugins_page() {
    if (isset($_POST['save_allowed_plugins'])) {
        $allowed_plugins = isset($_POST['allowed_plugins']) ? $_POST['allowed_plugins'] : [];
        $custom_names = isset($_POST['custom_plugin_names']) ? $_POST['custom_plugin_names'] : [];
        update_site_option('allowed_plugins', $allowed_plugins);
        update_site_option('custom_plugin_names', $custom_names);
        echo '<div class="updated"><p>Plugins updated successfully!</p></div>';
    }

    $all_plugins = get_plugins();
    $allowed_plugins = get_site_option('allowed_plugins', []);
    $custom_plugin_names = get_site_option('custom_plugin_names', []);

    echo '<div class="wrap">';
    echo '<h1>Manage Allowed Plugins</h1>';
    echo '<form method="post">';
    echo '<table class="form-table">';
    echo '<tr><th>Plugin</th><th>Custom Name</th><th>Allow</th></tr>';
    foreach ($all_plugins as $plugin_file => $plugin_data) {
        $checked = in_array($plugin_file, $allowed_plugins) ? 'checked' : '';
        $custom_name = isset($custom_plugin_names[$plugin_file]) ? $custom_plugin_names[$plugin_file] : $plugin_data['Name'];
        echo '<tr>';
        echo '<td>' . esc_html($plugin_data['Name']) . '</td>';
        echo '<td><input type="text" name="custom_plugin_names[' . esc_attr($plugin_file) . ']" value="' . esc_attr($custom_name) . '"></td>';
        echo '<td><input type="checkbox" name="allowed_plugins[]" value="' . esc_attr($plugin_file) . '" ' . $checked . '></td>';
        echo '</tr>';
    }
    echo '</table>';
    echo '<p><input type="submit" name="save_allowed_plugins" class="button-primary" value="Save Changes"></p>';
    echo '</form>';
    echo '</div>';
}

// 2. عرض البلجنز في المواقع الفرعية مع أزرار التفعيل/التعطيل
add_action('admin_menu', 'custom_add_plugins_page_subsite');
function custom_add_plugins_page_subsite() {
    if (!is_main_site()) {
        add_menu_page(
            'Allowed Plugins',
            'My Plugins',
            'activate_plugins',
            'my-plugins',
            'custom_show_allowed_plugins'
        );
    }
}

function custom_show_allowed_plugins() {
    $allowed_plugins = get_site_option('allowed_plugins', []);
    $custom_plugin_names = get_site_option('custom_plugin_names', []);
    $active_plugins = get_option('active_plugins', []);

    $all_plugins = get_plugins();

    echo '<div class="wrap">';
    echo '<h1>My Plugins</h1>';
    echo '<table class="wp-list-table widefat fixed striped">';
    echo '<thead><tr><th>Plugin</th><th>Action</th><th>Description</th></tr></thead><tbody>';
    foreach ($all_plugins as $plugin_file => $plugin_data) {
        if (in_array($plugin_file, $allowed_plugins)) {
            $custom_name = isset($custom_plugin_names[$plugin_file]) ? $custom_plugin_names[$plugin_file] : $plugin_data['Name'];
            $description = $plugin_data['Description'];
            $is_active = in_array($plugin_file, $active_plugins);
            $action_button = $is_active
                ? '<a href="?deactivate_plugin=' . esc_attr($plugin_file) . '" class="button-secondary">Deactivate</a>'
                : '<a href="?activate_plugin=' . esc_attr($plugin_file) . '" class="button-primary">Activate</a>';
            echo '<tr>';
            echo '<td>' . esc_html($custom_name) . '</td>';
            echo '<td>' . $action_button . '</td>';
            echo '<td><button onclick="alert(`' . esc_js($description) . '`)" class="button">Description</button></td>';
            echo '</tr>';
        }
    }
    echo '</tbody></table>';
    echo '</div>';
}

// 3. تفعيل وإلغاء تفعيل البلجنز
add_action('admin_init', 'custom_handle_plugin_actions');
function custom_handle_plugin_actions() {
    if (isset($_GET['activate_plugin'])) {
        $plugin = sanitize_text_field($_GET['activate_plugin']);
        activate_plugin($plugin);
        wp_redirect(admin_url('admin.php?page=my-plugins'));
        exit;
    }

    if (isset($_GET['deactivate_plugin'])) {
        $plugin = sanitize_text_field($_GET['deactivate_plugin']);
        deactivate_plugins($plugin);
        wp_redirect(admin_url('admin.php?page=my-plugins'));
        exit;
    }
}

// 4. السماح للمواقع الفرعية برفع البلجنز
add_action('admin_menu', 'custom_add_plugin_uploader');
function custom_add_plugin_uploader() {
    if (!is_main_site()) {
        add_submenu_page(
            'my-plugins',
            'Upload Plugin',
            'Upload Plugin',
            'install_plugins',
            'upload-plugin',
            'custom_plugin_uploader_page'
        );
    }
}

function custom_plugin_uploader_page() {
    echo '<div class="wrap">';
    echo '<h1>Upload Plugin</h1>';
    echo '<form method="post" enctype="multipart/form-data">';
    echo '<input type="file" name="plugin_zip" required>';
    echo '<p><button type="submit" name="upload_plugin" class="button-primary">Upload and Install</button></p>';
    echo '</form>';
    echo '</div>';

    if (isset($_POST['upload_plugin'])) {
        $file = $_FILES['plugin_zip'];
        if ($file['type'] === 'application/zip') {
            $upload_dir = wp_upload_dir();
            $dest = $upload_dir['path'] . '/' . $file['name'];
            move_uploaded_file($file['tmp_name'], $dest);
            WP_Filesystem();
            unzip_file($dest, WP_PLUGIN_DIR);
            echo '<div class="updated"><p>Plugin uploaded and installed successfully!</p></div>';
        } else {
            echo '<div class="error"><p>Please upload a valid ZIP file.</p></div>';
        }
    }
}