<?php
/*
Plugin Name: Sity Cloud Checkout Pro
Description: Checkout مخصص لسايتي كلاود (لوجو + Stepper + تصميم زجاجي + بوكس تفاصيل الباقة).
Author: Youssef Reda & AI Assistant
Version: 1.4
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * تحميل CSS و JS في صفحة الـ Checkout فقط
 */
add_action( 'wp_enqueue_scripts', 'sity_checkout_pro_enqueue_assets' );
function sity_checkout_pro_enqueue_assets() {
    if ( ! function_exists( 'is_checkout' ) || ! is_checkout() ) {
        return;
    }

    // تسجيل ستايل خاص بينا
    wp_register_style(
        'sity-checkout-pro',
        false,
        array(),
        null
    );
    wp_enqueue_style( 'sity-checkout-pro' );
    wp_add_inline_style( 'sity-checkout-pro', sity_checkout_pro_get_css() );

    // تسجيل سكربت خاص بينا
    wp_register_script(
        'sity-checkout-pro',
        false,
        array( 'jquery' ),
        null,
        true
    );
    wp_enqueue_script( 'sity-checkout-pro' );
    wp_add_inline_script( 'sity-checkout-pro', sity_checkout_pro_get_js() );
}

/**
 * CSS – تصميم لايت مود / بنفسجي / زجاجي + Stepper + أزرار + وسائل الدفع
 * مع عرض كامل للشاشة
 */
function sity_checkout_pro_get_css() {

    return "
    /* ====== Sity Cloud Checkout Pro (v1.4) ====== */

    body.woocommerce-checkout {
        background: radial-gradient(circle at top left, #f4ebff 0, #f9f7ff 40%, #f5f7ff 100%);
    }

    .woocommerce-checkout .site-main,
    .woocommerce-checkout main,
    .woocommerce-checkout .entry-content,
    .woocommerce-checkout .container {
        background: transparent !important;
        max-width: 100% !important;
        padding: 0 !important;
        margin: 0 !important;
    }

    .sity-checkout-wrapper {
        width: 100%;
        padding: 20px clamp(10px, 4vw, 40px) 40px;
        box-sizing: border-box;
        font-family: 'Tajawal', system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    }

    .sity-checkout-inner {
        max-width: 1200px;
        margin: 0 auto;
    }

    .sity-checkout-heading {
        text-align: center;
        margin-bottom: 24px;
    }

    .sity-logo {
        width: 140px;
        max-width: 50%;
        margin-bottom: 10px;
    }

    .sity-checkout-heading h1 {
        font-size: clamp(24px, 3vw, 30px);
        font-weight: 800;
        color: #2f255e;
        margin-bottom: 4px;
    }

    .sity-checkout-heading p {
        font-size: 14px;
        color: #7b779c;
        margin: 0;
    }

    .sity-checkout-heading .sity-checkout-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 5px 12px;
        border-radius: 999px;
        background: rgba(123, 71, 255, 0.06);
        color: #6b46ff;
        font-size: 11px;
        margin-bottom: 10px;
        border: 1px solid rgba(123, 71, 255, 0.1);
    }

    .sity-checkout-heading .sity-checkout-badge span:first-child {
        font-weight: 700;
    }

    /* Stepper */

    .sity-stepper {
        display: flex;
        justify-content: center;
        gap: 16px;
        margin: 14px auto 20px;
        flex-wrap: wrap;
    }

    .sity-step-item {
        min-width: 150px;
        padding: 7px 14px;
        border-radius: 999px;
        background: rgba(255,255,255,0.9);
        border: 1px solid rgba(149,117,205,0.4);
        box-shadow: 0 8px 18px rgba(79, 54, 177, 0.12);
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 12px;
        color: #6a6495;
        position: relative;
        overflow: hidden;
        cursor: pointer;
    }

    .sity-step-item::before {
        content: '';
        width: 20px;
        height: 20px;
        border-radius: 999px;
        border: 2px solid rgba(123,71,255,0.35);
        display: inline-flex;
        margin-left: 2px;
        flex-shrink: 0;
        background: #ffffff;
    }

    .sity-step-item span.sity-step-title {
        font-weight: 600;
        color: #403975;
    }

    .sity-step-item span.sity-step-sub {
        font-size: 11px;
        color: #9a96be;
    }

    .sity-step-item.is-active {
        background: linear-gradient(135deg, #7b47ff, #c095ff);
        border-color: transparent;
        color: #ffffff;
        box-shadow: 0 10px 26px rgba(80,54,177,0.4);
    }

    .sity-step-item.is-active::before {
        background: #ffffff;
        border-color: rgba(255,255,255,0.9);
    }

    .sity-step-item.is-active span.sity-step-title,
    .sity-step-item.is-active span.sity-step-sub {
        color: #ffffff;
    }

    /* Layout – ياخد عرض الشاشة ومتلائم مع كل المقاسات */

    .sity-checkout-layout {
        display: grid;
        grid-template-columns: minmax(0, 1.8fr) minmax(0, 1.2fr);
        gap: 22px;
        width: 100%;
    }

    @media (max-width: 980px) {
        .sity-checkout-layout {
            grid-template-columns: 1fr;
        }
    }

    .sity-card {
        background: rgba(255,255,255,0.92);
        border-radius: 20px;
        padding: 22px 22px 20px;
        box-shadow: 0 20px 45px rgba(61, 44, 142, 0.10);
        backdrop-filter: blur(14px);
        border: 1px solid rgba(255,255,255,0.9);
        position: relative;
        overflow: hidden;
    }

    /* left card (فورم البيانات) يكون مميز أكتر */
    .sity-checkout-col-left .sity-card {
        background: radial-gradient(circle at top left, rgba(123, 71, 255, 0.10), rgba(255,255,255,0.96));
        border: 1px solid rgba(123,71,255,0.18);
    }

    .sity-card::before {
        content: '';
        position: absolute;
        inset: 0;
        background: radial-gradient(circle at top right, rgba(124, 92, 255, 0.08), transparent 55%);
        opacity: 0.95;
        pointer-events: none;
    }

    .sity-card-inner {
        position: relative;
        z-index: 1;
    }

    .sity-card h3 {
        font-size: 18px;
        font-weight: 700;
        margin-bottom: 14px;
        color: #312660;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .sity-card h3::before {
        content: '';
        display: inline-block;
        width: 9px;
        height: 24px;
        border-radius: 999px;
        background: linear-gradient(135deg, #7a3cff, #c07dff);
        box-shadow: 0 0 0 3px rgba(122,60,255,0.16);
    }

    /* Panels (Stepper) */

    .sity-step-panel {
        display: none;
    }

    .sity-step-panel.is-active {
        display: block;
        animation: sityFadeIn 0.28s ease-out;
    }

    @keyframes sityFadeIn {
        from { opacity: 0; transform: translateY(5px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .sity-step-actions {
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
        gap: 10px;
        flex-wrap: wrap;
    }

    .sity-btn {
        border-radius: 999px;
        border: none;
        padding: 9px 16px;
        font-size: 13px;
        font-weight: 700;
        font-family: 'Tajawal', system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        transition: all 0.16s ease;
    }

    .sity-btn-primary {
        background: linear-gradient(135deg, #7b47ff, #c095ff);
        color: #ffffff;
        box-shadow: 0 10px 26px rgba(80,54,177,0.35);
    }

    .sity-btn-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 14px 32px rgba(80,54,177,0.4);
    }

    .sity-btn-secondary {
        background: rgba(255,255,255,0.96);
        color: #5b5686;
        border: 1px solid rgba(149,117,205,0.35);
    }

    .sity-btn-secondary:hover {
        background: #ffffff;
        box-shadow: 0 8px 20px rgba(80,54,177,0.18);
    }

    @media (max-width: 600px) {
        .sity-step-actions {
            flex-direction: column;
        }
        .sity-step-actions .sity-btn {
            width: 100%;
            justify-content: center;
        }
    }

    /* فورم البيانات – تصميم قوي */

    .woocommerce-checkout form.checkout {
        background: transparent;
        border: none;
        padding: 0;
        margin: 0;
    }

    .woocommerce-billing-fields__field-wrapper {
        display: grid;
        grid-template-columns: repeat(2, minmax(0, 1fr));
        gap: 14px 18px;
    }

    @media (max-width: 768px) {
        .woocommerce-billing-fields__field-wrapper {
            grid-template-columns: 1fr;
        }
    }

    .woocommerce-checkout .form-row {
        margin-bottom: 4px;
    }

    .woocommerce-checkout .form-row label {
        font-size: 13px;
        color: #59547f;
        margin-bottom: 6px;
        display: inline-flex;
        align-items: center;
        gap: 4px;
    }

    .woocommerce-checkout .form-row label .required {
        color: #e63946;
    }

    .woocommerce-checkout .input-text,
    .woocommerce-checkout select {
        width: 100%;
        border-radius: 13px !important;
        border: 1px solid rgba(149, 117, 205, 0.35);
        padding: 11px 12px;
        font-size: 14px;
        background: rgba(255,255,255,0.96);
        transition: all 0.18s ease;
        box-shadow: 0 0 0 0 rgba(123, 71, 255, 0.0);
        outline: none;
    }

    .woocommerce-checkout .input-text:focus,
    .woocommerce-checkout select:focus {
        border-color: #7b47ff;
        box-shadow: 0 0 0 1px rgba(123, 71, 255, 0.2);
        background: #ffffff;
    }

    .woocommerce-invalid .input-text,
    .woocommerce-invalid select {
        border-color: #e63946 !important;
    }

    .sity-field-focus label {
        color: #7b47ff;
    }

    /* رسائل ووكومرس */

    .woocommerce-error,
    .woocommerce-info,
    .woocommerce-message {
        border-radius: 14px;
        border-width: 1px;
        font-size: 13px;
    }

    .woocommerce-error li,
    .woocommerce-info li,
    .woocommerce-message li {
        font-size: 13px;
    }

    /* ملخص الطلب + بوكس الباقة */

    #order_review_heading {
        display: none;
    }

    #order_review {
        margin: 0;
    }

    .sity-order-summary-title {
        margin-bottom: 12px;
    }

    .sity-order-summary-title span {
        font-size: 12px;
        color: #8581a7;
        display: block;
    }

    .sity-plan-summary {
        margin-bottom: 12px;
        padding: 10px 12px;
        border-radius: 14px;
        background: rgba(122,60,255,0.03);
        border: 1px solid rgba(149,117,205,0.3);
        display: flex;
        flex-direction: column;
        gap: 2px;
        font-size: 12px;
    }

    .sity-plan-summary-title {
        font-weight: 700;
        color: #3a306c;
        font-size: 13px;
    }

    .sity-plan-summary-meta {
        color: #6e6997;
        font-size: 12px;
    }

    .sity-plan-summary-link {
        font-size: 11px;
        color: #7b47ff;
        text-decoration: underline;
        cursor: pointer;
        align-self: flex-start;
        margin-top: 4px;
    }

    .woocommerce-checkout-review-order-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
        color: #403b6b;
    }

    .woocommerce-checkout-review-order-table th,
    .woocommerce-checkout-review-order-table td {
        padding: 7px 0;
        border-bottom: 1px dashed rgba(149,117,205,0.28);
    }

    .woocommerce-checkout-review-order-table thead th {
        font-weight: 700;
    }

    .woocommerce-checkout-review-order-table tfoot th {
        font-weight: 600;
    }

    .woocommerce-checkout-review-order-table tfoot tr.order-total th,
    .woocommerce-checkout-review-order-table tfoot tr.order-total td {
        font-size: 14px;
        color: #2f255e;
    }

    /* وسائل الدفع – تصميم قوي */

    .woocommerce-checkout #payment {
        background: transparent;
        border-radius: 0;
        padding: 0;
        margin-top: 10px;
    }

    .woocommerce-checkout #payment ul.payment_methods {
        padding: 0;
        border: none;
        background: transparent;
    }

    .woocommerce-checkout #payment li.wc_payment_method {
        margin-bottom: 8px;
        padding: 8px 10px;
        border-radius: 13px;
        background: rgba(255,255,255,0.96);
        border: 1px solid rgba(149,117,205,0.26);
        transition: border-color 0.15s ease, box-shadow 0.15s ease, background 0.15s ease;
        position: relative;
        overflow: hidden;
    }

    .woocommerce-checkout #payment li.wc_payment_method::after {
        content: '✓';
        position: absolute;
        inset-inline-end: 10px;
        top: 9px;
        font-size: 13px;
        color: #7b47ff;
        opacity: 0;
        transition: opacity 0.15s ease, transform 0.15s ease;
        transform: translateY(-4px);
    }

    .woocommerce-checkout #payment li.wc_payment_method:hover {
        border-color: #7b47ff;
        box-shadow: 0 8px 22px rgba(80, 54, 177, 0.18);
        background: #ffffff;
    }

    .woocommerce-checkout #payment li.wc_payment_method label {
        font-size: 13px;
        color: #3c2a7b;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .woocommerce-checkout #payment li.wc_payment_method input[type='radio'] {
        accent-color: #7b47ff;
        margin-inline-end: 4px;
    }

    .woocommerce-checkout #payment li.wc_payment_method.sity-payment-active {
        border-color: #7b47ff;
        box-shadow: 0 10px 26px rgba(80,54,177,0.3);
        background: linear-gradient(135deg, #ffffff, #f8f2ff);
    }

    .woocommerce-checkout #payment li.wc_payment_method.sity-payment-active::after {
        opacity: 1;
        transform: translateY(0);
    }

    .woocommerce-checkout #payment div.payment_box {
        background: #f6f1ff;
        border-radius: 10px;
        border: 1px dashed rgba(149,117,205,0.5);
        margin: 6px 0 2px !important;
        padding: 8px 10px !important;
        color: #4f477d;
        font-size: 12px;
    }

    .woocommerce-checkout #payment div.form-row {
        padding: 13px 0 0;
    }

    /* زر إكمال الطلب */

    .woocommerce-checkout #place_order {
        width: 100%;
        display: inline-flex;
        justify-content: center;
        align-items: center;
        gap: 8px;
        border-radius: 999px;
        border: none;
        padding: 12px 18px;
        font-size: 15px;
        font-weight: 800;
        letter-spacing: 0.02em;
        font-family: 'Tajawal', system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        background: linear-gradient(135deg, #7b47ff, #c095ff);
        color: #ffffff;
        box-shadow: 0 16px 38px rgba(80, 54, 177, 0.32);
        cursor: pointer;
        transition: transform 0.14s ease, box-shadow 0.14s ease, opacity 0.1s ease;
    }

    .woocommerce-checkout #place_order:hover {
        transform: translateY(-1px);
        box-shadow: 0 19px 42px rgba(80, 54, 177, 0.42);
    }

    .woocommerce-checkout #place_order:active {
        transform: translateY(0);
        box-shadow: 0 11px 26px rgba(80, 54, 177, 0.22);
        opacity: 0.96;
    }

    .sity-checkout-note {
        font-size: 11px;
        color: #8a86ae;
        margin-top: 7px;
        text-align: center;
    }

    ";
}

/**
 * JS – Stepper + أزرار التالي/السابق + تظبيط وسائل الدفع
 */
function sity_checkout_pro_get_js() {

    $js = <<<'JS'
jQuery(function($) {

    // إضافة كلاس عند تركيز الحقول
    $(document).on('focus', '.woocommerce-checkout .input-text, .woocommerce-checkout select, .woocommerce-checkout textarea', function() {
        $(this).closest('.form-row').addClass('sity-field-focus');
    });

    $(document).on('blur', '.woocommerce-checkout .input-text, .woocommerce-checkout select, .woocommerce-checkout textarea', function() {
        $(this).closest('.form-row').removeClass('sity-field-focus');
    });

    // تظبيط stepper
    function sityGoToStep(step) {
        $('.sity-step-panel').removeClass('is-active');
        $('.sity-step-panel-' + step).addClass('is-active');

        $('.sity-step-item').removeClass('is-active');
        $('.sity-step-item[data-step="' + step + '"]').addClass('is-active');

        var top = $('.sity-checkout-wrapper').offset().top - 20;
        $('html, body').animate({ scrollTop: top }, 250);
    }

    function sityInitPanels() {
        var $panel1 = $('.sity-step-panel-1');
        var $panel2 = $('.sity-step-panel-2');
        if (!$panel1.length || !$panel2.length) return;

        if (!$panel1.hasClass('sity-panels-ready')) {
            $panel1.addClass('sity-panels-ready');
            if ($panel1.find('.sity-step-actions').length === 0) {
                $panel1.append(
                    '<div class="sity-step-actions">' +
                        '<button type="button" class="sity-btn sity-btn-primary sity-next-step" data-next="2">التالي: مراجعة الطلب</button>' +
                    '</div>'
                );
            }
        }

        if (!$panel2.hasClass('sity-panels-ready')) {
            $panel2.addClass('sity-panels-ready');

            var $orderReview = $('#order_review');
            if ($orderReview.length && !$orderReview.hasClass('sity-step-processed')) {
                var $table = $orderReview.find('.shop_table');
                var $payment = $('#payment');

                if ($table.length && $payment.length) {
                    $table.wrap('<div class="sity-step-panel-inner sity-order-table"></div>');
                    $payment.wrap('<div class="sity-step-panel-inner sity-payment-panel" style="display:none;"></div>');
                    $orderReview.addClass('sity-step-processed');
                }
            }

            if ($panel2.find('.sity-step-actions-review').length === 0) {
                $panel2.append(
                    '<div class="sity-step-actions sity-step-actions-review">' +
                        '<button type="button" class="sity-btn sity-btn-secondary sity-prev-step" data-prev="1">رجوع للبيانات</button>' +
                        '<button type="button" class="sity-btn sity-btn-primary sity-next-step sity-go-payment" data-next="3">استمرار للدفع</button>' +
                    '</div>'
                );
            }

            var $paymentPanel = $panel2.find('.sity-payment-panel');
            if ($paymentPanel.length && $paymentPanel.find('.sity-step-actions-payment').length === 0) {
                $paymentPanel.prepend(
                    '<div class="sity-step-actions sity-step-actions-payment" style="margin-bottom:10px;">' +
                        '<button type="button" class="sity-btn sity-btn-secondary sity-prev-step" data-prev="2">رجوع للمراجعة</button>' +
                    '</div>'
                );
            }
        }

        sityGoToStep(1);
        $('.sity-order-table').show();
        $('.sity-payment-panel').hide();
    }

    $(document).on('click', '.sity-next-step', function() {
        var next = $(this).data('next');
        if (next == 2) {
            $('.sity-order-table').show();
            $('.sity-payment-panel').hide();
        }
        if (next == 3) {
            $('.sity-order-table').hide();
            $('.sity-payment-panel').show();
        }
        sityGoToStep(next);
    });

    $(document).on('click', '.sity-prev-step', function() {
        var prev = $(this).data('prev');
        if (prev == 2) {
            $('.sity-order-table').show();
            $('.sity-payment-panel').hide();
        }
        if (prev == 1) {
            $('.sity-order-table').show();
            $('.sity-payment-panel').hide();
        }
        sityGoToStep(prev);
    });

    $(document).on('click', '.sity-step-item', function() {
        var step = $(this).data('step');
        if (step == 1) {
            $('.sity-order-table').show();
            $('.sity-payment-panel').hide();
        } else if (step == 2) {
            $('.sity-order-table').show();
            $('.sity-payment-panel').hide();
        } else if (step == 3) {
            $('.sity-order-table').hide();
            $('.sity-payment-panel').show();
        }
        sityGoToStep(step);
    });

    function sityUpdatePaymentHighlight() {
        $('#payment li.wc_payment_method').removeClass('sity-payment-active');
        $('#payment li.wc_payment_method input[type="radio"]:checked').each(function() {
            $(this).closest('li.wc_payment_method').addClass('sity-payment-active');
        });
    }

    $(document).on('change', '#payment li.wc_payment_method input[type="radio"]', function() {
        sityUpdatePaymentHighlight();
    });

    var $firstPayment = $('#payment ul.payment_methods li.wc_payment_method input[type="radio"]').first();
    if ($firstPayment.length && $('#payment ul.payment_methods li.wc_payment_method input[type="radio"]:checked').length === 0) {
        $firstPayment.prop('checked', true).trigger('change');
    }
    sityUpdatePaymentHighlight();

    $(document).ready(function() {
        sityInitPanels();
    });

    $('body').on('updated_checkout', function() {
        sityInitPanels();
        sityUpdatePaymentHighlight();
    });
});
JS;

    return $js;
}

/**
 * Wrapper البداية – اللوجو + العنوان + stepper + فتح الأعمدة
 */
add_action( 'woocommerce_before_checkout_form', 'sity_checkout_pro_wrapper_start', 1 );
function sity_checkout_pro_wrapper_start() {
    if ( ! is_checkout() ) {
        return;
    }

    // غيّر اللينك ده للوجو بتاع سيتى كلود عندك 👇
    $logo_url = 'https://sity.cloud/wp-content/uploads/sity-logo.png';

    echo '
    <div class="sity-checkout-wrapper">
        <div class="sity-checkout-inner">
            <div class="sity-checkout-heading">
                ' . ( $logo_url ? '<img src="' . esc_url( $logo_url ) . '" class="sity-logo" alt="Sity Cloud Logo" />' : '' ) . '
                <div class="sity-checkout-badge">
                    <span>Sity Cloud</span>
                    <span>Checkout</span>
                </div>
                <h1>إتمام الدفع لطلبك</h1>
                <p>خطوات بسيطة علشان تفعّل باقتك وتبدأ تبني موقعك من خلال سايتي كلاود.</p>
            </div>

            <div class="sity-stepper">
                <div class="sity-step-item is-active" data-step="1">
                    <span class="sity-step-title">البيانات</span>
                    <span class="sity-step-sub">بيانات الفاتورة والعميل</span>
                </div>
                <div class="sity-step-item" data-step="2">
                    <span class="sity-step-title">مراجعة الطلب</span>
                    <span class="sity-step-sub">تأكيد الباقة والإجمالي</span>
                </div>
                <div class="sity-step-item" data-step="3">
                    <span class="sity-step-title">الدفع</span>
                    <span class="sity-step-sub">اختيار وسيلة الدفع وإتمام العملية</span>
                </div>
            </div>

            <div class="sity-checkout-layout">
                <div class="sity-checkout-col-left sity-card">
                    <div class="sity-card-inner sity-step-panel sity-step-panel-1 is-active">
                        <h3>بيانات الفاتورة والشخصية</h3>
    ';
}

/**
 * Wrapper منتصف – نقلنا للعمود اليمين (ملخص الطلب + الدفع)
 */
add_action( 'woocommerce_checkout_after_customer_details', 'sity_checkout_pro_wrapper_switch_to_order', 100 );
function sity_checkout_pro_wrapper_switch_to_order() {
    if ( ! is_checkout() ) {
        return;
    }

    echo '
                    </div> <!-- .sity-card-inner step1 -->
                </div> <!-- .col-left -->

                <div class="sity-checkout-col-right sity-card">
                    <div class="sity-card-inner sity-step-panel sity-step-panel-2">
                        <div class="sity-order-summary-title">
                            <h3>ملخص الطلب والدفع</h3>
                            <span>تحقق من تفاصيل الباقة وقيمة الفاتورة قبل إتمام الدفع.</span>
                        </div>
    ';
}

/**
 * Wrapper النهاية – إغلاق الأعمدة والـ wrapper
 */
add_action( 'woocommerce_review_order_after_submit', 'sity_checkout_pro_wrapper_end', 100 );
function sity_checkout_pro_wrapper_end() {
    if ( ! is_checkout() ) {
        return;
    }

    echo '
                        <div class="sity-checkout-note">
                            بياناتك وعمليات الدفع يتم تشفيرها وحمايتها بالكامل من خلال بنية سايتي كلاود.
                        </div>
                    </div> <!-- .sity-card-inner (step2/3) -->
                </div> <!-- .col-right -->
            </div> <!-- .layout -->
        </div> <!-- .sity-checkout-inner -->
    </div> <!-- .sity-checkout-wrapper -->
    ';
}

/**
 * بوكس تفاصيل الباقة – نقرأ أول منتج في السلة ونعتبره باقة
 */
add_action( 'woocommerce_checkout_before_order_review', 'sity_checkout_pro_plan_summary', 5 );
function sity_checkout_pro_plan_summary() {
    if ( ! function_exists( 'WC' ) || ! WC()->cart || WC()->cart->is_empty() ) {
        return;
    }

    $items = WC()->cart->get_cart();
    if ( empty( $items ) ) {
        return;
    }

    $first_item   = reset( $items );
    $product      = isset( $first_item['data'] ) ? $first_item['data'] : null;
    $product_name = $product ? $product->get_name() : __( 'باقة سايتي كلاود', 'sity-checkout' );
    $qty          = isset( $first_item['quantity'] ) ? (int) $first_item['quantity'] : 1;
    $total        = WC()->cart->get_totals();
    $subtotal     = isset( $total['cart_contents_total'] ) ? $total['cart_contents_total'] : 0;

    echo '<div class="sity-plan-summary">';
    echo '<div class="sity-plan-summary-title">الباقة المختارة: ' . esc_html( $product_name ) . '</div>';
    echo '<div class="sity-plan-summary-meta">عدد المواقع / الاشتراكات في هذه الباقة: ' . esc_html( $qty ) . '</div>';
    echo '<div class="sity-plan-summary-meta">قيمة الطلب الحالية: ' . wp_kses_post( wc_price( $subtotal ) ) . '</div>';
    echo '<div class="sity-plan-summary-link" onclick="window.open(\'https://sity.cloud/pricing\', \'_blank\');">تعديل الباقة أو معرفة تفاصيل أكثر عن الباقات</div>';
    echo '</div>';
}

/**
 * إخفاء قسم "معلومات إضافية" / ملاحظات الطلب
 */
add_filter( 'woocommerce_enable_order_notes_field', '__return_false' );

add_filter( 'woocommerce_checkout_fields', 'sity_checkout_pro_customize_fields' );
function sity_checkout_pro_customize_fields( $fields ) {

    // إخفاء حقل ملاحظات الطلب (لو موجود)
    if ( isset( $fields['order']['order_comments'] ) ) {
        unset( $fields['order']['order_comments'] );
    }

    // تعديل بعض حقول الفاتورة
    if ( isset( $fields['billing']['billing_phone'] ) ) {
        $fields['billing']['billing_phone']['required']    = true;
        $fields['billing']['billing_phone']['priority']    = 25;
        $fields['billing']['billing_phone']['label']       = 'رقم الجوال';
        $fields['billing']['billing_phone']['placeholder'] = 'اكتب رقم الواتساب أو الجوال';
    }

    if ( isset( $fields['billing']['billing_company'] ) ) {
        $fields['billing']['billing_company']['required'] = false;
        $fields['billing']['billing_company']['label']    = 'اسم الشركة (اختياري)';
    }

    return $fields;
}
