<?php
/**
 * States
 * @since 10.8.8
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AL' => array( // Albania states.
		'AL-01' => __( 'Berat', 'real-estate-manager' ),
		'AL-09' => __( 'Dibër', 'real-estate-manager' ),
		'AL-02' => __( 'Durrës', 'real-estate-manager' ),
		'AL-03' => __( 'Elbasan', 'real-estate-manager' ),
		'AL-04' => __( 'Fier', 'real-estate-manager' ),
		'AL-05' => __( 'Gjirokastër', 'real-estate-manager' ),
		'AL-06' => __( 'Korçë', 'real-estate-manager' ),
		'AL-07' => __( 'Kukës', 'real-estate-manager' ),
		'AL-08' => __( 'Lezhë', 'real-estate-manager' ),
		'AL-10' => __( 'Shkodër', 'real-estate-manager' ),
		'AL-11' => __( 'Tirana', 'real-estate-manager' ),
		'AL-12' => __( 'Vlorë', 'real-estate-manager' ),
	),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'real-estate-manager' ),
		'BLU' => __( 'Benguela', 'real-estate-manager' ),
		'BIE' => __( 'Bié', 'real-estate-manager' ),
		'CAB' => __( 'Cabinda', 'real-estate-manager' ),
		'CNN' => __( 'Cunene', 'real-estate-manager' ),
		'HUA' => __( 'Huambo', 'real-estate-manager' ),
		'HUI' => __( 'Huíla', 'real-estate-manager' ),
		'CCU' => __( 'Kuando Kubango', 'real-estate-manager' ),
		'CNO' => __( 'Kwanza-Norte', 'real-estate-manager' ),
		'CUS' => __( 'Kwanza-Sul', 'real-estate-manager' ),
		'LUA' => __( 'Luanda', 'real-estate-manager' ),
		'LNO' => __( 'Lunda-Norte', 'real-estate-manager' ),
		'LSU' => __( 'Lunda-Sul', 'real-estate-manager' ),
		'MAL' => __( 'Malanje', 'real-estate-manager' ),
		'MOX' => __( 'Moxico', 'real-estate-manager' ),
		'NAM' => __( 'Namibe', 'real-estate-manager' ),
		'UIG' => __( 'Uíge', 'real-estate-manager' ),
		'ZAI' => __( 'Zaire', 'real-estate-manager' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'real-estate-manager' ),
		'B' => __( 'Buenos Aires', 'real-estate-manager' ),
		'K' => __( 'Catamarca', 'real-estate-manager' ),
		'H' => __( 'Chaco', 'real-estate-manager' ),
		'U' => __( 'Chubut', 'real-estate-manager' ),
		'X' => __( 'Córdoba', 'real-estate-manager' ),
		'W' => __( 'Corrientes', 'real-estate-manager' ),
		'E' => __( 'Entre Ríos', 'real-estate-manager' ),
		'P' => __( 'Formosa', 'real-estate-manager' ),
		'Y' => __( 'Jujuy', 'real-estate-manager' ),
		'L' => __( 'La Pampa', 'real-estate-manager' ),
		'F' => __( 'La Rioja', 'real-estate-manager' ),
		'M' => __( 'Mendoza', 'real-estate-manager' ),
		'N' => __( 'Misiones', 'real-estate-manager' ),
		'Q' => __( 'Neuquén', 'real-estate-manager' ),
		'R' => __( 'Río Negro', 'real-estate-manager' ),
		'A' => __( 'Salta', 'real-estate-manager' ),
		'J' => __( 'San Juan', 'real-estate-manager' ),
		'D' => __( 'San Luis', 'real-estate-manager' ),
		'Z' => __( 'Santa Cruz', 'real-estate-manager' ),
		'S' => __( 'Santa Fe', 'real-estate-manager' ),
		'G' => __( 'Santiago del Estero', 'real-estate-manager' ),
		'V' => __( 'Tierra del Fuego', 'real-estate-manager' ),
		'T' => __( 'Tucumán', 'real-estate-manager' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'real-estate-manager' ),
		'NSW' => __( 'New South Wales', 'real-estate-manager' ),
		'NT'  => __( 'Northern Territory', 'real-estate-manager' ),
		'QLD' => __( 'Queensland', 'real-estate-manager' ),
		'SA'  => __( 'South Australia', 'real-estate-manager' ),
		'TAS' => __( 'Tasmania', 'real-estate-manager' ),
		'VIC' => __( 'Victoria', 'real-estate-manager' ),
		'WA'  => __( 'Western Australia', 'real-estate-manager' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'real-estate-manager' ),
		'BD-01' => __( 'Bandarban', 'real-estate-manager' ),
		'BD-02' => __( 'Barguna', 'real-estate-manager' ),
		'BD-06' => __( 'Barishal', 'real-estate-manager' ),
		'BD-07' => __( 'Bhola', 'real-estate-manager' ),
		'BD-03' => __( 'Bogura', 'real-estate-manager' ),
		'BD-04' => __( 'Brahmanbaria', 'real-estate-manager' ),
		'BD-09' => __( 'Chandpur', 'real-estate-manager' ),
		'BD-10' => __( 'Chattogram', 'real-estate-manager' ),
		'BD-12' => __( 'Chuadanga', 'real-estate-manager' ),
		'BD-11' => __( "Cox's Bazar", 'real-estate-manager' ),
		'BD-08' => __( 'Cumilla', 'real-estate-manager' ),
		'BD-13' => __( 'Dhaka', 'real-estate-manager' ),
		'BD-14' => __( 'Dinajpur', 'real-estate-manager' ),
		'BD-15' => __( 'Faridpur ', 'real-estate-manager' ),
		'BD-16' => __( 'Feni', 'real-estate-manager' ),
		'BD-19' => __( 'Gaibandha', 'real-estate-manager' ),
		'BD-18' => __( 'Gazipur', 'real-estate-manager' ),
		'BD-17' => __( 'Gopalganj', 'real-estate-manager' ),
		'BD-20' => __( 'Habiganj', 'real-estate-manager' ),
		'BD-21' => __( 'Jamalpur', 'real-estate-manager' ),
		'BD-22' => __( 'Jashore', 'real-estate-manager' ),
		'BD-25' => __( 'Jhalokati', 'real-estate-manager' ),
		'BD-23' => __( 'Jhenaidah', 'real-estate-manager' ),
		'BD-24' => __( 'Joypurhat', 'real-estate-manager' ),
		'BD-29' => __( 'Khagrachhari', 'real-estate-manager' ),
		'BD-27' => __( 'Khulna', 'real-estate-manager' ),
		'BD-26' => __( 'Kishoreganj', 'real-estate-manager' ),
		'BD-28' => __( 'Kurigram', 'real-estate-manager' ),
		'BD-30' => __( 'Kushtia', 'real-estate-manager' ),
		'BD-31' => __( 'Lakshmipur', 'real-estate-manager' ),
		'BD-32' => __( 'Lalmonirhat', 'real-estate-manager' ),
		'BD-36' => __( 'Madaripur', 'real-estate-manager' ),
		'BD-37' => __( 'Magura', 'real-estate-manager' ),
		'BD-33' => __( 'Manikganj ', 'real-estate-manager' ),
		'BD-39' => __( 'Meherpur', 'real-estate-manager' ),
		'BD-38' => __( 'Moulvibazar', 'real-estate-manager' ),
		'BD-35' => __( 'Munshiganj', 'real-estate-manager' ),
		'BD-34' => __( 'Mymensingh', 'real-estate-manager' ),
		'BD-48' => __( 'Naogaon', 'real-estate-manager' ),
		'BD-43' => __( 'Narail', 'real-estate-manager' ),
		'BD-40' => __( 'Narayanganj', 'real-estate-manager' ),
		'BD-42' => __( 'Narsingdi', 'real-estate-manager' ),
		'BD-44' => __( 'Natore', 'real-estate-manager' ),
		'BD-45' => __( 'Nawabganj', 'real-estate-manager' ),
		'BD-41' => __( 'Netrakona', 'real-estate-manager' ),
		'BD-46' => __( 'Nilphamari', 'real-estate-manager' ),
		'BD-47' => __( 'Noakhali', 'real-estate-manager' ),
		'BD-49' => __( 'Pabna', 'real-estate-manager' ),
		'BD-52' => __( 'Panchagarh', 'real-estate-manager' ),
		'BD-51' => __( 'Patuakhali', 'real-estate-manager' ),
		'BD-50' => __( 'Pirojpur', 'real-estate-manager' ),
		'BD-53' => __( 'Rajbari', 'real-estate-manager' ),
		'BD-54' => __( 'Rajshahi', 'real-estate-manager' ),
		'BD-56' => __( 'Rangamati', 'real-estate-manager' ),
		'BD-55' => __( 'Rangpur', 'real-estate-manager' ),
		'BD-58' => __( 'Satkhira', 'real-estate-manager' ),
		'BD-62' => __( 'Shariatpur', 'real-estate-manager' ),
		'BD-57' => __( 'Sherpur', 'real-estate-manager' ),
		'BD-59' => __( 'Sirajganj', 'real-estate-manager' ),
		'BD-61' => __( 'Sunamganj', 'real-estate-manager' ),
		'BD-60' => __( 'Sylhet', 'real-estate-manager' ),
		'BD-63' => __( 'Tangail', 'real-estate-manager' ),
		'BD-64' => __( 'Thakurgaon', 'real-estate-manager' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'real-estate-manager' ),
		'BG-02' => __( 'Burgas', 'real-estate-manager' ),
		'BG-08' => __( 'Dobrich', 'real-estate-manager' ),
		'BG-07' => __( 'Gabrovo', 'real-estate-manager' ),
		'BG-26' => __( 'Haskovo', 'real-estate-manager' ),
		'BG-09' => __( 'Kardzhali', 'real-estate-manager' ),
		'BG-10' => __( 'Kyustendil', 'real-estate-manager' ),
		'BG-11' => __( 'Lovech', 'real-estate-manager' ),
		'BG-12' => __( 'Montana', 'real-estate-manager' ),
		'BG-13' => __( 'Pazardzhik', 'real-estate-manager' ),
		'BG-14' => __( 'Pernik', 'real-estate-manager' ),
		'BG-15' => __( 'Pleven', 'real-estate-manager' ),
		'BG-16' => __( 'Plovdiv', 'real-estate-manager' ),
		'BG-17' => __( 'Razgrad', 'real-estate-manager' ),
		'BG-18' => __( 'Ruse', 'real-estate-manager' ),
		'BG-27' => __( 'Shumen', 'real-estate-manager' ),
		'BG-19' => __( 'Silistra', 'real-estate-manager' ),
		'BG-20' => __( 'Sliven', 'real-estate-manager' ),
		'BG-21' => __( 'Smolyan', 'real-estate-manager' ),
		'BG-23' => __( 'Sofia', 'real-estate-manager' ),
		'BG-22' => __( 'Sofia-Grad', 'real-estate-manager' ),
		'BG-24' => __( 'Stara Zagora', 'real-estate-manager' ),
		'BG-25' => __( 'Targovishte', 'real-estate-manager' ),
		'BG-03' => __( 'Varna', 'real-estate-manager' ),
		'BG-04' => __( 'Veliko Tarnovo', 'real-estate-manager' ),
		'BG-05' => __( 'Vidin', 'real-estate-manager' ),
		'BG-06' => __( 'Vratsa', 'real-estate-manager' ),
		'BG-28' => __( 'Yambol', 'real-estate-manager' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Benin states.
		'AL' => __( 'Alibori', 'real-estate-manager' ),
		'AK' => __( 'Atakora', 'real-estate-manager' ),
		'AQ' => __( 'Atlantique', 'real-estate-manager' ),
		'BO' => __( 'Borgou', 'real-estate-manager' ),
		'CO' => __( 'Collines', 'real-estate-manager' ),
		'KO' => __( 'Kouffo', 'real-estate-manager' ),
		'DO' => __( 'Donga', 'real-estate-manager' ),
		'LI' => __( 'Littoral', 'real-estate-manager' ),
		'MO' => __( 'Mono', 'real-estate-manager' ),
		'OU' => __( 'Ouémé', 'real-estate-manager' ),
		'PL' => __( 'Plateau', 'real-estate-manager' ),
		'ZO' => __( 'Zou', 'real-estate-manager' ),
	),
	'BO' => array( // Bolivian states.
		'BO-B' => __( 'Beni', 'real-estate-manager' ),
		'BO-H' => __( 'Chuquisaca', 'real-estate-manager' ),
		'BO-C' => __( 'Cochabamba', 'real-estate-manager' ),
		'BO-L' => __( 'La Paz', 'real-estate-manager' ),
		'BO-O' => __( 'Oruro', 'real-estate-manager' ),
		'BO-N' => __( 'Pando', 'real-estate-manager' ),
		'BO-P' => __( 'Potosí', 'real-estate-manager' ),
		'BO-S' => __( 'Santa Cruz', 'real-estate-manager' ),
		'BO-T' => __( 'Tarija', 'real-estate-manager' ),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'real-estate-manager' ),
		'AL' => __( 'Alagoas', 'real-estate-manager' ),
		'AP' => __( 'Amapá', 'real-estate-manager' ),
		'AM' => __( 'Amazonas', 'real-estate-manager' ),
		'BA' => __( 'Bahia', 'real-estate-manager' ),
		'CE' => __( 'Ceará', 'real-estate-manager' ),
		'DF' => __( 'Distrito Federal', 'real-estate-manager' ),
		'ES' => __( 'Espírito Santo', 'real-estate-manager' ),
		'GO' => __( 'Goiás', 'real-estate-manager' ),
		'MA' => __( 'Maranhão', 'real-estate-manager' ),
		'MT' => __( 'Mato Grosso', 'real-estate-manager' ),
		'MS' => __( 'Mato Grosso do Sul', 'real-estate-manager' ),
		'MG' => __( 'Minas Gerais', 'real-estate-manager' ),
		'PA' => __( 'Pará', 'real-estate-manager' ),
		'PB' => __( 'Paraíba', 'real-estate-manager' ),
		'PR' => __( 'Paraná', 'real-estate-manager' ),
		'PE' => __( 'Pernambuco', 'real-estate-manager' ),
		'PI' => __( 'Piauí', 'real-estate-manager' ),
		'RJ' => __( 'Rio de Janeiro', 'real-estate-manager' ),
		'RN' => __( 'Rio Grande do Norte', 'real-estate-manager' ),
		'RS' => __( 'Rio Grande do Sul', 'real-estate-manager' ),
		'RO' => __( 'Rondônia', 'real-estate-manager' ),
		'RR' => __( 'Roraima', 'real-estate-manager' ),
		'SC' => __( 'Santa Catarina', 'real-estate-manager' ),
		'SP' => __( 'São Paulo', 'real-estate-manager' ),
		'SE' => __( 'Sergipe', 'real-estate-manager' ),
		'TO' => __( 'Tocantins', 'real-estate-manager' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'real-estate-manager' ),
		'BC' => __( 'British Columbia', 'real-estate-manager' ),
		'MB' => __( 'Manitoba', 'real-estate-manager' ),
		'NB' => __( 'New Brunswick', 'real-estate-manager' ),
		'NL' => __( 'Newfoundland and Labrador', 'real-estate-manager' ),
		'NT' => __( 'Northwest Territories', 'real-estate-manager' ),
		'NS' => __( 'Nova Scotia', 'real-estate-manager' ),
		'NU' => __( 'Nunavut', 'real-estate-manager' ),
		'ON' => __( 'Ontario', 'real-estate-manager' ),
		'PE' => __( 'Prince Edward Island', 'real-estate-manager' ),
		'QC' => __( 'Quebec', 'real-estate-manager' ),
		'SK' => __( 'Saskatchewan', 'real-estate-manager' ),
		'YT' => __( 'Yukon Territory', 'real-estate-manager' ),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'real-estate-manager' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'real-estate-manager' ),
		'AI' => __( 'Appenzell Innerrhoden', 'real-estate-manager' ),
		'BL' => __( 'Basel-Landschaft', 'real-estate-manager' ),
		'BS' => __( 'Basel-Stadt', 'real-estate-manager' ),
		'BE' => __( 'Bern', 'real-estate-manager' ),
		'FR' => __( 'Fribourg', 'real-estate-manager' ),
		'GE' => __( 'Geneva', 'real-estate-manager' ),
		'GL' => __( 'Glarus', 'real-estate-manager' ),
		'GR' => __( 'Graubünden', 'real-estate-manager' ),
		'JU' => __( 'Jura', 'real-estate-manager' ),
		'LU' => __( 'Luzern', 'real-estate-manager' ),
		'NE' => __( 'Neuchâtel', 'real-estate-manager' ),
		'NW' => __( 'Nidwalden', 'real-estate-manager' ),
		'OW' => __( 'Obwalden', 'real-estate-manager' ),
		'SH' => __( 'Schaffhausen', 'real-estate-manager' ),
		'SZ' => __( 'Schwyz', 'real-estate-manager' ),
		'SO' => __( 'Solothurn', 'real-estate-manager' ),
		'SG' => __( 'St. Gallen', 'real-estate-manager' ),
		'TG' => __( 'Thurgau', 'real-estate-manager' ),
		'TI' => __( 'Ticino', 'real-estate-manager' ),
		'UR' => __( 'Uri', 'real-estate-manager' ),
		'VS' => __( 'Valais', 'real-estate-manager' ),
		'VD' => __( 'Vaud', 'real-estate-manager' ),
		'ZG' => __( 'Zug', 'real-estate-manager' ),
		'ZH' => __( 'Zürich', 'real-estate-manager' ),
	),
	'CL' => array( // Chile states.
		'CL-AI' => __( 'Aisén del General Carlos Ibañez del Campo', 'real-estate-manager' ),
		'CL-AN' => __( 'Antofagasta', 'real-estate-manager' ),
		'CL-AP' => __( 'Arica y Parinacota', 'real-estate-manager' ),
		'CL-AR' => __( 'La Araucanía', 'real-estate-manager' ),
		'CL-AT' => __( 'Atacama', 'real-estate-manager' ),
		'CL-BI' => __( 'Biobío', 'real-estate-manager' ),
		'CL-CO' => __( 'Coquimbo', 'real-estate-manager' ),
		'CL-LI' => __( 'Libertador General Bernardo O\'Higgins', 'real-estate-manager' ),
		'CL-LL' => __( 'Los Lagos', 'real-estate-manager' ),
		'CL-LR' => __( 'Los Ríos', 'real-estate-manager' ),
		'CL-MA' => __( 'Magallanes', 'real-estate-manager' ),
		'CL-ML' => __( 'Maule', 'real-estate-manager' ),
		'CL-NB' => __( 'Ñuble', 'real-estate-manager' ),
		'CL-RM' => __( 'Región Metropolitana de Santiago', 'real-estate-manager' ),
		'CL-TA' => __( 'Tarapacá', 'real-estate-manager' ),
		'CL-VS' => __( 'Valparaíso', 'real-estate-manager' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'real-estate-manager' ),
		'CN2'  => __( 'Beijing / 北京', 'real-estate-manager' ),
		'CN3'  => __( 'Tianjin / 天津', 'real-estate-manager' ),
		'CN4'  => __( 'Hebei / 河北', 'real-estate-manager' ),
		'CN5'  => __( 'Shanxi / 山西', 'real-estate-manager' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'real-estate-manager' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'real-estate-manager' ),
		'CN8'  => __( 'Jilin / 吉林', 'real-estate-manager' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'real-estate-manager' ),
		'CN10' => __( 'Shanghai / 上海', 'real-estate-manager' ),
		'CN11' => __( 'Jiangsu / 江苏', 'real-estate-manager' ),
		'CN12' => __( 'Zhejiang / 浙江', 'real-estate-manager' ),
		'CN13' => __( 'Anhui / 安徽', 'real-estate-manager' ),
		'CN14' => __( 'Fujian / 福建', 'real-estate-manager' ),
		'CN15' => __( 'Jiangxi / 江西', 'real-estate-manager' ),
		'CN16' => __( 'Shandong / 山东', 'real-estate-manager' ),
		'CN17' => __( 'Henan / 河南', 'real-estate-manager' ),
		'CN18' => __( 'Hubei / 湖北', 'real-estate-manager' ),
		'CN19' => __( 'Hunan / 湖南', 'real-estate-manager' ),
		'CN20' => __( 'Guangdong / 广东', 'real-estate-manager' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'real-estate-manager' ),
		'CN22' => __( 'Hainan / 海南', 'real-estate-manager' ),
		'CN23' => __( 'Chongqing / 重庆', 'real-estate-manager' ),
		'CN24' => __( 'Sichuan / 四川', 'real-estate-manager' ),
		'CN25' => __( 'Guizhou / 贵州', 'real-estate-manager' ),
		'CN26' => __( 'Shaanxi / 陕西', 'real-estate-manager' ),
		'CN27' => __( 'Gansu / 甘肃', 'real-estate-manager' ),
		'CN28' => __( 'Qinghai / 青海', 'real-estate-manager' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'real-estate-manager' ),
		'CN30' => __( 'Macao / 澳门', 'real-estate-manager' ),
		'CN31' => __( 'Tibet / 西藏', 'real-estate-manager' ),
		'CN32' => __( 'Xinjiang / 新疆', 'real-estate-manager' ),
	),
	'CO' => array( // Colombia States.
		'CO-AMA' => __( 'Amazonas', 'real-estate-manager' ),
		'CO-ANT' => __( 'Antioquia', 'real-estate-manager' ),
		'CO-ARA' => __( 'Arauca', 'real-estate-manager' ),
		'CO-ATL' => __( 'Atlántico', 'real-estate-manager' ),
		'CO-BOL' => __( 'Bolívar', 'real-estate-manager' ),
		'CO-BOY' => __( 'Boyacá', 'real-estate-manager' ),
		'CO-CAL' => __( 'Caldas', 'real-estate-manager' ),
		'CO-CAQ' => __( 'Caquetá', 'real-estate-manager' ),
		'CO-CAS' => __( 'Casanare', 'real-estate-manager' ),
		'CO-CAU' => __( 'Cauca', 'real-estate-manager' ),
		'CO-CES' => __( 'Cesar', 'real-estate-manager' ),
		'CO-CHO' => __( 'Chocó', 'real-estate-manager' ),
		'CO-COR' => __( 'Córdoba', 'real-estate-manager' ),
		'CO-CUN' => __( 'Cundinamarca', 'real-estate-manager' ),
		'CO-DC' => __( 'Capital District', 'real-estate-manager' ),
		'CO-GUA' => __( 'Guainía', 'real-estate-manager' ),
		'CO-GUV' => __( 'Guaviare', 'real-estate-manager' ),
		'CO-HUI' => __( 'Huila', 'real-estate-manager' ),
		'CO-LAG' => __( 'La Guajira', 'real-estate-manager' ),
		'CO-MAG' => __( 'Magdalena', 'real-estate-manager' ),
		'CO-MET' => __( 'Meta', 'real-estate-manager' ),
		'CO-NAR' => __( 'Nariño', 'real-estate-manager' ),
		'CO-NSA' => __( 'Norte de Santander', 'real-estate-manager' ),
		'CO-PUT' => __( 'Putumayo', 'real-estate-manager' ),
		'CO-QUI' => __( 'Quindío', 'real-estate-manager' ),
		'CO-RIS' => __( 'Risaralda', 'real-estate-manager' ),
		'CO-SAN' => __( 'Santander', 'real-estate-manager' ),
		'CO-SAP' => __( 'San Andrés & Providencia', 'real-estate-manager' ),
		'CO-SUC' => __( 'Sucre', 'real-estate-manager' ),
		'CO-TOL' => __( 'Tolima', 'real-estate-manager' ),
		'CO-VAC' => __( 'Valle del Cauca', 'real-estate-manager' ),
		'CO-VAU' => __( 'Vaupés', 'real-estate-manager' ),
		'CO-VID' => __( 'Vichada', 'real-estate-manager' ),
	),
	'CR' => array( // Costa Rica states.
		'CR-A' => __( 'Alajuela', 'real-estate-manager' ),
		'CR-C' => __( 'Cartago', 'real-estate-manager' ),
		'CR-G' => __( 'Guanacaste', 'real-estate-manager' ),
		'CR-H' => __( 'Heredia', 'real-estate-manager' ),
		'CR-L' => __( 'Limón', 'real-estate-manager' ),
		'CR-P' => __( 'Puntarenas', 'real-estate-manager' ),
		'CR-SJ' => __( 'San José', 'real-estate-manager' ),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'DO' => array( // Dominican Republic.
		'DO-01' => __( 'Distrito Nacional', 'real-estate-manager' ),
		'DO-02' => __( 'Azua', 'real-estate-manager' ),
		'DO-03' => __( 'Baoruco', 'real-estate-manager' ),
		'DO-04' => __( 'Barahona', 'real-estate-manager' ),
		'DO-33' => __( 'Cibao Nordeste', 'real-estate-manager' ),
		'DO-34' => __( 'Cibao Noroeste', 'real-estate-manager' ),
		'DO-35' => __( 'Cibao Norte', 'real-estate-manager' ),
		'DO-36' => __( 'Cibao Sur', 'real-estate-manager' ),
		'DO-05' => __( 'Dajabón', 'real-estate-manager' ),
		'DO-06' => __( 'Duarte', 'real-estate-manager' ),
		'DO-08' => __( 'El Seibo', 'real-estate-manager' ),
		'DO-37' => __( 'El Valle', 'real-estate-manager' ),
		'DO-07' => __( 'Elías Piña', 'real-estate-manager' ),
		'DO-38' => __( 'Enriquillo', 'real-estate-manager' ),		
		'DO-09' => __( 'Espaillat', 'real-estate-manager' ),
		'DO-30' => __( 'Hato Mayor', 'real-estate-manager' ),
		'DO-19' => __( 'Hermanas Mirabal', 'real-estate-manager' ),
		'DO-39' => __( 'Higüamo', 'real-estate-manager' ),
		'DO-10' => __( 'Independencia', 'real-estate-manager' ),
		'DO-11' => __( 'La Altagracia', 'real-estate-manager' ),
		'DO-12' => __( 'La Romana', 'real-estate-manager' ),
		'DO-13' => __( 'La Vega', 'real-estate-manager' ),
		'DO-14' => __( 'María Trinidad Sánchez', 'real-estate-manager' ),
		'DO-28' => __( 'Monseñor Nouel', 'real-estate-manager' ),
		'DO-15' => __( 'Monte Cristi', 'real-estate-manager' ),
		'DO-29' => __( 'Monte Plata', 'real-estate-manager' ),
		'DO-40' => __( 'Ozama', 'real-estate-manager' ),
		'DO-16' => __( 'Pedernales', 'real-estate-manager' ),
		'DO-17' => __( 'Peravia', 'real-estate-manager' ),
		'DO-18' => __( 'Puerto Plata', 'real-estate-manager' ),
		'DO-20' => __( 'Samaná', 'real-estate-manager' ),
		'DO-21' => __( 'San Cristóbal', 'real-estate-manager' ),
		'DO-31' => __( 'San José de Ocoa', 'real-estate-manager' ),
		'DO-22' => __( 'San Juan', 'real-estate-manager' ),
		'DO-23' => __( 'San Pedro de Macorís', 'real-estate-manager' ),
		'DO-24' => __( 'Sánchez Ramírez', 'real-estate-manager' ),
		'DO-25' => __( 'Santiago', 'real-estate-manager' ),
		'DO-26' => __( 'Santiago Rodríguez', 'real-estate-manager' ),
		'DO-32' => __( 'Santo Domingo', 'real-estate-manager' ),
		'DO-41' => __( 'Valdesia', 'real-estate-manager' ),
		'DO-27' => __( 'Valverde', 'real-estate-manager' ),
		'DO-42' => __( 'Yuma', 'real-estate-manager' ),
	),
	'DZ' => array(
		'DZ-01' => __( 'Adrar', 'real-estate-manager' ),
		'DZ-02' => __( 'Chlef', 'real-estate-manager' ),
		'DZ-03' => __( 'Laghouat', 'real-estate-manager' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'real-estate-manager' ),
		'DZ-05' => __( 'Batna', 'real-estate-manager' ),
		'DZ-06' => __( 'Béjaïa', 'real-estate-manager' ),
		'DZ-07' => __( 'Biskra', 'real-estate-manager' ),
		'DZ-08' => __( 'Béchar', 'real-estate-manager' ),
		'DZ-09' => __( 'Blida', 'real-estate-manager' ),
		'DZ-10' => __( 'Bouira', 'real-estate-manager' ),
		'DZ-11' => __( 'Tamanghasset', 'real-estate-manager' ),
		'DZ-12' => __( 'Tébessa', 'real-estate-manager' ),
		'DZ-13' => __( 'Tlemcen', 'real-estate-manager' ),
		'DZ-14' => __( 'Tiaret', 'real-estate-manager' ),
		'DZ-15' => __( 'Tizi Ouzou', 'real-estate-manager' ),
		'DZ-16' => __( 'Algiers', 'real-estate-manager' ),
		'DZ-17' => __( 'Djelfa', 'real-estate-manager' ),
		'DZ-18' => __( 'Jijel', 'real-estate-manager' ),
		'DZ-19' => __( 'Sétif', 'real-estate-manager' ),
		'DZ-20' => __( 'Saïda', 'real-estate-manager' ),
		'DZ-21' => __( 'Skikda', 'real-estate-manager' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'real-estate-manager' ),
		'DZ-23' => __( 'Annaba', 'real-estate-manager' ),
		'DZ-24' => __( 'Guelma', 'real-estate-manager' ),
		'DZ-25' => __( 'Constantine', 'real-estate-manager' ),
		'DZ-26' => __( 'Médéa', 'real-estate-manager' ),
		'DZ-27' => __( 'Mostaganem', 'real-estate-manager' ),
		'DZ-28' => __( 'M’Sila', 'real-estate-manager' ),
		'DZ-29' => __( 'Mascara', 'real-estate-manager' ),
		'DZ-30' => __( 'Ouargla', 'real-estate-manager' ),
		'DZ-31' => __( 'Oran', 'real-estate-manager' ),
		'DZ-32' => __( 'El Bayadh', 'real-estate-manager' ),
		'DZ-33' => __( 'Illizi', 'real-estate-manager' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'real-estate-manager' ),
		'DZ-35' => __( 'Boumerdès', 'real-estate-manager' ),
		'DZ-36' => __( 'El Tarf', 'real-estate-manager' ),
		'DZ-37' => __( 'Tindouf', 'real-estate-manager' ),
		'DZ-38' => __( 'Tissemsilt', 'real-estate-manager' ),
		'DZ-39' => __( 'El Oued', 'real-estate-manager' ),
		'DZ-40' => __( 'Khenchela', 'real-estate-manager' ),
		'DZ-41' => __( 'Souk Ahras', 'real-estate-manager' ),
		'DZ-42' => __( 'Tipasa', 'real-estate-manager' ),
		'DZ-43' => __( 'Mila', 'real-estate-manager' ),
		'DZ-44' => __( 'Aïn Defla', 'real-estate-manager' ),
		'DZ-45' => __( 'Naama', 'real-estate-manager' ),
		'DZ-46' => __( 'Aïn Témouchent', 'real-estate-manager' ),
		'DZ-47' => __( 'Ghardaïa', 'real-estate-manager' ),
		'DZ-48' => __( 'Relizane', 'real-estate-manager' ),
	),
	'EE' => array(),
	'EC' => array( // Ecuador states.
		'EC-A' => __( 'Azuay', 'real-estate-manager' ),
		'EC-B' => __( 'Bolívar', 'real-estate-manager' ),
		'EC-F' => __( 'Cañar', 'real-estate-manager' ),
		'EC-C' => __( 'Carchi', 'real-estate-manager' ),
		'EC-H' => __( 'Chimborazo', 'real-estate-manager' ),
		'EC-X' => __( 'Cotopaxi', 'real-estate-manager' ),
		'EC-O' => __( 'El Oro', 'real-estate-manager' ),
		'EC-E' => __( 'Esmeraldas', 'real-estate-manager' ),
		'EC-W' => __( 'Galápagos', 'real-estate-manager' ),
		'EC-G' => __( 'Guayas', 'real-estate-manager' ),
		'EC-I' => __( 'Imbabura', 'real-estate-manager' ),
		'EC-L' => __( 'Loja', 'real-estate-manager' ),
		'EC-R' => __( 'Los Ríos', 'real-estate-manager' ),
		'EC-M' => __( 'Manabí', 'real-estate-manager' ),
		'EC-S' => __( 'Morona-Santiago', 'real-estate-manager' ),
		'EC-N' => __( 'Napo', 'real-estate-manager' ),
		'EC-D' => __( 'Orellana', 'real-estate-manager' ),
		'EC-Y' => __( 'Pastaza', 'real-estate-manager' ),
		'EC-P' => __( 'Pichincha', 'real-estate-manager' ),
		'EC-SE' => __( 'Santa Elena', 'real-estate-manager' ),
		'EC-SD' => __( 'Santo Domingo de los Tsáchilas', 'real-estate-manager' ),
		'EC-U' => __( 'Sucumbíos', 'real-estate-manager' ),
		'EC-T' => __( 'Tungurahua', 'real-estate-manager' ),
		'EC-Z' => __( 'Zamora-Chinchipe', 'real-estate-manager' ),
	),
	'EG' => array( // Egypt states.
		'EGALX' => __( 'Alexandria', 'real-estate-manager' ),
		'EGASN' => __( 'Aswan', 'real-estate-manager' ),
		'EGAST' => __( 'Asyut', 'real-estate-manager' ),
		'EGBA'  => __( 'Red Sea', 'real-estate-manager' ),
		'EGBH'  => __( 'Beheira', 'real-estate-manager' ),
		'EGBNS' => __( 'Beni Suef', 'real-estate-manager' ),
		'EGC'   => __( 'Cairo', 'real-estate-manager' ),
		'EGDK'  => __( 'Dakahlia', 'real-estate-manager' ),
		'EGDT'  => __( 'Damietta', 'real-estate-manager' ),
		'EGFYM' => __( 'Faiyum', 'real-estate-manager' ),
		'EGGH'  => __( 'Gharbia', 'real-estate-manager' ),
		'EGGZ'  => __( 'Giza', 'real-estate-manager' ),
		'EGIS'  => __( 'Ismailia', 'real-estate-manager' ),
		'EGJS'  => __( 'South Sinai', 'real-estate-manager' ),
		'EGKB'  => __( 'Qalyubia', 'real-estate-manager' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'real-estate-manager' ),
		'EGKN'  => __( 'Qena', 'real-estate-manager' ),
		'EGLX'  => __( 'Luxor', 'real-estate-manager' ),
		'EGMN'  => __( 'Minya', 'real-estate-manager' ),
		'EGMNF' => __( 'Monufia', 'real-estate-manager' ),
		'EGMT'  => __( 'Matrouh', 'real-estate-manager' ),
		'EGPTS' => __( 'Port Said', 'real-estate-manager' ),
		'EGSHG' => __( 'Sohag', 'real-estate-manager' ),
		'EGSHR' => __( 'Al Sharqia', 'real-estate-manager' ),
		'EGSIN' => __( 'North Sinai', 'real-estate-manager' ),
		'EGSUZ' => __( 'Suez', 'real-estate-manager' ),
		'EGWAD' => __( 'New Valley', 'real-estate-manager' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'real-estate-manager' ),
		'VI' => __( 'Araba/Álava', 'real-estate-manager' ),
		'AB' => __( 'Albacete', 'real-estate-manager' ),
		'A'  => __( 'Alicante', 'real-estate-manager' ),
		'AL' => __( 'Almería', 'real-estate-manager' ),
		'O'  => __( 'Asturias', 'real-estate-manager' ),
		'AV' => __( 'Ávila', 'real-estate-manager' ),
		'BA' => __( 'Badajoz', 'real-estate-manager' ),
		'PM' => __( 'Baleares', 'real-estate-manager' ),
		'B'  => __( 'Barcelona', 'real-estate-manager' ),
		'BU' => __( 'Burgos', 'real-estate-manager' ),
		'CC' => __( 'Cáceres', 'real-estate-manager' ),
		'CA' => __( 'Cádiz', 'real-estate-manager' ),
		'S'  => __( 'Cantabria', 'real-estate-manager' ),
		'CS' => __( 'Castellón', 'real-estate-manager' ),
		'CE' => __( 'Ceuta', 'real-estate-manager' ),
		'CR' => __( 'Ciudad Real', 'real-estate-manager' ),
		'CO' => __( 'Córdoba', 'real-estate-manager' ),
		'CU' => __( 'Cuenca', 'real-estate-manager' ),
		'GI' => __( 'Girona', 'real-estate-manager' ),
		'GR' => __( 'Granada', 'real-estate-manager' ),
		'GU' => __( 'Guadalajara', 'real-estate-manager' ),
		'SS' => __( 'Gipuzkoa', 'real-estate-manager' ),
		'H'  => __( 'Huelva', 'real-estate-manager' ),
		'HU' => __( 'Huesca', 'real-estate-manager' ),
		'J'  => __( 'Jaén', 'real-estate-manager' ),
		'LO' => __( 'La Rioja', 'real-estate-manager' ),
		'GC' => __( 'Las Palmas', 'real-estate-manager' ),
		'LE' => __( 'León', 'real-estate-manager' ),
		'L'  => __( 'Lleida', 'real-estate-manager' ),
		'LU' => __( 'Lugo', 'real-estate-manager' ),
		'M'  => __( 'Madrid', 'real-estate-manager' ),
		'MA' => __( 'Málaga', 'real-estate-manager' ),
		'ML' => __( 'Melilla', 'real-estate-manager' ),
		'MU' => __( 'Murcia', 'real-estate-manager' ),
		'NA' => __( 'Navarra', 'real-estate-manager' ),
		'OR' => __( 'Ourense', 'real-estate-manager' ),
		'P'  => __( 'Palencia', 'real-estate-manager' ),
		'PO' => __( 'Pontevedra', 'real-estate-manager' ),
		'SA' => __( 'Salamanca', 'real-estate-manager' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'real-estate-manager' ),
		'SG' => __( 'Segovia', 'real-estate-manager' ),
		'SE' => __( 'Sevilla', 'real-estate-manager' ),
		'SO' => __( 'Soria', 'real-estate-manager' ),
		'T'  => __( 'Tarragona', 'real-estate-manager' ),
		'TE' => __( 'Teruel', 'real-estate-manager' ),
		'TO' => __( 'Toledo', 'real-estate-manager' ),
		'V'  => __( 'Valencia', 'real-estate-manager' ),
		'VA' => __( 'Valladolid', 'real-estate-manager' ),
		'BI' => __( 'Biscay', 'real-estate-manager' ),
		'ZA' => __( 'Zamora', 'real-estate-manager' ),
		'Z'  => __( 'Zaragoza', 'real-estate-manager' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GF' => array(),
	'GH' => array( // Ghanaian Regions.
		'AF' => __( 'Ahafo', 'real-estate-manager' ),
		'AH' => __( 'Ashanti', 'real-estate-manager' ),
		'BA' => __( 'Brong-Ahafo', 'real-estate-manager' ),
		'BO' => __( 'Bono', 'real-estate-manager' ),
		'BE' => __( 'Bono East', 'real-estate-manager' ),
		'CP' => __( 'Central', 'real-estate-manager' ),
		'EP' => __( 'Eastern', 'real-estate-manager' ),
		'AA' => __( 'Greater Accra', 'real-estate-manager' ),
		'NE' => __( 'North East', 'real-estate-manager' ),
		'NP' => __( 'Northern', 'real-estate-manager' ),
		'OT' => __( 'Oti', 'real-estate-manager' ),
		'SV' => __( 'Savannah', 'real-estate-manager' ),
		'UE' => __( 'Upper East', 'real-estate-manager' ),
		'UW' => __( 'Upper West', 'real-estate-manager' ),
		'TV' => __( 'Volta', 'real-estate-manager' ),
		'WP' => __( 'Western', 'real-estate-manager' ),
		'WN' => __( 'Western North', 'real-estate-manager' ),
	),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Attica', 'real-estate-manager' ),
		'A' => __( 'East Macedonia and Thrace', 'real-estate-manager' ),
		'B' => __( 'Central Macedonia', 'real-estate-manager' ),
		'C' => __( 'West Macedonia', 'real-estate-manager' ),
		'D' => __( 'Epirus', 'real-estate-manager' ),
		'E' => __( 'Thessaly', 'real-estate-manager' ),
		'F' => __( 'Ionian Islands', 'real-estate-manager' ),
		'G' => __( 'West Greece', 'real-estate-manager' ),
		'H' => __( 'Central Greece', 'real-estate-manager' ),
		'J' => __( 'Peloponnese', 'real-estate-manager' ),
		'K' => __( 'North Aegean', 'real-estate-manager' ),
		'L' => __( 'South Aegean', 'real-estate-manager' ),
		'M' => __( 'Crete', 'real-estate-manager' ),
	),
	'GT' => array( // Guatemalan states.
		'GT-AV' => __( 'Alta Verapaz', 'real-estate-manager' ),
		'GT-BV' => __( 'Baja Verapaz', 'real-estate-manager' ),
		'GT-CM' => __( 'Chimaltenango', 'real-estate-manager' ),
		'GT-CQ' => __( 'Chiquimula', 'real-estate-manager' ),
		'GT-PR' => __( 'El Progreso', 'real-estate-manager' ),
		'GT-ES' => __( 'Escuintla', 'real-estate-manager' ),
		'GT-GU' => __( 'Guatemala', 'real-estate-manager' ),
		'GT-HU' => __( 'Huehuetenango', 'real-estate-manager' ),
		'GT-IZ' => __( 'Izabal', 'real-estate-manager' ),
		'GT-JA' => __( 'Jalapa', 'real-estate-manager' ),
		'GT-JU' => __( 'Jutiapa', 'real-estate-manager' ),
		'GT-PE' => __( 'Petén', 'real-estate-manager' ),
		'GT-QZ' => __( 'Quetzaltenango', 'real-estate-manager' ),
		'GT-QC' => __( 'Quiché', 'real-estate-manager' ),
		'GT-RE' => __( 'Retalhuleu', 'real-estate-manager' ),
		'GT-SA' => __( 'Sacatepéquez', 'real-estate-manager' ),
		'GT-SM' => __( 'San Marcos', 'real-estate-manager' ),
		'GT-SR' => __( 'Santa Rosa', 'real-estate-manager' ),
		'GT-SO' => __( 'Sololá', 'real-estate-manager' ),
		'GT-SU' => __( 'Suchitepéquez', 'real-estate-manager' ),
		'GT-TO' => __( 'Totonicapán', 'real-estate-manager' ),
		'GT-ZA' => __( 'Zacapa', 'real-estate-manager' ),
	),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'real-estate-manager' ),
		'KOWLOON'         => __( 'Kowloon', 'real-estate-manager' ),
		'NEW TERRITORIES' => __( 'New Territories', 'real-estate-manager' ),
	),
	'HN' => array( // Honduras states.
		'HN-AT' => __( 'Atlántida', 'real-estate-manager' ),
		'HN-IB' => __( 'Bay Islands', 'real-estate-manager' ),
		'HN-CH' => __( 'Choluteca', 'real-estate-manager' ),
		'HN-CL' => __( 'Colón', 'real-estate-manager' ),
		'HN-CM' => __( 'Comayagua', 'real-estate-manager' ),
		'HN-CP' => __( 'Copán', 'real-estate-manager' ),
		'HN-CR' => __( 'Cortés', 'real-estate-manager' ),
		'HN-EP' => __( 'El Paraíso', 'real-estate-manager' ),
		'HN-FM' => __( 'Francisco Morazán', 'real-estate-manager' ),
		'HN-GD' => __( 'Gracias a Dios', 'real-estate-manager' ),
		'HN-IN' => __( 'Intibucá', 'real-estate-manager' ),
		'HN-LE' => __( 'Lempira', 'real-estate-manager' ),
		'HN-LP' => __( 'La Paz', 'real-estate-manager' ),
		'HN-OC' => __( 'Ocotepeque', 'real-estate-manager' ),
		'HN-OL' => __( 'Olancho', 'real-estate-manager' ),
		'HN-SB' => __( 'Santa Bárbara', 'real-estate-manager' ),
		'HN-VA' => __( 'Valle', 'real-estate-manager' ),
		'HN-YO' => __( 'Yoro', 'real-estate-manager' ),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'real-estate-manager' ),
		'BE' => __( 'Békés', 'real-estate-manager' ),
		'BA' => __( 'Baranya', 'real-estate-manager' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'real-estate-manager' ),
		'BU' => __( 'Budapest', 'real-estate-manager' ),
		'CS' => __( 'Csongrád-Csanád', 'real-estate-manager' ),
		'FE' => __( 'Fejér', 'real-estate-manager' ),
		'GS' => __( 'Győr-Moson-Sopron', 'real-estate-manager' ),
		'HB' => __( 'Hajdú-Bihar', 'real-estate-manager' ),
		'HE' => __( 'Heves', 'real-estate-manager' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'real-estate-manager' ),
		'KE' => __( 'Komárom-Esztergom', 'real-estate-manager' ),
		'NO' => __( 'Nógrád', 'real-estate-manager' ),
		'PE' => __( 'Pest', 'real-estate-manager' ),
		'SO' => __( 'Somogy', 'real-estate-manager' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'real-estate-manager' ),
		'TO' => __( 'Tolna', 'real-estate-manager' ),
		'VA' => __( 'Vas', 'real-estate-manager' ),
		'VE' => __( 'Veszprém', 'real-estate-manager' ),
		'ZA' => __( 'Zala', 'real-estate-manager' ),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'real-estate-manager' ),
		'SU' => __( 'Sumatera Utara', 'real-estate-manager' ),
		'SB' => __( 'Sumatera Barat', 'real-estate-manager' ),
		'RI' => __( 'Riau', 'real-estate-manager' ),
		'KR' => __( 'Kepulauan Riau', 'real-estate-manager' ),
		'JA' => __( 'Jambi', 'real-estate-manager' ),
		'SS' => __( 'Sumatera Selatan', 'real-estate-manager' ),
		'BB' => __( 'Bangka Belitung', 'real-estate-manager' ),
		'BE' => __( 'Bengkulu', 'real-estate-manager' ),
		'LA' => __( 'Lampung', 'real-estate-manager' ),
		'JK' => __( 'DKI Jakarta', 'real-estate-manager' ),
		'JB' => __( 'Jawa Barat', 'real-estate-manager' ),
		'BT' => __( 'Banten', 'real-estate-manager' ),
		'JT' => __( 'Jawa Tengah', 'real-estate-manager' ),
		'JI' => __( 'Jawa Timur', 'real-estate-manager' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'real-estate-manager' ),
		'BA' => __( 'Bali', 'real-estate-manager' ),
		'NB' => __( 'Nusa Tenggara Barat', 'real-estate-manager' ),
		'NT' => __( 'Nusa Tenggara Timur', 'real-estate-manager' ),
		'KB' => __( 'Kalimantan Barat', 'real-estate-manager' ),
		'KT' => __( 'Kalimantan Tengah', 'real-estate-manager' ),
		'KI' => __( 'Kalimantan Timur', 'real-estate-manager' ),
		'KS' => __( 'Kalimantan Selatan', 'real-estate-manager' ),
		'KU' => __( 'Kalimantan Utara', 'real-estate-manager' ),
		'SA' => __( 'Sulawesi Utara', 'real-estate-manager' ),
		'ST' => __( 'Sulawesi Tengah', 'real-estate-manager' ),
		'SG' => __( 'Sulawesi Tenggara', 'real-estate-manager' ),
		'SR' => __( 'Sulawesi Barat', 'real-estate-manager' ),
		'SN' => __( 'Sulawesi Selatan', 'real-estate-manager' ),
		'GO' => __( 'Gorontalo', 'real-estate-manager' ),
		'MA' => __( 'Maluku', 'real-estate-manager' ),
		'MU' => __( 'Maluku Utara', 'real-estate-manager' ),
		'PA' => __( 'Papua', 'real-estate-manager' ),
		'PB' => __( 'Papua Barat', 'real-estate-manager' ),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'real-estate-manager' ),
		'CN' => __( 'Cavan', 'real-estate-manager' ),
		'CE' => __( 'Clare', 'real-estate-manager' ),
		'CO' => __( 'Cork', 'real-estate-manager' ),
		'DL' => __( 'Donegal', 'real-estate-manager' ),
		'D'  => __( 'Dublin', 'real-estate-manager' ),
		'G'  => __( 'Galway', 'real-estate-manager' ),
		'KY' => __( 'Kerry', 'real-estate-manager' ),
		'KE' => __( 'Kildare', 'real-estate-manager' ),
		'KK' => __( 'Kilkenny', 'real-estate-manager' ),
		'LS' => __( 'Laois', 'real-estate-manager' ),
		'LM' => __( 'Leitrim', 'real-estate-manager' ),
		'LK' => __( 'Limerick', 'real-estate-manager' ),
		'LD' => __( 'Longford', 'real-estate-manager' ),
		'LH' => __( 'Louth', 'real-estate-manager' ),
		'MO' => __( 'Mayo', 'real-estate-manager' ),
		'MH' => __( 'Meath', 'real-estate-manager' ),
		'MN' => __( 'Monaghan', 'real-estate-manager' ),
		'OY' => __( 'Offaly', 'real-estate-manager' ),
		'RN' => __( 'Roscommon', 'real-estate-manager' ),
		'SO' => __( 'Sligo', 'real-estate-manager' ),
		'TA' => __( 'Tipperary', 'real-estate-manager' ),
		'WD' => __( 'Waterford', 'real-estate-manager' ),
		'WH' => __( 'Westmeath', 'real-estate-manager' ),
		'WX' => __( 'Wexford', 'real-estate-manager' ),
		'WW' => __( 'Wicklow', 'real-estate-manager' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'real-estate-manager' ),
		'AR' => __( 'Arunachal Pradesh', 'real-estate-manager' ),
		'AS' => __( 'Assam', 'real-estate-manager' ),
		'BR' => __( 'Bihar', 'real-estate-manager' ),
		'CT' => __( 'Chhattisgarh', 'real-estate-manager' ),
		'GA' => __( 'Goa', 'real-estate-manager' ),
		'GJ' => __( 'Gujarat', 'real-estate-manager' ),
		'HR' => __( 'Haryana', 'real-estate-manager' ),
		'HP' => __( 'Himachal Pradesh', 'real-estate-manager' ),
		'JK' => __( 'Jammu and Kashmir', 'real-estate-manager' ),
		'JH' => __( 'Jharkhand', 'real-estate-manager' ),
		'KA' => __( 'Karnataka', 'real-estate-manager' ),
		'KL' => __( 'Kerala', 'real-estate-manager' ),
		'LA' => __( 'Ladakh', 'real-estate-manager' ),
		'MP' => __( 'Madhya Pradesh', 'real-estate-manager' ),
		'MH' => __( 'Maharashtra', 'real-estate-manager' ),
		'MN' => __( 'Manipur', 'real-estate-manager' ),
		'ML' => __( 'Meghalaya', 'real-estate-manager' ),
		'MZ' => __( 'Mizoram', 'real-estate-manager' ),
		'NL' => __( 'Nagaland', 'real-estate-manager' ),
		'OR' => __( 'Odisha', 'real-estate-manager' ),
		'PB' => __( 'Punjab', 'real-estate-manager' ),
		'RJ' => __( 'Rajasthan', 'real-estate-manager' ),
		'SK' => __( 'Sikkim', 'real-estate-manager' ),
		'TN' => __( 'Tamil Nadu', 'real-estate-manager' ),
		'TS' => __( 'Telangana', 'real-estate-manager' ),
		'TR' => __( 'Tripura', 'real-estate-manager' ),
		'UK' => __( 'Uttarakhand', 'real-estate-manager' ),
		'UP' => __( 'Uttar Pradesh', 'real-estate-manager' ),
		'WB' => __( 'West Bengal', 'real-estate-manager' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'real-estate-manager' ),
		'CH' => __( 'Chandigarh', 'real-estate-manager' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'real-estate-manager' ),
		'DD' => __( 'Daman and Diu', 'real-estate-manager' ),
		'DL' => __( 'Delhi', 'real-estate-manager' ),
		'LD' => __( 'Lakshadeep', 'real-estate-manager' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'real-estate-manager' ),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan (خوزستان)', 'real-estate-manager' ),
		'THR' => __( 'Tehran (تهران)', 'real-estate-manager' ),
		'ILM' => __( 'Ilaam (ایلام)', 'real-estate-manager' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'real-estate-manager' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'real-estate-manager' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'real-estate-manager' ),
		'YZD' => __( 'Yazd (یزد)', 'real-estate-manager' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'real-estate-manager' ),
		'KRN' => __( 'Kerman (کرمان)', 'real-estate-manager' ),
		'HDN' => __( 'Hamadan (همدان)', 'real-estate-manager' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'real-estate-manager' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'real-estate-manager' ),
		'LRS' => __( 'Luristan (لرستان)', 'real-estate-manager' ),
		'ABZ' => __( 'Alborz (البرز)', 'real-estate-manager' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'real-estate-manager' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'real-estate-manager' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'real-estate-manager' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'real-estate-manager' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'real-estate-manager' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'real-estate-manager' ),
		'SMN' => __( 'Semnan (سمنان)', 'real-estate-manager' ),
		'FRS' => __( 'Fars (فارس)', 'real-estate-manager' ),
		'QHM' => __( 'Qom (قم)', 'real-estate-manager' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'real-estate-manager' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'real-estate-manager' ),
		'GLS' => __( 'Golestan (گلستان)', 'real-estate-manager' ),
		'GIL' => __( 'Gilan (گیلان)', 'real-estate-manager' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'real-estate-manager' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'real-estate-manager' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'real-estate-manager' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'real-estate-manager' ),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'real-estate-manager' ),
		'AL' => __( 'Alessandria', 'real-estate-manager' ),
		'AN' => __( 'Ancona', 'real-estate-manager' ),
		'AO' => __( 'Aosta', 'real-estate-manager' ),
		'AR' => __( 'Arezzo', 'real-estate-manager' ),
		'AP' => __( 'Ascoli Piceno', 'real-estate-manager' ),
		'AT' => __( 'Asti', 'real-estate-manager' ),
		'AV' => __( 'Avellino', 'real-estate-manager' ),
		'BA' => __( 'Bari', 'real-estate-manager' ),
		'BT' => __( 'Barletta-Andria-Trani', 'real-estate-manager' ),
		'BL' => __( 'Belluno', 'real-estate-manager' ),
		'BN' => __( 'Benevento', 'real-estate-manager' ),
		'BG' => __( 'Bergamo', 'real-estate-manager' ),
		'BI' => __( 'Biella', 'real-estate-manager' ),
		'BO' => __( 'Bologna', 'real-estate-manager' ),
		'BZ' => __( 'Bolzano', 'real-estate-manager' ),
		'BS' => __( 'Brescia', 'real-estate-manager' ),
		'BR' => __( 'Brindisi', 'real-estate-manager' ),
		'CA' => __( 'Cagliari', 'real-estate-manager' ),
		'CL' => __( 'Caltanissetta', 'real-estate-manager' ),
		'CB' => __( 'Campobasso', 'real-estate-manager' ),
		'CE' => __( 'Caserta', 'real-estate-manager' ),
		'CT' => __( 'Catania', 'real-estate-manager' ),
		'CZ' => __( 'Catanzaro', 'real-estate-manager' ),
		'CH' => __( 'Chieti', 'real-estate-manager' ),
		'CO' => __( 'Como', 'real-estate-manager' ),
		'CS' => __( 'Cosenza', 'real-estate-manager' ),
		'CR' => __( 'Cremona', 'real-estate-manager' ),
		'KR' => __( 'Crotone', 'real-estate-manager' ),
		'CN' => __( 'Cuneo', 'real-estate-manager' ),
		'EN' => __( 'Enna', 'real-estate-manager' ),
		'FM' => __( 'Fermo', 'real-estate-manager' ),
		'FE' => __( 'Ferrara', 'real-estate-manager' ),
		'FI' => __( 'Firenze', 'real-estate-manager' ),
		'FG' => __( 'Foggia', 'real-estate-manager' ),
		'FC' => __( 'Forlì-Cesena', 'real-estate-manager' ),
		'FR' => __( 'Frosinone', 'real-estate-manager' ),
		'GE' => __( 'Genova', 'real-estate-manager' ),
		'GO' => __( 'Gorizia', 'real-estate-manager' ),
		'GR' => __( 'Grosseto', 'real-estate-manager' ),
		'IM' => __( 'Imperia', 'real-estate-manager' ),
		'IS' => __( 'Isernia', 'real-estate-manager' ),
		'SP' => __( 'La Spezia', 'real-estate-manager' ),
		'AQ' => __( "L'Aquila", 'real-estate-manager' ),
		'LT' => __( 'Latina', 'real-estate-manager' ),
		'LE' => __( 'Lecce', 'real-estate-manager' ),
		'LC' => __( 'Lecco', 'real-estate-manager' ),
		'LI' => __( 'Livorno', 'real-estate-manager' ),
		'LO' => __( 'Lodi', 'real-estate-manager' ),
		'LU' => __( 'Lucca', 'real-estate-manager' ),
		'MC' => __( 'Macerata', 'real-estate-manager' ),
		'MN' => __( 'Mantova', 'real-estate-manager' ),
		'MS' => __( 'Massa-Carrara', 'real-estate-manager' ),
		'MT' => __( 'Matera', 'real-estate-manager' ),
		'ME' => __( 'Messina', 'real-estate-manager' ),
		'MI' => __( 'Milano', 'real-estate-manager' ),
		'MO' => __( 'Modena', 'real-estate-manager' ),
		'MB' => __( 'Monza e della Brianza', 'real-estate-manager' ),
		'NA' => __( 'Napoli', 'real-estate-manager' ),
		'NO' => __( 'Novara', 'real-estate-manager' ),
		'NU' => __( 'Nuoro', 'real-estate-manager' ),
		'OR' => __( 'Oristano', 'real-estate-manager' ),
		'PD' => __( 'Padova', 'real-estate-manager' ),
		'PA' => __( 'Palermo', 'real-estate-manager' ),
		'PR' => __( 'Parma', 'real-estate-manager' ),
		'PV' => __( 'Pavia', 'real-estate-manager' ),
		'PG' => __( 'Perugia', 'real-estate-manager' ),
		'PU' => __( 'Pesaro e Urbino', 'real-estate-manager' ),
		'PE' => __( 'Pescara', 'real-estate-manager' ),
		'PC' => __( 'Piacenza', 'real-estate-manager' ),
		'PI' => __( 'Pisa', 'real-estate-manager' ),
		'PT' => __( 'Pistoia', 'real-estate-manager' ),
		'PN' => __( 'Pordenone', 'real-estate-manager' ),
		'PZ' => __( 'Potenza', 'real-estate-manager' ),
		'PO' => __( 'Prato', 'real-estate-manager' ),
		'RG' => __( 'Ragusa', 'real-estate-manager' ),
		'RA' => __( 'Ravenna', 'real-estate-manager' ),
		'RC' => __( 'Reggio Calabria', 'real-estate-manager' ),
		'RE' => __( 'Reggio Emilia', 'real-estate-manager' ),
		'RI' => __( 'Rieti', 'real-estate-manager' ),
		'RN' => __( 'Rimini', 'real-estate-manager' ),
		'RM' => __( 'Roma', 'real-estate-manager' ),
		'RO' => __( 'Rovigo', 'real-estate-manager' ),
		'SA' => __( 'Salerno', 'real-estate-manager' ),
		'SS' => __( 'Sassari', 'real-estate-manager' ),
		'SV' => __( 'Savona', 'real-estate-manager' ),
		'SI' => __( 'Siena', 'real-estate-manager' ),
		'SR' => __( 'Siracusa', 'real-estate-manager' ),
		'SO' => __( 'Sondrio', 'real-estate-manager' ),
		'SU' => __( 'Sud Sardegna', 'real-estate-manager' ),
		'TA' => __( 'Taranto', 'real-estate-manager' ),
		'TE' => __( 'Teramo', 'real-estate-manager' ),
		'TR' => __( 'Terni', 'real-estate-manager' ),
		'TO' => __( 'Torino', 'real-estate-manager' ),
		'TP' => __( 'Trapani', 'real-estate-manager' ),
		'TN' => __( 'Trento', 'real-estate-manager' ),
		'TV' => __( 'Treviso', 'real-estate-manager' ),
		'TS' => __( 'Trieste', 'real-estate-manager' ),
		'UD' => __( 'Udine', 'real-estate-manager' ),
		'VA' => __( 'Varese', 'real-estate-manager' ),
		'VE' => __( 'Venezia', 'real-estate-manager' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'real-estate-manager' ),
		'VC' => __( 'Vercelli', 'real-estate-manager' ),
		'VR' => __( 'Verona', 'real-estate-manager' ),
		'VV' => __( 'Vibo Valentia', 'real-estate-manager' ),
		'VI' => __( 'Vicenza', 'real-estate-manager' ),
		'VT' => __( 'Viterbo', 'real-estate-manager' ),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
		'JM-01' => __( 'Kingston', 'real-estate-manager' ),
		'JM-02' => __( 'Saint Andrew', 'real-estate-manager' ),
		'JM-03' => __( 'Saint Thomas', 'real-estate-manager' ),
		'JM-04' => __( 'Portland', 'real-estate-manager' ),
		'JM-05' => __( 'Saint Mary', 'real-estate-manager' ),
		'JM-06' => __( 'Saint Ann', 'real-estate-manager' ),
		'JM-07' => __( 'Trelawny', 'real-estate-manager' ),
		'JM-08' => __( 'Saint James', 'real-estate-manager' ),
		'JM-09' => __( 'Hanover', 'real-estate-manager' ),
		'JM-10' => __( 'Westmoreland', 'real-estate-manager' ),
		'JM-11' => __( 'Saint Elizabeth', 'real-estate-manager' ),
		'JM-12' => __( 'Manchester', 'real-estate-manager' ),
		'JM-13' => __( 'Clarendon', 'real-estate-manager' ),
		'JM-14' => __( 'Saint Catherine', 'real-estate-manager' ),
	),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'real-estate-manager' ),
		'JP02' => __( 'Aomori', 'real-estate-manager' ),
		'JP03' => __( 'Iwate', 'real-estate-manager' ),
		'JP04' => __( 'Miyagi', 'real-estate-manager' ),
		'JP05' => __( 'Akita', 'real-estate-manager' ),
		'JP06' => __( 'Yamagata', 'real-estate-manager' ),
		'JP07' => __( 'Fukushima', 'real-estate-manager' ),
		'JP08' => __( 'Ibaraki', 'real-estate-manager' ),
		'JP09' => __( 'Tochigi', 'real-estate-manager' ),
		'JP10' => __( 'Gunma', 'real-estate-manager' ),
		'JP11' => __( 'Saitama', 'real-estate-manager' ),
		'JP12' => __( 'Chiba', 'real-estate-manager' ),
		'JP13' => __( 'Tokyo', 'real-estate-manager' ),
		'JP14' => __( 'Kanagawa', 'real-estate-manager' ),
		'JP15' => __( 'Niigata', 'real-estate-manager' ),
		'JP16' => __( 'Toyama', 'real-estate-manager' ),
		'JP17' => __( 'Ishikawa', 'real-estate-manager' ),
		'JP18' => __( 'Fukui', 'real-estate-manager' ),
		'JP19' => __( 'Yamanashi', 'real-estate-manager' ),
		'JP20' => __( 'Nagano', 'real-estate-manager' ),
		'JP21' => __( 'Gifu', 'real-estate-manager' ),
		'JP22' => __( 'Shizuoka', 'real-estate-manager' ),
		'JP23' => __( 'Aichi', 'real-estate-manager' ),
		'JP24' => __( 'Mie', 'real-estate-manager' ),
		'JP25' => __( 'Shiga', 'real-estate-manager' ),
		'JP26' => __( 'Kyoto', 'real-estate-manager' ),
		'JP27' => __( 'Osaka', 'real-estate-manager' ),
		'JP28' => __( 'Hyogo', 'real-estate-manager' ),
		'JP29' => __( 'Nara', 'real-estate-manager' ),
		'JP30' => __( 'Wakayama', 'real-estate-manager' ),
		'JP31' => __( 'Tottori', 'real-estate-manager' ),
		'JP32' => __( 'Shimane', 'real-estate-manager' ),
		'JP33' => __( 'Okayama', 'real-estate-manager' ),
		'JP34' => __( 'Hiroshima', 'real-estate-manager' ),
		'JP35' => __( 'Yamaguchi', 'real-estate-manager' ),
		'JP36' => __( 'Tokushima', 'real-estate-manager' ),
		'JP37' => __( 'Kagawa', 'real-estate-manager' ),
		'JP38' => __( 'Ehime', 'real-estate-manager' ),
		'JP39' => __( 'Kochi', 'real-estate-manager' ),
		'JP40' => __( 'Fukuoka', 'real-estate-manager' ),
		'JP41' => __( 'Saga', 'real-estate-manager' ),
		'JP42' => __( 'Nagasaki', 'real-estate-manager' ),
		'JP43' => __( 'Kumamoto', 'real-estate-manager' ),
		'JP44' => __( 'Oita', 'real-estate-manager' ),
		'JP45' => __( 'Miyazaki', 'real-estate-manager' ),
		'JP46' => __( 'Kagoshima', 'real-estate-manager' ),
		'JP47' => __( 'Okinawa', 'real-estate-manager' ),
	),
	'KE' => array( // Kenya counties.
		'KE01' => __( 'Baringo', 'real-estate-manager' ),
		'KE02' => __( 'Bomet', 'real-estate-manager' ),
		'KE03' => __( 'Bungoma', 'real-estate-manager' ),
		'KE04' => __( 'Busia', 'real-estate-manager' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'real-estate-manager' ),
		'KE06' => __( 'Embu', 'real-estate-manager' ),
		'KE07' => __( 'Garissa', 'real-estate-manager' ),
		'KE08' => __( 'Homa Bay', 'real-estate-manager' ),
		'KE09' => __( 'Isiolo', 'real-estate-manager' ),
		'KE10' => __( 'Kajiado', 'real-estate-manager' ),
		'KE11' => __( 'Kakamega', 'real-estate-manager' ),
		'KE12' => __( 'Kericho', 'real-estate-manager' ),
		'KE13' => __( 'Kiambu', 'real-estate-manager' ),
		'KE14' => __( 'Kilifi', 'real-estate-manager' ),
		'KE15' => __( 'Kirinyaga', 'real-estate-manager' ),
		'KE16' => __( 'Kisii', 'real-estate-manager' ),
		'KE17' => __( 'Kisumu', 'real-estate-manager' ),
		'KE18' => __( 'Kitui', 'real-estate-manager' ),
		'KE19' => __( 'Kwale', 'real-estate-manager' ),
		'KE20' => __( 'Laikipia', 'real-estate-manager' ),
		'KE21' => __( 'Lamu', 'real-estate-manager' ),
		'KE22' => __( 'Machakos', 'real-estate-manager' ),
		'KE23' => __( 'Makueni', 'real-estate-manager' ),
		'KE24' => __( 'Mandera', 'real-estate-manager' ),
		'KE25' => __( 'Marsabit', 'real-estate-manager' ),
		'KE26' => __( 'Meru', 'real-estate-manager' ),
		'KE27' => __( 'Migori', 'real-estate-manager' ),
		'KE28' => __( 'Mombasa', 'real-estate-manager' ),
		'KE29' => __( 'Murang’a', 'real-estate-manager' ),
		'KE30' => __( 'Nairobi County', 'real-estate-manager' ),
		'KE31' => __( 'Nakuru', 'real-estate-manager' ),
		'KE32' => __( 'Nandi', 'real-estate-manager' ),
		'KE33' => __( 'Narok', 'real-estate-manager' ),
		'KE34' => __( 'Nyamira', 'real-estate-manager' ),
		'KE35' => __( 'Nyandarua', 'real-estate-manager' ),
		'KE36' => __( 'Nyeri', 'real-estate-manager' ),
		'KE37' => __( 'Samburu', 'real-estate-manager' ),
		'KE38' => __( 'Siaya', 'real-estate-manager' ),
		'KE39' => __( 'Taita-Taveta', 'real-estate-manager' ),
		'KE40' => __( 'Tana River', 'real-estate-manager' ),
		'KE41' => __( 'Tharaka-Nithi', 'real-estate-manager' ),
		'KE42' => __( 'Trans Nzoia', 'real-estate-manager' ),
		'KE43' => __( 'Turkana', 'real-estate-manager' ),
		'KE44' => __( 'Uasin Gishu', 'real-estate-manager' ),
		'KE45' => __( 'Vihiga', 'real-estate-manager' ),
		'KE46' => __( 'Wajir', 'real-estate-manager' ),
		'KE47' => __( 'West Pokot', 'real-estate-manager' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array(
		'AT' => __( 'Attapeu', 'real-estate-manager' ),
		'BK' => __( 'Bokeo', 'real-estate-manager' ),
		'BL' => __( 'Bolikhamsai', 'real-estate-manager' ),
		'CH' => __( 'Champasak', 'real-estate-manager' ),
		'HO' => __( 'Houaphanh', 'real-estate-manager' ),
		'KH' => __( 'Khammouane', 'real-estate-manager' ),
		'LM' => __( 'Luang Namtha', 'real-estate-manager' ),
		'LP' => __( 'Luang Prabang', 'real-estate-manager' ),
		'OU' => __( 'Oudomxay', 'real-estate-manager' ),
		'PH' => __( 'Phongsaly', 'real-estate-manager' ),
		'SL' => __( 'Salavan', 'real-estate-manager' ),
		'SV' => __( 'Savannakhet', 'real-estate-manager' ),
		'VI' => __( 'Vientiane Province', 'real-estate-manager' ),
		'VT' => __( 'Vientiane', 'real-estate-manager' ),
		'XA' => __( 'Sainyabuli', 'real-estate-manager' ),
		'XE' => __( 'Sekong', 'real-estate-manager' ),
		'XI' => __( 'Xiangkhouang', 'real-estate-manager' ),
		'XS' => __( 'Xaisomboun', 'real-estate-manager' ),
	),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'real-estate-manager' ),
		'BN' => __( 'Bong', 'real-estate-manager' ),
		'GA' => __( 'Gbarpolu', 'real-estate-manager' ),
		'GB' => __( 'Grand Bassa', 'real-estate-manager' ),
		'GC' => __( 'Grand Cape Mount', 'real-estate-manager' ),
		'GG' => __( 'Grand Gedeh', 'real-estate-manager' ),
		'GK' => __( 'Grand Kru', 'real-estate-manager' ),
		'LO' => __( 'Lofa', 'real-estate-manager' ),
		'MA' => __( 'Margibi', 'real-estate-manager' ),
		'MY' => __( 'Maryland', 'real-estate-manager' ),
		'MO' => __( 'Montserrado', 'real-estate-manager' ),
		'NM' => __( 'Nimba', 'real-estate-manager' ),
		'RV' => __( 'Rivercess', 'real-estate-manager' ),
		'RG' => __( 'River Gee', 'real-estate-manager' ),
		'SN' => __( 'Sinoe', 'real-estate-manager' ),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chișinău', 'real-estate-manager' ),
		'BL' => __( 'Bălți', 'real-estate-manager' ),
		'AN' => __( 'Anenii Noi', 'real-estate-manager' ),
		'BS' => __( 'Basarabeasca', 'real-estate-manager' ),
		'BR' => __( 'Briceni', 'real-estate-manager' ),
		'CH' => __( 'Cahul', 'real-estate-manager' ),
		'CT' => __( 'Cantemir', 'real-estate-manager' ),
		'CL' => __( 'Călărași', 'real-estate-manager' ),
		'CS' => __( 'Căușeni', 'real-estate-manager' ),
		'CM' => __( 'Cimișlia', 'real-estate-manager' ),
		'CR' => __( 'Criuleni', 'real-estate-manager' ),
		'DN' => __( 'Dondușeni', 'real-estate-manager' ),
		'DR' => __( 'Drochia', 'real-estate-manager' ),
		'DB' => __( 'Dubăsari', 'real-estate-manager' ),
		'ED' => __( 'Edineț', 'real-estate-manager' ),
		'FL' => __( 'Fălești', 'real-estate-manager' ),
		'FR' => __( 'Florești', 'real-estate-manager' ),
		'GE' => __( 'UTA Găgăuzia', 'real-estate-manager' ),
		'GL' => __( 'Glodeni', 'real-estate-manager' ),
		'HN' => __( 'Hîncești', 'real-estate-manager' ),
		'IL' => __( 'Ialoveni', 'real-estate-manager' ),
		'LV' => __( 'Leova', 'real-estate-manager' ),
		'NS' => __( 'Nisporeni', 'real-estate-manager' ),
		'OC' => __( 'Ocnița', 'real-estate-manager' ),
		'OR' => __( 'Orhei', 'real-estate-manager' ),
		'RZ' => __( 'Rezina', 'real-estate-manager' ),
		'RS' => __( 'Rîșcani', 'real-estate-manager' ),
		'SG' => __( 'Sîngerei', 'real-estate-manager' ),
		'SR' => __( 'Soroca', 'real-estate-manager' ),
		'ST' => __( 'Strășeni', 'real-estate-manager' ),
		'SD' => __( 'Șoldănești', 'real-estate-manager' ),
		'SV' => __( 'Ștefan Vodă', 'real-estate-manager' ),
		'TR' => __( 'Taraclia', 'real-estate-manager' ),
		'TL' => __( 'Telenești', 'real-estate-manager' ),
		'UN' => __( 'Ungheni', 'real-estate-manager' ),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de México', 'real-estate-manager' ),
		'JA' => __( 'Jalisco', 'real-estate-manager' ),
		'NL' => __( 'Nuevo León', 'real-estate-manager' ),
		'AG' => __( 'Aguascalientes', 'real-estate-manager' ),
		'BC' => __( 'Baja California', 'real-estate-manager' ),
		'BS' => __( 'Baja California Sur', 'real-estate-manager' ),
		'CM' => __( 'Campeche', 'real-estate-manager' ),
		'CS' => __( 'Chiapas', 'real-estate-manager' ),
		'CH' => __( 'Chihuahua', 'real-estate-manager' ),
		'CO' => __( 'Coahuila', 'real-estate-manager' ),
		'CL' => __( 'Colima', 'real-estate-manager' ),
		'DG' => __( 'Durango', 'real-estate-manager' ),
		'GT' => __( 'Guanajuato', 'real-estate-manager' ),
		'GR' => __( 'Guerrero', 'real-estate-manager' ),
		'HG' => __( 'Hidalgo', 'real-estate-manager' ),
		'MX' => __( 'Estado de México', 'real-estate-manager' ),
		'MI' => __( 'Michoacán', 'real-estate-manager' ),
		'MO' => __( 'Morelos', 'real-estate-manager' ),
		'NA' => __( 'Nayarit', 'real-estate-manager' ),
		'OA' => __( 'Oaxaca', 'real-estate-manager' ),
		'PU' => __( 'Puebla', 'real-estate-manager' ),
		'QT' => __( 'Querétaro', 'real-estate-manager' ),
		'QR' => __( 'Quintana Roo', 'real-estate-manager' ),
		'SL' => __( 'San Luis Potosí', 'real-estate-manager' ),
		'SI' => __( 'Sinaloa', 'real-estate-manager' ),
		'SO' => __( 'Sonora', 'real-estate-manager' ),
		'TB' => __( 'Tabasco', 'real-estate-manager' ),
		'TM' => __( 'Tamaulipas', 'real-estate-manager' ),
		'TL' => __( 'Tlaxcala', 'real-estate-manager' ),
		'VE' => __( 'Veracruz', 'real-estate-manager' ),
		'YU' => __( 'Yucatán', 'real-estate-manager' ),
		'ZA' => __( 'Zacatecas', 'real-estate-manager' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'real-estate-manager' ),
		'KDH' => __( 'Kedah', 'real-estate-manager' ),
		'KTN' => __( 'Kelantan', 'real-estate-manager' ),
		'LBN' => __( 'Labuan', 'real-estate-manager' ),
		'MLK' => __( 'Malacca (Melaka)', 'real-estate-manager' ),
		'NSN' => __( 'Negeri Sembilan', 'real-estate-manager' ),
		'PHG' => __( 'Pahang', 'real-estate-manager' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'real-estate-manager' ),
		'PRK' => __( 'Perak', 'real-estate-manager' ),
		'PLS' => __( 'Perlis', 'real-estate-manager' ),
		'SBH' => __( 'Sabah', 'real-estate-manager' ),
		'SWK' => __( 'Sarawak', 'real-estate-manager' ),
		'SGR' => __( 'Selangor', 'real-estate-manager' ),
		'TRG' => __( 'Terengganu', 'real-estate-manager' ),
		'PJY' => __( 'Putrajaya', 'real-estate-manager' ),
		'KUL' => __( 'Kuala Lumpur', 'real-estate-manager' ),
	),
	'MZ' => array( // Mozambique provinces.
		'MZP'   => __( 'Cabo Delgado', 'real-estate-manager' ),
		'MZG'   => __( 'Gaza', 'real-estate-manager' ),
		'MZI'   => __( 'Inhambane', 'real-estate-manager' ),
		'MZB'   => __( 'Manica', 'real-estate-manager' ),
		'MZL'   => __( 'Maputo Province', 'real-estate-manager' ),
		'MZMPM' => __( 'Maputo', 'real-estate-manager' ),
		'MZN'   => __( 'Nampula', 'real-estate-manager' ),
		'MZA'   => __( 'Niassa', 'real-estate-manager' ),
		'MZS'   => __( 'Sofala', 'real-estate-manager' ),
		'MZT'   => __( 'Tete', 'real-estate-manager' ),
		'MZQ'   => __( 'Zambézia', 'real-estate-manager' ),
	),
	'NA' => array( // Namibia regions.
		'ER' => __( 'Erongo', 'real-estate-manager' ),
		'HA' => __( 'Hardap', 'real-estate-manager' ),
		'KA' => __( 'Karas', 'real-estate-manager' ),
		'KE' => __( 'Kavango East', 'real-estate-manager' ),
		'KW' => __( 'Kavango West', 'real-estate-manager' ),
		'KH' => __( 'Khomas', 'real-estate-manager' ),
		'KU' => __( 'Kunene', 'real-estate-manager' ),
		'OW' => __( 'Ohangwena', 'real-estate-manager' ),
		'OH' => __( 'Omaheke', 'real-estate-manager' ),
		'OS' => __( 'Omusati', 'real-estate-manager' ),
		'ON' => __( 'Oshana', 'real-estate-manager' ),
		'OT' => __( 'Oshikoto', 'real-estate-manager' ),
		'OD' => __( 'Otjozondjupa', 'real-estate-manager' ),
		'CA' => __( 'Zambezi', 'real-estate-manager' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'real-estate-manager' ),
		'FC' => __( 'Abuja', 'real-estate-manager' ),
		'AD' => __( 'Adamawa', 'real-estate-manager' ),
		'AK' => __( 'Akwa Ibom', 'real-estate-manager' ),
		'AN' => __( 'Anambra', 'real-estate-manager' ),
		'BA' => __( 'Bauchi', 'real-estate-manager' ),
		'BY' => __( 'Bayelsa', 'real-estate-manager' ),
		'BE' => __( 'Benue', 'real-estate-manager' ),
		'BO' => __( 'Borno', 'real-estate-manager' ),
		'CR' => __( 'Cross River', 'real-estate-manager' ),
		'DE' => __( 'Delta', 'real-estate-manager' ),
		'EB' => __( 'Ebonyi', 'real-estate-manager' ),
		'ED' => __( 'Edo', 'real-estate-manager' ),
		'EK' => __( 'Ekiti', 'real-estate-manager' ),
		'EN' => __( 'Enugu', 'real-estate-manager' ),
		'GO' => __( 'Gombe', 'real-estate-manager' ),
		'IM' => __( 'Imo', 'real-estate-manager' ),
		'JI' => __( 'Jigawa', 'real-estate-manager' ),
		'KD' => __( 'Kaduna', 'real-estate-manager' ),
		'KN' => __( 'Kano', 'real-estate-manager' ),
		'KT' => __( 'Katsina', 'real-estate-manager' ),
		'KE' => __( 'Kebbi', 'real-estate-manager' ),
		'KO' => __( 'Kogi', 'real-estate-manager' ),
		'KW' => __( 'Kwara', 'real-estate-manager' ),
		'LA' => __( 'Lagos', 'real-estate-manager' ),
		'NA' => __( 'Nasarawa', 'real-estate-manager' ),
		'NI' => __( 'Niger', 'real-estate-manager' ),
		'OG' => __( 'Ogun', 'real-estate-manager' ),
		'ON' => __( 'Ondo', 'real-estate-manager' ),
		'OS' => __( 'Osun', 'real-estate-manager' ),
		'OY' => __( 'Oyo', 'real-estate-manager' ),
		'PL' => __( 'Plateau', 'real-estate-manager' ),
		'RI' => __( 'Rivers', 'real-estate-manager' ),
		'SO' => __( 'Sokoto', 'real-estate-manager' ),
		'TA' => __( 'Taraba', 'real-estate-manager' ),
		'YO' => __( 'Yobe', 'real-estate-manager' ),
		'ZA' => __( 'Zamfara', 'real-estate-manager' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'real-estate-manager' ),
		'BHE' => __( 'Bheri', 'real-estate-manager' ),
		'DHA' => __( 'Dhaulagiri', 'real-estate-manager' ),
		'GAN' => __( 'Gandaki', 'real-estate-manager' ),
		'JAN' => __( 'Janakpur', 'real-estate-manager' ),
		'KAR' => __( 'Karnali', 'real-estate-manager' ),
		'KOS' => __( 'Koshi', 'real-estate-manager' ),
		'LUM' => __( 'Lumbini', 'real-estate-manager' ),
		'MAH' => __( 'Mahakali', 'real-estate-manager' ),
		'MEC' => __( 'Mechi', 'real-estate-manager' ),
		'NAR' => __( 'Narayani', 'real-estate-manager' ),
		'RAP' => __( 'Rapti', 'real-estate-manager' ),
		'SAG' => __( 'Sagarmatha', 'real-estate-manager' ),
		'SET' => __( 'Seti', 'real-estate-manager' ),
	),
	'NI' => array( // Nicaragua states
		'NI-AN' => __( 'Atlántico Norte', 'real-estate-manager' ),
		'NI-AS' => __( 'Atlántico Sur', 'real-estate-manager' ),
		'NI-BO' => __( 'Boaco', 'real-estate-manager' ),
		'NI-CA' => __( 'Carazo', 'real-estate-manager' ),
		'NI-CI' => __( 'Chinandega', 'real-estate-manager' ),
		'NI-CO' => __( 'Chontales', 'real-estate-manager' ),
		'NI-ES' => __( 'Estelí', 'real-estate-manager' ),
		'NI-GR' => __( 'Granada', 'real-estate-manager' ),
		'NI-JI' => __( 'Jinotega', 'real-estate-manager' ),
		'NI-LE' => __( 'León', 'real-estate-manager' ),
		'NI-MD' => __( 'Madriz', 'real-estate-manager' ),
		'NI-MN' => __( 'Managua', 'real-estate-manager' ),
		'NI-MS' => __( 'Masaya', 'real-estate-manager' ),
		'NI-MT' => __( 'Matagalpa', 'real-estate-manager' ),
		'NI-NS' => __( 'Nueva Segovia', 'real-estate-manager' ),
		'NI-RI' => __( 'Rivas', 'real-estate-manager' ),
		'NI-SJ' => __( 'Río San Juan', 'real-estate-manager' ),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'real-estate-manager' ),
		'AK' => __( 'Auckland', 'real-estate-manager' ),
		'WA' => __( 'Waikato', 'real-estate-manager' ),
		'BP' => __( 'Bay of Plenty', 'real-estate-manager' ),
		'TK' => __( 'Taranaki', 'real-estate-manager' ),
		'GI' => __( 'Gisborne', 'real-estate-manager' ),
		'HB' => __( 'Hawke’s Bay', 'real-estate-manager' ),
		'MW' => __( 'Manawatu-Wanganui', 'real-estate-manager' ),
		'WE' => __( 'Wellington', 'real-estate-manager' ),
		'NS' => __( 'Nelson', 'real-estate-manager' ),
		'MB' => __( 'Marlborough', 'real-estate-manager' ),
		'TM' => __( 'Tasman', 'real-estate-manager' ),
		'WC' => __( 'West Coast', 'real-estate-manager' ),
		'CT' => __( 'Canterbury', 'real-estate-manager' ),
		'OT' => __( 'Otago', 'real-estate-manager' ),
		'SL' => __( 'Southland', 'real-estate-manager' ),
	),
	'PA' => array( // Panama states.
		'PA-1' => __( 'Bocas del Toro', 'real-estate-manager' ),
		'PA-2' => __( 'Coclé', 'real-estate-manager' ),
		'PA-3' => __( 'Colón', 'real-estate-manager' ),
		'PA-4' => __( 'Chiriquí', 'real-estate-manager' ),
		'PA-5' => __( 'Darién', 'real-estate-manager' ),
		'PA-6' => __( 'Herrera', 'real-estate-manager' ),
		'PA-7' => __( 'Los Santos', 'real-estate-manager' ),
		'PA-8' => __( 'Panamá', 'real-estate-manager' ),
		'PA-9' => __( 'Veraguas', 'real-estate-manager' ),
		'PA-10' => __( 'West Panamá', 'real-estate-manager' ),
		'PA-EM' => __( 'Emberá', 'real-estate-manager' ),
		'PA-KY' => __( 'Guna Yala', 'real-estate-manager' ),
		'PA-NB' => __( 'Ngöbe-Buglé', 'real-estate-manager' ),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'real-estate-manager' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'real-estate-manager' ),
		'AMA' => __( 'Amazonas', 'real-estate-manager' ),
		'ANC' => __( 'Ancash', 'real-estate-manager' ),
		'APU' => __( 'Apurímac', 'real-estate-manager' ),
		'ARE' => __( 'Arequipa', 'real-estate-manager' ),
		'AYA' => __( 'Ayacucho', 'real-estate-manager' ),
		'CAJ' => __( 'Cajamarca', 'real-estate-manager' ),
		'CUS' => __( 'Cusco', 'real-estate-manager' ),
		'HUV' => __( 'Huancavelica', 'real-estate-manager' ),
		'HUC' => __( 'Huánuco', 'real-estate-manager' ),
		'ICA' => __( 'Ica', 'real-estate-manager' ),
		'JUN' => __( 'Junín', 'real-estate-manager' ),
		'LAL' => __( 'La Libertad', 'real-estate-manager' ),
		'LAM' => __( 'Lambayeque', 'real-estate-manager' ),
		'LIM' => __( 'Lima', 'real-estate-manager' ),
		'LOR' => __( 'Loreto', 'real-estate-manager' ),
		'MDD' => __( 'Madre de Dios', 'real-estate-manager' ),
		'MOQ' => __( 'Moquegua', 'real-estate-manager' ),
		'PAS' => __( 'Pasco', 'real-estate-manager' ),
		'PIU' => __( 'Piura', 'real-estate-manager' ),
		'PUN' => __( 'Puno', 'real-estate-manager' ),
		'SAM' => __( 'San Martín', 'real-estate-manager' ),
		'TAC' => __( 'Tacna', 'real-estate-manager' ),
		'TUM' => __( 'Tumbes', 'real-estate-manager' ),
		'UCA' => __( 'Ucayali', 'real-estate-manager' ),
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'real-estate-manager' ),
		'AGN' => __( 'Agusan del Norte', 'real-estate-manager' ),
		'AGS' => __( 'Agusan del Sur', 'real-estate-manager' ),
		'AKL' => __( 'Aklan', 'real-estate-manager' ),
		'ALB' => __( 'Albay', 'real-estate-manager' ),
		'ANT' => __( 'Antique', 'real-estate-manager' ),
		'APA' => __( 'Apayao', 'real-estate-manager' ),
		'AUR' => __( 'Aurora', 'real-estate-manager' ),
		'BAS' => __( 'Basilan', 'real-estate-manager' ),
		'BAN' => __( 'Bataan', 'real-estate-manager' ),
		'BTN' => __( 'Batanes', 'real-estate-manager' ),
		'BTG' => __( 'Batangas', 'real-estate-manager' ),
		'BEN' => __( 'Benguet', 'real-estate-manager' ),
		'BIL' => __( 'Biliran', 'real-estate-manager' ),
		'BOH' => __( 'Bohol', 'real-estate-manager' ),
		'BUK' => __( 'Bukidnon', 'real-estate-manager' ),
		'BUL' => __( 'Bulacan', 'real-estate-manager' ),
		'CAG' => __( 'Cagayan', 'real-estate-manager' ),
		'CAN' => __( 'Camarines Norte', 'real-estate-manager' ),
		'CAS' => __( 'Camarines Sur', 'real-estate-manager' ),
		'CAM' => __( 'Camiguin', 'real-estate-manager' ),
		'CAP' => __( 'Capiz', 'real-estate-manager' ),
		'CAT' => __( 'Catanduanes', 'real-estate-manager' ),
		'CAV' => __( 'Cavite', 'real-estate-manager' ),
		'CEB' => __( 'Cebu', 'real-estate-manager' ),
		'COM' => __( 'Compostela Valley', 'real-estate-manager' ),
		'NCO' => __( 'Cotabato', 'real-estate-manager' ),
		'DAV' => __( 'Davao del Norte', 'real-estate-manager' ),
		'DAS' => __( 'Davao del Sur', 'real-estate-manager' ),
		'DAC' => __( 'Davao Occidental', 'real-estate-manager' ),
		'DAO' => __( 'Davao Oriental', 'real-estate-manager' ),
		'DIN' => __( 'Dinagat Islands', 'real-estate-manager' ),
		'EAS' => __( 'Eastern Samar', 'real-estate-manager' ),
		'GUI' => __( 'Guimaras', 'real-estate-manager' ),
		'IFU' => __( 'Ifugao', 'real-estate-manager' ),
		'ILN' => __( 'Ilocos Norte', 'real-estate-manager' ),
		'ILS' => __( 'Ilocos Sur', 'real-estate-manager' ),
		'ILI' => __( 'Iloilo', 'real-estate-manager' ),
		'ISA' => __( 'Isabela', 'real-estate-manager' ),
		'KAL' => __( 'Kalinga', 'real-estate-manager' ),
		'LUN' => __( 'La Union', 'real-estate-manager' ),
		'LAG' => __( 'Laguna', 'real-estate-manager' ),
		'LAN' => __( 'Lanao del Norte', 'real-estate-manager' ),
		'LAS' => __( 'Lanao del Sur', 'real-estate-manager' ),
		'LEY' => __( 'Leyte', 'real-estate-manager' ),
		'MAG' => __( 'Maguindanao', 'real-estate-manager' ),
		'MAD' => __( 'Marinduque', 'real-estate-manager' ),
		'MAS' => __( 'Masbate', 'real-estate-manager' ),
		'MSC' => __( 'Misamis Occidental', 'real-estate-manager' ),
		'MSR' => __( 'Misamis Oriental', 'real-estate-manager' ),
		'MOU' => __( 'Mountain Province', 'real-estate-manager' ),
		'NEC' => __( 'Negros Occidental', 'real-estate-manager' ),
		'NER' => __( 'Negros Oriental', 'real-estate-manager' ),
		'NSA' => __( 'Northern Samar', 'real-estate-manager' ),
		'NUE' => __( 'Nueva Ecija', 'real-estate-manager' ),
		'NUV' => __( 'Nueva Vizcaya', 'real-estate-manager' ),
		'MDC' => __( 'Occidental Mindoro', 'real-estate-manager' ),
		'MDR' => __( 'Oriental Mindoro', 'real-estate-manager' ),
		'PLW' => __( 'Palawan', 'real-estate-manager' ),
		'PAM' => __( 'Pampanga', 'real-estate-manager' ),
		'PAN' => __( 'Pangasinan', 'real-estate-manager' ),
		'QUE' => __( 'Quezon', 'real-estate-manager' ),
		'QUI' => __( 'Quirino', 'real-estate-manager' ),
		'RIZ' => __( 'Rizal', 'real-estate-manager' ),
		'ROM' => __( 'Romblon', 'real-estate-manager' ),
		'WSA' => __( 'Samar', 'real-estate-manager' ),
		'SAR' => __( 'Sarangani', 'real-estate-manager' ),
		'SIQ' => __( 'Siquijor', 'real-estate-manager' ),
		'SOR' => __( 'Sorsogon', 'real-estate-manager' ),
		'SCO' => __( 'South Cotabato', 'real-estate-manager' ),
		'SLE' => __( 'Southern Leyte', 'real-estate-manager' ),
		'SUK' => __( 'Sultan Kudarat', 'real-estate-manager' ),
		'SLU' => __( 'Sulu', 'real-estate-manager' ),
		'SUN' => __( 'Surigao del Norte', 'real-estate-manager' ),
		'SUR' => __( 'Surigao del Sur', 'real-estate-manager' ),
		'TAR' => __( 'Tarlac', 'real-estate-manager' ),
		'TAW' => __( 'Tawi-Tawi', 'real-estate-manager' ),
		'ZMB' => __( 'Zambales', 'real-estate-manager' ),
		'ZAN' => __( 'Zamboanga del Norte', 'real-estate-manager' ),
		'ZAS' => __( 'Zamboanga del Sur', 'real-estate-manager' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'real-estate-manager' ),
		'00'  => __( 'Metro Manila', 'real-estate-manager' ),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'real-estate-manager' ),
		'BA' => __( 'Balochistan', 'real-estate-manager' ),
		'TA' => __( 'FATA', 'real-estate-manager' ),
		'GB' => __( 'Gilgit Baltistan', 'real-estate-manager' ),
		'IS' => __( 'Islamabad Capital Territory', 'real-estate-manager' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'real-estate-manager' ),
		'PB' => __( 'Punjab', 'real-estate-manager' ),
		'SD' => __( 'Sindh', 'real-estate-manager' ),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunción', 'real-estate-manager' ),
		'PY-1'   => __( 'Concepción', 'real-estate-manager' ),
		'PY-2'   => __( 'San Pedro', 'real-estate-manager' ),
		'PY-3'   => __( 'Cordillera', 'real-estate-manager' ),
		'PY-4'   => __( 'Guairá', 'real-estate-manager' ),
		'PY-5'   => __( 'Caaguazú', 'real-estate-manager' ),
		'PY-6'   => __( 'Caazapá', 'real-estate-manager' ),
		'PY-7'   => __( 'Itapúa', 'real-estate-manager' ),
		'PY-8'   => __( 'Misiones', 'real-estate-manager' ),
		'PY-9'   => __( 'Paraguarí', 'real-estate-manager' ),
		'PY-10'  => __( 'Alto Paraná', 'real-estate-manager' ),
		'PY-11'  => __( 'Central', 'real-estate-manager' ),
		'PY-12'  => __( 'Ñeembucú', 'real-estate-manager' ),
		'PY-13'  => __( 'Amambay', 'real-estate-manager' ),
		'PY-14'  => __( 'Canindeyú', 'real-estate-manager' ),
		'PY-15'  => __( 'Presidente Hayes', 'real-estate-manager' ),
		'PY-16'  => __( 'Alto Paraguay', 'real-estate-manager' ),
		'PY-17'  => __( 'Boquerón', 'real-estate-manager' ),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'real-estate-manager' ),
		'AR' => __( 'Arad', 'real-estate-manager' ),
		'AG' => __( 'Argeș', 'real-estate-manager' ),
		'BC' => __( 'Bacău', 'real-estate-manager' ),
		'BH' => __( 'Bihor', 'real-estate-manager' ),
		'BN' => __( 'Bistrița-Năsăud', 'real-estate-manager' ),
		'BT' => __( 'Botoșani', 'real-estate-manager' ),
		'BR' => __( 'Brăila', 'real-estate-manager' ),
		'BV' => __( 'Brașov', 'real-estate-manager' ),
		'B'  => __( 'București', 'real-estate-manager' ),
		'BZ' => __( 'Buzău', 'real-estate-manager' ),
		'CL' => __( 'Călărași', 'real-estate-manager' ),
		'CS' => __( 'Caraș-Severin', 'real-estate-manager' ),
		'CJ' => __( 'Cluj', 'real-estate-manager' ),
		'CT' => __( 'Constanța', 'real-estate-manager' ),
		'CV' => __( 'Covasna', 'real-estate-manager' ),
		'DB' => __( 'Dâmbovița', 'real-estate-manager' ),
		'DJ' => __( 'Dolj', 'real-estate-manager' ),
		'GL' => __( 'Galați', 'real-estate-manager' ),
		'GR' => __( 'Giurgiu', 'real-estate-manager' ),
		'GJ' => __( 'Gorj', 'real-estate-manager' ),
		'HR' => __( 'Harghita', 'real-estate-manager' ),
		'HD' => __( 'Hunedoara', 'real-estate-manager' ),
		'IL' => __( 'Ialomița', 'real-estate-manager' ),
		'IS' => __( 'Iași', 'real-estate-manager' ),
		'IF' => __( 'Ilfov', 'real-estate-manager' ),
		'MM' => __( 'Maramureș', 'real-estate-manager' ),
		'MH' => __( 'Mehedinți', 'real-estate-manager' ),
		'MS' => __( 'Mureș', 'real-estate-manager' ),
		'NT' => __( 'Neamț', 'real-estate-manager' ),
		'OT' => __( 'Olt', 'real-estate-manager' ),
		'PH' => __( 'Prahova', 'real-estate-manager' ),
		'SJ' => __( 'Sălaj', 'real-estate-manager' ),
		'SM' => __( 'Satu Mare', 'real-estate-manager' ),
		'SB' => __( 'Sibiu', 'real-estate-manager' ),
		'SV' => __( 'Suceava', 'real-estate-manager' ),
		'TR' => __( 'Teleorman', 'real-estate-manager' ),
		'TM' => __( 'Timiș', 'real-estate-manager' ),
		'TL' => __( 'Tulcea', 'real-estate-manager' ),
		'VL' => __( 'Vâlcea', 'real-estate-manager' ),
		'VS' => __( 'Vaslui', 'real-estate-manager' ),
		'VN' => __( 'Vrancea', 'real-estate-manager' ),
	),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'SV' => array( // El Salvador states.
		'SV-AH' => __( 'Ahuachapán', 'real-estate-manager' ),
		'SV-CA' => __( 'Cabañas', 'real-estate-manager' ),
		'SV-CH' => __( 'Chalatenango', 'real-estate-manager' ),
		'SV-CU' => __( 'Cuscatlán', 'real-estate-manager' ),
		'SV-LI' => __( 'La Libertad', 'real-estate-manager' ),
		'SV-MO' => __( 'Morazán', 'real-estate-manager' ),
		'SV-PA' => __( 'La Paz', 'real-estate-manager' ),
		'SV-SA' => __( 'Santa Ana', 'real-estate-manager' ),
		'SV-SM' => __( 'San Miguel', 'real-estate-manager' ),
		'SV-SO' => __( 'Sonsonate', 'real-estate-manager' ),
		'SV-SS' => __( 'San Salvador', 'real-estate-manager' ),
		'SV-SV' => __( 'San Vicente', 'real-estate-manager' ),
		'SV-UN' => __( 'La Unión', 'real-estate-manager' ),
		'SV-US' => __( 'Usulután', 'real-estate-manager' ),
	),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'real-estate-manager' ),
		'TH-15' => __( 'Ang Thong', 'real-estate-manager' ),
		'TH-14' => __( 'Ayutthaya', 'real-estate-manager' ),
		'TH-10' => __( 'Bangkok', 'real-estate-manager' ),
		'TH-38' => __( 'Bueng Kan', 'real-estate-manager' ),
		'TH-31' => __( 'Buri Ram', 'real-estate-manager' ),
		'TH-24' => __( 'Chachoengsao', 'real-estate-manager' ),
		'TH-18' => __( 'Chai Nat', 'real-estate-manager' ),
		'TH-36' => __( 'Chaiyaphum', 'real-estate-manager' ),
		'TH-22' => __( 'Chanthaburi', 'real-estate-manager' ),
		'TH-50' => __( 'Chiang Mai', 'real-estate-manager' ),
		'TH-57' => __( 'Chiang Rai', 'real-estate-manager' ),
		'TH-20' => __( 'Chonburi', 'real-estate-manager' ),
		'TH-86' => __( 'Chumphon', 'real-estate-manager' ),
		'TH-46' => __( 'Kalasin', 'real-estate-manager' ),
		'TH-62' => __( 'Kamphaeng Phet', 'real-estate-manager' ),
		'TH-71' => __( 'Kanchanaburi', 'real-estate-manager' ),
		'TH-40' => __( 'Khon Kaen', 'real-estate-manager' ),
		'TH-81' => __( 'Krabi', 'real-estate-manager' ),
		'TH-52' => __( 'Lampang', 'real-estate-manager' ),
		'TH-51' => __( 'Lamphun', 'real-estate-manager' ),
		'TH-42' => __( 'Loei', 'real-estate-manager' ),
		'TH-16' => __( 'Lopburi', 'real-estate-manager' ),
		'TH-58' => __( 'Mae Hong Son', 'real-estate-manager' ),
		'TH-44' => __( 'Maha Sarakham', 'real-estate-manager' ),
		'TH-49' => __( 'Mukdahan', 'real-estate-manager' ),
		'TH-26' => __( 'Nakhon Nayok', 'real-estate-manager' ),
		'TH-73' => __( 'Nakhon Pathom', 'real-estate-manager' ),
		'TH-48' => __( 'Nakhon Phanom', 'real-estate-manager' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'real-estate-manager' ),
		'TH-60' => __( 'Nakhon Sawan', 'real-estate-manager' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'real-estate-manager' ),
		'TH-55' => __( 'Nan', 'real-estate-manager' ),
		'TH-96' => __( 'Narathiwat', 'real-estate-manager' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'real-estate-manager' ),
		'TH-43' => __( 'Nong Khai', 'real-estate-manager' ),
		'TH-12' => __( 'Nonthaburi', 'real-estate-manager' ),
		'TH-13' => __( 'Pathum Thani', 'real-estate-manager' ),
		'TH-94' => __( 'Pattani', 'real-estate-manager' ),
		'TH-82' => __( 'Phang Nga', 'real-estate-manager' ),
		'TH-93' => __( 'Phatthalung', 'real-estate-manager' ),
		'TH-56' => __( 'Phayao', 'real-estate-manager' ),
		'TH-67' => __( 'Phetchabun', 'real-estate-manager' ),
		'TH-76' => __( 'Phetchaburi', 'real-estate-manager' ),
		'TH-66' => __( 'Phichit', 'real-estate-manager' ),
		'TH-65' => __( 'Phitsanulok', 'real-estate-manager' ),
		'TH-54' => __( 'Phrae', 'real-estate-manager' ),
		'TH-83' => __( 'Phuket', 'real-estate-manager' ),
		'TH-25' => __( 'Prachin Buri', 'real-estate-manager' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'real-estate-manager' ),
		'TH-85' => __( 'Ranong', 'real-estate-manager' ),
		'TH-70' => __( 'Ratchaburi', 'real-estate-manager' ),
		'TH-21' => __( 'Rayong', 'real-estate-manager' ),
		'TH-45' => __( 'Roi Et', 'real-estate-manager' ),
		'TH-27' => __( 'Sa Kaeo', 'real-estate-manager' ),
		'TH-47' => __( 'Sakon Nakhon', 'real-estate-manager' ),
		'TH-11' => __( 'Samut Prakan', 'real-estate-manager' ),
		'TH-74' => __( 'Samut Sakhon', 'real-estate-manager' ),
		'TH-75' => __( 'Samut Songkhram', 'real-estate-manager' ),
		'TH-19' => __( 'Saraburi', 'real-estate-manager' ),
		'TH-91' => __( 'Satun', 'real-estate-manager' ),
		'TH-17' => __( 'Sing Buri', 'real-estate-manager' ),
		'TH-33' => __( 'Sisaket', 'real-estate-manager' ),
		'TH-90' => __( 'Songkhla', 'real-estate-manager' ),
		'TH-64' => __( 'Sukhothai', 'real-estate-manager' ),
		'TH-72' => __( 'Suphan Buri', 'real-estate-manager' ),
		'TH-84' => __( 'Surat Thani', 'real-estate-manager' ),
		'TH-32' => __( 'Surin', 'real-estate-manager' ),
		'TH-63' => __( 'Tak', 'real-estate-manager' ),
		'TH-92' => __( 'Trang', 'real-estate-manager' ),
		'TH-23' => __( 'Trat', 'real-estate-manager' ),
		'TH-34' => __( 'Ubon Ratchathani', 'real-estate-manager' ),
		'TH-41' => __( 'Udon Thani', 'real-estate-manager' ),
		'TH-61' => __( 'Uthai Thani', 'real-estate-manager' ),
		'TH-53' => __( 'Uttaradit', 'real-estate-manager' ),
		'TH-95' => __( 'Yala', 'real-estate-manager' ),
		'TH-35' => __( 'Yasothon', 'real-estate-manager' ),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'real-estate-manager' ),
		'TR02' => __( 'Adıyaman', 'real-estate-manager' ),
		'TR03' => __( 'Afyon', 'real-estate-manager' ),
		'TR04' => __( 'Ağrı', 'real-estate-manager' ),
		'TR05' => __( 'Amasya', 'real-estate-manager' ),
		'TR06' => __( 'Ankara', 'real-estate-manager' ),
		'TR07' => __( 'Antalya', 'real-estate-manager' ),
		'TR08' => __( 'Artvin', 'real-estate-manager' ),
		'TR09' => __( 'Aydın', 'real-estate-manager' ),
		'TR10' => __( 'Balıkesir', 'real-estate-manager' ),
		'TR11' => __( 'Bilecik', 'real-estate-manager' ),
		'TR12' => __( 'Bingöl', 'real-estate-manager' ),
		'TR13' => __( 'Bitlis', 'real-estate-manager' ),
		'TR14' => __( 'Bolu', 'real-estate-manager' ),
		'TR15' => __( 'Burdur', 'real-estate-manager' ),
		'TR16' => __( 'Bursa', 'real-estate-manager' ),
		'TR17' => __( 'Çanakkale', 'real-estate-manager' ),
		'TR18' => __( 'Çankırı', 'real-estate-manager' ),
		'TR19' => __( 'Çorum', 'real-estate-manager' ),
		'TR20' => __( 'Denizli', 'real-estate-manager' ),
		'TR21' => __( 'Diyarbakır', 'real-estate-manager' ),
		'TR22' => __( 'Edirne', 'real-estate-manager' ),
		'TR23' => __( 'Elazığ', 'real-estate-manager' ),
		'TR24' => __( 'Erzincan', 'real-estate-manager' ),
		'TR25' => __( 'Erzurum', 'real-estate-manager' ),
		'TR26' => __( 'Eskişehir', 'real-estate-manager' ),
		'TR27' => __( 'Gaziantep', 'real-estate-manager' ),
		'TR28' => __( 'Giresun', 'real-estate-manager' ),
		'TR29' => __( 'Gümüşhane', 'real-estate-manager' ),
		'TR30' => __( 'Hakkari', 'real-estate-manager' ),
		'TR31' => __( 'Hatay', 'real-estate-manager' ),
		'TR32' => __( 'Isparta', 'real-estate-manager' ),
		'TR33' => __( 'İçel', 'real-estate-manager' ),
		'TR34' => __( 'İstanbul', 'real-estate-manager' ),
		'TR35' => __( 'İzmir', 'real-estate-manager' ),
		'TR36' => __( 'Kars', 'real-estate-manager' ),
		'TR37' => __( 'Kastamonu', 'real-estate-manager' ),
		'TR38' => __( 'Kayseri', 'real-estate-manager' ),
		'TR39' => __( 'Kırklareli', 'real-estate-manager' ),
		'TR40' => __( 'Kırşehir', 'real-estate-manager' ),
		'TR41' => __( 'Kocaeli', 'real-estate-manager' ),
		'TR42' => __( 'Konya', 'real-estate-manager' ),
		'TR43' => __( 'Kütahya', 'real-estate-manager' ),
		'TR44' => __( 'Malatya', 'real-estate-manager' ),
		'TR45' => __( 'Manisa', 'real-estate-manager' ),
		'TR46' => __( 'Kahramanmaraş', 'real-estate-manager' ),
		'TR47' => __( 'Mardin', 'real-estate-manager' ),
		'TR48' => __( 'Muğla', 'real-estate-manager' ),
		'TR49' => __( 'Muş', 'real-estate-manager' ),
		'TR50' => __( 'Nevşehir', 'real-estate-manager' ),
		'TR51' => __( 'Niğde', 'real-estate-manager' ),
		'TR52' => __( 'Ordu', 'real-estate-manager' ),
		'TR53' => __( 'Rize', 'real-estate-manager' ),
		'TR54' => __( 'Sakarya', 'real-estate-manager' ),
		'TR55' => __( 'Samsun', 'real-estate-manager' ),
		'TR56' => __( 'Siirt', 'real-estate-manager' ),
		'TR57' => __( 'Sinop', 'real-estate-manager' ),
		'TR58' => __( 'Sivas', 'real-estate-manager' ),
		'TR59' => __( 'Tekirdağ', 'real-estate-manager' ),
		'TR60' => __( 'Tokat', 'real-estate-manager' ),
		'TR61' => __( 'Trabzon', 'real-estate-manager' ),
		'TR62' => __( 'Tunceli', 'real-estate-manager' ),
		'TR63' => __( 'Şanlıurfa', 'real-estate-manager' ),
		'TR64' => __( 'Uşak', 'real-estate-manager' ),
		'TR65' => __( 'Van', 'real-estate-manager' ),
		'TR66' => __( 'Yozgat', 'real-estate-manager' ),
		'TR67' => __( 'Zonguldak', 'real-estate-manager' ),
		'TR68' => __( 'Aksaray', 'real-estate-manager' ),
		'TR69' => __( 'Bayburt', 'real-estate-manager' ),
		'TR70' => __( 'Karaman', 'real-estate-manager' ),
		'TR71' => __( 'Kırıkkale', 'real-estate-manager' ),
		'TR72' => __( 'Batman', 'real-estate-manager' ),
		'TR73' => __( 'Şırnak', 'real-estate-manager' ),
		'TR74' => __( 'Bartın', 'real-estate-manager' ),
		'TR75' => __( 'Ardahan', 'real-estate-manager' ),
		'TR76' => __( 'Iğdır', 'real-estate-manager' ),
		'TR77' => __( 'Yalova', 'real-estate-manager' ),
		'TR78' => __( 'Karabük', 'real-estate-manager' ),
		'TR79' => __( 'Kilis', 'real-estate-manager' ),
		'TR80' => __( 'Osmaniye', 'real-estate-manager' ),
		'TR81' => __( 'Düzce', 'real-estate-manager' ),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'real-estate-manager' ),
		'TZ02' => __( 'Dar es Salaam', 'real-estate-manager' ),
		'TZ03' => __( 'Dodoma', 'real-estate-manager' ),
		'TZ04' => __( 'Iringa', 'real-estate-manager' ),
		'TZ05' => __( 'Kagera', 'real-estate-manager' ),
		'TZ06' => __( 'Pemba North', 'real-estate-manager' ),
		'TZ07' => __( 'Zanzibar North', 'real-estate-manager' ),
		'TZ08' => __( 'Kigoma', 'real-estate-manager' ),
		'TZ09' => __( 'Kilimanjaro', 'real-estate-manager' ),
		'TZ10' => __( 'Pemba South', 'real-estate-manager' ),
		'TZ11' => __( 'Zanzibar South', 'real-estate-manager' ),
		'TZ12' => __( 'Lindi', 'real-estate-manager' ),
		'TZ13' => __( 'Mara', 'real-estate-manager' ),
		'TZ14' => __( 'Mbeya', 'real-estate-manager' ),
		'TZ15' => __( 'Zanzibar West', 'real-estate-manager' ),
		'TZ16' => __( 'Morogoro', 'real-estate-manager' ),
		'TZ17' => __( 'Mtwara', 'real-estate-manager' ),
		'TZ18' => __( 'Mwanza', 'real-estate-manager' ),
		'TZ19' => __( 'Coast', 'real-estate-manager' ),
		'TZ20' => __( 'Rukwa', 'real-estate-manager' ),
		'TZ21' => __( 'Ruvuma', 'real-estate-manager' ),
		'TZ22' => __( 'Shinyanga', 'real-estate-manager' ),
		'TZ23' => __( 'Singida', 'real-estate-manager' ),
		'TZ24' => __( 'Tabora', 'real-estate-manager' ),
		'TZ25' => __( 'Tanga', 'real-estate-manager' ),
		'TZ26' => __( 'Manyara', 'real-estate-manager' ),
		'TZ27' => __( 'Geita', 'real-estate-manager' ),
		'TZ28' => __( 'Katavi', 'real-estate-manager' ),
		'TZ29' => __( 'Njombe', 'real-estate-manager' ),
		'TZ30' => __( 'Simiyu', 'real-estate-manager' ),
	),
	'LK' => array(),
	'RS' => array( // Serbia districts. Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
		'RS00' => _x( 'Belgrade', 'district', 'real-estate-manager' ),
		'RS14' => _x( 'Bor', 'district', 'real-estate-manager' ),
		'RS11' => _x( 'Braničevo', 'district', 'real-estate-manager' ),
		'RS02' => _x( 'Central Banat', 'district', 'real-estate-manager' ),
		'RS10' => _x( 'Danube', 'district', 'real-estate-manager' ),
		'RS23' => _x( 'Jablanica', 'district', 'real-estate-manager' ),
		'RS09' => _x( 'Kolubara', 'district', 'real-estate-manager' ),
		'RS08' => _x( 'Mačva', 'district', 'real-estate-manager' ),
		'RS17' => _x( 'Morava', 'district', 'real-estate-manager' ),
		'RS20' => _x( 'Nišava', 'district', 'real-estate-manager' ),
		'RS01' => _x( 'North Bačka', 'district', 'real-estate-manager' ),
		'RS03' => _x( 'North Banat', 'district', 'real-estate-manager' ),
		'RS24' => _x( 'Pčinja', 'district', 'real-estate-manager' ),
		'RS22' => _x( 'Pirot', 'district', 'real-estate-manager' ),
		'RS13' => _x( 'Pomoravlje', 'district', 'real-estate-manager' ),
		'RS19' => _x( 'Rasina', 'district', 'real-estate-manager' ),
		'RS18' => _x( 'Raška', 'district', 'real-estate-manager' ),
		'RS06' => _x( 'South Bačka', 'district', 'real-estate-manager' ),
		'RS04' => _x( 'South Banat', 'district', 'real-estate-manager' ),
		'RS07' => _x( 'Srem', 'district', 'real-estate-manager' ),
		'RS12' => _x( 'Šumadija', 'district', 'real-estate-manager' ),
		'RS21' => _x( 'Toplica', 'district', 'real-estate-manager' ),
		'RS05' => _x( 'West Bačka', 'district', 'real-estate-manager' ),
		'RS15' => _x( 'Zaječar', 'district', 'real-estate-manager' ),
		'RS16' => _x( 'Zlatibor', 'district', 'real-estate-manager' ),
		'RS25' => _x( 'Kosovo', 'district', 'real-estate-manager' ),
		'RS26' => _x( 'Peć', 'district', 'real-estate-manager' ),
		'RS27' => _x( 'Prizren', 'district', 'real-estate-manager' ),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'real-estate-manager' ),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'real-estate-manager' ),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'real-estate-manager' ),
		'RSVO' => _x( 'Vojvodina', 'district', 'real-estate-manager' ),
	),
	'SE' => array(),
	'UA' => array( // Ukraine. Ref: https://en.wikipedia.org/wiki/Oblasts_of_Ukraine.
		'VN' => __( 'Vinnytsia Oblast', 'real-estate-manager' ),
		'VL' => __( 'Volyn Oblast', 'real-estate-manager' ),
		'DP' => __( 'Dnipropetrovsk Oblast', 'real-estate-manager' ),
		'DT' => __( 'Donetsk Oblast', 'real-estate-manager' ),
		'ZT' => __( 'Zhytomyr Oblast', 'real-estate-manager' ),
		'ZK' => __( 'Zakarpattia Oblast', 'real-estate-manager' ),
		'ZP' => __( 'Zaporizhzhia Oblast', 'real-estate-manager' ),
		'IF' => __( 'Ivano-Frankivsk Oblast', 'real-estate-manager' ),
		'KV' => __( 'Kyiv Oblast', 'real-estate-manager' ),
		'KH' => __( 'Kirovohrad Oblast', 'real-estate-manager' ),
		'LH' => __( 'Luhansk Oblast', 'real-estate-manager' ),
		'LV' => __( 'Lviv Oblast', 'real-estate-manager' ),
		'MY' => __( 'Mykolaiv Oblast', 'real-estate-manager' ),
		'OD' => __( 'Odessa Oblast', 'real-estate-manager' ),
		'PL' => __( 'Poltava Oblast', 'real-estate-manager' ),
		'RV' => __( 'Rivne Oblast', 'real-estate-manager' ),
		'SM' => __( 'Sumy Oblast', 'real-estate-manager' ),
		'TP' => __( 'Ternopil Oblast', 'real-estate-manager' ),
		'KK' => __( 'Kharkiv Oblast', 'real-estate-manager' ),
		'KS' => __( 'Kherson Oblast', 'real-estate-manager' ),
		'KM' => __( 'Khmelnytskyi Oblast', 'real-estate-manager' ),
		'CK' => __( 'Cherkasy Oblast', 'real-estate-manager' ),
		'CH' => __( 'Chernihiv Oblast', 'real-estate-manager' ),
		'CV' => __( 'Chernivtsi Oblast', 'real-estate-manager' ),
	),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'real-estate-manager' ),
		'UG301' => __( 'Adjumani', 'real-estate-manager' ),
		'UG322' => __( 'Agago', 'real-estate-manager' ),
		'UG323' => __( 'Alebtong', 'real-estate-manager' ),
		'UG315' => __( 'Amolatar', 'real-estate-manager' ),
		'UG324' => __( 'Amudat', 'real-estate-manager' ),
		'UG216' => __( 'Amuria', 'real-estate-manager' ),
		'UG316' => __( 'Amuru', 'real-estate-manager' ),
		'UG302' => __( 'Apac', 'real-estate-manager' ),
		'UG303' => __( 'Arua', 'real-estate-manager' ),
		'UG217' => __( 'Budaka', 'real-estate-manager' ),
		'UG218' => __( 'Bududa', 'real-estate-manager' ),
		'UG201' => __( 'Bugiri', 'real-estate-manager' ),
		'UG235' => __( 'Bugweri', 'real-estate-manager' ),
		'UG420' => __( 'Buhweju', 'real-estate-manager' ),
		'UG117' => __( 'Buikwe', 'real-estate-manager' ),
		'UG219' => __( 'Bukedea', 'real-estate-manager' ),
		'UG118' => __( 'Bukomansimbi', 'real-estate-manager' ),
		'UG220' => __( 'Bukwa', 'real-estate-manager' ),
		'UG225' => __( 'Bulambuli', 'real-estate-manager' ),
		'UG416' => __( 'Buliisa', 'real-estate-manager' ),
		'UG401' => __( 'Bundibugyo', 'real-estate-manager' ),
		'UG430' => __( 'Bunyangabu', 'real-estate-manager' ),
		'UG402' => __( 'Bushenyi', 'real-estate-manager' ),
		'UG202' => __( 'Busia', 'real-estate-manager' ),
		'UG221' => __( 'Butaleja', 'real-estate-manager' ),
		'UG119' => __( 'Butambala', 'real-estate-manager' ),
		'UG233' => __( 'Butebo', 'real-estate-manager' ),
		'UG120' => __( 'Buvuma', 'real-estate-manager' ),
		'UG226' => __( 'Buyende', 'real-estate-manager' ),
		'UG317' => __( 'Dokolo', 'real-estate-manager' ),
		'UG121' => __( 'Gomba', 'real-estate-manager' ),
		'UG304' => __( 'Gulu', 'real-estate-manager' ),
		'UG403' => __( 'Hoima', 'real-estate-manager' ),
		'UG417' => __( 'Ibanda', 'real-estate-manager' ),
		'UG203' => __( 'Iganga', 'real-estate-manager' ),
		'UG418' => __( 'Isingiro', 'real-estate-manager' ),
		'UG204' => __( 'Jinja', 'real-estate-manager' ),
		'UG318' => __( 'Kaabong', 'real-estate-manager' ),
		'UG404' => __( 'Kabale', 'real-estate-manager' ),
		'UG405' => __( 'Kabarole', 'real-estate-manager' ),
		'UG213' => __( 'Kaberamaido', 'real-estate-manager' ),
		'UG427' => __( 'Kagadi', 'real-estate-manager' ),
		'UG428' => __( 'Kakumiro', 'real-estate-manager' ),
		'UG101' => __( 'Kalangala', 'real-estate-manager' ),
		'UG222' => __( 'Kaliro', 'real-estate-manager' ),
		'UG122' => __( 'Kalungu', 'real-estate-manager' ),
		'UG102' => __( 'Kampala', 'real-estate-manager' ),
		'UG205' => __( 'Kamuli', 'real-estate-manager' ),
		'UG413' => __( 'Kamwenge', 'real-estate-manager' ),
		'UG414' => __( 'Kanungu', 'real-estate-manager' ),
		'UG206' => __( 'Kapchorwa', 'real-estate-manager' ),
		'UG236' => __( 'Kapelebyong', 'real-estate-manager' ),
		'UG126' => __( 'Kasanda', 'real-estate-manager' ),
		'UG406' => __( 'Kasese', 'real-estate-manager' ),
		'UG207' => __( 'Katakwi', 'real-estate-manager' ),
		'UG112' => __( 'Kayunga', 'real-estate-manager' ),
		'UG407' => __( 'Kibaale', 'real-estate-manager' ),
		'UG103' => __( 'Kiboga', 'real-estate-manager' ),
		'UG227' => __( 'Kibuku', 'real-estate-manager' ),
		'UG432' => __( 'Kikuube', 'real-estate-manager' ),
		'UG419' => __( 'Kiruhura', 'real-estate-manager' ),
		'UG421' => __( 'Kiryandongo', 'real-estate-manager' ),
		'UG408' => __( 'Kisoro', 'real-estate-manager' ),
		'UG305' => __( 'Kitgum', 'real-estate-manager' ),
		'UG319' => __( 'Koboko', 'real-estate-manager' ),
		'UG325' => __( 'Kole', 'real-estate-manager' ),
		'UG306' => __( 'Kotido', 'real-estate-manager' ),
		'UG208' => __( 'Kumi', 'real-estate-manager' ),
		'UG333' => __( 'Kwania', 'real-estate-manager' ),
		'UG228' => __( 'Kween', 'real-estate-manager' ),
		'UG123' => __( 'Kyankwanzi', 'real-estate-manager' ),
		'UG422' => __( 'Kyegegwa', 'real-estate-manager' ),
		'UG415' => __( 'Kyenjojo', 'real-estate-manager' ),
		'UG125' => __( 'Kyotera', 'real-estate-manager' ),
		'UG326' => __( 'Lamwo', 'real-estate-manager' ),
		'UG307' => __( 'Lira', 'real-estate-manager' ),
		'UG229' => __( 'Luuka', 'real-estate-manager' ),
		'UG104' => __( 'Luwero', 'real-estate-manager' ),
		'UG124' => __( 'Lwengo', 'real-estate-manager' ),
		'UG114' => __( 'Lyantonde', 'real-estate-manager' ),
		'UG223' => __( 'Manafwa', 'real-estate-manager' ),
		'UG320' => __( 'Maracha', 'real-estate-manager' ),
		'UG105' => __( 'Masaka', 'real-estate-manager' ),
		'UG409' => __( 'Masindi', 'real-estate-manager' ),
		'UG214' => __( 'Mayuge', 'real-estate-manager' ),
		'UG209' => __( 'Mbale', 'real-estate-manager' ),
		'UG410' => __( 'Mbarara', 'real-estate-manager' ),
		'UG423' => __( 'Mitooma', 'real-estate-manager' ),
		'UG115' => __( 'Mityana', 'real-estate-manager' ),
		'UG308' => __( 'Moroto', 'real-estate-manager' ),
		'UG309' => __( 'Moyo', 'real-estate-manager' ),
		'UG106' => __( 'Mpigi', 'real-estate-manager' ),
		'UG107' => __( 'Mubende', 'real-estate-manager' ),
		'UG108' => __( 'Mukono', 'real-estate-manager' ),
		'UG334' => __( 'Nabilatuk', 'real-estate-manager' ),
		'UG311' => __( 'Nakapiripirit', 'real-estate-manager' ),
		'UG116' => __( 'Nakaseke', 'real-estate-manager' ),
		'UG109' => __( 'Nakasongola', 'real-estate-manager' ),
		'UG230' => __( 'Namayingo', 'real-estate-manager' ),
		'UG234' => __( 'Namisindwa', 'real-estate-manager' ),
		'UG224' => __( 'Namutumba', 'real-estate-manager' ),
		'UG327' => __( 'Napak', 'real-estate-manager' ),
		'UG310' => __( 'Nebbi', 'real-estate-manager' ),
		'UG231' => __( 'Ngora', 'real-estate-manager' ),
		'UG424' => __( 'Ntoroko', 'real-estate-manager' ),
		'UG411' => __( 'Ntungamo', 'real-estate-manager' ),
		'UG328' => __( 'Nwoya', 'real-estate-manager' ),
		'UG331' => __( 'Omoro', 'real-estate-manager' ),
		'UG329' => __( 'Otuke', 'real-estate-manager' ),
		'UG321' => __( 'Oyam', 'real-estate-manager' ),
		'UG312' => __( 'Pader', 'real-estate-manager' ),
		'UG332' => __( 'Pakwach', 'real-estate-manager' ),
		'UG210' => __( 'Pallisa', 'real-estate-manager' ),
		'UG110' => __( 'Rakai', 'real-estate-manager' ),
		'UG429' => __( 'Rubanda', 'real-estate-manager' ),
		'UG425' => __( 'Rubirizi', 'real-estate-manager' ),
		'UG431' => __( 'Rukiga', 'real-estate-manager' ),
		'UG412' => __( 'Rukungiri', 'real-estate-manager' ),
		'UG111' => __( 'Sembabule', 'real-estate-manager' ),
		'UG232' => __( 'Serere', 'real-estate-manager' ),
		'UG426' => __( 'Sheema', 'real-estate-manager' ),
		'UG215' => __( 'Sironko', 'real-estate-manager' ),
		'UG211' => __( 'Soroti', 'real-estate-manager' ),
		'UG212' => __( 'Tororo', 'real-estate-manager' ),
		'UG113' => __( 'Wakiso', 'real-estate-manager' ),
		'UG313' => __( 'Yumbe', 'real-estate-manager' ),
		'UG330' => __( 'Zombo', 'real-estate-manager' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'real-estate-manager' ),
		'84' => __( 'Howland Island', 'real-estate-manager' ),
		'86' => __( 'Jarvis Island', 'real-estate-manager' ),
		'67' => __( 'Johnston Atoll', 'real-estate-manager' ),
		'89' => __( 'Kingman Reef', 'real-estate-manager' ),
		'71' => __( 'Midway Atoll', 'real-estate-manager' ),
		'76' => __( 'Navassa Island', 'real-estate-manager' ),
		'95' => __( 'Palmyra Atoll', 'real-estate-manager' ),
		'79' => __( 'Wake Island', 'real-estate-manager' ),
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'real-estate-manager' ),
		'AK' => __( 'Alaska', 'real-estate-manager' ),
		'AZ' => __( 'Arizona', 'real-estate-manager' ),
		'AR' => __( 'Arkansas', 'real-estate-manager' ),
		'CA' => __( 'California', 'real-estate-manager' ),
		'CO' => __( 'Colorado', 'real-estate-manager' ),
		'CT' => __( 'Connecticut', 'real-estate-manager' ),
		'DE' => __( 'Delaware', 'real-estate-manager' ),
		'DC' => __( 'District Of Columbia', 'real-estate-manager' ),
		'FL' => __( 'Florida', 'real-estate-manager' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'real-estate-manager' ),
		'HI' => __( 'Hawaii', 'real-estate-manager' ),
		'ID' => __( 'Idaho', 'real-estate-manager' ),
		'IL' => __( 'Illinois', 'real-estate-manager' ),
		'IN' => __( 'Indiana', 'real-estate-manager' ),
		'IA' => __( 'Iowa', 'real-estate-manager' ),
		'KS' => __( 'Kansas', 'real-estate-manager' ),
		'KY' => __( 'Kentucky', 'real-estate-manager' ),
		'LA' => __( 'Louisiana', 'real-estate-manager' ),
		'ME' => __( 'Maine', 'real-estate-manager' ),
		'MD' => __( 'Maryland', 'real-estate-manager' ),
		'MA' => __( 'Massachusetts', 'real-estate-manager' ),
		'MI' => __( 'Michigan', 'real-estate-manager' ),
		'MN' => __( 'Minnesota', 'real-estate-manager' ),
		'MS' => __( 'Mississippi', 'real-estate-manager' ),
		'MO' => __( 'Missouri', 'real-estate-manager' ),
		'MT' => __( 'Montana', 'real-estate-manager' ),
		'NE' => __( 'Nebraska', 'real-estate-manager' ),
		'NV' => __( 'Nevada', 'real-estate-manager' ),
		'NH' => __( 'New Hampshire', 'real-estate-manager' ),
		'NJ' => __( 'New Jersey', 'real-estate-manager' ),
		'NM' => __( 'New Mexico', 'real-estate-manager' ),
		'NY' => __( 'New York', 'real-estate-manager' ),
		'NC' => __( 'North Carolina', 'real-estate-manager' ),
		'ND' => __( 'North Dakota', 'real-estate-manager' ),
		'OH' => __( 'Ohio', 'real-estate-manager' ),
		'OK' => __( 'Oklahoma', 'real-estate-manager' ),
		'OR' => __( 'Oregon', 'real-estate-manager' ),
		'PA' => __( 'Pennsylvania', 'real-estate-manager' ),
		'RI' => __( 'Rhode Island', 'real-estate-manager' ),
		'SC' => __( 'South Carolina', 'real-estate-manager' ),
		'SD' => __( 'South Dakota', 'real-estate-manager' ),
		'TN' => __( 'Tennessee', 'real-estate-manager' ),
		'TX' => __( 'Texas', 'real-estate-manager' ),
		'UT' => __( 'Utah', 'real-estate-manager' ),
		'VT' => __( 'Vermont', 'real-estate-manager' ),
		'VA' => __( 'Virginia', 'real-estate-manager' ),
		'WA' => __( 'Washington', 'real-estate-manager' ),
		'WV' => __( 'West Virginia', 'real-estate-manager' ),
		'WI' => __( 'Wisconsin', 'real-estate-manager' ),
		'WY' => __( 'Wyoming', 'real-estate-manager' ),
		'AA' => __( 'Armed Forces (AA)', 'real-estate-manager' ),
		'AE' => __( 'Armed Forces (AE)', 'real-estate-manager' ),
		'AP' => __( 'Armed Forces (AP)', 'real-estate-manager' ),
	),
	'UY' => array( // Uruguay States.
		'UY-AR' => __( 'Artigas', 'real-estate-manager' ),
		'UY-CA' => __( 'Canelones', 'real-estate-manager' ),
		'UY-CL' => __( 'Cerro Largo', 'real-estate-manager' ),
		'UY-CO' => __( 'Colonia', 'real-estate-manager' ),
		'UY-DU' => __( 'Durazno', 'real-estate-manager' ),
		'UY-FS' => __( 'Flores', 'real-estate-manager' ),
		'UY-FD' => __( 'Florida', 'real-estate-manager' ),
		'UY-LA' => __( 'Lavalleja', 'real-estate-manager' ),
		'UY-MA' => __( 'Maldonado', 'real-estate-manager' ),
		'UY-MO' => __( 'Montevideo', 'real-estate-manager' ),
		'UY-PA' => __( 'Paysandú', 'real-estate-manager' ),
		'UY-RN' => __( 'Río Negro', 'real-estate-manager' ),
		'UY-RV' => __( 'Rivera', 'real-estate-manager' ),
		'UY-RO' => __( 'Rocha', 'real-estate-manager' ),
		'UY-SA' => __( 'Salto', 'real-estate-manager' ),
		'UY-SJ' => __( 'San José', 'real-estate-manager' ),
		'UY-SO' => __( 'Soriano', 'real-estate-manager' ),
		'UY-TA' => __( 'Tacuarembó', 'real-estate-manager' ),
		'UY-TT' => __( 'Treinta y Tres', 'real-estate-manager' ),
	),
	'VE' => array( // Venezuela States.
		'VE-A' => __( 'Capital', 'real-estate-manager' ),
		'VE-B' => __( 'Anzoátegui', 'real-estate-manager' ),
		'VE-C' => __( 'Apure', 'real-estate-manager' ),
		'VE-D' => __( 'Aragua', 'real-estate-manager' ),
		'VE-E' => __( 'Barinas', 'real-estate-manager' ),
		'VE-F' => __( 'Bolívar', 'real-estate-manager' ),
		'VE-G' => __( 'Carabobo', 'real-estate-manager' ),
		'VE-H' => __( 'Cojedes', 'real-estate-manager' ),
		'VE-I' => __( 'Falcón', 'real-estate-manager' ),
		'VE-J' => __( 'Guárico', 'real-estate-manager' ),
		'VE-K' => __( 'Lara', 'real-estate-manager' ),
		'VE-L' => __( 'Mérida', 'real-estate-manager' ),
		'VE-M' => __( 'Miranda', 'real-estate-manager' ),
		'VE-N' => __( 'Monagas', 'real-estate-manager' ),
		'VE-O' => __( 'Nueva Esparta', 'real-estate-manager' ),
		'VE-P' => __( 'Portuguesa', 'real-estate-manager' ),
		'VE-R' => __( 'Sucre', 'real-estate-manager' ),
		'VE-S' => __( 'Táchira', 'real-estate-manager' ),
		'VE-T' => __( 'Trujillo', 'real-estate-manager' ),
		'VE-U' => __( 'Yaracuy', 'real-estate-manager' ),
		'VE-V' => __( 'Zulia', 'real-estate-manager' ),
		'VE-W' => __( 'Federal Dependencies', 'real-estate-manager' ),
		'VE-X' => __( 'La Guaira (Vargas)', 'real-estate-manager' ),
		'VE-Y' => __( 'Delta Amacuro', 'real-estate-manager' ),
		'VE-Z' => __( 'Amazonas', 'real-estate-manager' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'real-estate-manager' ),
		'FS'  => __( 'Free State', 'real-estate-manager' ),
		'GP'  => __( 'Gauteng', 'real-estate-manager' ),
		'KZN' => __( 'KwaZulu-Natal', 'real-estate-manager' ),
		'LP'  => __( 'Limpopo', 'real-estate-manager' ),
		'MP'  => __( 'Mpumalanga', 'real-estate-manager' ),
		'NC'  => __( 'Northern Cape', 'real-estate-manager' ),
		'NW'  => __( 'North West', 'real-estate-manager' ),
		'WC'  => __( 'Western Cape', 'real-estate-manager' ),
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'real-estate-manager' ),
		'ZM-02' => __( 'Central', 'real-estate-manager' ),
		'ZM-03' => __( 'Eastern', 'real-estate-manager' ),
		'ZM-04' => __( 'Luapula', 'real-estate-manager' ),
		'ZM-05' => __( 'Northern', 'real-estate-manager' ),
		'ZM-06' => __( 'North-Western', 'real-estate-manager' ),
		'ZM-07' => __( 'Southern', 'real-estate-manager' ),
		'ZM-08' => __( 'Copperbelt', 'real-estate-manager' ),
		'ZM-09' => __( 'Lusaka', 'real-estate-manager' ),
		'ZM-10' => __( 'Muchinga', 'real-estate-manager' ),
	),
);
