<?php
/*
Plugin Name: Sity Cloud Auto Blocksy Theme
Description: تفعيل قالب Blocksy تلقائيًا على أي موقع فرعي جديد في الشبكة وإخفاء قالب Twenty Twenty-Five.
Author: Sity Cloud
Version: 1.0
Network: true
*/

// تفعيل قالب Blocksy على أي موقع فرعي جديد
add_action('wpmu_new_blog', 'sitycloud_activate_blocksy_on_new_site', 10, 1);
function sitycloud_activate_blocksy_on_new_site($blog_id) {
    if ( ! function_exists('switch_to_blog') ) {
        return;
    }

    $blocksy_slug = 'blocksy'; // لو اسم مجلد القالب مختلف عدله هنا

    switch_to_blog($blog_id);

    // تأكد إن Blocksy موجود
    $theme = wp_get_theme($blocksy_slug);
    if ( $theme->exists() ) {
        switch_theme($blocksy_slug);
    }

    restore_current_blog();
}

// وقت تفعيل البلجن: السماح لقالب Blocksy على الشبكة ومنع twentytwentyfive
register_activation_hook(__FILE__, 'sitycloud_setup_allowed_themes');
function sitycloud_setup_allowed_themes() {
    if ( ! is_multisite() ) {
        return;
    }

    $blocksy_slug        = 'blocksy';
    $twenty_twenty_five  = 'twentytwentyfive';

    // جلب الثيمات المسموحة على مستوى الشبكة
    $allowed = get_site_option('allowedthemes', array());

    if ( ! is_array($allowed) ) {
        $allowed = array();
    }

    // السماح لـ Blocksy
    $allowed[$blocksy_slug] = true;

    // إزالة Twenty Twenty-Five
    if ( isset($allowed[$twenty_twenty_five]) ) {
        unset($allowed[$twenty_twenty_five]);
    }

    update_site_option('allowedthemes', $allowed);

    // احتياط للـ option القديم لو موجود
    $legacy_allowed = get_site_option('allowed_themes');
    if ( is_array($legacy_allowed) ) {
        $legacy_allowed[$blocksy_slug] = 1;
        if ( isset($legacy_allowed[$twenty_twenty_five]) ) {
            unset($legacy_allowed[$twenty_twenty_five]);
        }
        update_site_option('allowed_themes', $legacy_allowed);
    }
}

// إخفاء قالب Twenty Twenty-Five من شاشة القوالب في المواقع الفرعية
add_filter('wp_prepare_themes_for_js', 'sitycloud_hide_twenty_twenty_five_theme');
function sitycloud_hide_twenty_twenty_five_theme($themes) {
    if ( is_network_admin() ) {
        // في لوحة إدارة الشبكة خليه يظهر عادي لو حابب تتحكم فيه
        return $themes;
    }

    $twenty_twenty_five = 'twentytwentyfive';

    if ( isset($themes[$twenty_twenty_five]) ) {
        unset($themes[$twenty_twenty_five]);
    }

    return $themes;
}
