/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/analytify-shortcode/assets/icons.js":
/*!*************************************************!*\
  !*** ./src/analytify-shortcode/assets/icons.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   analytify: function() { return /* binding */ analytify; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);


const analytify = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  width: "33.2px",
  height: "33.2px",
  viewBox: "-478.3 346.3 33.2 33.2"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M-446.5,375.9c-0.8,0-1.4-0.6-1.4-1.4v-1.4v-1c-3,4.5-8,7.4-13.8,7.4c-9.2,0-16.6-7.4-16.6-16.6 c0-9.2,7.4-16.6,16.6-16.6c5.8,0,10.8,2.9,13.8,7.4v-0.3v-0.1l0,0c0.1-0.7,0.7-1.3,1.4-1.3c0.7,0,1.3,0.6,1.4,1.3l0,0v0.1v2.1v17.6 v1.4C-445.1,375.2-445.7,375.9-446.5,375.9z M-461.7,349.1c-7.6,0-13.8,6.2-13.8,13.8s6.2,13.8,13.8,13.8s13.8-6.2,13.8-13.8 S-454.1,349.1-461.7,349.1z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M-467.4,361.9c-0.9,0-1.6,0.7-1.6,1.6v5.3c0,0.9,0.7,1.6,1.6,1.6c0.9,0,1.6-0.7,1.6-1.6v-5.3 C-465.9,362.6-466.6,361.9-467.4,361.9z M-461.7,359.3c-0.9,0-1.6,0.7-1.6,1.6v7.9c0,0.9,0.7,1.6,1.6,1.6s1.6-0.7,1.6-1.6v-7.9 C-460.1,360-460.8,359.3-461.7,359.3z M-456,355.4c-0.9,0-1.6,0.7-1.6,1.6v11.8c0,0.9,0.7,1.6,1.6,1.6s1.6-0.7,1.6-1.6V357 C-454.4,356.1-455.1,355.4-456,355.4z"
}));

/***/ }),

/***/ "./src/analytify-shortcode/blockVariationPicker.js":
/*!*********************************************************!*\
  !*** ./src/analytify-shortcode/blockVariationPicker.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AnalytifyBlockVariationPicker: function() { return /* binding */ AnalytifyBlockVariationPicker; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__);




const AnalytifyBlockVariationPicker = ({
  name: blockName,
  setAttributes
}) => {
  const {
    blockType,
    defaultVariation,
    variations
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const {
      getBlockVariations,
      getBlockType,
      getDefaultBlockVariation
    } = select(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__.store);
    return {
      blockType: getBlockType(blockName),
      defaultVariation: getDefaultBlockVariation(blockName, 'block'),
      variations: getBlockVariations(blockName, 'block')
    };
  }, [blockName]);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)()
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.__experimentalBlockVariationPicker, {
    icon: blockType?.icon?.src,
    label: blockType?.title,
    variations: variations,
    onSelect: (nextVariation = defaultVariation) => {
      if (nextVariation.attributes) {
        setAttributes(nextVariation.attributes);
      }
    }
  }));
};

/***/ }),

/***/ "./src/analytify-shortcode/edit.js":
/*!*****************************************!*\
  !*** ./src/analytify-shortcode/edit.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ Edit; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _blockVariationPicker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./blockVariationPicker */ "./src/analytify-shortcode/blockVariationPicker.js");
/* harmony import */ var _editSimpleShortCode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./editSimpleShortCode */ "./src/analytify-shortcode/editSimpleShortCode.js");
/* harmony import */ var _editAdvancedShortcode__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editAdvancedShortcode */ "./src/analytify-shortcode/editAdvancedShortcode.js");
/* harmony import */ var _assets_editor_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./assets/editor.scss */ "./src/analytify-shortcode/assets/editor.scss");






/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @param {Object}   props               Properties passed to the function.
 * @param {Object}   props.attributes    Available block attributes.
 * @param {Function} props.setAttributes Function that updates individual attributes.
 * @param {boolean}  props.isSelected    Boolean whether the block is selected in editor.
 *
 * @return {Element} Element to render.
 */
function Edit(props) {
  const {
    attributes: {
      shortCodeType
    }
  } = props;
  let Component = _blockVariationPicker__WEBPACK_IMPORTED_MODULE_1__.AnalytifyBlockVariationPicker;
  if (shortCodeType === 'simple') {
    Component = _editSimpleShortCode__WEBPACK_IMPORTED_MODULE_2__["default"];
  } else if (shortCodeType === 'advanced') {
    Component = _editAdvancedShortcode__WEBPACK_IMPORTED_MODULE_3__["default"];
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Component, {
    ...props
  });
}

/***/ }),

/***/ "./src/analytify-shortcode/editAdvancedShortcode.js":
/*!**********************************************************!*\
  !*** ./src/analytify-shortcode/editAdvancedShortcode.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ EditAdvanceShortCode; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_metrics_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./data/metrics.json */ "./src/analytify-shortcode/data/metrics.json");
/* harmony import */ var _data_dimensions_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./data/dimensions.json */ "./src/analytify-shortcode/data/dimensions.json");
/* harmony import */ var _data_sortOptions_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./data/sortOptions.json */ "./src/analytify-shortcode/data/sortOptions.json");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _assets_editor_scss__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./assets/editor.scss */ "./src/analytify-shortcode/assets/editor.scss");

/**
 * WordPress components that create the necessary UI elements for the block
 *
 * @see https://developer.wordpress.org/block-editor/packages/packages-components/
 */








/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */




/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @param {Object}   props               Properties passed to the function.
 * @param {Object}   props.attributes    Available block attributes.
 * @param {Function} props.setAttributes Function that updates individual attributes.
 * @param {boolean}  props.isSelected    Boolean whether the block is selected in editor.
 *
 * @return {Element} Element to render.
 */
function EditAdvanceShortCode({
  attributes,
  setAttributes
}) {
  const {
    shortcode,
    selectedMetrics,
    selectedDimensions,
    sortOption,
    selectedDate,
    analyticsFor,
    post_id
  } = attributes;
  const [startDate, setStartDate] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)('');
  const [endDate, setEndDate] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)('');
  const isInitialMount = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useRef)(true);
  const instanceId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_6__.useInstanceId)(EditAdvanceShortCode);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (isInitialMount.current) {
      isInitialMount.current = false;
      return;
    }

    // Start creating the shortcode.
    let createdShortcode = `[analytify-stats`;

    // If user has selected some metrics add it to the shortcode.
    if (selectedMetrics?.length) {
      createdShortcode = createdShortcode + ` metrics="${selectedMetrics}"`;
    }

    // If user has selected some dimensions and that to shortcode.
    if (selectedDimensions?.length) {
      createdShortcode = createdShortcode + ` dimensions="${selectedDimensions}"`;
    }

    /**
     * There are two types of dates predefined and custom 
     * both have slightly different structure.
     * we will check that and store the structure in this
     * variable.
     */
    let date = '';
    if (selectedDate) {
      date = ` date_type="${selectedDate}"`;
    }
    if (startDate || endDate) {
      date = ` date_type='custom' start_date="${startDate}" end_date="${endDate}"`;
    }

    // Add the date variable contents to shortcode.
    createdShortcode = createdShortcode + date;
    createdShortcode = createdShortcode + ` analytics_for="${analyticsFor}"`;

    // If the Analytics for is page id and some post id is selected add that to shortcode.
    if (analyticsFor === 'page_id' && post_id) {
      createdShortcode = createdShortcode + ` custom_page_id="${post_id}"`;
    }

    // If user has selected some sort option add that to shortcode
    if (sortOption) {
      createdShortcode = createdShortcode + ` sort="${sortOption}"`;
    }

    // At last close the shortcode with closing bracket.
    createdShortcode = createdShortcode + ']';

    // Save the created shortcode in attributes and re-render the component.
    setAttributes({
      shortcode: createdShortcode
    });
  }, [selectedMetrics, selectedDimensions, selectedDate, sortOption, analyticsFor, startDate, endDate, post_id]);
  const inputId = `analytify-shortcode-input-${instanceId}`;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.useBlockProps)({
      className: 'components-placeholder'
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Analytify Shortcode Orchestrator')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    multiple: true,
    label: "Select Metrics",
    value: selectedMetrics,
    options: _data_metrics_json__WEBPACK_IMPORTED_MODULE_3__,
    onChange: metrics => {
      if ('' == metrics[0]) {
        setAttributes({
          selectedMetrics: []
        });
      } else {
        setAttributes({
          selectedMetrics: [...metrics]
        });
      }
    },
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    multiple: true,
    label: "Select Dimensions",
    value: selectedDimensions,
    options: _data_dimensions_json__WEBPACK_IMPORTED_MODULE_4__,
    onChange: dimensions => {
      if ('' == dimensions[0]) {
        setAttributes({
          selectedDimensions: []
        });
      } else {
        setAttributes({
          selectedDimensions: [...dimensions]
        });
      }
    },
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    label: "Period:",
    value: selectedDate,
    options: [{
      "value": "- 1 days",
      "label": "Yesterday"
    }, {
      "value": "- 7 days",
      "label": "Last week"
    }, {
      "value": "- 15 days",
      "label": "Last 15 days"
    }, {
      "value": "- 30 days",
      "label": "Last 30 days"
    }, {
      "value": "year-to-date",
      "label": "This year"
    }, {
      "value": "- 365 days",
      "label": "Last Year"
    }],
    onChange: date => {
      setAttributes({
        selectedDate: date
      });
      setStartDate('');
      setEndDate('');
    },
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    label: "Sort by",
    value: sortOption,
    options: _data_sortOptions_json__WEBPACK_IMPORTED_MODULE_5__,
    onChange: sortOption => setAttributes({
      sortOption: sortOption
    }),
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    label: "Analytics For:",
    value: analyticsFor,
    options: [{
      "value": "current",
      "label": "Current Post/Page"
    }, {
      "value": "full",
      "label": "Full Site"
    }, {
      "value": "page_id",
      "label": "Post/Page ID"
    }],
    onChange: analyticsFor => setAttributes({
      analyticsFor: analyticsFor
    }),
    __nextHasNoMarginBottom: true
  }), analyticsFor === 'page_id' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
    label: "Enter Post ID",
    type: "number",
    value: post_id,
    onChange: post_id => {
      post_id > 0 ? setAttributes({
        post_id: post_id
      }) : setAttributes({
        post_id: null
      });
    }
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelBody, {
    title: "Custom Date",
    initialOpen: false
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Start Date:', 'wp-analytify-pro'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.DatePicker, {
    currentDate: startDate,
    onChange: newDate => setStartDate(new Date(newDate).toLocaleDateString("en-CA")),
    is12Hour: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('End Date:', 'wp-analytify-pro'))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.DatePicker, {
    currentDate: endDate,
    onChange: newDate => setEndDate(new Date(newDate).toLocaleDateString("en-CA")),
    is12Hour: true
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: inputId,
    className: "components-placeholder__label"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Analytify Shortcode:')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_7__.PlainText, {
    className: "blocks-shortcode__textarea",
    id: inputId,
    value: shortcode,
    onChange: contents => setAttributes({
      shortcode: contents
    })
  }));
}

/***/ }),

/***/ "./src/analytify-shortcode/editSimpleShortCode.js":
/*!********************************************************!*\
  !*** ./src/analytify-shortcode/editSimpleShortCode.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ EditSimpleShortCode; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_metrics_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./data/metrics.json */ "./src/analytify-shortcode/data/metrics.json");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "@wordpress/compose");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _assets_editor_scss__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./assets/editor.scss */ "./src/analytify-shortcode/assets/editor.scss");

/**
 * WordPress components that create the necessary UI elements for the block
 *
 * @see https://developer.wordpress.org/block-editor/packages/packages-components/
 */






/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */




/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @param {Object}   props               Properties passed to the function.
 * @param {Object}   props.attributes    Available block attributes.
 * @param {Function} props.setAttributes Function that updates individual attributes.
 * @param {boolean}  props.isSelected    Boolean whether the block is selected in editor.
 *
 * @return {Element} Element to render.
 */
function EditSimpleShortCode({
  attributes,
  setAttributes
}) {
  const {
    shortcode,
    selectedMetrics,
    selectedDate,
    analyticsFor
  } = attributes;
  const isInitialMount = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useRef)(true);
  const instanceId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__.useInstanceId)(EditSimpleShortCode);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (isInitialMount.current) {
      isInitialMount.current = false;
      return;
    }
    setAttributes({
      shortcode: `[analytify-stats metrics="${selectedMetrics}" date_type="${selectedDate}" analytics_for="${analyticsFor}"]`
    });
  }, [selectedMetrics, selectedDate, analyticsFor]);
  const inputId = `analytify-shortcode-input-${instanceId}`;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.useBlockProps)({
      className: 'components-placeholder'
    })
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelBody, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Analytify Shortcode Orchestrator')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    multiple: true,
    label: "Select Metrics",
    value: selectedMetrics,
    options: _data_metrics_json__WEBPACK_IMPORTED_MODULE_3__,
    onChange: metrics => setAttributes({
      selectedMetrics: [...metrics]
    }),
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    label: "Period:",
    value: selectedDate,
    options: [{
      "value": "- 1 days",
      "label": "Yesterday"
    }, {
      "value": "- 7 days",
      "label": "Last week"
    }, {
      "value": "- 15 days",
      "label": "Last 15 days"
    }, {
      "value": "- 30 days",
      "label": "Last 30 days"
    }, {
      "value": "year-to-date",
      "label": "This year"
    }, {
      "value": "- 365 days",
      "label": "Last Year"
    }],
    onChange: date => setAttributes({
      selectedDate: date
    }),
    __nextHasNoMarginBottom: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
    label: "Analytics For:",
    value: analyticsFor,
    options: [{
      "value": "current",
      "label": "Current Post/Page"
    }, {
      "value": "full",
      "label": "Full Site"
    }],
    onChange: analyticsFor => setAttributes({
      analyticsFor: analyticsFor
    }),
    __nextHasNoMarginBottom: true
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: inputId,
    className: "components-placeholder__label"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Analytify Shortcode:')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.PlainText, {
    className: "blocks-shortcode__textarea",
    id: inputId,
    value: shortcode,
    onChange: contents => setAttributes({
      shortcode: contents
    })
  }));
}

/***/ }),

/***/ "./src/analytify-shortcode/save.js":
/*!*****************************************!*\
  !*** ./src/analytify-shortcode/save.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ save; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */


/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
function save({
  attributes
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.RawHTML, null, attributes.shortcode));
}

/***/ }),

/***/ "./src/analytify-shortcode/variations.js":
/*!***********************************************!*\
  !*** ./src/analytify-shortcode/variations.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _assets_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./assets/icons */ "./src/analytify-shortcode/assets/icons.js");

/**
 * WordPress dependencies
 */




/** @typedef {import('@wordpress/blocks').WPBlockVariation} WPBlockVariation */

/**
 * Template option choices for predefined columns layouts.
 *
 * @type {WPBlockVariation[]}
 */
const variations = [{
  name: 'simple-shortcode',
  title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Analytify Simple Shortcode'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Create Simple Analytify Shortcode to show stats. It's enough most of the times"),
  icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SVG, {
    width: "800px",
    height: "800px",
    viewBox: "0 0 17 17",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Path, {
    d: "M0.026 1h3v1h-2v13h2v1h-3v-15zM14.026  1v1h2v13h-2v1h3v-15h-3zM8.91 7.967c-1.115-0.433-1.607-0.804-1.607-1.56 0-0.552 0.42-1.211  1.523-1.211 0.731 0 1.271 0.239 1.535 0.384l0.288-0.852c-0.359-0.204-0.96-0.396-1.787-0.396-1.571  0-2.614 0.936-2.614 2.195 0 1.14 0.815 1.823 2.135 2.291 1.091 0.419 1.523 0.851 1.523 1.606 0  0.815-0.624 1.38-1.691 1.38-0.72 0-1.403-0.24-1.871-0.528l-0.264 0.876c0.432 0.287 1.283 0.516 2.062  0.516 1.907 0 2.831-1.079 2.831-2.327 0.001-1.188-0.696-1.847-2.063-2.374z"
  })),
  attributes: {
    "shortcode": "[analytify-stats metrics=\"screenPageViews\" date_type=\"- 1 days\" analytics_for=\"current\"]",
    "selectedMetrics": ["screenPageViews"],
    "selectedDate": "- 1 days",
    "analyticsFor": "current",
    "shortCodeType": "simple"
  },
  scope: ['block'],
  isActive: (blockAttributes, variationAttributes) => blockAttributes.shortCodeType === variationAttributes.shortCodeType
}, {
  name: "advance-shortcode",
  title: "Analytify Advaned Shortcode",
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Get more granular control over shortcode generation use to create complex shortcodes.'),
  attributes: {
    "shortcode": "[analytify-stats metrics=\"sessions\" date_type=\"- 1 days\" analytics_for=\"current\"]",
    "selectedMetrics": ["sessions"],
    "selectedDimensions": [],
    "sortOption": "",
    "selectedDate": "- 1 days",
    "analyticsFor": "current",
    "shortCodeType": "advanced",
    "post_id": "12"
  },
  icon: _assets_icons__WEBPACK_IMPORTED_MODULE_3__.analytify,
  scope: ['block'],
  isActive: (blockAttributes, variationAttributes) => blockAttributes.shortCodeType === variationAttributes.shortCodeType
}];
/* harmony default export */ __webpack_exports__["default"] = (variations);

/***/ }),

/***/ "./src/analytify-shortcode/assets/editor.scss":
/*!****************************************************!*\
  !*** ./src/analytify-shortcode/assets/editor.scss ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ (function(module) {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ (function(module) {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ (function(module) {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ (function(module) {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/compose":
/*!*********************************!*\
  !*** external ["wp","compose"] ***!
  \*********************************/
/***/ (function(module) {

module.exports = window["wp"]["compose"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ (function(module) {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/analytify-shortcode/block.json":
/*!********************************************!*\
  !*** ./src/analytify-shortcode/block.json ***!
  \********************************************/
/***/ (function(module) {

module.exports = JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"analytify/shortcodes","version":"1.0.0","title":"Analytify Shortcode","category":"widgets","description":"Analytify Shortcode block","attributes":{"shortcode":{"type":"string","default":"[analytify-stats metrics=\\"screenPageViews\\" date_type=\\"- 1 days\\" analytics_for=\\"current\\"]"},"selectedMetrics":{"type":"array","default":["screenPageViews"]},"selectedDimensions":{"type":"array"},"sortOption":{"type":"string"},"selectedDate":{"type":"string","default":"- 1 days"},"analyticsFor":{"type":"string","default":"current"},"shortCodeType":{"type":"string"},"post_id":{"type":"string"}},"example":{"attributes":{"shortcode":"[analytify-stats metrics=\\"screenPageViews\\" date_type=\\"- 1 days\\" analytics_for=\\"current\\"]","shortCodeType":"simple"}},"textdomain":"analytify-shortcode","editorScript":"file:./index.js","editorStyle":"file:./index.css"}');

/***/ }),

/***/ "./src/analytify-shortcode/data/dimensions.json":
/*!******************************************************!*\
  !*** ./src/analytify-shortcode/data/dimensions.json ***!
  \******************************************************/
/***/ (function(module) {

module.exports = JSON.parse('[{"value":"","label":"CLEAR DIMENSIONS"},{"value":"city","label":"City"},{"value":"country","label":"Country"},{"value":"firstUserSourceMedium","label":"First user source / medium"},{"value":"fullPageUrl","label":"Full page URL"},{"value":"pageLocation","label":"Page Location"},{"value":"pagePath","label":"Page Path"},{"value":"pageTitle","label":"Page Title"},{"value":"sessionSourceMedium","label":"Session source / medium"},{"value":"socialNetwork","label":"Social Network"}]');

/***/ }),

/***/ "./src/analytify-shortcode/data/metrics.json":
/*!***************************************************!*\
  !*** ./src/analytify-shortcode/data/metrics.json ***!
  \***************************************************/
/***/ (function(module) {

module.exports = JSON.parse('[{"value":"","label":"CLEAR METRICS"},{"value":"totalUsers","label":"Total Users"},{"value":"newUsers","label":"New Users"},{"value":"sessions","label":"Sessions"},{"value":"bounceRate","label":"Bounce Rate"},{"value":"userEngagementDuration","label":"User Engagement Duration"},{"value":"averageSessionDuration","label":"Average Session Duration"},{"value":"screenPageViews","label":"Page Views"},{"value":"screenPageViewsPerSession","label":"Screen Page Views Per Session"}]');

/***/ }),

/***/ "./src/analytify-shortcode/data/sortOptions.json":
/*!*******************************************************!*\
  !*** ./src/analytify-shortcode/data/sortOptions.json ***!
  \*******************************************************/
/***/ (function(module) {

module.exports = JSON.parse('[{"value":"totalUsers","label":"Total Users"},{"value":"newUsers","label":"New Users"},{"value":"sessions","label":"Sessions"},{"value":"bounceRate","label":"Bounce Rate"},{"value":"userEngagementDuration","label":"User Engagement Duration"},{"value":"averageSessionDuration","label":"Average Session Duration"},{"value":"screenPageViews","label":"Page Views"},{"value":"screenPageViewsPerSession","label":"Screen Page Views Per Session"}]');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
!function() {
/*!******************************************!*\
  !*** ./src/analytify-shortcode/index.js ***!
  \******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assets/icons */ "./src/analytify-shortcode/assets/icons.js");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./edit */ "./src/analytify-shortcode/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./save */ "./src/analytify-shortcode/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./block.json */ "./src/analytify-shortcode/block.json");
/* harmony import */ var _variations__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./variations */ "./src/analytify-shortcode/variations.js");
/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */



/**
 * Internal dependencies
 */





/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_4__.name, {
  icon: _assets_icons__WEBPACK_IMPORTED_MODULE_1__.analytify,
  variations: _variations__WEBPACK_IMPORTED_MODULE_5__["default"],
  /**
   * @see ./edit.js
   */
  edit: _edit__WEBPACK_IMPORTED_MODULE_2__["default"],
  /**
   * @see ./save.js
   */
  save: _save__WEBPACK_IMPORTED_MODULE_3__["default"]
});
}();
/******/ })()
;
//# sourceMappingURL=index.js.map