<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

ob_start();

$i = 0;

if ( ! empty( $stats['rows'] ) ) {
	foreach ( $stats['rows'] as $c_stats ) {
		$i++;
		?>
		<div class="pa_campaigns_statistics">
			<div class="pa-tdo-left">
				<div class="pa_data_text_wraper">
					<span class="large-count"><?php echo esc_html( $c_stats[0] ); ?></span>
					<?php
					if ( '(not set)' === $c_stats[0] ) {
						?>
						<span class="dashicons dashicons-editor-help analytify-campaings-tooltip" title="<?php esc_html_e( 'Not Set: The \'keyword\' (not set) simply identifies traffic that doesn\'t arrive via a particular keyword and hence may not come via any search at all. This includes traffic coming from email, referral sites, or even things like Google Images.', 'wp-analytify-campaings' ); ?>"></span>
						<?php
					}
					if ( class_exists( 'WP_Analytify_WooCommerce_Addon' ) && '(not set)' !== $c_stats[0] ) {
						?>
						<a href="<?php echo admin_url( 'admin.php?page=analytify-woocommerce&cn=' . $c_stats[0] ); ?>" style="display:block;margin-top:10px;"><?php esc_html_e( 'View Sale Stats', 'wp-analytify-campaings' ); ?></a>
						<?php
					}
					?>
					<a href="#" class="analytify-view-detail-campaings" data-source="<?php echo esc_html( $c_stats[0] ); ?>"><?php esc_html_e( 'View Detail Stats', 'wp-analytify-campaings' ); ?></a>
				</div>
			</div>

			<div class="pa-tdo-right" id="pa-tdo-right">
				<div class="pa-bigtext"><span class="count-visits"><?php echo number_format( $c_stats[1] ); ?></span><span class="source"><?php analytify_e( 'Sessions', 'wp-analytify' ); ?></span></div>
				<div class="pa-bigtext"><span class="count-visits">
					<?php
					if ( $c_stats[1] > 0 ) {
						echo number_format( round( ( $c_stats[2] / $c_stats[1] ) * 100, 2 ), 2 );
					} else {
						echo '0';
					}
					?>
				</span><span class="source"><?php analytify_e( '% New Sessions', 'wp-analytify' ); ?></span></div>
				<div class="pa-bigtext"><span class="count-visits"><?php echo $c_stats[2]; ?></span><span class="source"><?php esc_html_e( 'New Users', 'wp-analytify-campaings' ); ?></span></div>
			</div>
			<div class="pa-tdo-rights" id="pa-tdo-rights">
				<div class="pa-bigtext"><span class="count-visits">
					<?php
					if ( $c_stats[4] <= 0 ) {
						echo '0.00%';
					} else {
						echo number_format( round( ( $c_stats[3] / $c_stats[4] ) * 100, 2 ), 2 ) . '%';
					}
					?>
					</span><span class="source"><?php analytify_e( 'Bounce Rate', 'wp-analytify' ); ?></span>
				</div>
				<div class="pa-bigtext">
					<span class=" count-visits">
						<?php
						if ( $c_stats[1] <= 0 ) {
							echo '0.00';
						} else {
							echo number_format( round( $c_stats[6] / $c_stats[1], 2 ), 2 );
						}
						?>
						</span><span class="source"><?php esc_html_e( 'Pages / Session', 'wp-analytify-campaings' ); ?></span>
					</div>
					<div class="pa-bigtext"><span class="count-visits"><?php echo WPANALYTIFY_Utils::pretty_time( $c_stats[5] ); ?></span><span class="source"><?php esc_html_e( 'Avg. Session duration', 'wp-analytify-campaings' ); ?></span></div>
				</div>
				<div class="analytify-detail-campaings-container">
				</div>
			</div>
		</div>
		<?php
	}
} else {
	esc_html_e( 'No Campaigns.', 'wp-analytify-campaings' );
}

$body = ob_get_clean();

echo wp_json_encode(
	array(
		'message' => $i,
		'body'    => $body,
	)
);
