<?php
class WP_Analytify_Addon_Email extends WP_Analytify_Pro_Base
{

	private $info_message;

	private $ga_mode;

	private $wp_analytify;
	/**
	 * Constructor.
	 */
	public function __construct() {
		parent::__construct();
		$this->setup_constants();
		$this->hooks();
	}

	/**
	 * Register all the hooks.
	 *
	 * @return void
	 */
	private function hooks() {
		add_action( 'admin_init', array( $this, 'save_version' ), 50 );
		add_action( 'admin_init', array( $this, 'update_routine' ), 10 );
		add_action( 'admin_init', array( $this, 'backward_compatibility' ), 10 );

		add_filter( 'wp_analytify_pro_setting_fields', array( $this, 'analytify_email_setting_fields' ), 21, 1 );
		/**
		 * This hooks is called in the Core version.
		 */
		add_filter( 'wp_analytify_email_on_cron_time', array( $this, 'callback_wp_analytify_email_on_cron_time' ), 10, 3 );
		add_filter( 'wp_analytify_single_email', array( $this, 'callback_wp_analytify_single_email' ), 10, 3 );
	}

	/**
	 * Setup plugin constants
	 *
	 * @access      private
	 * @since       1.0.0
	 * @return      void
	 */
	private function setup_constants() {
		// Setting Global Values.
		$this->define( 'EMAIL_ANALYTIFY_PLUGIN_FILE', __FILE__ );
		$this->define( 'EMAIL_ANALYTIFY_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		$this->define( 'EMAIL_ANALYTIFY_PLUGIN_DIR', dirname( __FILE__ ) );
		$this->define( 'EMAIL_ANALYTIFY_PRODUCT_NAME', 'Google Analytics Email Notifications' );
		$this->define( 'EMAIL_ANALYTIFY_PRODUCT_ID', 6580 );
		$this->define( 'EMAIL_ANALYTIFY_STORE_URL', 'https://analytify.io' );
	}

	/**
	 * Define constant if not already set.
	 *
	 * @param  string      $name
	 * @param  string|bool $value
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	public function analytify_email_notics() {
		?>
		<div class="notice notice-success is-dismissible">
			<p><?php _e( 'Analytify detailed report sent!', 'wp-analytify-email' ); ?></p>
		</div>
		<?php
	}

	public function custom_phpmailer_init( $PHPMailer ) {
		$PHPMailer->IsSMTP();
		$PHPMailer->SMTPAuth   = true;
		$PHPMailer->SMTPSecure = 'ssl';
		$PHPMailer->Host       = 'smtp.gmail.com';
		$PHPMailer->Port       = 465;
		$PHPMailer->Username   = 'test@gmail.com';
		$PHPMailer->Password   = '';
	}

	public function analytify_email_setting_fields( $old_fields ) {

		$stats_option = array(
			'show-overall-general' => analytify__( 'General Stats', 'wp-analytify' ),
			'show-top-pages'       => __( 'Top Pages Stats', 'wp-analytify-email' ),
			'show-geographics'     => analytify__( 'Geographic Stats', 'wp-analytify' ),
			'show-system'          => analytify__( 'System Stats', 'wp-analytify' ),
			'show-keywords'        => analytify__( 'Keywords and Referrers Stats', 'wp-analytify' ),
			'show-social'          => analytify__( 'Social Media Stats', 'wp-analytify' ),
			'show-whats-happen'    => __( 'Whats Happening Stats', 'wp-analytify-email' ),
		);

		// check if Analytify Pro and AnalytifyForms is installed.
		if (class_exists('Analytify_Addon_Forms') && class_exists('WP_Analytify_Pro_Base')) {
			$stats_option['show-forms-tracking'] = __('Forms Tracking Stats', 'wp-analytify-forms');
		}
		// check if WooCommerce or EDD installed.
		if ( class_exists( 'WP_Analytify_WooCommerce_Addon' ) || class_exists( 'WP_Analytify_Edd_Addon' ) ) {
			$stats_option['show-e-commerce-stats'] = __( 'E-Commerce Report', 'wp-analytify-email' );
		}

		$free_email_fields = $old_fields['wp-analytify-email'];

		// New addon fields.
		$addon_fields = array(
			array(
				'name'    => 'analytif_email_cron_time',
				'label'   => __( 'Set Schedule', 'wp-analytify-email' ),
				'desc'    => __( 'Select days to schedule weekly or/and monthly emails.', 'wp-analytify-email' ),
				'type'    => 'multi_select',
				'default' => 'weekly',
				'options' => array(
					'main'  => array(
						'week'  => 'Weekly',
						'month' => 'Monthly',
					),
					'value' => array(
						'week'  => array(
							'false'     => __( 'Select Day', 'wp-analytify-email' ),
							'Sunday'    => analytify__( 'Sunday' ),
							'Monday'    => analytify__( 'Monday' ),
							'Tuesday'   => analytify__( 'Tuesday' ),
							'Wednesday' => analytify__( 'Wednesday' ),
							'Thursday'  => analytify__( 'Thursday' ),
							'Friday'    => analytify__( 'Friday' ),
							'Saturday'  => analytify__( 'Saturday' ),
						),
						'month' => array(
							'false'    => __( 'Select Date', 'wp-analytify-email' ),
							'1'        => __( '1', 'wp-analytify-email' ),
							'2'        => __( '2', 'wp-analytify-email' ),
							'3'        => __( '3', 'wp-analytify-email' ),
							'4'        => __( '4', 'wp-analytify-email' ),
							'5'        => __( '5', 'wp-analytify-email' ),
							'6'        => __( '6', 'wp-analytify-email' ),
							'7'        => __( '7', 'wp-analytify-email' ),
							'8'        => __( '8', 'wp-analytify-email' ),
							'9'        => __( '9', 'wp-analytify-email' ),
							'10'       => __( '10', 'wp-analytify-email' ),
							'11'       => __( '11', 'wp-analytify-email' ),
							'12'       => __( '12', 'wp-analytify-email' ),
							'13'       => __( '13', 'wp-analytify-email' ),
							'14'       => __( '14', 'wp-analytify-email' ),
							'15'       => __( '15', 'wp-analytify-email' ),
							'16'       => __( '16', 'wp-analytify-email' ),
							'17'       => __( '17', 'wp-analytify-email' ),
							'18'       => __( '18', 'wp-analytify-email' ),
							'19'       => __( '19', 'wp-analytify-email' ),
							'20'       => __( '20', 'wp-analytify-email' ),
							'21'       => __( '21', 'wp-analytify-email' ),
							'22'       => __( '22', 'wp-analytify-email' ),
							'23'       => __( '23', 'wp-analytify-email' ),
							'24'       => __( '24', 'wp-analytify-email' ),
							'25'       => __( '25', 'wp-analytify-email' ),
							'26'       => __( '26', 'wp-analytify-email' ),
							'27'       => __( '27', 'wp-analytify-email' ),
							'28'       => __( '28', 'wp-analytify-email' ),
							'last_day' => __( 'Last Day', 'wp-analytify-email' ),
						),
					),
				),
			),
			array(
				'name'              => 'analytify_email_subject',
				'label'             => __( 'Subject', 'wp-analytify-email' ),
				'desc'              => __( 'Add Email Subject', 'wp-analytify-email' ),
				'type'              => 'text',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			),
			array(
				'name'    => 'analytify_email_stats',
				'label'   => __( 'Select Email Stats', 'wp-analytify-email' ),
				'desc'    => __( 'Select which Stats panels you want to display in Email. ', 'wp-analytify-email' ),
				'type'    => 'chosen',
				'default' => array(),
				'options' => $stats_option,
			),
			array(
				'name'              => 'analytify_email_logo',
				'label'             => __( 'Your Agency Logo', 'wp-analytify-email' ),
				'desc'              => __( 'Add your Agency logo in Email Template.<br />Preferred size 150*150 pixel', 'wp-analytify-email' ),
				'type'              => 'image',
				'default'           => '',
				'sanitize_callback' => '',
			),
			array(
				'name'              => 'analytify_note_text',
				'label'             => __( 'Report Note', 'wp-analytify-email' ),
				'desc'              => __( 'The welcome message or top notice will be added in the Email Report. Leave it empty to disable it.', 'wp-analytify-email' ),
				'type'              => 'wysiwyg',
				'default'           => '',
				'options'           => array(
					'tinymce'       => false,
					'media_buttons' => false,
				),
				'sanitize_callback' => 'sanitize_text_field',
			),
			array(
				'name'              => 'analytiy_mail_text',
				'label'             => __( 'Personal Note', 'wp-analytify-email' ),
				'desc'              => __( 'The personal message will be added in Email Report. Leave it empty to disable it.', 'wp-analytify-email' ),
				'type'              => 'wysiwyg',
				'default'           => '',
				'options'           => array(
					'tinymce'       => false,
					'media_buttons' => false,
				),
				'sanitize_callback' => 'wp_kses_post',
			),
			array(
				'name'              => 'analytiy_mail_text_additional',
				'label'             => __( 'Additional Note', 'wp-analytify-email' ),
				'desc'              => __( 'An additional note area at the bottom of the email. Leave it empty to disable it.', 'wp-analytify-email' ),
				'type'              => 'wysiwyg',
				'options'           => array(
					'tinymce'       => false,
					'media_buttons' => false,
				),
				'default'           => __( 'We hope your weekly Analytics summaries encourage the efforts you are putting in your business. But if you no longer wish to receive Analytify Insights emails, you may change your preferences from plugin settings.', 'wp-analytify-email' ),
				'sanitize_callback' => 'wp_kses_post',
			),
			array(
				'name'  => 'analytify_go_to_dashboard',
				'label' => __( 'Hide \'Go To Dashboard\' Button:', 'wp-analytify-email' ),
				'desc'  => __( 'Check this if you want to hide the Go To Dashboard button', 'wp-analytify-email' ),
				'type'  => 'checkbox',
			),
		);

		// Add new addon fields.
		$pro_fields = array_merge( $free_email_fields, $addon_fields );

		// Add sender name option at second position.
		array_splice(
			$pro_fields,
			1,
			0,
			array(
				array(
					'name'              => 'analytiy_from_name',
					'label'             => __( 'From Name', 'wp-analytify-email' ),
					'desc'              => __( 'Sender Name.', 'wp-analytify-email' ),
					'type'              => 'text',
					'default'           => '',
					'sanitize_callback' => 'sanitize_text_field',
				),
			)
		);

		$old_fields['wp-analytify-email'] = $pro_fields;

		return $old_fields;
	}

	public function save_version() {

		if ( ANALTYIFY_EMAIL_ADDON_VERSION != get_option( 'ANALTYIFY_EMAIL_ADDON_VERSION' ) ) {
			update_option( 'ANALTYIFY_EMAIL_ADDON_VERSION', ANALTYIFY_EMAIL_ADDON_VERSION );
		}
	}

	public function update_routine() {
		$old_version  = get_option('ANALTYIFY_EMAIL_ADDON_VERSION');
		$email_option = maybe_unserialize(get_option('wp-analytify-email')) ?: [];
	
		// Ensure 'analytif_email_cron_time' key exists.
		$cron_time = $email_option['analytif_email_cron_time'] ?? '';
	
		if (!$old_version && !is_array($cron_time)) {
			if ($cron_time === 'weekly' || $cron_time === 'biweekly') {
				$email_option['analytif_email_cron_time'] = [
					'week'  => 'Monday',
					'month' => 'false',
				];
			} elseif ($cron_time === '4weeks') {
				$email_option['analytif_email_cron_time'] = [
					'week'  => 'false',
					'month' => '1',
				];
			}
	
			// Update the option and clear old cron.
			update_option('wp-analytify-email', $email_option);
			wp_clear_scheduled_hook('analytify_email_cron_function');
		}
	}
	

	/**
	 * Add pro reports in email message body.
	 *
	 * @return $message
	 */
	public function callback_wp_analytify_email_on_cron_time( $message, $selected_sections, $dates ) {

		if ( ! is_array( $selected_sections ) || empty( $selected_sections ) ) {
			return $message;
		}

		$wp_analytify = $GLOBALS['WP_ANALYTIFY'];

		// Ecommerce.
		if ( in_array( 'show-e-commerce-stats', $selected_sections, true ) ) {

			// WooCommerce.
			if ( class_exists( 'WP_Analytify_WooCommerce_Addon' ) ) {
				if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

					$general_stats = $wp_analytify->get_reports(
						'analytify-email-woo-general-stats',
						array(
							'transactions',
							'totalRevenue',
							'averagePurchaseRevenue',
							'ecommercePurchases',
							'addToCarts',
							'checkouts',
							'itemListClicks',
							'itemViews',
						),
						array(
							'start' => $dates['start_date'],
							'end'   => $dates['end_date'],
						),
						array(),
						array(),
						array(),
						0
					);

					$remove_from_cart = $wp_analytify->get_reports(
						'analytify-email-woo-remove-from-cart',
						array(
							'eventCount',
						),
						array(
							'start' => $dates['start_date'],
							'end'   => $dates['end_date'],
						),
						array(
							'eventName',
						),
						array(),
						array(
							'logic'   => 'AND',
							'filters' => array(
								array(
									'type'       => 'dimension',
									'name'       => 'eventName',
									'match_type' => 1,
									'value'      => 'remove_from_cart',
								),
							),
						),
						0
					);

					if ( isset( $remove_from_cart['aggregations']['eventCount'] ) ) {
						$general_stats['remove_from_cart'] = $remove_from_cart['aggregations']['eventCount'];
					}
					if ( ! function_exists( 'pa_email_include_woo_general' ) ) {
						include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/woo-general-stats.php';
					}
					$message .= pa_email_include_woo_general( $this->wp_analytify, $general_stats );
				}
			}


			// EDD.
			if (class_exists('WP_Analytify_Edd_Addon')) {
				if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {

					$stats = $wp_analytify->get_reports(
						'edd-shopping-analysis-stats',
						array(
							'transactions',
							'totalRevenue',
							'averagePurchaseRevenue',
							// 'ga:refundAmount, TODO: missing_ga4
							// 'ga:transactionsPerSession, TODO: missing_ga4
							'addToCarts',
							// 'ga:productRemovesFromCart, TODO: missing_ga4
							'checkouts',
							'itemViews',
							// 'ga:totalRefunds, TODO: missing_ga4
						),
						array(
							'start' => $dates['start_date'],
							'end' => $dates['end_date'],
						),
						array(),
						array(),
						array(),
						0
					);

					if (!function_exists('pa_email_include_edd_general')) {
						include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/edd-general-stats.php';
					}
					$message .= pa_email_include_edd_general($wp_analytify, $stats);
				}
			}
		}



		// Forms tracking Stats.
		if (in_array('show-forms-tracking', $selected_sections, true)) {

			// API request limit.
			$api_request_limit = apply_filters('analytify_api_limit_forms_addon', 100, $this->ga_mode);

			// Data container.
			$stats = array();

			$this->info_message = esc_html__('\'Impressions\' show how many times a particular form has been viewed.', 'wp-analytify-forms');

			$report_filter = [];
			if ( class_exists( 'AnalytifyAddonFormHelper' ) ) {
				foreach ( AnalytifyAddonFormHelper::get_forms_for_dashboard() as $form ) {
			
					// API filter.
					$report_filter[] = array(
						'type'       => 'dimension',
						'name'       => 'customEvent:wpa_category',
						'match_type' => 1,
						'value'      => $form['category'],
					);
			
					// Stats base.
					$stats[ $form['category'] ] = array(
						'stats'        => array(),
						'info_message' => $this->info_message,
					);
				}
			} else {
				error_log( 'Analytify Form Addon is deactivated. Skipping form data processing.' );
			}			
			if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {

				$st = $wp_analytify->get_reports(
					'show-analytify-forms-dashboard',
					array(
						'eventCount',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'customEvent:wpa_category',
						'customEvent:wpa_link_action',
						'customEvent:wpa_link_label',
					),
					array(
						'type' => 'metric',
						'name' => 'eventCount',
						'order' => 'desc',
					),
					array(
						'logic' => 'OR',
						'filters' => $report_filter,
					),
					$api_request_limit,
					false,
				);

				// Break the report into separate forms for submission and impression.
				if (isset($st['rows']) && !empty($st['rows'])) {
					foreach ($st['rows'] as $st) {

						$_ct = $st['customEvent:wpa_category'];
						$_lb = $st['customEvent:wpa_link_label'];
						$_ac = $st['customEvent:wpa_link_action'];
						$count = $st['eventCount'];

						$stats = apply_filters('analytify_forms_row_format', $stats, $_ct, $_lb, $_ac, $count);
					}
				}


				if (!function_exists('pa_include_forms_tracking_stats')) {
					include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/forms-tracking-stats.php';
				}
				$message .= pa_include_forms_tracking_stats($wp_analytify, $stats);
			}
		}

		// Top Pages Stats.
// Top Pages Stats.
if ( in_array( 'show-top-pages', $selected_sections, true ) ) {
	if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

		$stats = $wp_analytify->get_reports(
			'analytify-email-top-pages-stats',
			array(
				'screenPageViews',
				'userEngagementDuration',
				'bounceRate',
			),
			array(
				'start' => $dates['start_date'],
				'end'   => $dates['end_date'],
			),
			array(
				'pageTitle',
				'pagePath',
			),
			array(
				'type'  => 'metric',
				'name'  => 'screenPageViews',
				'order' => 'desc',
			),
			array(
				'logic'   => 'AND',
				'filters' => array(
					array(
						'type'           => 'dimension',
						'name'           => 'pageTitle',
						'match_type'     => 4,
						'value'          => '(not set)',
						'not_expression' => true,
					),
					array(
						'type'           => 'dimension',
						'name'           => 'pagePath',
						'match_type'     => 4,
						'value'          => '(not set)',
						'not_expression' => true,
					),
				),
			),
			5,
		);

		if ( ! function_exists( 'pa_include_top_pages_stats' ) ) {
			include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/top-pages-stats.php';
		}
		$message .= pa_include_top_pages_stats( $wp_analytify, $stats );
			}
		}

		// Geographic Stats
		if (in_array('show-geographics', $selected_sections, true)) {
			if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {
				$countries_stats = $wp_analytify->get_reports(
					'analytify-email-country-stats',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'country',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'country',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
						),
					),
					10
				);

				$cities_stats = $wp_analytify->get_reports(
					'analytify-email-city-stats',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'city',
						'country',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'country',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'city',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
						),
					),
					10
				);

				if (!function_exists('pa_geopgraphic_lisiting')) {
					include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/geographic.php';
				}

				$message .= pa_geopgraphic_lisiting($wp_analytify, $countries_stats, $cities_stats);
			}
		}

		// System stats
		if (in_array('show-system', $selected_sections, true)) {

			if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {
				$browser_stats = $wp_analytify->get_reports(
					'show-default-browser-dashboard',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'browser',
						'operatingSystem',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'operatingSystem',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
						),
					),
					5
				);

				$os_stats = $wp_analytify->get_reports(
					'show-default-os-dashboard',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'operatingSystem',
						'operatingSystemVersion',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'operatingSystemVersion',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
						),
					),
					5
				);

				$mobile_stats = $wp_analytify->get_reports(
					'show-default-mobile-dashboard',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'mobileDeviceBranding',
						'mobileDeviceModel',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'deviceCategory',
								'match_type' => 4,
								'value' => 'desktop',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'mobileDeviceModel',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
						),
					),
					5
				);

				if (!function_exists('pa_system_stats')) {
					include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/system-stats.php';
				}
				$message .= pa_system_stats($wp_analytify, $browser_stats, $os_stats, $mobile_stats);
			}
		}

		// Keywords stats
		if (in_array('show-keywords', $selected_sections, true)) {

			if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {

				$keyword_stats_raw = $wp_analytify->get_search_console_stats(
					'analytify-email-keyword-stats',
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					5
				);

				$keywords = false;
				if (isset($keyword_stats_raw['response']['rows']) && $keyword_stats_raw['response']['rows'] > 0) {
					$keywords = $keyword_stats_raw['response']['rows'];
				}

				$referer_stats_raw = $wp_analytify->get_reports(
					'analytify-email-refferal-stats',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'sessionSource',
						'sessionMedium',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(),
					5
				);

				$refferals = false;

				if (isset($refferals)) {
					$refferals = $referer_stats_raw;
				}

				if (!function_exists('pa_keyword_referral')) {
					include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/keyword-referral.php';
				}
				$message .= pa_keyword_referral($wp_analytify, $keywords, $refferals);
			}
		}

		if (in_array('show-social', $selected_sections, true)) {
		// Social Media
		if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {
		
			$api_stats_limit = apply_filters( 'analytify_api_limit_social_media_stats', 5, 'dashboard' );
			
			// GA4 Mode
			$social_stats_raw = $wp_analytify->get_reports('show-default-social-dashboard', array(
				'sessions',
			), array(
				'start' => $dates['start_date'],
				'end' => $dates['end_date'],
			), array(
				'sessionSource',
			), array(
				'type'  => 'metric',
				'name'  => 'sessions',
				'order' => 'desc',
			), array(
				'logic'   => 'AND',
				'filters' => array(
					array(
						'type'           => 'dimension',
						'name'           => 'sessionSource',
						'match_type'     => 5,
						'value'          => '^([a-z-]*\.|)(facebook|reddit|youtube|tumblr|quora|instagram|linkedin|yelp|wordpress|pinterest|twitter|t)(\.(com|org|co|)|)$',
						'not_expression' => false,
					),
				),
			), $api_stats_limit * 3);
			
			if (!function_exists('social_stats')) {
				include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/social-media.php';
			}
			$message .= social_stats($wp_analytify, $social_stats_raw);
		}

		}

		// Whats Happen
		if (in_array('show-whats-happen', $selected_sections, true)) {
			if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {
				// jawad changes this var name from stats to whats_happens finally
				$whats_happens = $wp_analytify->get_reports(
					'analytify-email-what-happen-stats',
					array(
						'engagedSessions',
						'engagementRate',
						'userEngagementDuration',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'landingPage',
						'pageTitle',
					),
					array(
						'type' => 'metric',
						'name' => 'engagedSessions',
						'order' => 'desc',
					),
					array(),
					5
				);
				if (!function_exists('whats_happen')) {
					include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/whats-happen.php';
				}
				$message .= whats_happen($wp_analytify, $whats_happens);
			}
		}

		if ('' !== $wp_analytify->settings->get_option('analytiy_mail_text', 'wp-analytify-email')) {
			$message .= '<tr>
			<td style="padding: 40px 20px; text-align:center;padding-bottom: 20px;font: normal 13px \'Roboto\', Arial, Helvetica, sans-serif;"><font color="#444444">' . $wp_analytify->settings->get_option('analytiy_mail_text', 'wp-analytify-email') . '</font></td>
			</tr>';
		}

		// Should we add the email note.
		$show_email_note = apply_filters('wp_analytify_show_email_note', true);
		$emil_note_text = $wp_analytify->settings->get_option('analytiy_mail_text_additional', 'wp-analytify-email');

		if ('' !== $emil_note_text && $show_email_note) {
			// Filter the email additional note text.
			$text_email_note = apply_filters('wp_analytify_email_note_text', $emil_note_text);

			if ($show_email_note) {
				$note_title = apply_filters('wp_analytify_email_note_title', 'Note:');
				$note_title_string = !empty($note_title) ? '<td valign="top" style="width:100px; font: bold 14px \'Roboto\', Arial, Helvetica, sans-serif; padding-right:4px;"><font  color="#444444">' . $note_title . ' </font></td>' : '';

				$message .= '
				<tr>
					<td style="padding: 20px 20px;">
						<table cellpadding="0" cellspacing="0" border="0" width="100%">
							<tr>
								' . $note_title_string . '
								<td style="font: normal 14px \'Roboto\', Arial, Helvetica, sans-serif;"><font color="#848484">' . $text_email_note . '</font><br><br></td>
							</tr>
						</table>
					</td>
				</tr>';
			}
		}

		if ('on' !== $wp_analytify->settings->get_option('analytify_go_to_dashboard', 'wp-analytify-email')) {
			$dashboard_link = apply_filters('analytify_email_dashboard_url', get_admin_url(null, 'admin.php?page=analytify-dashboard'));
			$message .= '<tr>
				<td style="padding-top: 40px; text-align:center;padding-bottom: 40px;"><a href="' . esc_url($dashboard_link) . '"><img src="' . ANALYTIFY_IMAGES_PATH . 'analytify_go_to_dashboard.png" alt="go to dashboard"  /></a></td>
			</tr>';
		}

		return $message;
	}

	/**
	 * Add pro reports in single post email message body.
	 *
	 * @return $message
	 */
	public function callback_wp_analytify_single_email($message, $selected_sections, $dates)
	{

		if (!is_array($selected_sections) || empty($selected_sections)) {
			return $message;
		}

		$post_id = sanitize_text_field(wp_unslash($_POST['post_id']));
		$post_url = get_the_permalink($post_id);
		$u_post = parse_url(urldecode($post_url));
		$filter = $u_post['path'];
		$filter = apply_filters('analytify_page_path_filter', $filter, $u_post);
		// Url have query string incase of WPML.
		if (isset($u_post['query'])) {
			$filter .= '?' . $u_post['query'];
		}

		$wp_analytify = $GLOBALS['WP_ANALYTIFY'];
		$ga_mode = method_exists('WPANALYTIFY_Utils', 'get_ga_mode') ? WPANALYTIFY_Utils::get_ga_mode() : 'ga3';

		// Geographic Stats.
		if (in_array('show-geographics', $selected_sections, true)) {
			if ('ga4' === $ga_mode) {
				$countries_stats = $wp_analytify->get_reports(
					'analytify-email-country-stats',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'country',
						'pagePath',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'country',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'pagePath',
								'match_type' => 1,
								'value' => $filter,
							),
						),
					),
					5 // This is for stats limit in email
				);

				$cities_stats = $wp_analytify->get_reports(
					'analytify-email-city-stats',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'city',
						'country',
						'pagePath',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'country',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'city',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'pagePath',
								'match_type' => 1,
								'value' => $filter,
							),
						),
					),
					5 // This is for stats limit in email
				);
				if (!function_exists('pa_geopgraphic_lisiting')) {
					include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/geographic.php';
				}
				$message .= pa_geopgraphic_lisiting($wp_analytify, $countries_stats, $cities_stats);
			}
		}

		// System stats.
		if (in_array('show-system', $selected_sections, true)) {
			if ('ga4' === $ga_mode) {
				$browser_stats = $wp_analytify->get_reports(
					'show-default-browser-dashboard',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'browser',
						'operatingSystem',
						'pagePath',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'operatingSystem',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'pagePath',
								'match_type' => 1,
								'value' => $filter,
							),
						),
					),
					5
				);

				$os_stats = $wp_analytify->get_reports(
					'show-default-os-dashboard',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'operatingSystem',
						'operatingSystemVersion',
						'pagePath',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'operatingSystemVersion',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'pagePath',
								'match_type' => 1,
								'value' => $filter,
							),
						),
					),
					5
				);

				$mobile_stats = $wp_analytify->get_reports(
					'show-default-mobile-dashboard',
					array(
						'sessions',
					),
					array(
						'start' => $dates['start_date'],
						'end' => $dates['end_date'],
					),
					array(
						'mobileDeviceBranding',
						'mobileDeviceModel',
						'pagePath',
					),
					array(
						'type' => 'metric',
						'name' => 'sessions',
						'order' => 'desc',
					),
					array(
						'logic' => 'AND',
						'filters' => array(
							array(
								'type' => 'dimension',
								'name' => 'deviceCategory',
								'match_type' => 4,
								'value' => 'desktop',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'mobileDeviceModel',
								'match_type' => 4,
								'value' => '(not set)',
								'not_expression' => true,
							),
							array(
								'type' => 'dimension',
								'name' => 'pagePath',
								'match_type' => 1,
								'value' => $filter,
							),
						),
					),
					5
				);

				if (!function_exists('pa_system_stats')) {
					include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/system-stats.php';
				}
				$message .= pa_system_stats($wp_analytify, $browser_stats, $os_stats, $mobile_stats);
			}
		}

		/*
		 * Keywords and/or refferals
		 *
		 */
		// check if the 'keywords' are set
		if ('ga4' === $ga_mode) {
			// TODO: add page URL check.
			$keyword_stats_raw = $wp_analytify->get_search_console_stats(
				'analytify-email-keyword-stats',
				array(
					'start' => $dates['start_date'],
					'end' => $dates['end_date'],
				),
				5
			);

			$keywords = false;
			if (isset($keyword_stats_raw['response']['rows']) && $keyword_stats_raw['response']['rows'] > 0) {
				$keywords = $keyword_stats_raw['response']['rows'];
			}

			$refferals = $wp_analytify->get_reports(
				'analytify-email-refferal-stats',
				array(
					'sessions',
				),
				array(
					'start' => $dates['start_date'],
					'end' => $dates['end_date'],
				),
				array(
					'sessionSource',
					'sessionMedium',
					'pagePath',
				),
				array(
					'type' => 'metric',
					'name' => 'sessions',
					'order' => 'desc',
				),
				array(
					'logic' => 'AND',
					'filters' => array(
						array(
							'type' => 'dimension',
							'name' => 'pagePath',
							'match_type' => 1,
							'value' => $filter,
						),
					),
				),
				5
			);

			if (!function_exists('pa_keyword_referral')) {
				include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/keyword-referral.php';
			}
			$message .= pa_keyword_referral($wp_analytify, $keywords, $refferals);
		}
		if (in_array('show-social', $selected_sections, true)) {

		if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {
			// GA4 Mode
			$social_stats_raw = $wp_analytify->get_reports(
				'analytify-email-social-media-stats',
				array(
					'sessions',
				),
				array(
					'start' => $dates['start_date'],
					'end' => $dates['end_date'],
				),
				array(
					'sessionSource',
				),
				array(
					'type' => 'metric',
					'name' => 'sessions',
					'order' => 'desc',
				),
				array(
					'logic' => 'AND',
					'filters' => array(
						array(
							'type' => 'dimension',
							'name' => 'sessionSource',
							'match_type' => 5,
							'value' => '^([a-z-]*\.|)(facebook|reddit|youtube|tumblr|quora|instagram|linkedin|yelp|wordpress|pinterest|twitter|t)(\.(com|org|co|)|)$',
							'not_expression' => false,
						),
					),
				),
				15 // You can adjust the limit as needed
			);

			if (!function_exists('social_stats')) {
				include ANALYTIFY_EMAIL_ADDON_ROOT_PATH . '/views/social-media.php';
			}
			$message .= social_stats($wp_analytify, $social_stats_raw);
		}
		}
		return $message;
	}

	/**
	 * Add Email settings in diagnostic logs.
	 */
	public function analytify_settings_logs()
	{
		echo "Analytify Email Setting:\r\n";

		$analytify_email = get_option('wp-analytify-email');
		print_r($analytify_email);

		echo "\r\n";
	}

	/**
	 * Configure backward compatibility for options tabele.
	 */
	public function backward_compatibility()
	{
		$_analytify_email = get_option('wp-analytify-email');

		if (empty($_analytify_email)) {
			$default['analytify_email_user_email'] = get_bloginfo('admin_email');
			$default['analytif_email_cron_time'] = array(
				'week' => 'Monday',
			);

			update_option('wp-analytify-email', $default);
		}
	}
}
