<?php
/**
 * Analytify Dashboard file.
 *
 * @package WP_Analytify
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$wp_analytify = $GLOBALS['WP_ANALYTIFY'];


$selected_stats = $wp_analytify->settings->get_option( 'show_analytics_panels_dashboard', 'wp-analytify-dashboard', array() );

//Get the start date and end date from wpa-core-functions
if ( function_exists( 'analytify_datepicker_dates' ) ) {
	extract( analytify_datepicker_dates() );
} else {
	$start_date = wp_date( 'Y-m-d', strtotime( '-1 month' ) );
	$end_date   = wp_date( 'Y-m-d', strtotime( 'now' ) );
}

$date1 = date_create( $start_date );
$date2 = date_create( $end_date );
$diff  = date_diff( $date2, $date1 );

$compare_start_date = strtotime( $start_date . $diff->format( '%R%a days' ) );
$compare_start_date = date( 'Y-m-d', $compare_start_date );
$compare_end_date   = $start_date;

$dashboard_profile_ID = $wp_analytify->settings->get_option( 'profile_for_dashboard', 'wp-analytify-profile' );
$fetch_fresh          = $wp_analytify->settings->get_option( 'delete_dashboard_cache', 'wp-analytify-dashboard' );

$acces_token = get_option( 'post_analytics_token' );

if ( ! $acces_token ) {
	return;
} else {
	if ( WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Analytify' ) ) {
		return; 
	}
}

// global $submenu;
// $analytify_submenus = $submenu['analytify-dashboard'];
// $analytify_dashboard_nav = [];
// foreach ( $submenu['analytify-dashboard'] as $key => $value) {
// 	# code...
// }

/*
* Check with roles assigned at dashboard settings.
*/
$is_access_level = $wp_analytify->settings->get_option( 'show_analytics_roles_dashboard', 'wp-analytify-dashboard' );

// Show dashboard to admin incase of empty access roles.
if ( empty( $is_access_level ) ) {
	$is_access_level = array( 'Administrator' ); 
}

$version = defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION;

if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {

	if ( $acces_token ) {
		// dequeue event calendar js
		wp_dequeue_script( 'tribe-common' ); ?>

		<div class="wpanalytify analytify-dashboard-nav">
			<div class="wpb_plugin_wraper">
				<div class="wpb_plugin_header_wraper">
					<div class="graph"></div>
						<div class="wpb_plugin_header">
							<div class="wpb_plugin_header_title"></div>
							<div class="wpb_plugin_header_info">
									<a href="https://analytify.io/changelog/" target="_blank" class="btn">View Changelog</a>
							</div>
							<div class="wpb_plugin_header_logo">
									<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg'?>" alt="Analytify">
							</div>
						</div>
					</div>
						
					<div class="analytify-dashboard-body-container">
						<div class="wpb_plugin_body_wraper">
								<div class="wpb_plugin_body">
									<div class="wpa-tab-wrapper">
									
										<?php 
											if ( method_exists( $GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation' ) ) {
												echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation();
										} ?>

									</div>
									<div class="wpb_plugin_tabs_content analytify-dashboard-content">
										<div class="analytify_wraper">
											<div class="analytify_main_title_section">
												<div class="analytify_dashboard_title">
													<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Goals (Key Events) Dashboard', 'wp-analytify' ); ?></h1>

													<span class="analytify_stats_of"><a href="<?php echo WP_ANALYTIFY_FUNCTIONS::search_profile_info( $dashboard_profile_ID, 'websiteUrl' ) ?>" target="_blank"><?php echo WP_ANALYTIFY_FUNCTIONS::search_profile_info( $dashboard_profile_ID, 'websiteUrl' ) ?></a> (<?php echo WP_ANALYTIFY_FUNCTIONS::search_profile_info( $dashboard_profile_ID, 'name' ) ?>)</span>

												</div>
												<div class="analytify_main_setting_bar">
													<div class="analytify_pull_right analytify_setting">
														<div class="analytify_select_date">

															<?php 
															if ( method_exists( 'WPANALYTIFY_Utils', 'date_form' )  ) {
																WPANALYTIFY_Utils::date_form( $start_date, $end_date );
															} ?>

														</div>
													</div>
												</div>
											</div>

										<?php
										function search_profile_info_( $id, $index ) {

											if ( ! get_option( 'pa_google_token' ) ) {
												return; }

											$accounts = WP_ANALYTIFY_FUNCTIONS::fetch_profiles_list_summary();

											if ( ! $accounts ) {
												return false;
											}

											foreach ( $accounts->getItems() as $account ) {
												foreach ( $account->getWebProperties() as  $property ) {
													foreach ( $property->getProfiles() as $profile ) {
														// Get Property ID i.e UA Code
														if ( $profile->getId() === $id && $index === 'webPropertyId' ) {
															return $property->getId();
														}

														// Get Property URL i.e analytify.io
														if ( $profile->getId() === $id && $index === 'websiteUrl' ) {
															return $property->getWebsiteUrl();
														}

														// Get Accoint Id for Goal List
														if ( $profile->getId() === $id && $index === 'accountid' ) {
															return $account->getId();
														}

														// Get Profile view i.e All website data
														if ( $profile->getId() === $id && $index === 'name' ) {
															return $profile->getName();
														}

														// Get Profile view i.e All website data
														if ( $profile->getId() === $id && $index === 'viewId' ) {
															return $profile->getId();
														}
													}
												}
											}
										}

										$ua_code    = WP_ANALYTIFY_FUNCTIONS::search_profile_info( $wp_analytify->settings->get_option( 'profile_for_dashboard', 'wp-analytify-profile' ), 'webPropertyId' );
										$profile_id = WP_ANALYTIFY_FUNCTIONS::search_profile_info( $wp_analytify->settings->get_option( 'profile_for_dashboard', 'wp-analytify-profile' ), 'accountId' );
										$viewId     = WP_ANALYTIFY_FUNCTIONS::search_profile_info( $wp_analytify->settings->get_option( 'profile_for_dashboard', 'wp-analytify-profile' ), 'viewId' );
										$_all_goals = array();

										// try {
										// 	$goals = $wp_analytify->service->management_goals->listManagementGoals( $profile_id, $ua_code, $viewId );

										// 	foreach ( $goals->getItems() as $index => $all_goals ) {

										// 		$_all_goals[ 'ga:goal' . (string) ( $index + 1 ) . 'Completions' ] = $all_goals->getName();

										// 	}
										// } catch ( apiServiceException $e ) {
										// 	// print 'There was an Analytics API service error '
										// 	// . $e->getCode() . ':' . $e->getMessage();
										// } catch ( apiException $e ) {
										// 	// print 'There was a general API error '
										// 	// . $e->getCode() . ':' . $e->getMessage();
										// } ?>

										<div class="analytify_goals_status_boxes">

											<?php
											if ( ! empty( $_all_goals ) ) {

												$analytics_query = 'ga:goalCompletionsAll,ga:goalValueAll,ga:goalConversionRateAll,ga:goalAbandonRateAll';
												$goals_stats     = $wp_analytify->pa_get_analytics_dashboard( $analytics_query, $start_date, $end_date, false, false, false, false, 'show-general-goal-stats' ); ?>

												<div class="analytify_general_status_boxes">
													<h4><?php esc_html_e( 'Goal Completions', 'wp-analytify' ); ?></h4>
													<div class="analytify_general_stats_value"><?php echo $goals_stats['totalsForAllResults']['ga:goalCompletionsAll']; ?></div>
													<p><?php esc_html_e( 'Total number of Goal Completions', 'wp-analytify' ); ?></p>
												</div>

													<div class="analytify_general_status_boxes">
														<h4><?php esc_html_e( 'Goal Value', 'wp-analytify' ); ?></h4>
														<div class="analytify_general_stats_value"><?php echo '$' . number_format_i18n( $goals_stats['totalsForAllResults']['ga:goalValueAll'] ); ?></div>
														<p><?php esc_html_e( 'Total number of Goal Value', 'wp-analytify' ); ?></p>
													</div>

													<div class="analytify_general_status_boxes">
														<h4><?php esc_html_e( 'Goal Conversion Rate', 'wp-analytify' ); ?></h4>
														<div class="analytify_general_stats_value"><?php echo round( $goals_stats['totalsForAllResults']['ga:goalConversionRateAll'], 2 ); ?>%</div>
														<p><?php esc_html_e( 'Total number of Goal Conversion Rate', 'wp-analytify' ); ?></p>
													</div>

													<div class="analytify_general_status_boxes">
														<h4><?php esc_html_e( 'Total Abandonment Rate', 'wp-analytify' ); ?></h4>
														<div class="analytify_general_stats_value"><?php echo round( $goals_stats['totalsForAllResults']['ga:goalAbandonRateAll'], 2 ); ?>%</div>
														<p><?php esc_html_e( 'Number of Total Abandonment Rate', 'wp-analytify' ); ?></p>
													</div>

													<?php
													// Divide the array by 10
													$goals_chunk = array_chunk( $_all_goals, 10, true );

													foreach ( $goals_chunk as $key => $goal ) {
														$_query				= implode( ',', array_keys( $goal ) );
														$goals_stats_inner	= $wp_analytify->pa_get_analytics_dashboard( $_query, $start_date, $end_date, false, false, false, false, 'show-goal-query-stats-'.uniqid() );

														foreach ( $goals_stats_inner['totalsForAllResults'] as $key => $value ) : ?>

															<div class="analytify_general_status_boxes">
																<h4><?php echo $goal[ $key ]; ?></h4>
																<div class="analytify_general_stats_value"><?php echo $value; ?></div>
																<p><?php esc_html_e( 'Total Completions of Goal', 'wp-analytify-goals' ); ?></p>
																<p style="padding-top: 10px;"><a href="<?php echo admin_url( 'admin.php?page=analytify-goals&goal_id=' . $key . '&sd=' . $start_date . '&ed=' . $end_date ); ?>"><?php esc_html_e( 'View More Details', 'wp-analytify-goals' ); ?></a></p>
															</div>

														<?php
														endforeach;
													} ?>

											<?php
											} else {
											echo '		<div class="analytify-email-premium-overlay">
														<div class="analytify-email-premium-popup">
															<h3 class="analytify-promo-popup-heading" style="text-align:left;">Unable To Fetch Reports</h3>
															<p class="analytify-promo-popup-paragraph analytify-error-popup-paragraph">Goals are not available in GA4</p><p class="analytify-promo-popup-paragraph analytify-error-popup-paragraph"><a href="https://analytify.io/doc/get-started-with-custom-dimensions-addon/" target="_blank">Click here to read our guide on goals</a></p>
														</div>
													</div>';
											} ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<?php
		} else {
			esc_html_e( 'You must be authenticated to see the Analytics Dashboard.', 'wp-analytify' );
		} // End if()
	} else {

		esc_html_e( 'You don\'t have access to Analytify Dashboard.', 'wp-analytify' );
	} // End if()

