<?php
$WP_Analytify  = $GLOBALS['WP_ANALYTIFY'];

//Get the start date and end date from wpa-core-functions
if ( function_exists( 'analytify_datepicker_dates' ) ) {
	extract( analytify_datepicker_dates() );
} else {
	$start_date = wp_date( 'Y-m-d', strtotime( '-1 month' ) );
	$end_date   = wp_date( 'Y-m-d', strtotime( 'now' ) );
}

$date1 = date_create( $start_date );
$date2 = date_create( $end_date );
$diff  = date_diff( $date2, $date1 );

$compare_start_date = strtotime( $start_date . $diff->format( '%R%a days' ) );
$compare_start_date = date( 'Y-m-d', $compare_start_date );
$compare_end_date  	= $start_date;

// Fetch Dashboard Profile ID.
$dashboard_profile_id = $WP_Analytify->settings->get_option( 'profile_for_dashboard','wp-analytify-profile' );
$dashboard_profile_id = method_exists( 'WPANALYTIFY_Utils', 'get_reporting_property' ) ? WPANALYTIFY_Utils::get_reporting_property() : $dashboard_profile_id;

// Remove cache if delete cache is enabled.
if ( 'on' === $WP_Analytify->settings->get_option( 'delete_dashboard_cache','wp-analytify-dashboard' ) ) {
  self::delete_woo_transients( $dashboard_profile_id, $start_date, $end_date );
}

$report_url			= WP_ANALYTIFY_FUNCTIONS::get_ga_report_url( $dashboard_profile_id ) ;
$report_date_range	= WP_ANALYTIFY_FUNCTIONS::get_ga_report_range( $start_date, $end_date, $compare_start_date, $compare_end_date );
$version			= defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION; 
$access_token		= get_option( "post_analytics_token" );
$_analytify_profile	= get_option( 'wp-analytify-profile' );
$is_access_level	= $WP_Analytify->settings->get_option( 'show_analytics_roles_dashboard', 'wp-analytify-dashboard' ); ?>

<div class="wpanalytify analytify-dashboard-nav">
	<div class="wpb_plugin_wraper">
		<div class="wpb_plugin_header_wraper">
			<div class="graph"></div>
				<div class="wpb_plugin_header">
					<div class="wpb_plugin_header_title"></div>
					<div class="wpb_plugin_header_info">
							<a href="https://analytify.io/changelog/" target="_blank" class="btn"><?php echo esc_html__( 'View Changelog', 'wp-analytify-woocommerce' ); ?></a>
					</div>
					<div class="wpb_plugin_header_logo">
							<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg'; ?>" alt="Analytify">
					</div>
				</div>
			</div>
					
			<div class="analytify-dashboard-body-container">
				<div class="wpb_plugin_body_wraper">
					<div class="wpb_plugin_body">
						<div class="wpa-tab-wrapper">
							<?php
							if ( method_exists( $GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation' ) ) {
								echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation();
							}
							?>
						</div>
						<div class="wpb_plugin_tabs_content analytify-dashboard-content">			

							<div class="analytify_wraper">
								<div class="analytify_main_title_section">
									<div class="analytify_dashboard_title">
										<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'WooCommerce Dashboard', 'wp-analytify-woocommerce' ); ?></h1>
										<?php
										$_analytify_profile = get_option( 'wp-analytify-profile' );
										if ( $access_token && method_exists( 'WPANALYTIFY_Utils', 'dashboard_subtitle_section' ) ) {
											echo WPANALYTIFY_Utils::dashboard_subtitle_section();
										}
										?>
									</div>

									<div class="analytify_main_setting_bar">
										<div class="analytify_pull_right analytify_setting">
											<div class="analytify_select_date">
												<?php
												if ( method_exists( 'WPANALYTIFY_Utils', 'date_form' ) ) {
													WPANALYTIFY_Utils::date_form( $start_date, $end_date );
												}
												?>
											</div>
										</div>
									</div>
									<!-- <div class="analytify_select_dashboard analytify_pull_right"><?php // do_action( 'analytify_dashboad_dropdown' ); ?></div> -->
								</div>
								<?php

								if ( ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection('WooCommerce') ) {

									/*
									 * Check with roles assigned at dashboard settings.
									 * 
									 */
									$is_access_level = $WP_Analytify->settings->get_option('show_analytics_roles_dashboard','wp-analytify-dashboard');

									if ( $WP_Analytify->pa_check_roles( $is_access_level ) ) {
										if ( $access_token ) {
											$famous = '';	
											?>

											<div class="analytify_status_body stats_loading">
												<div class="general-stats-report"></div>
											</div>

											<script>
											//<![CDATA[
											jQuery( function($) {
												$.ajax({
												url:  <?php echo wp_json_encode( esc_url_raw( rest_url( "wp-analytify/v1/get_pro_woo_report/$dashboard_profile_id/general-stats" ) ) ); ?>,
												data: {
													sd : '<?php echo $start_date; ?>',
													ed : '<?php echo $end_date; ?>',
												},
												beforeSend: function ( xhr ) {
													xhr.setRequestHeader('X-WP-Nonce', '<?php echo wp_create_nonce( 'wp_rest' ) ?>');
												},
												})
												.fail(function(data) {
													var _html = '<table class="analytify_data_tables analytify_no_header_table"><tbody><tr><td class="analytify_td_error_msg"><div class="analytify-stats-error-msg"><div class="wpb-error-box"><span class="blk"><span class="line"></span><span class="dot"></span></span><span class="information-txt">Something Unexpected Occurred.</span></div></div></td></tr></tbody></table>'
													$('.general-stats-report').html(_html).parent().removeClass("stats_loading");
												})
												.done(function(data) {
													//console.log(data);
													$(".general-stats-report").append(data.body).parent().removeClass("stats_loading");
													wp_analytify_paginated();
												}); 
											});
											//]]>
											</script>

											<div class="analytify_status_body stats_loading">
												<div class="country-performance-report"></div>
											</div>

											<script>
											//<![CDATA[
											jQuery( function($) {
												$.ajax({
												url:  <?php echo wp_json_encode( esc_url_raw( rest_url( "wp-analytify/v1/get_pro_woo_report/$dashboard_profile_id/country-performance" ) ) ); ?>,
												data: {
													sd : '<?php echo $start_date; ?>',
													ed : '<?php echo $end_date; ?>',
												},
												beforeSend: function ( xhr ) {
													xhr.setRequestHeader('X-WP-Nonce', '<?php echo wp_create_nonce( 'wp_rest' ) ?>');
												},
												})
												.fail(function(data) {
													var _html = '<table class="analytify_data_tables analytify_no_header_table"><tbody><tr><td class="analytify_td_error_msg"><div class="analytify-stats-error-msg"><div class="wpb-error-box"><span class="blk"><span class="line"></span><span class="dot"></span></span><span class="information-txt">Something Unexpected Occurred.</span></div></div></td></tr></tbody></table>'
													$('.country-performance-report').html(_html).parent().removeClass("stats_loading");
												})
												.done(function(data) {
													//console.log(data);
													$(".country-performance-report").append(data.body).parent().removeClass("stats_loading");
													wp_analytify_paginated();
												}); 
											});
											//]]>
											</script>

											<?php
											/**
											 * 
											 * ECharts Funnel.
											 * 
											 */

											if ( ! isset( $_GET['cn'] ) ) {
												if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
													$stats = $WP_Analytify->get_reports(
														'show-woo-product-funnel-chart',
														array(
															'itemsAddedToCart',
															'itemsPurchased',
															'itemsViewed',
														),
														array(
															'start' => $start_date,
															'end'   => $end_date,
														),
														array(
															'itemListName',
														),
														array(
															'type' => 'metric',
															'name' => 'itemsViewed',
															'order' => 'desc',
														),
														false,
														10
													);

													include WC_ANALYTIFY_PLUGIN_DIR . '/views/default/ecommerce-funnel.php';
													wpa_woocommerce_funnel_chart( $WP_Analytify, $stats );
											    }
											}


											if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
												$stats = $WP_Analytify->get_reports(
													'show-woo-roi-stats',
													array(
														'sessions',
														'bounceRate',
														// 'transactions', commented out due to incompatibility.
														'purchaseRevenue'
													),
													array(
														'start' => $start_date,
														'end'   => $end_date,
													),
													array(
														'sourceMedium',
														'currencyCode',
													),
													array(
														'type' => 'metric',
														'name' => 'purchaseRevenue',
													),
													array(),
													50
												);

												include WC_ANALYTIFY_PLUGIN_DIR . '/views/default/measuring-roi.php';
												wpa_woo_measuring_roi( $WP_Analytify, $stats, $report_url, $report_date_range );
											}

											// if campaigns stats than don't add.
											if ( ! isset( $_GET['cn'] ) ) {
												if ( method_exists( $WP_Analytify, 'get_reports' ) ) {
													$stats = $WP_Analytify->get_reports(
														'show-woo-product-performance-stats',
														array(
															'itemRevenue',
															// 'ecommercePurchases', commented out due to incompatibility.
															'itemPurchaseQuantity',
															'cartToViewRate',
															'purchaseToViewRate',
														),
														array(
															'start' => $start_date,
															'end'   => $end_date,
														),
														array(
															'itemName',
															'currencyCode',
														),
														array(
															'type'  => 'metric',
															'name'  => 'itemPurchaseQuantity',
															'order' => 'desc',
														),
														array(
															'logic'   => 'AND',
															'filters' => array(
																array(
																	'type'           => 'dimension',
																	'name'           => 'itemName',
																	'match_type'     => 4,
																	'value'          => '(not set)',
																	'not_expression' => true,
																),
															),
														),
														50
													);

													include WC_ANALYTIFY_PLUGIN_DIR . '/views/default/products-performance.php';
													wpa_wocommerce_products( $WP_Analytify, $stats, $report_url, $report_date_range );
												}
											}

											// if campaigns stats than don't add.
											if ( ! isset( $_GET['cn'] ) ) {
												if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
													$stats = $WP_Analytify->get_reports(
														'show-woo-product-list-stats',
														array(
															'itemListClickThroughRate',
															'itemRevenue',
															'itemsAddedToCart',
															'itemsCheckedOut',
															'itemsClickedInList',
															'itemsPurchased',
															'itemsViewedInList',
														),
														array(
															'start' => $start_date,
															'end'   => $end_date,
														),
														array(
															'itemListName',
															'currencyCode',
														),
														array(
															'type' => 'metric',
															'name' => 'itemRevenue',
															'order' => 'desc',
														),
														false,
														/*
														Commented out to show not set list name too.
														array(
															'logic'   => 'AND',
															'filters' => array(
																array(
																	'type'           => 'dimension',
																	'name'           => 'itemName',
																	'match_type'     => 4,
																	'value'          => '(not set)',
																	'not_expression' => true,
																),
															),
														),
														 */
														10
													);

													include WC_ANALYTIFY_PLUGIN_DIR . '/views/default/lists-performance.php';
													wpa_wocommerce_lists_performance( $WP_Analytify, $stats );
											}
											}

											// if campaigns stats than don't add.
											if ( ! isset( $_GET['cn'] ) ) {
												?>

												<div class="analytify_status_body stats_loading">
													<div class="categories-performance-report"></div>
												</div>

												<script>
												//<![CDATA[
												jQuery( function($) {
													$.ajax({
													url:  <?php echo wp_json_encode( esc_url_raw( rest_url( "wp-analytify/v1/get_pro_woo_report/$dashboard_profile_id/categories-performance" ) ) ); ?>,
													data: {
														sd : '<?php echo $start_date; ?>',
														ed : '<?php echo $end_date; ?>',
													},
													beforeSend: function ( xhr ) {
														xhr.setRequestHeader('X-WP-Nonce', '<?php echo wp_create_nonce( 'wp_rest' ) ?>');
													},
													})
													.fail(function(data) {
														var _html = '<table class="analytify_data_tables analytify_no_header_table"><tbody><tr><td class="analytify_td_error_msg"><div class="analytify-stats-error-msg"><div class="wpb-error-box"><span class="blk"><span class="line"></span><span class="dot"></span></span><span class="information-txt">Something Unexpected Occurred.</span></div></div></td></tr></tbody></table>'
														$('.categories-performance-report').html(_html).parent().removeClass("stats_loading");
													})
													.done(function(data) {
														//console.log(data);
														$(".categories-performance-report").append(data.body).parent().removeClass("stats_loading");
														wp_analytify_paginated();
														if (typeof enableWooAnalytifyTableSorting === 'function') { enableWooAnalytifyTableSorting(); }
													}); 
												});
												//]]>
												</script>

												<?php
											}

											if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
												$analytify_enhanced_coupon_filter = apply_filters( 'analytify_enhanced_coupon_filter', 'ga:orderCouponCode!=(not set)' );
												$stats = get_transient( md5( 'show-woo-coupons-analysis-stats' . $dashboard_profile_id . $start_date . $end_date . $analytify_enhanced_coupon_filter ) );

												$stats = $WP_Analytify->get_reports(
													'show-woo-coupons-analysis-stats',
													array(
														'purchaseRevenue',
														'transactions',
														// TODO: (missing_ga4) 'revenuePerTransaction',
													),
													array(
														'start' => $start_date,
														'end'   => $end_date,
													),
													array(
														'orderCoupon',
														'currencyCode',
													),
													array(
														'type' => 'dimension',
														'name' => 'orderCoupon',
														'order' => 'desc',
													),
													array(
														'logic'   => 'AND',
														'filters' => array(
															array(
																'type'           => 'dimension',
																'name'           => 'orderCoupon',
																'match_type'     => 4,
																'value'          => '(not set)',
																'not_expression' => true,
															),
														),
													),
													10
												);

												include WC_ANALYTIFY_PLUGIN_DIR . '/views/default/coupons.php';
												wpa_wocommerce_coupons_performance( $WP_Analytify, $stats );
											}
										} else {
											esc_html_e( 'You must be logged in to see the Analytics Dashboard.', 'wp-analytify-woocommerce' );
										}
									} else {
										esc_html_e( 'You don\'t have access to WooCommerce Dashboard.', 'wp-analytify-woocommerce' );
									} 
								}
								?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
