<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
$api_key = ANALYTIFY_DEV_KEY;
$url  = WP_ANALYTIFY_FUNCTIONS::ga_reporting_property_info( 'url' );

wp_add_inline_style( 'dummy-handle', '* { color: red; }' );
$nonce = wp_create_nonce('my_pagespeed_nonce');

?>
<style>
	
/* Dashboard speed analytics */

.header-page-speed{
    display: flex;
    column-gap: 15px;
}
.header-page-speed .view-toggle{
    display: flex;
}
.header-page-speed .view-toggle button{
    border: 1px solid #E0E0E0;
    width: 53px;
    height: 53px;
    vertical-align: middle;
    cursor: pointer;
	display: inline-flex;
	align-items: center;
	justify-content: center;
}
.header-page-speed .view-toggle button svg g{
    opacity: 1;
}
.header-page-speed .view-toggle button svg{
    opacity: .5;
}
.header-page-speed .view-toggle button svg path{
    fill: black;
}
.header-page-speed .view-toggle button:hover ,
.header-page-speed .view-toggle button.active{
    background: #448AFF;
    border-color: #448AFF;
}
.header-page-speed .view-toggle button:hover svg path,
.header-page-speed .view-toggle button.active svg path{
    fill: #fff;
}
.header-page-speed .view-toggle button.active svg{
    fill: #fff;
    opacity: 1;
}
.header-page-speed .run-button button[disabled]{
	cursor: wait;
	opacity: .5;
}
.header-page-speed  .run-button button{
    font-family: "Roboto", sans-serif;
font-size: 16px;
font-weight: 600;
line-height: 21.28px;
text-align: left;
    background: #444444;
    color: #fff;
    border: 0;
    padding: 14px 28px;
    border: 1px solid #444444;
    border-radius: 5px;
    cursor: pointer;

}
.header-page-speed  .run-button button:not([disabled]):hover{
    background: #fff;
    color: #444;
}
.analytify_speed_wrapper{
    display: flex;
    column-gap: 30px;
    align-items: flex-start;
}
.analytify_big_box{
    border: 1px solid #E0E0E0;
    padding: 35px;
    text-align: center;
    width: 30%;
}
.analytify_metrics_boxes{
    display: flex;
    flex-wrap: wrap;
    gap: 30px;
    align-items: flex-start;
	flex: 1;
}
.analytify_metrics_box{
    width: calc(50% - 15px);
    padding: 15px;
    border: 1px solid #E0E0E0
}
.analytify_pie{
    margin-bottom: 30px;
}
.analytify_pie #analytify_overallScore{
    font-family: Roboto;
font-size: 40px;
font-weight: 700;
line-height: 46.88px;
text-align: center;
color: #00C853;
width: 100px;

}
.analytify_pie #analytify_overallScore.yellow{
	color: #ec942c;
}
.analytify_pie #analytify_overallScore.red{
	color: #cc3300;
}
.analytify_pie:has(.yellow) .analytiyf_progress-ring__circle{
	stroke: #ec942c;
}
.analytify_pie:has(.red) .analytiyf_progress-ring__circle{
	stroke: #cc3300;
}
.analytify_pie span{
    font-family: "Roboto", sans-serif;
font-size: 12px;
font-weight: 600;
line-height: 15.96px;
text-align: center;

}
.analytify_big_box h5{
    font-family: "Roboto", sans-serif;
font-size: 18px;
font-weight: 600;
line-height: 23.94px;
color: #444444;
margin: 0 0 10px;
}
.analytify_big_box p{
    font-family: "Roboto", sans-serif;
font-size: 12px;
font-weight: 400;
line-height: 20px;
text-align: center;

}
.analytify_metrics_box div{
    font-family: "Roboto", sans-serif;
font-size: 14px;
font-weight: 400;
line-height: 18.62px;
text-align: left;
color: #444444;
    padding-left: 20px;

}

.analytify_metrics_box div span{
    font-family: "Roboto", sans-serif;
font-size: 30px;
font-weight: 400;
line-height: 39.9px;
text-align: left;
color: #008800;
display: block;
margin-top: 5px;

}
.analytify_speed_wrapper{
    margin-top: 22px;
}
.analytify_pie{
  
}
.analytify_improvementTips li{
    border: 1px solid #E3E6E9;
    margin: 0;
}
.analytify_improvementTips li h3{
    padding: 16px 40px 16px 42px;
    font-family: "Roboto", sans-serif;
	font-size: 14px;
	font-weight: 600;
	line-height: 18.62px;
	text-align: left;
	cursor: pointer;
	position: relative;
	width: 100%;
	float: none;
}
.analytify_improvementTips li h3:after{
	background-image: url('data:image/svg+xml;base64,Cjxzdmcgd2lkdGg9IjEyIiBoZWlnaHQ9IjgiIHZpZXdCb3g9IjAgMCAxMiA4IiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgo8cGF0aCBkPSJNNS40Njg3NSA3LjAzMTI1TDEuMjE4NzUgMi43ODEyNUMwLjkwNjI1IDIuNDY4NzUgMC45MDYyNSAyIDEuMjE4NzUgMS43MTg3NUwxLjkwNjI1IDFDMi4yMTg3NSAwLjcxODc1IDIuNjg3NSAwLjcxODc1IDIuOTY4NzUgMUw1Ljk2ODc1IDQuMDMxMjVMOSAxQzkuMjgxMjUgMC43MTg3NSA5Ljc1IDAuNzE4NzUgMTAuMDYyNSAxTDEwLjc1IDEuNzE4NzVDMTEuMDYyNSAyIDExLjA2MjUgMi40Njg3NSAxMC43NSAyLjc4MTI1TDYuNSA3LjAzMTI1QzYuMjE4NzUgNy4zMTI1IDUuNzUgNy4zMTI1IDUuNDY4NzUgNy4wMzEyNVoiIGZpbGw9IiM0NDQ0NDQiLz4KPC9zdmc+Cg==');
	width: 18px;
    height: 10px;
    position: absolute;
    top: 24px;
    right: 20px;
    content: '';
    background-size: contain;
    background-repeat: no-repeat;
    background-position: center;
}
.analytify_improvement-section .analytify_status_header h3{
	width: 100%;
}
.analytify_improvementTips li h3.analyfity-accordion-open:after{
	transform: rotate(180deg);
}
.analytify_improvementTips li + li{
    border-top: 0;
}
.analytify-device{
	height: 33px;
}
.analytify_faq_description{
        padding: 0 20px 16px;
    font-family: "Roboto", sans-serif;
    font-size: 14px;
    font-weight: 600;
    line-height: 18.62px;
    text-align: left;
}
.analytify_improvement-section{
    margin-top: 22px;
}
.analytify_improvement-section .analytify_status_header {
	margin-top: 20px;
}
.analytify_improvement-section  .analytify_status_header{
    border: 1px solid #e2e5e8;
    border-bottom: 0;
}
.analytify_status_box_wraper:has(.analytify_score-section){
    border-inline: 0;
}
.analytify_faq_description{
    display: none;
}
/* .wpb_plugin_tabs_content:has(.header-page-speed) {
    padding: 0;
    background: #fff;
} */
.analytify_improvementTips .analytify_info_stats{
    padding: 0;
    margin-right: 10px;
	position: absolute;
	left: 13px;
}
.analytify_improvementTips .analytify_info_stats:before{
    position: relative;
    display: inline-block;
    vertical-align: middle;
    width: 20px;
    height: 20px;
    background-size: contain;
}
.analytify_pie {
    position: relative;
    width: 160px;
    height: 160px;
    margin-inline: auto;
    display: flex;
    align-items: center;
    flex-direction: column;
    justify-content: center;
}
.analytify_pie svg{
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;
}
.analytify_metrics_box div{
    position: relative;
}
.analytify_metrics_box div:before{
    width: 9px;
    height: 9px;
    position: absolute;
    top: 6px;
    left: 0;
    content: '';
    background: #00C853;
	border-radius: 50%;
}
.analytify_metrics_box div:has(.red):before{
	background: none;
    width: 0;
    height: 0;
    border-left: 7px solid transparent;
    border-right: 7px solid transparent;
    border-bottom: 8px solid #C33300;
	border-radius: 0;
}
.analytify_metrics_box div:has(.orange):before{
   background: #ECA73F;
   border-radius: 0;

}
.analytify_metrics_box div:has(.red, .orange) span{
    color: #C33300;
}
.analytify_improvementTips p + p{
    margin-top: 10px;
}
.analytify_improvementTips p{
    font-weight: 400;
}
.analytify_improvementTips p a:hover{
	text-decoration: none;
}
.analytify_improvementTips li:has(p.skt-loading:only-child){
	padding: 15px 20px;
}
.analytiyf_progress-ring {
	position: relative;
	width: 159px;
	height: 159px;
}

.analytiyf_progress-ring__circle {
	fill: none;
	stroke: #00C853;
	stroke-width: 11.6154;
	transform: rotate(-90deg);
	transform-origin: 50% 50%;
	stroke-dasharray: 462.256; /* This is the circumference of the circle */
	stroke-dashoffset: 462.256; /* Start with full offset */
	transition: stroke-dashoffset 1s ease;
}

.analytiyf_progress-ring__background {
	fill: none;
	stroke: #E0F0E7;
	stroke-width: 11.6154;
}
.analytify-device>svg{
    position: static;
    width: auto;
    height: auto;
    opacity: .5;
}
.analytify-device g{
    opacity: 1;
}
.analytify-device>svg>path{
    fill: #000;
}
.analytify-dashboard-body-container .wpb_plugin_body_wraper .analytify-dashboard-content:has(.analytify_speed_wrapper){
    background: #fff;
}
.analytify_score-section .analytify_status_header{
    border: 1px solid #e2e5e8;
}
.analytify_displayValue{
	font-weight: 400;
}
.analytify_improvementTips li h3:before{
    content: '';
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: #4caf50;
    position: absolute;
    top: 19px;
    left: 20px;
}
.analytify_improvementTips li.orange h3:before{
    border-radius: 0;
    background: #fa3;
}
.analytify_improvementTips li.red h3:before{
    width: 0; 
  height: 0; 
  border-left: 7px solid transparent;
  border-right: 7px solid transparent;
  
  border-bottom: 10px solid #f33;
    background: transparent;
    border-radius: 0;
    top: 20px;
}
.analytify_improvementTips{
	display: flex;
	flex-direction: column;
}
.analytify_improvementTips li.red{
	order: -2;
}
.analytify_improvementTips li.orange{
	order: -1;
}
@media (max-width: 1100px){
    .analytify_big_box{
        width: 40%;
    }
    .analytify_metrics_box{
        width: 100%;
    }
}
@media (max-width: 970px) {
	.analytify_speed_wrapper{
		flex-direction: column;
		gap: 20px;
	}
	div.analytify_big_box{
	max-width: 400px;
	margin: 0 auto;
	width: 100%;
	padding: 30px 15px;
	}
	.analytify_metrics_box {
		width: calc(50% - 10px);
		padding: 15px;
		border: 1px solid #E0E0E0;
	}
	.analytify_metrics_boxes{
		gap: 20px
	}
}
@media (max-width: 480px) {
	.analytify_metrics_box{width: 100%;}
}
</style>
<div class="analytify_general_status analytify_status_box_wraper">
    <!-- Header section for view toggle and run button -->
    

    <!-- Section for PageSpeed Insights Score and metrics -->
    <div class="analytify_score-section">
	<div class="analytify_status_header analytify_header_adj">
		<h3>PageSpeed Insights</h3>
	</div>
	<div class="analytify_speed_wrapper">
	<div class="analytify_big_box">
		<div class="analytify_pie">
		<svg class="analytiyf_progress-ring" width="159" height="159">
			<circle class="analytiyf_progress-ring__background" cx="79.5" cy="79.5" r="73.6923"></circle>
			<circle class="analytiyf_progress-ring__circle animate-analytiyf_progress" cx="79.5" cy="79.5" r="73.6923"></circle>
		</svg>
			<div class="analytify-device">
			<svg width="25" height="20" viewBox="0 0 25 20" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" clip-rule="evenodd" d="M22.7807 0.427673H1.313C0.616629 0.427673 0.046875 0.997483 0.046875 1.69386V14.3625C0.046875 15.0589 0.616629 15.6287 1.313 15.6287H22.7807C23.4772 15.6287 24.0469 15.0589 24.0469 14.3625V1.69386C24.0469 0.997483 23.4772 0.427673 22.7807 0.427673ZM22.4398 2.03484H1.65399V14.0215H22.4398V2.03484Z" fill="#F7FFFF"></path>
				<path fill-rule="evenodd" clip-rule="evenodd" d="M14.4815 15.3608H9.61057C9.57275 16.8759 8.9669 18.7342 7.77734 19.5723H16.3147C15.1252 18.7342 14.5193 16.8759 14.4815 15.3608Z" fill="#F7FFFF"></path>
			</svg>
			</div>
			<div id="analytify_overallScore"><p class="skt-loading"></p></div>
			<span>Overall Score:</span>
		</div>
		<h5>Performance</h5>
		<p>Values are estimated and may vary. The <a target="_blank" href="https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/?utm_source=lighthouse&utm_medium=lr">performance score is calculated</a> directly from these metrics. <a target="_blank" href="https://googlechrome.github.io/lighthouse/scorecalc/#FCP=4085&LCP=8401&TBT=6178&CLS=0.01&SI=10300&TTI=27745&device=mobile&version=12.2.1">See calculator.</a></p>
	</div>
	<div class="analytify_metrics_boxes">
		<div class="analytify_metrics_box">
        	<div>Server Response Time: <br><span id="serverResponseTime"><p class="skt-loading"></p></span></div>
		</div>
		<div class="analytify_metrics_box">
        	<div>First Contentful Paint: <br><span id="firstContentfulPaint"><p class="skt-loading"></p></span></div>
		</div>
		<div class="analytify_metrics_box">
        	<div>Total Blocking Time: <br><span id="totalBlockingTime"><p class="skt-loading"></p></span></div>
		</div>
		<div class="analytify_metrics_box">
        	<div>Time to Interactive: <br><span id="timeToInteractive"><p class="skt-loading"></p></span></div>
		</div>
		<!-- console.log("Largest Contentful Paint: ", data.audits['largest-contentful-paint']?.displayValue);
    console.log("Speed Index: ", data.audits['speed-index']?.displayValue);
    console.log("Cumulative Layout Shift: ", data.audits['cumulative-layout-shift']?.displayValue); -->
		<div class="analytify_metrics_box">
        	<div>Largest Contentful Paint: <br><span id="largest-contentful-paint"><p class="skt-loading"></p></span></div>
		</div>
		<div class="analytify_metrics_box">
        	<div>Speed Index: <br><span id="speed-index"><p class="skt-loading"></p></span></div>
		</div>
		<div class="analytify_metrics_box">
        	<div>Cumulative Layout Shift: <br><span id="cumulative-layout-shift"><p class="skt-loading"></p></span></div>
		</div>
	</div>
	</div>
        <!-- <br>
        <h1 id="overallScore">Overall Score: Loading...</h1>
        <h3>Key Metrics:</h3>
        <p id="serverResponseTime">Server Response Time: Loading...</p>
        <p id="firstContentfulPaint">First Contentful Paint: Loading... </p>
        <p id="totalBlockingTime">Total Blocking Time: Loading...</p>
        <p id="timeToInteractive">Time to Interactive: Loading...</p> -->
    </div>

    <!-- Section for How to Improve -->
    <div class="analytify_improvement-section">
	<div class="analytify_status_header analytify_header_adj">
		<h3>How to Improve</h3>
	</div>
        <ul id="analytify_improvementTips" class="analytify_improvementTips">
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
        </ul>
        <div class="analytify_status_header analytify_header_adj">
		    <h3>Passed Audits</h3>
	    </div>
        <ul id="passedAudits" class="analytify_improvementTips">
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
            <li><p class="skt-loading"></p></li>
		</ul> <!-- Passed Audits Section -->
            
    </div>
</div>

<script>
let selectedView = 'desktop'; // default view
let mobileData = null;
let desktopData = null;

function run() {
    fetchDataForView('desktop').then(data => {
        desktopData = data;
        if (selectedView === 'desktop') {
            displayData(desktopData);
        }
    });

    fetchDataForView('mobile').then(data => {
        mobileData = data;
        if (selectedView === 'mobile') {
            displayData(mobileData);
        }
    });
}

function switchView(view, event) {
    // Get the clicked button element
    const clickedButton = event.currentTarget;

    // Get the SVG inside the button
    const svg = clickedButton.querySelector('svg');

    // Clone the SVG to insert it into a different element
    const clonedSvg = svg.cloneNode(true);

    // Clear any existing content inside the .analytify-device element
    const targetElement = document.querySelector('.analytify-device');
    targetElement.innerHTML = ''; // Clear previous content

    // Append the cloned SVG to the .analytify-device element
    targetElement.appendChild(clonedSvg);

    selectedView = view;

    // Toggle the active class based on the view
    const mobileView = document.getElementById('mobileView');
    const desktopView = document.getElementById('desktopView');

    if (view === 'mobile') {
        mobileView.classList.add('active');
        desktopView.classList.remove('active');
    } else if (view === 'desktop') {
        desktopView.classList.add('active');
        mobileView.classList.remove('active');
    }

    if (view === 'mobile' && mobileData) {
        displayData(mobileData);
    } else if (view === 'desktop' && desktopData) {
        displayData(desktopData);
    }
}

function fetchDataForView(view) {
    const buttonElement = document.getElementById('runButton'); // Change this to your specific element ID or selector

    // Add the 'disabled' class
    buttonElement.setAttribute('disabled', true);

    jQuery('.analytify_metrics_box div span,#analytify_overallScore').html('<p class="skt-loading"></p>');
    jQuery('.analytify_improvementTips').html(`
        <li><p class="skt-loading"></p></li>
        <li><p class="skt-loading"></p></li>
        <li><p class="skt-loading"></p></li>
        <li><p class="skt-loading"></p></li>
        <li><p class="skt-loading"></p></li>
    `);

    const url = setUpQuery(view);
    return fetch(url)
        .then(response => {
            buttonElement.removeAttribute('disabled');

            if (!response.ok) {
                throw new Error('Network response was not ok');
            }

            return response.json();
        })
        .then(json => {
            return json.lighthouseResult;
        })
        .catch(error => {
            console.error('Error fetching PageSpeed Insights data:', error);
            buttonElement.removeAttribute('disabled');
            return null;
        });
}

function setUpQuery(view) {
    const api = 'https://www.googleapis.com/pagespeedonline/v5/runPagespeed';
    const parameters = {
        key: '<?php echo esc_attr($api_key); ?>', 
        url: encodeURIComponent('<?php echo esc_url($url); ?>'),
        strategy: view, // 'mobile' or 'desktop'
        nonce: '<?php echo esc_attr($nonce); ?>'
    };

    let query = `${api}?`;
    for (let key in parameters) {
        query += `${key}=${parameters[key]}&`;
    }
    return query.slice(0, -1); // Remove the trailing '&'
}

function displayData(data) {
    if (!data) return;

    const score = data.categories['performance'].score;

    // Update the SVG ring progress
    function setanalytiyf_Progress(element) {
        const circle = element.querySelector('.analytiyf_progress-ring__circle');
        const radius = circle.r.baseVal.value;
        const circumference = 2 * Math.PI * radius;
        const analytiyf_progress = score * 100;
        const offset = circumference - (analytiyf_progress / 100) * circumference;
        circle.style.strokeDasharray = circumference;
        circle.style.strokeDashoffset = offset;
    }

    const analytiyf_progressRing = document.querySelector('.analytiyf_progress-ring');
    setanalytiyf_Progress(analytiyf_progressRing);

    const overallScoreElement = document.getElementById('analytify_overallScore');
    overallScoreElement.textContent = `${(score * 100).toFixed(0)}`;

    overallScoreElement.classList.remove('red', 'yellow', 'green');
    if (score * 100 < 50) {
        overallScoreElement.classList.add('red');
    } else if (score * 100 >= 50 && score * 100 < 90) {
        overallScoreElement.classList.add('yellow');
    } else {
        overallScoreElement.classList.add('green');
    }
	var serverResponseTime = data.audits['server-response-time']?.displayValue;

    // Update and color-code key metrics
    updateMetricColor('serverResponseTime', serverResponseTime.replace('Root document took', ''), 200, 600);
    updateMetricColor('firstContentfulPaint', data.audits['first-contentful-paint']?.displayValue, 1.8, 3);
    updateMetricColor('totalBlockingTime', data.audits['total-blocking-time']?.displayValue, 200, 600);
    updateMetricColor('timeToInteractive', data.audits['interactive']?.displayValue, 3.8, 7.3);
    updateMetricColor('largest-contentful-paint', data.audits['largest-contentful-paint']?.displayValue, 3.8, 7.3);
    updateMetricColor('speed-index', data.audits['speed-index']?.displayValue, 3.8, 7.3);
    updateMetricColor('cumulative-layout-shift', data.audits['cumulative-layout-shift']?.displayValue, 3.8, 7.3);

    // Display improvement suggestions
    showImprovementSuggestions(data.audits);
}

// Function to update the text and color coding for a metric
function updateMetricColor(elementId, value, greenThreshold, yellowThreshold) {
    const element = document.getElementById(elementId);
    
    if (!value) {
        element.textContent = "Not Available";
        element.classList.remove('red', 'yellow', 'green');
        return;
    }

    element.textContent = value;

    element.classList.remove('red', 'yellow', 'green');

    const numericValue = parseFloat(value.replace(/[^0-9.]/g, ''));
    if (numericValue < greenThreshold) {
        element.classList.add('green');
    } else if (numericValue >= greenThreshold && numericValue <= yellowThreshold) {
        element.classList.add('yellow');
    } else {
        element.classList.add('red');
    }
}

function showImprovementSuggestions(audits) {
    const improvementSection = document.getElementById('analytify_improvementTips');
    const passedAuditsSection = document.getElementById('passedAudits');

    improvementSection.innerHTML = '';  // Clear existing improvements
    passedAuditsSection.innerHTML = '';  // Clear passed audits

    const allAudits = Object.values(audits);
    const improvements = allAudits.filter(audit => audit.details && audit.details.type === 'opportunity');
    const passedAudits = allAudits.filter(audit => audit.score === 1);

    // Sort improvements by savings (first by ms, then by KiB)
    improvements.sort((a, b) => {
        const savingsA = a.details.overallSavingsMs || 0;
        const savingsBytesA = a.details.overallSavingsBytes || 0;
        const savingsKiBA = savingsBytesA / 1024;

        const savingsB = b.details.overallSavingsMs || 0;
        const savingsBytesB = b.details.overallSavingsBytes || 0;
        const savingsKiBB = savingsBytesB / 1024;

        // Sorting by ms first, then KiB, with red class audits prioritized at the top
        if (savingsA > savingsB) return -1;
        if (savingsA < savingsB) return 1;
        return savingsKiBA > savingsKiBB ? -1 : 1;
    });

    // Function to render audit descriptions and savings
    function renderAudit(audit, section) {
        const li = document.createElement('li');
        const savingsMs = audit.details.overallSavingsMs || 0;  // Savings in milliseconds
        const savingsBytes = audit.details.overallSavingsBytes || 0; // Savings in bytes
        const savingsKiB = savingsBytes > 0 ? (savingsBytes / 1024).toFixed(2) : 0; // Convert bytes to kilobytes (KiB)

        // Determine the class based on both potential savings in ms and KiB
        let savingsClass = '';
        
        // Check both ms and KiB, prioritizing higher savings class
        if (savingsMs > 1000 || savingsKiB > 10) {  // High savings
            savingsClass = 'red';
        } else if (savingsMs > 500 || (savingsKiB > 1 && savingsKiB <= 10)) {  // Medium savings
            savingsClass = 'orange';
        } else if (savingsMs < 1 || savingsKiB <= 1) {  // Low savings
            savingsClass = 'green';
        }

        li.classList.add(savingsClass); // Add the determined class

        li.innerHTML = `
            <h3>${audit.title}${audit.displayValue ? '<span class="analytify_displayValue"> — ' + audit.displayValue + '</span>' : ''}</h3>
            <div class="analytify_faq_description">
                <p>${convertMarkdownLinks(audit.description)}</p>
                <p>Estimated Savings: ${savingsMs ? savingsMs + ' ms' : ''}${savingsKiB ? ' / ' + savingsKiB + ' KiB' : ''}</p>
                <p><strong>Recommendation:</strong> Consider reducing the time spent parsing, compiling, and executing JavaScript. 
                You may find delivering smaller JS payloads helps with this. 
                <a href="https://developers.google.com/web/fundamentals/performance/optimizing-javascript" target="_blank">Learn how to reduce JavaScript execution time.</a></p>
            </div>
        `;

        
		if(audit.displayValue){
			section.appendChild(li);
		}else{
			passedAuditsSection.appendChild(li);
		}
    }

    // Display improvements (sorted by savings)
    improvements.forEach(audit => {
        renderAudit(audit, improvementSection);
    });

    // Display passed audits (which have no significant issues)
    passedAudits.forEach(audit => {
        const li = document.createElement('li');
        li.innerHTML = `
            <h3>${audit.title}${audit.displayValue ? '<span class="analytify_displayValue"> — ' + audit.displayValue + '</span>' : ''}</h3>
            <div class="analytify_faq_description">
                <p>${convertMarkdownLinks(audit.description)}</p>
            </div>
        `;
		if(audit.displayValue){
			improvementSection.appendChild(li);
		}else{
			passedAuditsSection.appendChild(li);
		}
    });
}

function convertMarkdownLinks(text) {
    const markdownLinkRegex = /\[([^\]]+)\]\((https?:\/\/[^\)]+)\)/g;
    return text.replace(markdownLinkRegex, '<a href="$2" target="_blank">$1</a>');
}




// Fetch data for both views when page loads
run();
jQuery(document).ready(function ($) {
	$(document).on('click','.analytify_improvementTips h3', function (e) { 
		$(this).toggleClass('analyfity-accordion-open').parent().siblings().find('h3').removeClass('analyfity-accordion-open');
		$(this).next().slideToggle().parent().siblings().find('.analytify_faq_description').slideUp();
	});
});
</script>
