<?php
/**
 * Analytify Dashboard file.
 *
 * @package WP_Analytify
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wp_analytify   = $GLOBALS['WP_ANALYTIFY'];
$selected_stats = $wp_analytify->settings->get_option( 'show_analytics_panels_dashboard', 'wp-analytify-dashboard', array() );

$dashboard_profile_id = WPANALYTIFY_Utils::get_reporting_property();
$access_token         = get_option( 'post_analytics_token' );
$version              = defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION;

//Get the start date and end date from wpa-core-functions
extract( analytify_datepicker_dates() );

// Get compare dates for legacy version (before v5.0.0).
$date_diff          = WPANALYTIFY_Utils::calculate_date_diff( $start_date, $end_date );
$compare_start_date = $date_diff['start_date'];
$compare_end_date   = $date_diff['end_date'];

/**
 * To be used by the 'view stats' on GA's website link.
 * Date range is for legacy support, 5.0.0 or later will use date generated by JS.
 */
$report_url        = WP_ANALYTIFY_FUNCTIONS::get_ga_report_url( $dashboard_profile_id );
$report_date_range = WP_ANALYTIFY_FUNCTIONS::get_ga_report_range( $start_date, $end_date, $compare_start_date, $compare_end_date );
?>
<div class="wpanalytify analytify-dashboard-nav">
	<div class="wpb_plugin_wraper">
		<div class="wpb_plugin_header_wraper">
			<div class="graph"></div>
			<div class="wpb_plugin_header">
				<div class="wpb_plugin_header_title"></div>
				<div class="wpb_plugin_header_info">
					<a href="https://analytify.io/changelog/?utm-source=main-dashboard" target="_blank" class="btn"><?php echo esc_html__( 'View Changelog', 'wp-analytify' ); ?></a>
				</div>
				<div class="wpb_plugin_header_logo">
					<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg'?>" alt="Analytify">
				</div>
			</div>
		</div>

		<div class="analytify-dashboard-body-container">
			<div class="wpb_plugin_body_wraper">
				<div class="wpb_plugin_body">
					<div class="wpa-tab-wrapper"><?php echo $wp_analytify->dashboard_navigation(); ?></div>
					<div class="wpb_plugin_tabs_content analytify-dashboard-content">
						<div class="analytify_wraper <?php echo esc_attr( implode( ' ', $selected_stats ) ); ?>">
							<div class="analytify_main_title_section">
								<div class="analytify_dashboard_title">
									<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Overview Dashboard', 'wp-analytify' ); ?> <?php if (class_exists('WP_Analytify_Pro_Base') && isset($_GET['page']) && $_GET['page'] === 'analytify-dashboard' && count($_GET) === 1) { ?>
										<button name="generate_dashboard_pdf" 
											class="analytify_export_pdf_btn analytify_tooltip"
											data-tooltip="<?php _e('Export PDF Report', 'wp-analytify') ?>">
										<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/pdf-btn.png' ?>" 
											class="analytify_pdf_logo" 
											alt="<?php _e('Export PDF Report', 'wp-analytify') ?>" />
										</button>
									<?php } ?></h1>
									<?php WPANALYTIFY_Utils::dashboard_subtitle_section(); ?>
									
								</div>							
								<div class="analytify_main_setting_bar">
									<div class="analytify_pull_right analytify_setting">
										<div class="analytify_select_date">
											<?php WPANALYTIFY_Utils::date_form( $start_date, $end_date ); ?>
										</div>
									</div>
								</div>
							</div>

							<?php
							//Show notice if the user is using UA or has'nt selected any property yet.
							if ( WP_ANALYTIFY_FUNCTIONS::wpa_check_ga_version() && ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Analytify' ) ) {
								/*
								* Check with roles assigned at dashboard settings.
								*/
								$is_access_level = $wp_analytify->settings->get_option( 'show_analytics_roles_dashboard', 'wp-analytify-dashboard' );

								// Show dashboard to admin incase of empty access roles.
								if ( empty( $is_access_level ) ) { $is_access_level = array( 'administrator' ); }

								if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
									if ( $access_token ) {

										// 'Compare Chart' section added by the Pro version.
										if ( in_array( 'show-compare-stats', $selected_stats, true ) ) {
											/**
											 * All 4 dates are for Pro versions that are older then v5.0.0.
											 * Version 5.0.0 and above will use dates via AJAX.
											 */
											do_action( 'wp_analytify_view_compare_stats', $start_date, $end_date, $compare_start_date, $compare_end_date );
										}

										// 'General Stats' section.
										if ( in_array( 'show-overall-dashboard', $selected_stats, true ) ) {
											?>
											<div class="analytify_general_status analytify_section_general_stats analytify_status_box_wraper" data-endpoint="general-stats" data-target=".analytify_section_general_stats">
												<div class="analytify_status_header">
													<h3><?php esc_html_e( 'General Statistics', 'wp-analytify' ); ?>
													<?php if ( class_exists( 'WP_Analytify_Pro_Base' ) ) { ?>
														<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="general-stats">
															<span class="analytify_tooltiptext"><?php esc_html_e( 'Export General Stats', 'wp-analytify' ); ?></span>
														</a>
														<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
													<?php } ?>
													</h3>
												</div>
												<div class="analytify_status_body">
													<div class="analytify_general_status_boxes_wraper stats-wrapper"></div>
												</div>
												<div class="analytify_stats_loading analytify_general_status_boxes_wraper">
													<?php for ( $i = 0; $i < 9; $i++ ) { ?>
													<div class="analytify_general_status_boxes">
														<p class="skt-loading loading-width-sm inline"></p>
														<div>
															<p class="skt-loading loading-width-lg inline large"></p>
														</div>
														<p class="skt-loading"></p>
														<p class="skt-loading"></p>
														<div class="analytify_general_status_footer_info">
															<p class="skt-loading light-gray"></p>
														</div>
													</div>
													<?php } ?>
												</div>
											</div>
											<?php
										}

										// 'Top Pages' section.
										if ( in_array( 'show-top-pages-dashboard', $selected_stats, true ) ) {
											?>
											<div class="analytify_general_status analytify_section_top_pages analytify_status_box_wraper" data-endpoint="top-pages-stats" data-target=".analytify_section_top_pages">
												<div class="analytify_status_header">
													<h3>
														<?php esc_html_e( 'Top pages by views', 'wp-analytify' ); ?>
														<a href="javascript: return false;" data-ga-dashboard-link="<?php echo WPANALYTIFY_Utils::get_all_stats_link( $report_url, 'top_pages', false ); ?>" target="_blank" class="analytify_tooltip"><span class="analytify_tooltiptext"><?php _e( 'View All Top Pages', 'wp-analytify' ); ?></span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>
														<?php do_action( 'analytify_after_top_page_text' ); ?>
													</h3>
													<div class="analytify_top_page_detials analytify_tp_btn"></div>
												</div>
												<div class="analytify_status_body">
													<div class="analytify_top_pages_boxes_wraper stats-wrapper"></div>
												</div>
												<div class="analytify_stats_loading">
													<table class="analytify_data_tables">
														<thead>
															<tr>
																<th class="analytify_num_row"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
															</tr>
														</thead>
														<tbody>
															<?php for ( $i = 0; $i < 5; $i++ ) { ?>
															<tr>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																<td><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
															</tr>
															<?php } ?>
														</tbody>
													</table>
												</div>
											</div>
											<?php
										}

										// 'Geographic' section.
										if ( in_array( 'show-geographic-dashboard', $selected_stats, true ) ) {
											?>
											<div class="analytify_general_status analytify_section_geo_stats analytify_status_box_wraper" data-endpoint="geographic-stats" data-target=".analytify_section_geo_stats">
												<div class="analytify_status_header">
													<h3><?php esc_html_e( 'Geographic Stats', 'wp-analytify' ); ?></h3>
												</div>
												<div class="analytify_status_body">
													<div class="analytify_geographic_stats_boxes_wraper stats-wrapper"></div>
												</div>
												<div class="analytify_stats_loading">
													<div class="analytify_clearfix">
														<?php for ( $i = 0; $i < 2; $i++ ) { ?>
														<table class="analytify_data_tables analytify_half analytify_pull_left">
															<thead>
																<tr>
																	<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
																	<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
																</tr>
															</thead>
															<tbody>
																<?php for ( $k = 0; $k < 5; $k++ ) { ?>
																<tr>
																	<td><p class="skt-loading"></p></td>
																	<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																</tr>
																<?php } ?>
															</tbody>
														</table>
														<?php } ?>
													</div>
												</div>
											</div>
											<?php
										}

										// 'System' section.
										if ( in_array( 'show-system-stats', $selected_stats, true ) ) {
											?>
											<div class="analytify_general_status analytify_section_system_stats analytify_status_box_wraper" data-endpoint="system-stats" data-target=".analytify_section_system_stats">
												<div class="analytify_status_header">
													<h3><?php esc_html_e( 'System Stats', 'wp-analytify' ); ?></h3>
												</div>
												<div class="analytify_status_body">
													<div class="analytify_system_stats_boxes_wraper stats-wrapper"></div>
												</div>
												<div class="analytify_stats_loading">
													<div class="analytify_clearfix">
														<?php for ( $i = 0; $i < 3; $i++ ) { ?>
														<div class="analytify_one_tree_table">
															<table class="analytify_data_tables">
																<thead>
																	<tr>
																		<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
																		<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
																	</tr>
																</thead>
																<tbody>
																	<?php for ( $k = 0; $k < 5; $k++ ) { ?>
																	<tr>
																		<td><p class="skt-loading"></p></td>
																		<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																	</tr>
																	<?php } ?>
																</tbody>
															</table>
														</div>
														<?php } ?>
													</div>
												</div>
											</div>
											<?php
										}

										// Free vs Pro comparison gif
										if ( ! class_exists( 'WP_Analytify_Pro' ) && 'yes' !== get_option( 'analytify_remove_comparison_gif' ) ) {
											?>
											<div class="analytify_general_status analytify_general_status-gif">
												<span class="dashicons dashicons-no-alt analytify_general_status-icon"><?php _e( 'Dismiss', 'wp-analytify' ); ?></span>
												<a href="https://analytify.io/pricing?utm_source=analytify-lite&utm_medium=overview-dashboard&utm_campaign=pro-upgrade&utm_content=Upgrade-Banner-CTA" class="analytify_block" target="_blank">
													<img src="<?php echo plugins_url( '../assets/img/analytify_compare.gif', __FILE__ ); ?>" alt="<?php _e( 'Upgrade to Pro', 'wp-analytify' ); ?>" style="width:100%">
												</a>
												<a href="https://analytify.io/pricing?utm_source=analytify-lite&utm_medium=overview-dashboard&utm_campaign=pro-upgrade&utm_content=Upgrade-Banner-CTA" class="analytify_go_pro_overlay" target="_blank">
													<span class="analytify_go_pro_overlay_inner">
														<span class="analytify_h2"><?php _e( 'Premium feature', 'wp-analytify' ); ?></span>
														<span class="analytify_btn" target="_blank"><?php _e( 'Upgrade Now', 'wp-analytify' ); ?></span>
													</span>
												</a>
											</div>
											<?php
										}

										/*if ( 'ga4' === WPANALYTIFY_Utils::get_ga_mode()  ) { ?><div class="analytify_column"><div class="analytify_half analytify_left_flow"><?php }*/

										// 'Keywords' section.
										if ( in_array( 'show-keywords-dashboard', $selected_stats, true ) ) {
											?>
											<div class="analytify_general_status analytify_section_keywords_stats analytify_status_box_wraper" data-endpoint="keyword-stats" data-target=".analytify_section_keywords_stats">
												<div class="analytify_status_header analytify_header_adj">
													<h3>
														<?php
														esc_html_e( 'Keywords (How People Are Finding Your Website)', 'wp-analytify' );
														do_action( 'analytify_after_top_keyword_text' );
														?>
													</h3>
													<div class="analytify_status_header_value keywords_total empty-on-loading title-total-wrapper"></div>
													<div class="analytify_top_keywords_detials analytify_tp_btn"></div>
												</div>
												<div class="analytify_status_body">
													<div class="analytify_keyword_stats_boxes_wraper stats-wrapper"></div>
												</div>
												<div class="analytify_stats_loading">
													<table class="analytify_data_tables">
														<thead>
															<tr>
															<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
															<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
															</tr>
														</thead>
														<tbody>
															<?php for ( $i = 0; $i < 5; $i++ ) { ?>
															<tr>
																<td><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
															</tr>
															<?php } ?>
														</tbody>
													</table>
												</div>
											</div>
											<?php
										}

										//if ( 'ga3' === WPANALYTIFY_Utils::get_ga_mode() && in_array( 'show-social-dashboard', $selected_stats, true ) ) {
										if ( in_array( 'show-social-dashboard', $selected_stats, true ) ) {
											?>
											<div class="analytify_column"><div class="analytify_half analytify_left_flow">
											<div class="analytify_general_status analytify_section_social_media_stats analytify_status_box_wraper" data-endpoint="social-stats" data-target=".analytify_section_social_media_stats">
													<div class="analytify_status_header analytify_header_adj">
														<h3>
															<?php esc_html_e( 'Social Network', 'wp-analytify' ); ?>
															<?php do_action( 'analytify_after_top_social_media_text' ); ?>
														</h3>
														<div class="analytify_top_keywords_detials analytify_tp_btn"></div>
														<div class="analytify_status_header_value social_total empty-on-loading title-total-wrapper"></div>
													</div>
													<div class="analytify_status_body">
														<div class="stats-wrapper"></div>
													</div>
													<div class="analytify_stats_loading">
														<table class="analytify_data_tables">
															<thead>
																<tr>
																<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
																</tr>
															</thead>
															<tbody>
																<?php for ( $i = 0; $i < 5; $i++ ) { ?>
																<tr>
																	<td><p class="skt-loading"></p></td>
																	<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																</tr>
																<?php } ?>
															</tbody>
														</table>
													</div>
												</div>
											<?php
										}

										?></div><div class="analytify_half analytify_right_flow"><?php

										if ( in_array( 'show-referrer-dashboard', $selected_stats, true ) ) {
											?>
											<div class="analytify_general_status analytify_status_box_wraper analytify_section_referer_stats" data-endpoint="referer-stats" data-target=".analytify_section_referer_stats">
												<div class="analytify_status_header analytify_header_adj">
													<h3>
														<?php esc_html_e( 'Top Referrers', 'wp-analytify' ); ?>
														<a href="javascript: return false;" data-ga-dashboard-link="<?php echo WPANALYTIFY_Utils::get_all_stats_link( $report_url, 'referer', false ); ?>" target="_blank" class="analytify_tooltip"><span class="analytify_tooltiptext"><?php _e( 'View All Top Referrers', 'wp-analytify' ); ?></span><span aria-hidden="true" class="dashicons dashicons-external"></span></a>
														<?php do_action( 'analytify_after_top_reffers_text' ); ?>
													</h3>
													<div class="analytify_top_keywords_detials analytify_tp_btn"></div>
													<div class="analytify_status_header_value reffers_total empty-on-loading title-total-wrapper"></div>
												</div>
												<div class="analytify_status_body">
													<div class="stats-wrapper"></div>
												</div>
												<div class="analytify_stats_loading">
													<table class="analytify_data_tables">
														<thead>
															<tr>
															<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
															<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
															</tr>
														</thead>
														<tbody>
															<?php for ( $i = 0; $i < 10; $i++ ) { ?>
															<tr>
																<td><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
															</tr>
															<?php } ?>
														</tbody>
													</table>
												</div>
											</div>
											<?php
										}

										?></div><?php

										if ( in_array( 'show-page-stats-dashboard', $selected_stats, true ) ) {
											?>
											<div class="analytify_general_status analytify_status_box_wraper analytify_section_whats_happening_stats" data-endpoint="what-is-happening-stats" data-target=".analytify_section_whats_happening_stats">
												<div class="analytify_status_header">
													<h3><?php esc_html_e( 'What\'s happening when users come to your site', 'wp-analytify' ); ?> <?php do_action( 'analytify_after_top_page_stats_text' ); ?></h3>
													<div class="analytify_top_page_detials analytify_tp_btn"></div>
												</div>
												<div class="analytify_status_body">
													<div class="analytify_page_stats_boxes_wraper stats-wrapper"></div>
												</div>
												<div class="analytify_stats_loading">
													<table class="analytify_data_tables">
														<thead>
															<tr>
																<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_compair_value_row"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_compair_value_row"><p class="skt-loading light-gray"></p></th>
																<th class="analytify_compair_row"><p class="skt-loading light-gray"></p></th>
															</tr>
														</thead>
														<tbody>
															<?php for ( $i = 0; $i < 5; $i++ ) { ?>
															<tr>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																<td class="analytify_txt_center"><p class="skt-loading"></p></td>
															</tr>
															<?php } ?>
														</tbody>
													</table>
												</div>
											</div>
											<?php
										}

										/**
										 * Pro adds these sections.
										 * All 4 dates, $dashboard_profile_id, $report_url, $report_date_range are
										 * for Pro versions that are older then v5.0.0.
										 * Version 5.0.0 and above will use dates via AJAX.
										 */
										do_action( 'wp_analytify_view_ajax_error', $start_date, $end_date, $dashboard_profile_id, $report_url, $report_date_range );
										do_action( 'wp_analytify_view_404_error', $start_date, $end_date, $dashboard_profile_id, $report_url, $report_date_range );
										do_action( 'wp_analytify_view_javascript_error', $start_date, $end_date, $dashboard_profile_id, $report_url, $report_date_range );

									} else {
										esc_html_e( 'You must be authenticated to see the Analytics Dashboard.', 'wp-analytify' );
									}
								} else {
									esc_html_e( 'You don\'t have access to Analytify Dashboard.', 'wp-analytify' );
								}
							}
							?>
						</>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
