<?php
/**
 * Kadence Cloud Settings Class
 *
 * @package Kadence Cloud
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main Kadence_Cloud_Settings class
 */
class Kadence_Cloud_Settings {
	const OPT_NAME = 'kadence_cloud';

	/**
	 * Action on init.
	 */
	public function __construct() {
		require_once KADENCE_CLOUD_PATH . 'inc/settings/load.php';
		// Need to load this with priority higher then 10 so class is loaded.
		add_action( 'after_setup_theme', array( $this, 'add_sections' ), 20 );
		add_action( 'init', array( $this, 'add_telemetry' ), 20 );
	}
	/**
	 * Add Telemetry
	 */
	public function add_telemetry() {
		add_filter( 'stellarwp/telemetry/kadence-cloud/optin_args', array( $this, 'optin_notice_args' ), 10 );
		add_filter( 'stellarwp/telemetry/kadence-cloud/exit_interview_args', array( $this, 'exit_interview_args' ), 10 );
		add_action( 'kadence_settings_dash_kadence_cloud_before_head', array( $this, 'trigger_optin' ), 10 );
		add_action( 'kadence_settings_dash_kadence_cloud_enqueue', array( $this, 'scripts' ) );
	}
	/**
	 * Loads admin style sheets and scripts
	 */
	public function scripts() {
		wp_enqueue_style( 'kadence-cloud-admin-css', KADENCE_CLOUD_URL . 'inc/assets/css/admin-dashboard.css', KADENCE_CLOUD_VERSION, 'all' );
	}
	/**
	 * Trigger Optin
	 */
	public function trigger_optin() {
		do_action( 'stellarwp/telemetry/kadence-cloud/optin' );
	}
	/**
	 * Filter the exit_interview notice args.
	 *
	 * @param array $default_args the exit_interview args.
	 */
	public function exit_interview_args( $default_args ) {
		$args = array(
			'plugin_logo'           => KADENCE_CLOUD_URL . 'assets/kadence-cloud.png',
			'plugin_logo_width'     => 50,
			'plugin_logo_height'    => 50,
			'plugin_logo_alt'       => 'KadenceWP Logo',
			'uninstall_reasons'=> array(
				array(
					'uninstall_reason_id' => 'confusing',
					'uninstall_reason'    => __( 'I couldn\'t understand how to make it work.', 'kadence-cloud' ),
					'show_comment'        => false,
				),
				array(
					'uninstall_reason_id' => 'better-plugin',
					'uninstall_reason'   => __( 'I found a better plugin.', 'kadence-cloud' ),
					'show_comment' => false,
				),
				array(
					'uninstall_reason_id' => 'no-feature',
					'uninstall_reason'   => __( 'I need a specific feature kadence blocks doesn\'t provide.', 'kadence-cloud' ),
					'show_comment' => true,
				),
				array(
					'uninstall_reason_id' => 'broken',
					'uninstall_reason'   => __( 'Something is broken.', 'kadence-cloud' ),
					'show_comment' => false,
				),
				array(
					'uninstall_reason_id' => 'other',
					'uninstall_reason'   => __( 'Other', 'kadence-cloud' ),
					'show_comment' => true,
				),
			),
		);
		$args = wp_parse_args( $args, $default_args );
		return $args;
	}
	/**
	 * Filter the optin notice args.
	 *
	 * @param array $default_args the optin args.
	 */
	public function optin_notice_args( $default_args ) {
		$args = array(
			'plugin_logo'           => KADENCE_CLOUD_URL . 'assets/kadence-cloud.png',
			'plugin_logo_width'     => 50,
			'plugin_logo_height'    => 50,
			'plugin_logo_alt'       => 'KadenceWP Logo',
			'plugin_name'           => 'Kadence Pattern Hub',
			'plugin_slug'           => 'kadence-cloud',
			'permissions_url'       => 'https://www.kadencewp.com/in-app-telemetry/',
			'tos_url'               => 'https://www.kadencewp.com/terms-and-conditions/',
			'privacy_url'           => 'https://www.kadencewp.com/privacy-policy/',
			'heading'               => __( 'Help us make Kadence Cloud even better.', 'kadence-cloud' ),
			'intro'                 => sprintf(
				// translators: placeholder: username.
				esc_html__(
					'Hi, %1$s! At KadenceWP, we\'re always looking for more ways to make our products better for you. If you opt into sharing some data on your usage of Kadence Cloud, it helps us identify key areas where we can improve. In return, we\'ll also email helpful articles and guides to get more out of Kadence, WordPress, and more. If you skip this, that\'s okay. Kadence Cloud will work just fine. We hope you love building with Kadence.', 'kadence-cloud'
				),
				$default_args['user_name'],
			),
		);
		$args = wp_parse_args( $args, $default_args );
		return $args;
	}
	/**
	 * Add sections to settings.
	 */
	public function add_sections() {
		if ( ! class_exists( 'Kadence_Settings_Engine' ) ) {
			return;
		}
		$args = array(
			'opt_name'                         => self::OPT_NAME,
			'menu_icon'                        => '',
			'menu_title'                       => __( 'Settings', 'kadence-cloud' ),
			'page_title'                       => __( 'Pattern Hub Settings', 'kadence-cloud' ),
			'page_slug'                        => 'kadence-cloud-settings',
			'page_permissions'                 => 'manage_options',
			'menu_type'                        => 'submenu',
			'page_parent'                      => 'edit.php?post_type=kadence_cloud',
			'page_priority'                    => null,
			'footer_credit'                    => '',
			'class'                            => '',
			'admin_bar'                        => false,
			'admin_bar_priority'               => 999,
			'admin_bar_icon'                   => '',
			'show_import_export'               => false,
			'version'                          => KADENCE_CLOUD_VERSION,
			'logo'                             => KADENCE_CLOUD_URL . 'assets/kadence-cloud.png',
			'changelog'                        => KADENCE_CLOUD_PATH . 'changelog.txt',
		);
		$args['tabs'] = array(
			'settings' => array(
				'id' => 'settings',
				'title' => __( 'Settings', 'kadence-cloud' ),
			),
			'dash' => array(
				'id' => 'dash',
				'title' => __( 'Analytics', 'kadence-cloud' ),
			),
			'started' => array(
				'id' => 'started',
				'title' => __( 'Getting Started', 'kadence-cloud' ),
			),
			'changelog' => array(
				'id' => 'changelog',
				'title' => __( 'Changelog', 'kadence-cloud' ),
			),
		);
		$args['started'] = array(
			'title' => __( 'Welcome to Kadence Cloud', 'kadence-cloud' ),
			'description' => __( 'We are working on a getting started video to be added below here, it\'s coming soon.', 'kadence-cloud' ),
			'video_url' => '',
			'link_url' => 'https://kadencecloud.com/knowledge-base/',
			'link_text' => __( 'View Knowledge Base', 'kadence-cloud' ),
		);
		$args['sidebar'] = array(
			'facebook' => array(
				'title' => __( 'Web Creators Community', 'kadence-cloud' ),
				'description' => __( 'Join our community of fellow kadence users creating effective websites! Share your site, ask a question and help others.', 'kadence-cloud' ),
				'link' => 'https://www.facebook.com/groups/webcreatorcommunity',
				'link_text' => __( 'Join our Facebook Group', 'kadence-cloud' ),
			),
			'docs' => array(
				'title' => __( 'Documentation', 'kadence-cloud' ),
				'description' => __( 'Need help? We have a knowledge base full of articles to get you started.', 'kadence-cloud' ),
				'link' => 'https://kadencecloud.com/knowledge-base/',
				'link_text' => __( 'Browse Docs', 'kadence-cloud' ),
			),
			'support' => array(
				'title' => __( 'Support', 'kadence-cloud' ),
				'description' => __( 'Have a question, we are happy to help! Get in touch with our support team.', 'kadence-cloud' ),
				'link' => 'https://www.kadencewp.com/premium-support-tickets/',
				'link_text' => __( 'Submit a Ticket', 'kadence-cloud' ),
			),
		);
		Kadence_Settings_Engine::set_args( self::OPT_NAME, $args );
		Kadence_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id'     => 'kc_general',
				'title'  => __( 'General', 'kadence-cloud' ),
				'long_title'  => __( 'General Settings', 'kadence-cloud' ),
				'desc'   => '',
				'fields' => array(
					array(
						'id'       => 'cloud_name',
						'type'     => 'text',
						'title'    => __( 'Set Pattern Hub Name', 'kadence-cloud' ),
						'help' => __( 'If unset the site title will be used.', 'kadence-cloud' ),
					),
					array(
						'id'       => 'expires',
						'type'     => 'select',
						'title'    => __( 'Force sites to resync after', 'kadence-cloud' ),
						'options'  => array(
							'day'   => __( 'One Day', 'kadence-cloud' ),
							'week'  => __( 'One Week', 'kadence-cloud' ),
							'month' => __( 'One Month', 'kadence-cloud' ),
						),
						'default'  => 'month',
					),
					array(
						'id'       => 'enable_flash',
						'type'     => 'switch',
						'title'    => __( 'Enable API Flash for screenshots.', 'kadence-cloud' ),
						'help' => __( 'This allows you to regenerate thumbnails with a click.', 'kadence-cloud' ),
						'default'  => 0,
					),
					array(
						'id'       => 'flash_api',
						'type'     => 'text',
						'title'    => __( 'Add API Flash Key', 'kadence-cloud' ),
						'help'     => __( 'Get your API Key here', 'kadence-cloud' ),
						'helpLink' => 'https://apiflash.com/',
						'required' => array( 'enable_flash', '=', 'true' ),
					),
					array(
						'id'       => 'enable_analytics',
						'type'     => 'switch',
						'title'    => __( 'Enable Anonymous Usage Tracking', 'kadence-cloud' ),
						'help' => __( 'This will track how many times a library item is imported.', 'kadence-cloud' ),
						'default'  => 0,
					),
				),
			)
		);
		Kadence_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id'     => 'kc_keys',
				'title'  => __( 'Access Keys', 'kadence-cloud' ),
				'long_title'  => __( 'Access Keys', 'kadence-cloud' ),
				'desc'   => '',
				'fields' => array(
					array(
						'id'         => 'site_url',
						'type'       => 'code_info',
						'title'      => __( 'Connection URL', 'kadence-cloud' ),
						'content'    => get_site_url(),
					),
					array(
						'id'         => 'access_keys',
						'type'       => 'text_repeater_expanded',
						'title'      => __( 'Access Keys', 'kadence-cloud' ),
						'add_button' => __( 'Generate Key', 'kadence-cloud' ),
						'editable'   => true,
						'content'    => 'key',
					),
				),
			)
		);
	}
}
new Kadence_Cloud_Settings();
