<?php
namespace KadenceWP\KadenceCloud\Tables;

use KadenceWP\KadenceCloud\StellarWP\DB\DB;
use KadenceWP\KadenceCloud\StellarWP\Schema\Tables\Contracts\Table;

class Analytics_Table extends Table {
	/**
	 * {@inheritdoc}
	 */
	const SCHEMA_VERSION = '1.0.0';

	/**
	 * {@inheritdoc}
	 */
	protected static $base_table_name = 'kadence_cloud_events';

	/**
	 * {@inheritdoc}
	 */
	protected static $group = 'kadencewp';

	/**
	 * {@inheritdoc}
	 */
	protected static $schema_slug = 'kadence_cloud_db_build';

	/**
	 * {@inheritdoc}
	 */
	protected static $uid_column = 'id';

	/**
	 * {@inheritdoc}
	 */
	protected function get_definition() {
		$table_name = self::table_name( true );
		$charset_collate = DB::get_charset_collate();

		return "
			CREATE TABLE `{$table_name}` (
				`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
				`type` varchar(50) NOT NULL,
				`post` int(11) NOT NULL DEFAULT '0',
				`style` varchar(50) NOT NULL,
				`time` datetime NOT NULL,
				`count` int(11) unsigned NOT NULL DEFAULT '1',
				`consolidated` tinyint(1) NOT NULL DEFAULT '0',
				PRIMARY KEY (`id`),
				UNIQUE KEY `type__post__time__consolidated` (type,post,time,consolidated)
			) {$charset_collate};
		";
	}
}