<?php
/**
 * Plugin Name: Kadence Pattern Hub
 * Description: Create your own remote hub of shareable prebuilt block patterns
 * Version: 1.1.0
 * Author: Kadence WP
 * Author URI: http://kadencewp.com/
 * Requires PHP: 7.4
 * License: GPLv2 or later
 * Text Domain: kadence-cloud
 *
 * @package Kadence Cloud
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'KADENCE_CLOUD_PATH', realpath( plugin_dir_path( __FILE__ ) ) . DIRECTORY_SEPARATOR );
define( 'KADENCE_CLOUD_URL', plugin_dir_url( __FILE__ ) );
define( 'KADENCE_CLOUD_VERSION', '1.1.0' );

require_once KADENCE_CLOUD_PATH . 'vendor/vendor-prefixed/autoload.php';
require_once KADENCE_CLOUD_PATH . 'vendor/autoload.php';
require_once KADENCE_CLOUD_PATH . 'inc/kadence-cloud-analytics-init.php';
require_once KADENCE_CLOUD_PATH . 'inc/uplink/Helper.php';
require_once KADENCE_CLOUD_PATH . 'inc/uplink/Connect.php';

use KadenceWP\KadenceCloud\StellarWP\Telemetry\Config;
use KadenceWP\KadenceCloud\StellarWP\Telemetry\Core as Telemetry;
use KadenceWP\KadenceCloud\Container;
/**
 * Load Plugin
 */
function kadence_cloud_init() {
	require_once KADENCE_CLOUD_PATH . 'kadence-cloud-rest-controller.php';
	require_once KADENCE_CLOUD_PATH . 'class-kadence-cloud.php';
	require_once KADENCE_CLOUD_PATH . 'inc/class-kadence-cloud-settings.php';
	/**
	 * Site Health
	 */
	require_once KADENCE_CLOUD_PATH . 'inc/class-kadence-cloud-site-health.php';
	/**
	 * Telemetry.
	 */
	Config::set_container( new Container() );
	Config::set_server_url( 'https://telemetry.stellarwp.com/api/v1' );
	Config::set_hook_prefix( 'kadence-pattern-hub' );
	Config::set_stellar_slug( 'kadence-pattern-hub' );
	Telemetry::instance()->init( __FILE__ );
}
add_action( 'plugins_loaded', 'kadence_cloud_init' );

/**
 * Load the plugin textdomain
 */
function kadence_cloud_lang() {
	load_plugin_textdomain( 'kadence-cloud', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
add_action( 'init', 'kadence_cloud_lang' );
