<?php
/**
 * Base Page
 */


		global $wpdb;
		$tables = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tables');
?>

		<div class="ksp-sliders-list kpt-tables-list ksp-table ksp-clearfix">
		<div class="ksp-table-title">
			<h3>
				<?php _e('Kadence Pricing Tables List', 'kadence-pricing-table'); ?>
			</h3>
		</div>
		<div class="ksp_table_body ksp-clearfix">
			<div class="ksp-table-header ksp-clearfix">
				<div class="ksp-table-column ksp_column_02"><?php _e('ID', 'kadence-pricing-table'); ?></div>
				<div class="ksp-table-column ksp_column_03"><?php _e('Name', 'kadence-pricing-table'); ?></div>
				<div class="ksp-table-column ksp_column_04"><?php _e('Shortcode', 'kadence-pricing-table'); ?></div>
				<div class="ksp-table-column ksp_column_05"><?php _e('Actions', 'kadence-pricing-table'); ?></div>
			</div>
		<?php if(!empty($tables)){
			foreach($tables as $table) { ?>
		<div class="ksp_table_content ksp_table_row ksp-clearfix">
				<div class="ksp-table-column ksp_column_02"><?php echo $table->id;?></div>
				<div class="ksp-table-column ksp_column_03"><a href="<?php echo esc_url(admin_url('?page=kadencepricingtable&view=tableedit&id=' . $table->id ));?>"><?php echo esc_html($table->name)?></a></div>
				<div class="ksp-table-column ksp_column_04">[kadence_pricing_table id="<?php echo esc_attr($table->id); ?>"]</div>
				<div class="ksp-table-column ksp_column_05">
					<a class="ksp-edit-table ksp-button ksp-is-success" href="<?php echo esc_url(admin_url('?page=kadencepricingtable&view=tableedit&id=' . $table->id));?>"><?php echo __('Edit Table', 'kadence-pricing-table');?></a>
					<a class="ksp-duplicate-table ksp-button ksp-is-warning" href="javascript:void(0)" data-duplicate="<?php echo esc_attr($table->id); ?>"><?php echo __('Duplicate Table', 'kadence-pricing-table');?></a>
					<a class="ksp-export-table ksp-button ksp-is-warning" href="javascript:void(0)" data-export="<?php echo esc_attr($table->id); ?>"><?php echo __('Export Table', 'kadence-pricing-table');?></a>
					<a class="ksp-delete-table ksp-button ksp-is-danger" href="javascript:void(0)" data-delete="<?php echo esc_attr($table->id); ?>"><?php echo __('Delete Table', 'kadence-pricing-table');?></a>
				</div>
				</div>
				<?php }
			} else { ?>
				<div class="ksp-no-tables">
			<?php _e('No Tables found. Please add a new one.', 'kadence-pricing-table'); ?>
		</div>
			<?php }
			?>
			</div>
			</div>



<a class="ksp-button ksp-is-primary kpt-add-table" href="?page=kadencepricingtable&view=tableadd"><?php _e('Add Pricing Table', 'kadence-pricing-table'); ?></a>
<a class="ksp-button ksp-is-secondary kpt-add-table-template" href="?page=kadencepricingtable&view=import"><?php _e('Add Pricing Table from Template', 'kadence-pricing-table'); ?></a>
<a class="ksp-button ksp-is-warning kpt-import-table" href="javascript:void(0)"><?php _e('Import Pricing Table', 'kadence-pricing-table'); ?></a>
<input id="kpt-import-file" type="file" style="display: none;">




