<?php 
function kpt_table_row_data($single_row = null) {
	$void = !$single_row ? true : false;
	$fontdata = get_option('kadence_pricing_table');
	$data = array();
	if(!$void) {
		$data['row_bg_color'] = $single_row->background;
		$data['row_color'] = $single_row->color;
		$data['row_font_size'] = $single_row->font_size;
		$data['row_letter_spacing'] = $single_row->letter_spacing;
		$data['row_line_height'] = $single_row->line_height;
		$data['row_font'] = $single_row->font;
		$data['row_padding'] = $single_row->padding;
		$data['row_height'] = $single_row->height;
		$data['row_html'] = $single_row->inner_html;
	} else {
		$data['row_bg_color'] = '#ffffff';
		$data['row_color'] = '#444444';
		$data['row_font_size'] = '14';
		$data['row_letter_spacing'] = '1';
		$data['row_line_height'] = '20';
		$data['row_font'] = 'font_option_three';
		$data['row_padding'] = '5';
		$data['row_height'] = '40';
		$data['row_html'] = __('Single Row', 'kadence-pricing-table');
	}
	if(isset($fontdata[$data['row_font']]['font-family'])) {
		$data['row_font_family'] = 'font-family: ' . $fontdata[$data['row_font']]['font-family'] . ';'; 
	} else {
		$data['row_font_family'] = 'font-family: Open Sans;'; 
	}
	if(isset($fontdata[$data['row_font']]['font-weight'])) { 
		$data['row_font_weight'] = 'font-weight: ' . $fontdata[$data['row_font']]['font-weight'] . ';'; 
	} else {
		$data['row_font_weight'] = 'font-weight: 600;'; 
	}
	if(isset($fontdata[$data['row_font']]['font-style'])) { 
		$data['row_font_style'] = 'font-style: ' . $fontdata[$data['row_font']]['font-style'] . ';'; 
	} else {
		$data['row_font_style'] = '';
	} 

	return $data;
}
function kpt_admin_output_table_rows($edit, $table, $pane, $table_rows) {
	if($edit && $table_rows != NULL) {
		$i = 1;
		foreach($table_rows as $single_row) {
			$data = kpt_table_row_data($single_row);
			if($data['row_height'] == '0') {
				$data['row_height'] = '5';
			}
			echo '<div class="kpt-pane-single-row" style="background:'.esc_attr($data['row_bg_color']).'; color:'.esc_attr($data['row_color']).'; font-size:'.esc_attr($data['row_font_size']).'px; letter-spacing:'.esc_attr($data['row_letter_spacing']).'px; line-height:'.esc_attr($data['row_line_height']).'px; padding-top:'.esc_attr($data['row_padding']).'px; padding-bottom:'.esc_attr($data['row_padding']).'px; min-height:'.esc_attr($data['row_height']).'px; '.esc_attr($data['row_font_family']).' '.esc_attr($data['row_font_weight']).' '.esc_attr($data['row_font_style']).'">';
				echo '<div class="kpt-pane-single-row-inner">';
				echo wp_kses_post($data['row_html']);
			echo '</div>';
				echo '<div class="row-controls">';
					echo '<span class="kpt-row-duplicate" title="'.__("Duplicate", 'kadence-pricing-table').'"></span>';
					echo '<span class="kpt-row-close" title="'.__("Delete", 'kadence-pricing-table').'"></span>';
					echo '<span class="kpt-row-drag" title="'.__("Drag", 'kadence-pricing-table').'"></span>';
				echo '</div>';
			echo '</div>';
		}
	} else {
		$data = kpt_table_row_data(null);
		if($data['row_height'] == '0') {
			$data['row_height'] = '5';
		}
		echo '<div class="kpt-pane-single-row" style="background:'.esc_attr($data['row_bg_color']).'; color:'.esc_attr($data['row_color']).'; font-size:'.esc_attr($data['row_font_size']).'px; letter-spacing:'.esc_attr($data['row_letter_spacing']).'px; line-height:'.esc_attr($data['row_line_height']).'px; padding-top:'.esc_attr($data['row_padding']).'px; padding-bottom:'.esc_attr($data['row_padding']).'px; min-height:'.esc_attr($data['row_height']).'px; '.esc_attr($data['row_font_family']).' '.esc_attr($data['row_font_weight']).' '.esc_attr($data['row_font_style']).'">';
			echo '<div class="kpt-pane-single-row-inner">';
				echo wp_kses_post($data['row_html']);
			echo '</div>';
			echo '<div class="row-controls">';
				echo '<span class="kpt-row-duplicate" title="'.__("Duplicate", 'kadence-pricing-table').'"></span>';
				echo '<span class="kpt-row-close" title="'.__("Delete", 'kadence-pricing-table').'"></span>';
				echo '<span class="kpt-row-drag" title="'.__("Drag", 'kadence-pricing-table').'"></span>';
			echo '</div>';
		echo '</div>';
	}
}
function kpt_admin_output_table_rows_settings($edit, $table, $pane, $table_rows) {
	if($edit && $table_rows != NULL) {
		$i = 1;
		foreach($table_rows as $single_row) {
			$data = kpt_table_row_data($single_row);
			kpt_admin_output_table_row_settings($data);
		}
	} else {
		$data = kpt_table_row_data(null);
		kpt_admin_output_table_row_settings($data);
	}
}
function kpt_admin_output_table_row_settings($data) {
	?>
	<div class="ksp-row row-settings-contain single-row-settings">
			<div class="ksp-list-title">
					<?php _e('Single Row Options', 'kadence-pricing-table'); ?>
			</div>
			<div class="ksp-column ksp-full">
				<div class="ksp-content">
					<div class="ksp-inner-row ksp-btn-options ksp-clearfix">
						<div class="ksp-border-wrap ksp-clearfix">
								<div class="ksp-column kpt-column-full ksp-odd">
									<span class="ksp-inner-row-label">
										<?php _e('Row Text', 'kadence-pricing-table'); ?>
									</span>
									<?php					
										echo '<textarea class="kpt-inner-html kpt-row_html">' . esc_textarea($data['row_html']) . '</textarea>';
									?>
								</div>
								<div class="ksp-column ksp-even kpt-row_font kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font', 'kadence-pricing-table'); ?>
									</span>
									<?php
									echo kpt_font_list_select($data['row_font']);
									?>
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Color', 'kadence-pricing-table'); ?>
									</span>
									<input class="kpt-row_color kpt-color-button ksp-bcolor-wp-color-picker kpt-color" type="text" value="<?php echo esc_attr($data['row_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Size', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-row_font_size kt_small_input" type="number" value="' . esc_attr($data['row_font_size']) .'" />';
									 ?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Line height', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-row_line_height kt_small_input" type="number" value="' . esc_attr($data['row_line_height']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Letter Spacing', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-row_letter_spacing kt_small_input" type="number" value="' . esc_attr($data['row_letter_spacing']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Top and Bottom Padding', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-row_padding kt_small_input" type="number" value="' .esc_attr($data['row_padding']).'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
										<span class="ksp-inner-row-label">
											<?php _e('Row Background', 'kadence-pricing-table'); ?>
										</span>
										<input class="kpt-row_background kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['row_bg_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
										<span class="ksp-inner-row-label">
											<?php _e('Row Min-Height', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-row_height kt_small_input" type="number" value="' . esc_attr($data['row_height']) .'" />';
										?>
										px
							</div>
							</div>
					</div>
				</div>
			</div>
		</div>
	<?php

	}