<?php
/**
 * Plugin Name: Kadence Simple Share
 * Plugin URI: https://www.kadencewp.com/
 * Description: Simple Sharing plugin, no tracking or loading of extra js
 * Version: 1.2.11
 * Author: Kadence WP
 * Author URI: https://www.kadencewp.com/
 * Text Domain: kadence-simple-share
 * Domain Path: /languages
 * License: GPL-2.0+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.txt
 */

/**
 * Load Translation
 */
function kt_share_load_textdomain() {
	load_plugin_textdomain( 'kadence-simple-share', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'kt_share_load_textdomain' );


if ( ! defined( 'KTSS_PATH' ) ) {
	define( 'KTSS_PATH', realpath( plugin_dir_path( __FILE__ ) ) . DIRECTORY_SEPARATOR );
}
if ( ! defined( 'KTSS_URL' ) ) {
	define( 'KTSS_URL', plugin_dir_url( __FILE__ ) );
}

/**
 * Main Class.
 */
class Kadence_Simple_Share {
	/**
	 * Construct class.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'init' ) );
		add_action( 'plugins_loaded', array( $this, 'on_plugins_loaded' ) );
		add_action( 'after_setup_theme', array( $this, 'kt_share_remove_woo' ) );
		require_once KTSS_PATH . '/includes/class-kadence-svg.php';
	}
	/**
	 * Get options and meta boxes.
	 */
	public function on_plugins_loaded() {
		require_once KTSS_PATH . '/admin/admin_options.php';
		require_once KTSS_PATH . '/admin/metaboxes.php';
	}
	/**
	 * Initiate everything.
	 */
	public function init() {
		add_action( 'get_header', array( $this, 'kadence_simple_share_content' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'kadence_simple_share_enqueue_scripts' ) );
		add_shortcode( 'kadence_simple_share', array( $this, 'kadence_simple_share_content_output_shortcode' ) );
		add_filter( 'get_the_excerpt', array( $this, 'kadence_simple_share_content_excerpt' ), 99 );
		// add_filter( 'cmb2_admin_init', array($this, 'kt_share_metaboxes') );
	}
	/**
	 * Get options and meta boxes.
	 */
	public function kadence_simple_share_content_excerpt( $excerpt ) {
		global $kt_share, $post;
		if ( ! isset( $kt_share ) || 'post' != get_post_type() ) {
			return $excerpt;
		}
		if ( isset( $kt_share['enable_posts_excerpts'] ) && 1 == $kt_share['enable_posts_excerpts'] ) {
			$show = get_post_meta( $post->ID, '_kt_share_control', true );
			if ( empty( $show ) || 'default' == $show || 'show' == $show ) {
				if ( isset( $kt_share['excerpt_sharing_location'] ) && 'both' == $kt_share['excerpt_sharing_location'] ) {
					$excerpt = '<div class="excerpt_sharing_before_output">' . $this->kadence_simple_share_content_output() . '</div>' . $excerpt . '<div class="excerpt_sharing_after_output">' . $this->kadence_simple_share_content_output() . '</div>';
				} else if ( isset( $kt_share['excerpt_sharing_location'] ) && 'after' == $kt_share['excerpt_sharing_location'] ) {
					$excerpt = $excerpt . '<div class="excerpt_sharing_after_output">' . $this->kadence_simple_share_content_output() . '</div>';
				} else {
					$excerpt = '<div class="excerpt_sharing_before_output">' . $this->kadence_simple_share_content_output() . '</div>' . $excerpt;
				}
			}
		}
		return $excerpt;
	}
	/**
	 * Check for Kadence standard Themes.
	 */
	public function kt_share_theme_is_kadence() {
		if ( class_exists( 'kt_api_manager' ) ) {
			return true;
		}
		return false;
	}
	/**
	 * Get options and meta boxes.
	 */
	public function kt_share_remove_woo() {
		if ( ! class_exists( 'Redux' ) ) {
			return;
		}
		if ( ! class_exists( 'woocommerce' ) ) {
			Redux::removefield( 'kt_share', 'enable_products' );
		}
	}
	public function kadence_simple_share_content() {
		global $kt_share, $post;
		if ( ! isset( $kt_share ) ) {
			die();
		}
		$post_type = get_post_type();
		$kadence = $this->kt_share_theme_is_kadence();
		$post_id = null;
		if ( is_home() ) {
			$post_id = get_option( 'page_for_posts' );
		} else if ( isset( $post ) ) {
			$post_id = $post->ID;
		}

		$location = $kt_share['sharing_location'];
		$location_mobile = 'inherit' == $kt_share['sharing_location_mobile'] ? $location : $kt_share['sharing_location_mobile'];

		$show = 'default';
		if ( $post_id ) {
			$show = get_post_meta( $post_id, '_kt_share_control', true );
		}

		if ( empty( $show ) || 'default' == $show ) {
			if ( 'post' == $post_type && ( isset( $kt_share['enable_posts'] ) && 1 == $kt_share['enable_posts'] ) ) {
				$show = 'show';
			} else if ( 'portfolio' == $post_type && ( isset( $kt_share['enable_portfolio'] ) && 1 == $kt_share['enable_portfolio'] ) ) {
				$show = 'show';
			} else if ( 'product' == $post_type && ( isset( $kt_share['enable_products'] ) && 1 == $kt_share['enable_products'] ) ) {
				$show = 'show';
			} else if ( 'page' == $post_type && ( isset( $kt_share['enable_pages'] ) && 1 == $kt_share['enable_pages'] ) ) {
				$show = 'show';
			} else {
				$show = 'hide';
			}
		}

		if ( $show == 'show' ) {
			if ( $kadence ) {
				if ( $post_type == 'post' ) {
					if ( isset( $location ) ) {
						if ( $location == 'both' ) {
							add_action( 'kadence_single_post_content_before', array( $this, 'kadence_simple_share_content_output_before' ) );
							add_action( 'kadence_single_post_content_after', array( $this, 'kadence_simple_share_content_output_after' ) );
						} elseif ( $location == 'after' ) {
							add_action( 'kadence_single_post_content_after', array( $this, 'kadence_simple_share_content_output_after' ) );
						} else {
							add_action( 'kadence_single_post_content_before', array( $this, 'kadence_simple_share_content_output_before' ) );
						}
					} else {
						add_action( 'kadence_single_post_content_before', array( $this, 'kadence_simple_share_content_output_before' ) );
					}
				} else if ( $post_type == 'portfolio' ) {
					if ( isset( $location ) ) {
						if ( $location == 'both' ) {
							add_action( 'kadence_single_portfolio_before_content', array( $this, 'kadence_simple_share_content_output_before' ) );
							add_action( 'kadence_single_portfolio_after_content', array( $this, 'kadence_simple_share_content_output_after' ) );
						} elseif ( $location == 'after' ) {
							add_action( 'kadence_single_portfolio_after_content', array( $this, 'kadence_simple_share_content_output_after' ) );
						} else {
							add_action( 'kadence_single_portfolio_before_content', array( $this, 'kadence_simple_share_content_output_before' ) );
						}
					} else {
						add_action( 'kadence_single_portfolio_before_content', array( $this, 'kadence_simple_share_content_output_before' ) );
					}
				} else if ( $post_type == 'product' ) {
					add_action( 'woocommerce_share', array( $this, 'kadence_simple_share_content_output_after' ), 10 );
				} else if ( $post_type == 'page' ) {
					if ( isset( $location ) ) {
						if ( $location == 'both' ) {
							add_action( 'kadence_page_content_before', array( $this, 'kadence_simple_share_content_output_before' ) );
							add_action( 'kadence_page_footer', array( $this, 'kadence_simple_share_content_output_after' ), 10 );
						} elseif ( $location == 'after' ) {
							add_action( 'kadence_page_footer', array( $this, 'kadence_simple_share_content_output_after' ), 10 );
						} else {
							add_action( 'kadence_page_content_before', array( $this, 'kadence_simple_share_content_output_before' ) );
						}
					} else {
						add_action( 'kadence_page_content_before', array( $this, 'kadence_simple_share_content_output_before' ) );
					}
				}
			} else {
				if ( $post_type == 'post' ) {
					if ( isset( $location ) ) {
						if ( $location == 'both' ) {
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_before' ), 5 );
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_after' ), 100 );
						} elseif ( $location == 'after' ) {
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_after' ), 100 );
						} else {
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_before' ), 5 );
						}
					} else {
						add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_before' ), 5 );
					}
				} else if ( $post_type == 'product' ) {
					add_action( 'woocommerce_share', array( $this, 'kadence_simple_share_content_output_after' ), 10 );
				} else if ( $post_type == 'page' ) {
					if ( isset( $location ) ) {
						if ( $location == 'both' ) {
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_before' ), 5 );
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_after' ), 100 );
						} elseif ( $location == 'after' ) {
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_after' ), 100 );
						} else {
							add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_before' ), 5 );
						}
					} else {
						add_filter( 'the_content', array( $this, 'kadence_simple_share_content_filter_output_before' ), 5 );
					}
				}
			}
		}
	}
	public function kadence_simple_share_content_output() {
		global $kt_share;

		$location = $kt_share['sharing_location'];
		$location_mobile = 'inherit' == $kt_share['sharing_location_mobile'] ? $location : $kt_share['sharing_location_mobile'];

		if ( isset( $kt_share['enabled_sharing']['enabled'] ) ) {
			$enabled_sharing = $kt_share['enabled_sharing']['enabled'];
		} else {
			$enabled_sharing = array(
				'facebook' => 'facebook',
				'twitter' => 'twitter',
			);
		}
		if ( isset( $kt_share['sharing_align'] ) ) {
			$align = $kt_share['sharing_align'];
		} else {
			$align = 'left';
		}
		if ( isset( $kt_share['sharing_style'] ) ) {
			$style = $kt_share['sharing_style'];
		} else {
			$style = 'style_01';
		}
		if ( isset( $kt_share['sharing_size'] ) ) {
			$size = $kt_share['sharing_size'];
		} else {
			$size = 'normal';
		}
		if ( isset( $kt_share['sharing_text'] ) && ! empty( $kt_share['sharing_text'] ) ) {
			$sharing_text = '<div class="kt_before_share_text">' . $kt_share['sharing_text'] . '</div>';
		} else {
			$sharing_text = '';
		}
		$trans_bg_class = isset( $kt_share['transparent_background'] ) && $kt_share['transparent_background'] ? 'kt-social-bg-transparent' : '';

		$tooltip = false;
		$tool_text = null;
		$tool_text_email = null;
		$tool_align = null;
		if ( isset( $kt_share['enable_tooltip'] ) && 1 == $kt_share['enable_tooltip'] && 'style_05' != $style ) {
			$tooltip = true;

			if ( isset( $kt_share['tooltip_align'] ) && ! empty( $kt_share['tooltip_align'] ) ) {
				$tool_align = $kt_share['tooltip_align'];
				$tool_align_mobile = $tool_align;
			} else {
				$tool_align = 'bottom';
				$tool_align_mobile = $tool_align;
			}

			// Override tool align if in a fixed location.
			$tool_align = 'left' == $location ? 'right' : $tool_align;
			$tool_align = 'right' == $location ? 'left' : $tool_align;
			$tool_align = 'bottom' == $location ? 'top' : $tool_align;
			$tool_align_mobile = 'left' == $location_mobile ? 'right' : $tool_align_mobile;
			$tool_align_mobile = 'right' == $location_mobile ? 'left' : $tool_align_mobile;
			$tool_align_mobile = 'bottom' == $location_mobile ? 'top' : $tool_align_mobile;

			if ( isset( $kt_share['tooltip_text'] ) ) {
				$tool_text = $kt_share['tooltip_text'];
			} else {
				$tool_text = 'Share on';
			}

			if ( isset( $kt_share['tooltip_text_email'] ) ) {
				$tool_text_email = $kt_share['tooltip_text_email'];
			} else {
				$tool_text_email = $tool_text;
			}
		}
		$kt_share_output = null;
		if ( $enabled_sharing ) :
			$kt_share_output .= '<div class="kt_simple_share_container kt-social-align-' . $align . ' kt-socialstyle-' . $style . ' kt-social-size-' . $size . ' ' . $trans_bg_class. '">';
			$kt_share_output .= $sharing_text;
			foreach ( $enabled_sharing as $key => $value ) {
				$tool_text_to_use = 'email' == $key ? ( $tool_text_email ? $tool_text_email : $tool_text ) : $tool_text;

				switch ( $key ) {
					case 'facebook':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_facebook_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_facebook();
						}
						break;
					case 'twitter':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_twitter_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_twitter();
						}
						break;
					case 'xing':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_xing_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_xing();
						}
						break;
					case 'whatsapp':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_whatsapp_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_whatsapp();
						}
						break;
					case 'linkedin':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_linkedin_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_linkedin();
						}
						break;
					case 'tumblr':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_tumblr_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_tumblr();
						}
						break;
					case 'digg':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_digg_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_digg();
						}
						break;
					case 'vk':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_vk_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_vk();
						}
						break;
					case 'stumbleupon':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_stumbleupon_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_stumbleupon();
						}
						break;
					case 'pinterest':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_pinterest_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_pinterest();
						}
						break;
					case 'reddit':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_reddit_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_reddit();
						}
						break;
					case 'email':
						if ( $tooltip ) {
							$kt_share_output .= $this->kt_share_email_tooltip( $tool_align, $tool_text_to_use, $tool_align_mobile );
						} else {
							$kt_share_output .= $this->kt_share_email();
						}
						break;
				}
			}
			$kt_share_output .= '</div>';
			endif;

		return $kt_share_output;
	}
	public function kadence_simple_share_get_location_classes() {
		global $kt_share;

		$location = $kt_share['sharing_location'];
		$location_mobile = 'inherit' == $kt_share['sharing_location_mobile'] ? $location : $kt_share['sharing_location_mobile'];

		$location_class = 'kt_share_location_' . $location;
		$location_class_mobile = 'kt_share_location_mobile_' . $location_mobile;

		return $location_class . ' ' . $location_class_mobile;
	}
	public function kadence_simple_share_get_location_styles() {
		global $kt_share;

		$location = $kt_share['sharing_location'];
		$location_mobile = 'inherit' == $kt_share['sharing_location_mobile'] ? $location : $kt_share['sharing_location_mobile'];

		$padding_size = 'large' == $kt_share['sharing_size'] ? '70px' : '50px';

		$desktop_style = '';
		$mobile_style = '';

		if ( 'bottom' == $location ) {
			$desktop_style = '@media screen and (min-width: 768px){ body{ padding-bottom:' . $padding_size . ' } }';
		}
		if ( 'bottom' == $location_mobile ) {
			$mobile_style = '@media screen and (max-width: 767px){ body{ padding-bottom:' . $padding_size . ' } }';
		}

		if ( $desktop_style || $mobile_style ) {
			return sprintf( '<style>%s %s</style>', $desktop_style, $mobile_style );
		}

		return '';
	}
	public function kadence_simple_share_content_output_after() {
		echo '<div class="kt_simple_share_container kt_share_aftercontent ' . $this->kadence_simple_share_get_location_classes() . '">' . $this->kadence_simple_share_content_output() . '</div>' . $this->kadence_simple_share_get_location_styles();
	}
	public function kadence_simple_share_content_filter_output_after( $content ) {
		if ( doing_filter( 'get_the_excerpt' ) ) {
			return $content;
		}
		return $content . '<div class="kt_simple_share_container kt_share_aftercontent ' . $this->kadence_simple_share_get_location_classes() . '">' . $this->kadence_simple_share_content_output() . '</div>' . $this->kadence_simple_share_get_location_styles();
	}
	public function kadence_simple_share_content_output_before() {
		echo '<div class="kt_simple_share_container kt_share_beforecontent ' . $this->kadence_simple_share_get_location_classes() . '">' . $this->kadence_simple_share_content_output() . '</div>' . $this->kadence_simple_share_get_location_styles();
	}
	public function kadence_simple_share_content_filter_output_before( $content ) {
		if ( doing_filter( 'get_the_excerpt' ) ) {
			return $content;
		}
		return '<div class="kt_simple_share_container kt_share_beforecontent ' . $this->kadence_simple_share_get_location_classes() . '">' . $this->kadence_simple_share_content_output() . '</div>' . $this->kadence_simple_share_get_location_styles() . $content;
	}
	public function kadence_simple_share_content_output_shortcode() {
		return '<div class="kt_simple_share_container kt_share_shortcode ' . $this->kadence_simple_share_get_location_classes() . '">' . $this->kadence_simple_share_content_output() . '</div>' . $this->kadence_simple_share_get_location_styles();
	}
	public function kt_share_facebook() {
		return '<a class="kt_facebook_share" href="https://www.facebook.com/sharer.php?u=' . get_permalink() . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_facebook-f' ) . '</a>';
	}
	public function kt_share_facebook_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_facebook_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' Facebook" data-tooltip="' . esc_attr( $tool_text ) . ' Facebook" href="https://www.facebook.com/sharer.php?u=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_facebook-f' ) . '</a>';
	}
	public function kt_share_twitter() {
		$twitter_title = urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) );
		return '<a class="kt_twitter_share" href="https://twitter.com/intent/tweet?url=' . get_permalink() . '&text=' . esc_attr( $twitter_title ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_twitter' ) . '</a>';
	}
	public function kt_share_twitter_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		$twitter_title = urlencode( html_entity_decode( get_the_title(), ENT_COMPAT, 'UTF-8' ) );
		return '<a class="kt_twitter_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' X" data-tooltip="' . esc_attr( $tool_text ) . ' X" href="https://twitter.com/intent/tweet?url=' . esc_attr( get_permalink() ) . '&text=' . esc_attr( $twitter_title ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_twitter' ) . '</a>';
	}
	public function kt_share_xing() {
		return '<a class="kt_xing_share" href="https://www.xing.com/social_plugins/share/new?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_xing' ) . '</a>';
	}
	public function kt_share_xing_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_xing_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' XING" data-tooltip="' . esc_attr( $tool_text ) . ' XING" href="https://www.xing.com/social_plugins/share/new?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_xing' ) . '</a>';
	}
	public function kt_share_whatsapp() {
		return '<a class="kt_whatsapp_share" href="https://wa.me/?text=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_whatsapp' ) . '</a>';
	}
	public function kt_share_whatsapp_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_whatsapp_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' WhatsApp" data-tooltip="' . esc_attr( $tool_text ) . ' WhatsApp" href="https://wa.me/?text=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_whatsapp' ) . '</a>';
	}
	public function kt_share_vk() {
		return '<a class="kt_vk_share" href="https://vkontakte.ru/share.php?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_vk' ) . '</a>';
	}
	public function kt_share_vk_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_vk_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' VK" data-tooltip="' . esc_attr( $tool_text ) . ' VK" href="https://vkontakte.ru/share.php?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_vk' ) . '</a>';
	}
	public function kt_share_linkedin() {
		return '<a class="kt_linkedin_share" href="https://www.linkedin.com/shareArticle?mini=true&url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_linkedin-in' ) . '</a>';
	}
	public function kt_share_linkedin_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_linkedin_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' LinkedIn" data-tooltip="' . esc_attr( $tool_text ) . ' LinkedIn" href="https://www.linkedin.com/shareArticle?mini=true&url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_linkedin-in' ) . '</a>';
	}
	public function kt_share_tumblr() {
		return '<a class="kt_tumblr_share" href="https://www.tumblr.com/share/link?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_tumblr' ) . '</a>';
	}
	public function kt_share_tumblr_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_tumblr_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' Tumblr" data-tooltip="' . esc_attr( $tool_text ) . ' Tumblr" href="https://www.tumblr.com/share/link?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_tumblr' ) . '</a>';
	}
	public function kt_share_stumbleupon() {
		return '<a class="kt_stumbleupon_share" href="https://www.stumbleupon.com/submit?url=' . esc_attr( get_permalink() ) . '&amp;title=' . esc_attr( get_the_title() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_stumbleupon' ) . '</a>';
	}
	public function kt_share_stumbleupon_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_stumbleupon_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' StumbleUpon" data-tooltip="' . esc_attr( $tool_text ) . ' StumbleUpon" href="https://www.stumbleupon.com/submit?url=' . esc_attr( get_permalink() ) . '&amp;title=' . esc_attr( get_the_title() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_stumbleupon' ) . '</a>';
	}
	public function kt_share_digg() {
		return '<a class="kt_digg_share" href="https://www.digg.com/submit?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_digg' ) . '</a>';
	}
	public function kt_share_digg_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_digg_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' Digg" data-tooltip="' . esc_attr( $tool_text ) . ' Digg" href="https://www.digg.com/submit?url=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_digg' ) . '</a>';
	}
	public function kt_share_reddit() {
		return '<a class="kt_reddit_share" href="https://reddit.com/submit?url=' . esc_attr( get_permalink() ) . '&amp;title=' . esc_attr( get_the_title() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_reddit-alien' ) . '</a>';
	}
	public function kt_share_reddit_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_reddit_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' Reddit" data-tooltip="' . esc_attr( $tool_text ) . ' Reddit" href="https://reddit.com/submit?url=' . esc_attr( get_permalink() ) . '&amp;title=' . esc_attr( get_the_title() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_reddit-alien' ) . '</a>';
	}
	public function kt_share_pinterest() {
		global $post, $kt_share;
		if ( has_post_thumbnail( $post->ID ) && 1 == $kt_share['pinterest_featured'] ) {
			// Get the featured image.
			$url_post_thumb = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
			$url_post_thumb = $url_post_thumb[0];
						// Pinterest share link.
			return '<a data-site="pinterest-featured" href="https://pinterest.com/pin/create/bookmarklet/?is_video=false&url=' . esc_attr( get_permalink() ) . '&media=' . esc_attr( $url_post_thumb ) . '&description=' . esc_attr( get_the_title() ) . '" target="_blank" rel="nofollow" class="kt_pinterest_share">' . Kadence_Social_Svg_Render::render( 'fa_pinterest' ) . '</a>';
		} else { // No featured image set.
			return "<a class='kt_pinterest_share kt_no_pop_window' href='javascript:void((function()%7Bvar%20e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;//assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)%7D)());'>" . Kadence_Social_Svg_Render::render( 'fa_pinterest' ) . "</a>";
		}
	}
	/**
	 * Pinterest tooltip.
	 *
	 * @param string $tool_align the alignment.
	 * @param string $tool_text the text align.
	 */
	public function kt_share_pinterest_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		global $post, $kt_share;
		if ( has_post_thumbnail( $post->ID ) && 1 == $kt_share['pinterest_featured'] ) {
			// Get the featured image.
			$url_post_thumb = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
			$url_post_thumb = $url_post_thumb[0];
						// Pinterest share link.
			return '<a data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' Pinterest" data-tooltip="' . esc_attr( $tool_text ) . ' Pinterest" href="https://pinterest.com/pin/create/bookmarklet/?is_video=false&url=' . esc_attr( get_permalink() ) . '&media=' . esc_attr( $url_post_thumb ) . '&description=' . esc_attr( get_the_title() ) . '" target="_blank" class="kt_pinterest_share">' . Kadence_Social_Svg_Render::render( 'fa_pinterest' ) . '</a>';
		} else { // No featured image set.
			return "<a class='kt_pinterest_share kt_no_pop_window' data-toggle='tooltip' data-placement='" . esc_attr( $tool_align ) . "' aria-label='" . esc_attr( $tool_text ) . " Pinterest' data-tooltip='" . esc_attr( $tool_text ) . " Pinterest' href='javascript:void((function()%7Bvar%20e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;//assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)%7D)());'>" . Kadence_Social_Svg_Render::render( 'fa_pinterest' ) . "</a>";
		}
	}
	public function kt_share_email() {
		return '<a class="kt_email_share" href="mailto:?subject=' . esc_attr( get_the_title() ) . '&body=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_envelope' ) . '</a>';
	}
	public function kt_share_email_tooltip( $tool_align, $tool_text, $tool_align_mobile ) {
		return '<a class="kt_email_share" data-placement="' . esc_attr( $tool_align ) . '" data-placement-mobile="' . esc_attr( $tool_align_mobile ) . '" aria-label="' . esc_attr( $tool_text ) . ' Email" data-tooltip="' . esc_attr( $tool_text ) . ' Email" href="mailto:?subject=' . esc_attr( get_the_title() ) . '&body=' . esc_attr( get_permalink() ) . '" target="_blank">' . Kadence_Social_Svg_Render::render( 'fa_envelope' ) . '</a>';
	}
	public function kadence_simple_share_enqueue_scripts() {
		global $kt_share;
		wp_enqueue_style( 'kadence_share_css', KTSS_URL . 'assets/css/kt-social.css', false, '1.2.11' );
		if ( isset( $kt_share['sharing_link_exit'] ) && 'popup' === $kt_share['sharing_link_exit'] ) {
			wp_enqueue_script( 'kadence_share_js', KTSS_URL . 'assets/js/kt-social-min.js', array(), '1.2.9', true );
		}
	}

}

$GLOBALS['kadence_simple_share'] = new Kadence_Simple_Share();

/* Updater */
add_action( 'after_setup_theme', 'kadence_simple_share_updating', 1 );
function kadence_simple_share_updating() {
	require_once KTSS_PATH . 'kadence-update-checker/kadence-update-checker.php';
	$kadence_simple_share_updater = Kadence_Update_Checker::buildUpdateChecker(
		'https://kernl.us/api/v1/updates/57a37cbe1d258384118780a6/',
		__FILE__,
		'kadence-simple-share'
	);
}
