jQuery( function( $ ) {
// For a widget without a skin (skin = default)
	function custom_getEnhancedSelectFormatString() {
		return {
			'language': {
				errorLoading: function() {
					// Workaround for https://github.com/select2/select2/issues/4355 instead of i18n_ajax_error.
					return wc_country_select_params.i18n_searching;
				},
				inputTooLong: function( args ) {
					var overChars = args.input.length - args.maximum;

					if ( 1 === overChars ) {
						return wc_country_select_params.i18n_input_too_long_1;
					}

					return wc_country_select_params.i18n_input_too_long_n.replace( '%qty%', overChars );
				},
				inputTooShort: function( args ) {
					var remainingChars = args.minimum - args.input.length;

					if ( 1 === remainingChars ) {
						return wc_country_select_params.i18n_input_too_short_1;
					}

					return wc_country_select_params.i18n_input_too_short_n.replace( '%qty%', remainingChars );
				},
				loadingMore: function() {
					return wc_country_select_params.i18n_load_more;
				},
				maximumSelected: function( args ) {
					if ( args.maximum === 1 ) {
						return wc_country_select_params.i18n_selection_too_long_1;
					}

					return wc_country_select_params.i18n_selection_too_long_n.replace( '%qty%', args.maximum );
				},
				noResults: function() {
					return wc_country_select_params.i18n_no_matches;
				},
				searching: function() {
					return wc_country_select_params.i18n_searching;
				}
			}
		};
	}

 elementorFrontend.hooks.addAction( 'frontend/element_ready/checkout-billing.default', function( $scope ) {
		if ( $().selectWoo ) {
			$( 'select.country_select:visible, select.state_select:visible' ).each( function() {
				var select2_args = $.extend({
					placeholderOption: 'first',
					width: '100%'
				}, custom_getEnhancedSelectFormatString() );

				$( this ).selectWoo( select2_args );
				// Maintain focus after select https://github.com/select2/select2/issues/4384
				$( this ).on( 'select2:select', function() {
					$( this ).focus();
				} );
			});
		}
	} );
  elementorFrontend.hooks.addAction( 'frontend/element_ready/checkout-shipping.default', function( $scope ) {
		if ( $().selectWoo ) {
			$( 'select.country_select:visible, select.state_select:visible' ).each( function() {
				var select2_args = $.extend({
					placeholderOption: 'first',
					width: '100%'
				}, custom_getEnhancedSelectFormatString() );

				$( this ).selectWoo( select2_args );
				// Maintain focus after select https://github.com/select2/select2/issues/4384
				$( this ).on( 'select2:select', function() {
					$( this ).focus();
				} );
			});
		}
} );

} );