<?php
defined( 'ABSPATH' ) or exit;

/**
 * Class Kadence_Checkout_Elementor
 */
class Kadence_Checkout_Elementor {

	/**
	* @var null
	*/
	private static $instance = null;

	/**
	* Instance Control
	*/
	public static function get_instance() {
		if ( is_null(  self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Constructor
	 */
	public function __construct() {

		// Replace woocommerce file
		add_filter(	'wc_get_template', array( $this, 'checkout_page_template' ), 50, 3);

		// Add Elementor
		add_action('kadence_woocommerce_checkout_builder', array( $this, 'checkout_template') );

		// Scripts and styles.
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function checkout_page_template($located, $name, $args){
		if( $name ==='checkout/form-checkout.php'):
			if ( kadence_woo_ele_checkout_template_enabled() ) {
				$located = KT_WOOELE_PRO_PATH . 'templates/form-checkout.php';
			}
		endif;

		return $located;
	}
	public function checkout_template() {
		echo Kadence_Woocommerce_Elementor_Pro::$elementor_instance->frontend->get_builder_content_for_display( Kadence_Woocommerce_Elementor_Pro::get_default_checkout_setting() );
	}

	/**
	 * Enqueue styles and scripts.
	 */
	public function enqueue_scripts() {
		if ( kadence_woo_ele_checkout_template_enabled() ) {
			remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
			//wp_enqueue_style( 'kt-woo-ele-pro-style', KT_WOOELE_PRO_URL . 'assets/css/kadence-woocommerce-elementor-pro.css', array(), KT_WOOELE_PRO_VERSION );
			if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {

				if ( class_exists( '\Elementor\Plugin' ) ) {
					$elementor = \Elementor\Plugin::instance();
					if ( $elementor && isset( $elementor->frontend ) ) {
						if ( method_exists( $elementor->frontend, 'enqueue_scripts' ) ) {
							$elementor->frontend->enqueue_scripts();
						}
					}
				}

				if ( class_exists( '\ElementorPro\Plugin' ) ) {
					$elementor_pro = \ElementorPro\Plugin::instance();
					if ( $elementor_pro && method_exists( $elementor_pro, 'enqueue_styles' ) ) {
						$elementor_pro->enqueue_styles();
					}
				}
				if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
					$css_file = new \Elementor\Core\Files\CSS\Post( get_kadence_woo_ele_archive_builder_id() );
					if ( $css_file && method_exists( $css_file, 'enqueue' ) ) {
						$css_file->enqueue();
					}
				}
			}
		}
	}

}
Kadence_Checkout_Elementor::get_instance();
