<?php
defined( 'ABSPATH' ) or exit;

/**
 * Class Kadence_Product_Archive_Elementor
 */
class Kadence_Product_Loop_Elementor {

	/**
	 * Instance Control
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Enabled Status
	 *
	 * @var null
	 */
	private static $status = null;

	/**
	 * Template ID
	 *
	 * @var null
	 */
	private static $template_id = null;

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Constructor
	 */
	public function __construct() {

		// Replace main template.
		add_filter( 'wc_get_template_part', array( $this, 'loop_content_template_loader' ), 100, 3 );

		// Add Elementor.
		add_action( 'kadence_woocommerce_loop_builder', array( $this, 'loop_template' ) );

		// // Scripts and styles.
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

	}
	/**
	 * Checks if Woo Ele Builder is running
	 */
	public static function product_loop_enabled() {
		if ( is_null( self::$status ) ) {
			self::$status = false;
			$loop_default = Kadence_Woocommerce_Elementor_Pro::get_default_loop_setting();
			if ( ! empty( $loop_default ) && 'default' !== $loop_default ) {
				 self::$status = true;
			}
		}
		return apply_filters( 'kadence_woo_ele_loop_builder_enabled', self::$status );
	}

	/**
	 * Checks if Woo Ele Builder is running
	 */
	public static function product_loop_id() {
		if ( is_null( self::$template_id ) ) {
			$loop_default = Kadence_Woocommerce_Elementor_Pro::get_default_loop_setting();
			if ( ! empty( $loop_default ) && 'default' !== $loop_default ) {
				self::$template_id = $loop_default;
			} else {
				self::$template_id = null;
			}
		}
		return apply_filters( 'kadence_woo_ele_loop_builder_id', self::$template_id );
	}
	/**
	 * Changes template if elementor take over
	 *
	 * @param string $template path to template.
	 * @param string $slug the template slug.
	 * @param string $name the template name.
	 */
	public function loop_content_template_loader( $template, $slug, $name ) {

		if ( 'content' === $slug && 'product' === $name ) {
			if ( self::product_loop_enabled() ) {
				$template = KT_WOOELE_PRO_PATH . 'templates/product-loop-elementor.php';
			}
		}

		return $template;
	}

	public static function loop_template() {
		echo Kadence_Woocommerce_Elementor_Pro::$elementor_instance->frontend->get_builder_content_for_display( self::product_loop_id() );
	}
	/**
	 * Enqueue styles and scripts.
	 */
	public function enqueue_scripts() {
		if ( is_woocommerce() && self::product_loop_enabled() ) {
			if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
				if ( class_exists( '\Elementor\Plugin' ) ) {
					$elementor = \Elementor\Plugin::instance();
					if ( $elementor && isset( $elementor->frontend ) ) {
						if ( method_exists( $elementor->frontend, 'enqueue_scripts' ) ) {
							$elementor->frontend->enqueue_scripts();
						}
					}
				}

				if ( class_exists( '\ElementorPro\Plugin' ) ) {
					$elementor_pro = \ElementorPro\Plugin::instance();
					if ( $elementor_pro && method_exists( $elementor_pro, 'enqueue_styles' ) ) {
						$elementor_pro->enqueue_styles();
					}
				}
				if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
					$css_file = new \Elementor\Core\Files\CSS\Post( self::product_loop_id() );
					if ( $css_file && method_exists( $css_file, 'enqueue' ) ) {
						$css_file->enqueue();
					}
				}
			}
		}
	}

}
Kadence_Product_Loop_Elementor::get_instance();
