<?php
/**
 * WPML Compatibility.
 *
 */

defined( 'ABSPATH' ) or exit;

/**
 * Set up WPML Compatibiblity Class.
 */
class Kadence_Woocommerce_Elementor_Pro_WPML_Compatibility {

	/**
	* @var null
	*/
	private static $instance = null;

	/**
	* Instance Control
	*/
	public static function get_instance() {
		if ( is_null(  self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}


	/**
	 * Setup actions and filters.
	 *
	 * @since  1.0.9
	 */
	private function __construct() {
		add_filter( 'kadence_category_elementor_template', array( $this, 'get_wpml_object' ) );
		add_filter( 'kadence_tag_elementor_template', array( $this, 'get_wpml_object' ) );
		add_filter( 'kadence_checkout_elementor_template', array( $this, 'get_wpml_object' ) );
	}

	/**
	 * Pass the final template ID from the WPML's object filter to allow strings to be translated.
	 *
	 * @since  1.0.9
	 * @param  Int $id  Post ID of the template being rendered.
	 * @return Int $id  Post ID of the template being rendered, Passed through the `wpml_object_id` id.
	 */
	public function get_wpml_object( $id ) {
		return apply_filters( 'wpml_object_id', $id );
	}

}

/**
 * Initiate the class.
 */
Kadence_Woocommerce_Elementor_Pro_WPML_Compatibility::get_instance();
