<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Elementor Element Checkout_Additional
 *
 */
class Checkout_Additional_Element extends \Elementor\Widget_Base {

	public function get_name() {
		return 'checkout-additional';
	}

	public function get_title() {
		return __( 'Checkout: Additional Fields', 'kadence-woocommerce-elementor-pro' );
	}

	public function get_icon() {
		return 'eicon-text-field';
	}

	public function get_categories() {
		return array( 'woocommerce-elements' );
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Checkout Additional Fields', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the additional fields for checkout', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			array(
				'label' => __( 'Heading Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Heading Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'title_typography',
				'label'     => __( 'Heading Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} h3',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_label_style',
			array(
				'label' => __( 'Field Label Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'label_color',
			[
				'label'     => __( 'Field Label Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'label_typography',
				'label'     => __( 'Field Label Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .form-row label',
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_input_style',
			array(
				'label' => __( 'Field Input Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'input_typography',
				'label'     => __( 'Field Input Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .form-row input, {{WRAPPER}} .form-row textarea',
			)
		);
		$this->add_control(
			'input_placeholder_color',
			[
				'label'     => __( 'Field Placeholder Input Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input::placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row input::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row input::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row input:-ms-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row textarea::placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row textarea::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row textarea::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row textarea:-ms-input-placeholder' => 'color: {{VALUE}};',
				],
			]
		);
		$this->start_controls_tabs( 'tabs_input_style' );

		$this->start_controls_tab(
			'tab_input_normal',
			[
				'label' => __( 'Normal', 'kadence-woocommerce-elementor-pro' ),
			]
		);
		$this->add_control(
			'input_color',
			[
				'label'     => __( 'Field Input Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input, {{WRAPPER}} .form-row textarea' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'input_background',
			[
				'label'     => __( 'Field Input Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input, {{WRAPPER}} .form-row textarea' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'input_border',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .form-row input, {{WRAPPER}} .form-row textarea',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'input_border_radius',
			[
				'label' => __( 'Input Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row input, {{WRAPPER}} .form-row textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'input_box_shadow',
				'selector' => '{{WRAPPER}} .form-row input, {{WRAPPER}} .form-row textarea',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_input_focus',
			[
				'label' => __( 'Focus', 'kadence-woocommerce-elementor-pro' ),
			]
		);
		$this->add_control(
			'input_focus_color',
			[
				'label'     => __( 'Field Input Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input:focus, {{WRAPPER}} .form-row textarea:focus' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'input_background_focus',
			[
				'label'     => __( 'Field Input Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input:focus, {{WRAPPER}} .form-row textarea:focus' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'input_border_focus',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .form-row input:focus, {{WRAPPER}} .form-row textarea:focus',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'input_border_radius_focus',
			[
				'label' => __( 'Input Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row input:focus, {{WRAPPER}} .form-row textarea:focus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'input_box_shadow_focus',
				'selector' => '{{WRAPPER}} .form-row textarea:focus, {{WRAPPER}} .form-row input:focus',
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		

		$this->add_responsive_control(
			'input_padding',
			[
				'label' => __( 'Field Input Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

	}


	protected function render() {
		//$settings = $this->get_settings_for_display();
		if( is_checkout() ) {
			$checkout = WC()->checkout();
        	if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>
        		<div class="woocommerce-additional-fields">
					<?php do_action( 'woocommerce_before_order_notes', $checkout ); ?>

					<?php if ( apply_filters( 'woocommerce_enable_order_notes_field', 'yes' === get_option( 'woocommerce_enable_order_comments', 'yes' ) ) ) : ?>

						<?php if ( ! WC()->cart->needs_shipping() || wc_ship_to_billing_address_only() ) : ?>

							<h3><?php _e( 'Additional information', 'kadence-woocommerce-elementor-pro' ); ?></h3>

						<?php endif; ?>

						<div class="woocommerce-additional-fields__field-wrapper">
							<?php foreach ( $checkout->get_checkout_fields( 'order' ) as $key => $field ) : ?>
								<?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
							<?php endforeach; ?>
						</div>

					<?php endif; ?>

					<?php do_action( 'woocommerce_after_order_notes', $checkout ); ?>
				</div>
				<?php 
        	endif;
	    } else if ( 'ele-check-template' == get_post_type() ) {
			$checkout = WC()->checkout();
        	if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>
        		<div class="woocommerce-additional-fields">
					<?php do_action( 'woocommerce_before_order_notes', $checkout ); ?>

					<?php if ( apply_filters( 'woocommerce_enable_order_notes_field', 'yes' === get_option( 'woocommerce_enable_order_comments', 'yes' ) ) ) : ?>


							<h3><?php _e( 'Additional information', 'kadence-woocommerce-elementor-pro' ); ?></h3>


						<div class="woocommerce-additional-fields__field-wrapper">
							<?php foreach ( $checkout->get_checkout_fields( 'order' ) as $key => $field ) : ?>
								<?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
							<?php endforeach; ?>
						</div>

					<?php endif; ?>

					<?php do_action( 'woocommerce_after_order_notes', $checkout ); ?>
				</div>
				<?php 
        	endif;
	    }
	}

	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Checkout_Additional_Element());
