<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Elementor Element Product Description
 *
 */
class Product_Archive_Description_Element extends \Elementor\Widget_Base {

	public function get_name() {
		return 'archive-description';
	}

	public function get_title() {
		return __( 'Product Archive: Description', 'kadence-woocommerce-elementor-pro' );
	}

	public function get_icon() {
		return 'eicon-text';
	}

	public function get_categories() {
		return array( 'woocommerce-elements' );
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Archive Description', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the archives description.', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);

		$this->add_control(
			'archive_description_color',
			array(
				'label'     => __( 'Text Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kadence-ele-builder-archive-description, {{WRAPPER}} .kadence-ele-builder-archive-description p' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'archive_description_typography',
				'label'     => __( 'Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .kadence-ele-builder-archive-description, {{WRAPPER}} .kadence-ele-builder-archive-description p',
			)
		);

		$this->add_responsive_control(
			'archive_description_align',
			array(
				'label'        => __( 'Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default'      => 'left',
			)
		);


		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( is_product_taxonomy() || is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
			echo '<div class="kadence-ele-builder-archive-description">';
			/**
			 * Hook: woocommerce_archive_description.
			 *
			 * @hooked woocommerce_taxonomy_archive_description - 10
			 * @hooked woocommerce_product_archive_description - 10
			 */
			do_action( 'woocommerce_archive_description' );
			echo '</div>';
	    } else if ( 'ele-p-arch-template' == get_post_type() ) {
	    	echo '<div class="kadence-ele-builder-archive-description">';
			echo '<p>Mauris eu est placerat, fringilla tellus ut, rhoncus ante. Nulla maximus ultrices ullamcorper. Aliquam dictum risus et odio pellentesque vestibulum. Vestibulum bibendum, erat eget luctus mollis, ante enim tincidunt sapien, at rutrum odio lorem eget ipsum. Vestibulum tincidunt fermentum ornare. Suspendisse consequat malesuada faucibus. Praesent fringilla, turpis nec convallis euismod, velit purus gravida nibh, in sodales orci leo non leo.</p><p>Quisque tempor volutpat libero, aliquet venenatis turpis pulvinar sed. Maecenas eget ullamcorper purus. Vivamus magna libero, gravida at elit quis, eleifend faucibus dolor. Phasellus mattis risus at facilisis consequat. Donec mollis ipsum nec ex laoreet, at euismod metus finibus. Suspendisse interdum quam nec dignissim pulvinar.</p>';
			echo '</div>';
	    } else {
	    	echo  __( 'This element is not designed for this post type', 'kadence-woocommerce-elementor-pro' );
	    }
	}

	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Product_Archive_Description_Element());
