<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Elementor Element Product Title
 *
 */
class Product_Archive_Title_Element extends \Elementor\Widget_Base {

	public function get_name() {
		return 'archive-title';
	}

	public function get_title() {
		return __( 'Product Archive: Title', 'kadence-woocommerce-elementor-pro' );
	}

	public function get_icon() {
		return 'eicon-archive-title';
	}

	public function get_categories() {
		return array( 'woocommerce-elements' );
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Archive Title', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the archives title.', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);

		$this->add_control(
			'archive_title_color',
			array(
				'label'     => __( 'Text Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kadence-ele-builder-archive-title h1' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'archive_title_typography',
				'label'     => __( 'Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .kadence-ele-builder-archive-title h1',
			)
		);

		$this->add_responsive_control(
			'archive_title_align',
			array(
				'label'        => __( 'Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default'      => 'left',
			)
		);


		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( is_product_taxonomy() || is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
			echo '<div class="kadence-ele-builder-archive-title">';
				echo '<h1 class="page-title">';
					woocommerce_page_title();
				echo '</h1>';
			echo '</div>';
	    } else if ( 'ele-p-arch-template' == get_post_type() ) {
	    	echo '<div class="kadence-ele-builder-archive-title">';
			echo '<h1 class="page-title">Archive Title</h1>';
			echo '</div>';
	    } else {
	    	echo  __( 'This element is not designed for this post type', 'kadence-woocommerce-elementor-pro' );
	    }
	}

	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Product_Archive_Title_Element());
