<?php
/**
 * Build Elementor Element
 *
 * @package Kadence Woocommerce Elementor Pro.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Element Product Loop Custom
 */
class Product_Loop_Custom_Meta_Element extends \Elementor\Widget_Base {
	/**
	 * Get Element name.
	 */
	public function get_name() {
		return 'product-loop-custom';
	}
	/**
	 * Get Element Title.
	 */
	public function get_title() {
		return __( 'Product Loop: Custom Meta', 'kadence-woocommerce-elementor-pro' );
	}
	/**
	 * Get Element Icon.
	 */
	public function get_icon() {
		return 'eicon-meta-data';
	}
	/**
	 * Get Element Categories.
	 */
	public function get_categories() {
		return array( 'woocommerce-elements' );
	}
	/**
	 * Element register.
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Custom Meta', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs some custom meta from the product.', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->add_control(
			'meta_field',
			[
				'label' => __( 'Choose Meta Content', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'sku',
				'options' => [
					'sku' => __( 'SKU', 'kadence-woocommerce-elementor-pro' ),
					'categories' => __( 'Product Categories', 'kadence-woocommerce-elementor-pro' ),
					'tags' => __( 'Product Tags', 'kadence-woocommerce-elementor-pro' ),
					'custom'  => __( 'Custom', 'kadence-woocommerce-elementor-pro' ),
				],
			]
		);
		$this->add_control(
			'meta_field_key',
			[
				'label' => __( 'Add Custom Meta Field Key', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'meta_field' => ['custom'],
				],
			]
		);
		$this->add_control(
			'meta_link',
			[
				'label' => __( 'Custom Item Link', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'product',
				'options' => [
					'product' => __( 'Link to Product', 'kadence-woocommerce-elementor-pro' ),
					'none'    => __( 'No Link', 'kadence-woocommerce-elementor-pro' ),
				],
				'condition' => [
					'meta_field' => ['sku', 'custom'],
				],
			]
		);
		$this->add_control(
			'meta_color',
			array(
				'label'     => __( 'Item Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kadence-ele-builder-loop-meta-wrap' => 'color: {{VALUE}};',
				],
			)
		);
		$this->add_control(
			'meta_link_color',
			[
				'label'     => __( 'Link Color', 'kadence-woocommerce-elementor' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kadence-ele-builder-loop-meta-wrap a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'meta_typography',
				'label'    => __( 'Item Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector' => '{{WRAPPER}} .kadence-ele-builder-loop-meta-wrap',
			)
		);

		$this->add_responsive_control(
			'meta_padding',
			[
				'label' => __( 'Item Padding', 'kadence-woocommerce-elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .kadence-ele-builder-loop-meta-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'meta_align',
			array(
				'label'        => __( 'Item Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default'      => 'left',
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Element render.
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( 'ele-p-loop-template' == get_post_type() ) {
			echo '<ul class="products">';
			echo '<li class="product">';
			echo '<span class="kadence-ele-builder-loop-meta-wrap">';
				if ( 'sku' === $settings['meta_field'] ) {
					if ( 'product' === $settings['meta_link'] ) {
						echo '<a href="#" class="kadence-ele-builder-loop-meta-link">';
					}
					echo '<span class="sku_wrapper"><span class="sku_start">' . esc_html__( 'SKU:', 'kadence-woocommerce-elementor-pro' ) . '</span> <span class="sku">' . esc_html__( 'N/A', 'kadence-woocommerce-elementor-pro' ) . '</span></span>';
					if ( 'product' === $settings['meta_link'] ) {
						echo '</a>';
					}
				} else if ( 'categories' === $settings['meta_field'] ) {
					echo '<span class="posted_in">' . __( 'Categories:', 'kadence-woocommerce-elementor-pro' ) .' <a href="#" rel="tag">Books</a> <a href="#" rel="tag">Comics</a></span>';
				} else if ( 'tags' === $settings['meta_field'] ) {
					echo '<span class="tagged_as">' . __( 'Tags:', 'kadence-woocommerce-elementor-pro' ) .' <a href="#" rel="tag">Books</a> <a href="#" rel="tag">Comics</a></span>';
				} else if ( 'custom' === $settings['meta_field'] ) {
					if ( 'product' === $settings['meta_link'] ) {
						echo '<a href="#" class="kadence-ele-builder-loop-meta-link">';
					}
					echo esc_html__( 'Custom Meta Text', 'kadence-woocommerce-elementor-pro' );
					if ( 'product' === $settings['meta_link'] ) {
						echo '</a>';
					}
				}
			echo '</span>';
			echo '</li>';
			echo '</ul>';
		} elseif ( 'product' == get_post_type() ) {
			global $product;
			echo '<span class="kadence-ele-builder-loop-meta-wrap">';
			if ( 'sku' === $settings['meta_field'] ) {
				if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) {
					if ( 'product' === $settings['meta_link'] ) {
						$link = apply_filters( 'woocommerce_loop_product_link', get_the_permalink(), $product );
						echo '<a href="' . esc_url( $link ) . '" class="kadence-ele-builder-loop-meta-link">';
					}
					echo '<span class="sku_wrapper"><span class="sku_start">' . esc_html__( 'SKU:', 'kadence-woocommerce-elementor-pro' ) . '</span> <span class="sku">';
					echo ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'kadence-woocommerce-elementor-pro' );
					echo '</span></span>';
					if ( 'product' === $settings['meta_link'] ) {
						echo '</a>';
					}

				}
			} else if ( 'categories' === $settings['meta_field'] ) {
				echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'kadence-woocommerce-elementor-pro' ) . ' ', '</span>' );
			} else if ( 'tags' === $settings['meta_field'] ) {
				echo wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'kadence-woocommerce-elementor-pro' ) . ' ', '</span>' );
			} else if ( 'custom' === $settings['meta_field'] ) {
				if ( 'product' === $settings['meta_link'] ) {
					$link = apply_filters( 'woocommerce_loop_product_link', get_the_permalink(), $product );
					echo '<a href="' . esc_url( $link ) . '" class="kadence-ele-builder-loop-meta-link">';
				}
				echo get_post_meta( $product->get_id(), $settings['meta_field_key'], true );
				if ( 'product' === $settings['meta_link'] ) {
					echo '</a>';
				}
			}
			echo '</span>';
		}
	}
	/**
	 * Element content template.
	 */
	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Product_Loop_Custom_Meta_Element() );
