<?php
/**
 * Build Elementor Element
 *
 * @package Kadence Woocommerce Elementor Pro.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Element Product Loop Excerpt
 */
class Product_Loop_Excerpt_Element extends \Elementor\Widget_Base {
	/**
	 * Get Element name.
	 */
	public function get_name() {
		return 'product-loop-excerpt';
	}
	/**
	 * Get Element Title.
	 */
	public function get_title() {
		return __( 'Product Loop: Short Description', 'kadence-woocommerce-elementor-pro' );
	}
	/**
	 * Get Element Icon.
	 */
	public function get_icon() {
		return 'eicon-product-description';
	}
	/**
	 * Get Element Categories.
	 */
	public function get_categories() {
		return array( 'woocommerce-elements' );
	}
	/**
	 * Element register.
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Loop Short Description', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the product short description.', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->add_control(
			'excerpt_link',
			[
				'label' => __( 'Short Description Link', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'product' => __( 'Link to Product', 'kadence-woocommerce-elementor-pro' ),
					'none'    => __( 'No Link', 'kadence-woocommerce-elementor-pro' ),
				],
			]
		);
		$this->add_control(
			'excerpt_color',
			array(
				'label'     => __( 'Short Description Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_excerpt' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'excerpt_typography',
				'label'     => __( 'Short Description Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .product_excerpt',
			)
		);

		$this->add_responsive_control(
			'excerpt_padding',
			[
				'label' => __( 'Short Description Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .product_excerpt' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'excerpt_align',
			array(
				'label'        => __( 'Short Description Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default'      => 'left',
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Element render.
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( 'ele-p-loop-template' == get_post_type() ) {
			echo '<ul class="products">';
			echo '<li class="product">';
			echo '<span class="product_excerpt kadence-ele-builder-loop-excerpt-wrap">';
				echo '<p class="woocommerce-loop-product__excerpt">' . esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'kadence-woocommerce-elementor-pro' ) . '</p>';
			echo '</span>';
			echo '</li>';
			echo '</ul>';
		} else {
			if ( 'product' === $settings['excerpt_link'] ) {
				global $product;
				$link = apply_filters( 'woocommerce_loop_product_link', get_the_permalink(), $product );
				echo '<a href="' . esc_url( $link ) . '" class="product_excerpt kadence-ele-builder-loop-excerpt-wrap kadence-ele-builder-loop-excerpt-link">';
			} else {
				echo '<div class="product_excerpt kadence-ele-builder-loop-excerpt-wrap">';
			}
			global $post;
			if ( $post->post_excerpt ) {
				echo apply_filters( 'kadence_archive_woocommerce_short_description', $post->post_excerpt );
			}
			if ( 'product' === $settings['excerpt_link'] ) {
				echo '</a>';
			} else {
				echo '</div>';
			}
		}
	}
	/**
	 * Element content template.
	 */
	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Product_Loop_Excerpt_Element() );
