<?php
/**
 * Build Elementor Element
 *
 * @package Kadence Woocommerce Elementor Pro.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Element Product Loop Image
 */
class Product_Loop_Image_Element extends \Elementor\Widget_Base {
	/**
	 * Get Element name.
	 */
	public function get_name() {
		return 'product-loop-image';
	}
	/**
	 * Get Element Title.
	 */
	public function get_title() {
		return __( 'Product Loop: Image', 'kadence-woocommerce-elementor-pro' );
	}
	/**
	 * Get Element Icon.
	 */
	public function get_icon() {
		return 'eicon-image';
	}
	/**
	 * Get Element Categories.
	 */
	public function get_categories() {
		return array( 'woocommerce-elements' );
	}
	/**
	 * Element register.
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Loop Image', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the product image.', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->add_control(
			'image_link',
			[
				'label' => __( 'Image Link', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'product',
				'options' => [
					'product' => __( 'Link to Product', 'kadence-woocommerce-elementor-pro' ),
					'none'    => __( 'No Link', 'kadence-woocommerce-elementor-pro' ),
				],
			]
		);
		$this->add_control(
			'overlay_background_color',
			[
				'label' => __( 'Image Overlay Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kadence-ele-builder-loop-image-overlay' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'sale_flash_content',
			array(
				'label' => __( 'Sale Flash', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'show_sale',
			[
				'label' => __( 'Sale Flash (only shows on products that are on sale)', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'show',
				'options' => [
					'show' => __( 'Enable', 'kadence-woocommerce-elementor-pro' ),
					'hide' => __( 'Disable', 'kadence-woocommerce-elementor-pro' ),
				],
			]
		);
		$this->add_control(
			'sale_flash_color',
			array(
				'label'     => __( 'Sale Flash: Text Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_sale' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .onsale' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'sale_flash_typography',
				'label'     => __( 'Sale Flash: Typography', 'kadence-woocommerce-elementor-pro' ),
				'condition' => [
					'show_sale' => 'show',
				],
				'selector'  => '{{WRAPPER}} .onsale',
			)
		);
		$this->add_control(
			'sale_flash_background_color',
			[
				'label' => __( 'Sale Flash: Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_sale' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .onsale' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'sale_flash_border',
				'placeholder' => '1px',
				'default' => '0',
				'condition' => [
					'show_sale' => 'show',
				],
				'selector' => '{{WRAPPER}} .onsale',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sale_flash_border_radius',
			[
				'label' => __( 'Sale Flash: Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'condition' => [
					'show_sale' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .onsale' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'sale_flash_box_shadow',
				'condition' => [
					'show_sale' => 'show',
				],
				'label' => __( 'Sale Flash: Box Shadow', 'kadence-woocommerce-elementor-pro' ),
				'selector' => '{{WRAPPER}} .onsale',
			]
		);

		$this->add_responsive_control(
			'sale_flash_padding',
			[
				'label' => __( 'Sale Flash: Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition' => [
					'show_sale' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .onsale' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'sale_flash_align',
			array(
				'label'        => __( 'Sale Flash: Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'condition' => [
					'show_sale' => 'show',
				],
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'kt-woo-flash-align-',
				'default'      => 'left',
			)
		);
		$this->add_control(
			'sale_flash_valign',
			[
				'label' => __( 'Sale Flash: Vertical Alignment', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'condition' => [
					'show_sale' => 'show',
				],
				'options' => [
					'top' => __( 'Top', 'elementor' ),
					'middle' => __( 'Middle', 'elementor' ),
					'bottom' => __( 'Bottom', 'elementor' ),
				],
				'default' => 'top',
				'prefix_class' => 'kt-woo-flash-vertical-align-',
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'price_content',
			array(
				'label' => __( 'Price Overlay', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'show_price',
			[
				'label' => __( 'Price Overlay', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'hide',
				'options' => [
					'show' => __( 'Enable', 'kadence-woocommerce-elementor-pro' ),
					'hide' => __( 'Disable', 'kadence-woocommerce-elementor-pro' ),
				],
			]
		);
		$this->add_control(
			'price_color',
			array(
				'label'     => __( 'Price: Text Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_price' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .price, .woocommerce .products {{WRAPPER}} .price' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'price_typography',
				'label'     => __( 'Price: Typography', 'kadence-woocommerce-elementor-pro' ),
				'condition' => [
					'show_price' => 'show',
				],
				'selector'  => '{{WRAPPER}} .price, .woocommerce .products {{WRAPPER}} .price',
			)
		);
		$this->add_control(
			'price_background_color',
			[
				'label' => __( 'Price: Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_price' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .price, .woocommerce .products {{WRAPPER}} .price' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'price_border',
				'placeholder' => '1px',
				'default' => '0',
				'condition' => [
					'show_price' => 'show',
				],
				'selector' => '{{WRAPPER}} .price, .woocommerce .products {{WRAPPER}} .price',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'price_border_radius',
			[
				'label' => __( 'Price: Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'condition' => [
					'show_price' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .price, .woocommerce .products {{WRAPPER}} .price' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'price_box_shadow',
				'condition' => [
					'show_price' => 'show',
				],
				'label' => __( 'Price: Box Shadow', 'kadence-woocommerce-elementor-pro' ),
				'selector' => '{{WRAPPER}} .price, .woocommerce .products {{WRAPPER}} .price',
			]
		);

		$this->add_responsive_control(
			'price_padding',
			[
				'label' => __( 'Price: Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition' => [
					'show_price' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .price, .woocommerce .products {{WRAPPER}} .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'price_margin',
			[
				'label' => __( 'Price: Margin', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition' => [
					'show_price' => 'show',
				],
				'selectors' => [
					'{{WRAPPER}} .price, , .woocommerce .products {{WRAPPER}} .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'price_align',
			array(
				'label'        => __( 'Price: Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'condition' => [
					'show_price' => 'show',
				],
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'kt-woo-price-align-',
				'default'      => 'right',
			)
		);
		$this->add_control(
			'price_valign',
			[
				'label' => __( 'Price: Vertical Alignment', 'elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'condition' => [
					'show_price' => 'show',
				],
				'options' => [
					'top' => __( 'Top', 'elementor' ),
					'middle' => __( 'Middle', 'elementor' ),
					'bottom' => __( 'Bottom', 'elementor' ),
				],
				'default' => 'top',
				'prefix_class' => 'kt-woo-price-vertical-align-',
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Element render.
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( 'ele-p-loop-template' == get_post_type() ) {
			echo '<ul class="products">';
			echo '<li class="product">';
			echo '<div class="kadence-ele-builder-loop-image-wrap kadence-ele-builder-loop-image-link">';
			if ( 'show' === $settings['show_sale'] ) {
				echo '<span class="onsale">' . esc_html__( 'Sale!', 'kadence-woocommerce-elementor-pro' ) . '</span>';
			}
			if ( 'show' === $settings['show_price'] ) {
				echo '<span class="price"><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">$</span>40.00</span></span>';
			}
			$image_size = apply_filters( 'single_product_archive_thumbnail_size', 'woocommerce_thumbnail' );
			echo wc_placeholder_img( $image_size );
			echo '<div class="kadence-ele-builder-loop-image-overlay"></div>';
			echo '</div>';
			echo '</li>';
			echo '</ul>';
		} elseif ( 'product' == get_post_type() ) {
			if ( 'product' === $settings['image_link'] ) {
				global $product;
				$link = apply_filters( 'woocommerce_loop_product_link', get_the_permalink(), $product );
				echo '<a href="' . esc_url( $link ) . '" class="kadence-ele-builder-loop-image-wrap kadence-ele-builder-loop-image-link">';
			} else {
				echo '<div class="kadence-ele-builder-loop-image-wrap">';
			}
			if ( 'show' === $settings['show_sale'] ) {
				woocommerce_show_product_loop_sale_flash();
			}
			if ( 'show' === $settings['show_price'] ) {
				woocommerce_template_loop_price();
			}
				woocommerce_template_loop_product_thumbnail();
				echo '<div class="kadence-ele-builder-loop-image-overlay"></div>';
			if ( 'product' === $settings['image_link'] ) {
				echo '</a>';
			} else {
				echo '</div>';
			}
		}
	}
	/**
	 * Element content template.
	 */
	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Product_Loop_Image_Element() );
