<?php
/**
 * Build Elementor Element
 *
 * @package Kadence Woocommerce Elementor Pro.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Element Product Loop Title
 */
class Product_Loop_Title_Element extends \Elementor\Widget_Base {
	/**
	 * Get Element name.
	 */
	public function get_name() {
		return 'product-loop-title';
	}
	/**
	 * Get Element Title.
	 */
	public function get_title() {
		return __( 'Product Loop: Title', 'kadence-woocommerce-elementor-pro' );
	}
	/**
	 * Get Element Icon.
	 */
	public function get_icon() {
		return 'eicon-product-title';
	}
	/**
	 * Get Element Categories.
	 */
	public function get_categories() {
		return array( 'woocommerce-elements' );
	}
	/**
	 * Element register.
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Loop Title', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the product title.', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->add_control(
			'title_link',
			[
				'label' => __( 'Title Link', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'product',
				'options' => [
					'product' => __( 'Link to Product', 'kadence-woocommerce-elementor-pro' ),
					'none'    => __( 'No Link', 'kadence-woocommerce-elementor-pro' ),
				],
			]
		);
		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'Title Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-loop-product__title' => 'color: {{VALUE}};',
				],
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'title_typography',
				'label'     => __( 'Title Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .woocommerce-loop-product__title',
			)
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' => __( 'Title Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-loop-product__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-loop-product__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'title_align',
			array(
				'label'        => __( 'Title Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default'      => 'left',
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Element render.
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( 'ele-p-loop-template' == get_post_type() ) {
			echo '<ul class="products">';
			echo '<li class="product">';
			echo '<span class="kadence-ele-builder-loop-title-wrap kadence-ele-builder-loop-title-link">';
				echo '<h2 class="woocommerce-loop-product__title">' . esc_html__( 'Product Title', 'kadence-woocommerce-elementor-pro' ) . '</h2>';
			echo '</span>';
			echo '</li>';
			echo '</ul>';
		} elseif ( 'product' == get_post_type() ) {
			if ( 'product' === $settings['title_link'] ) {
				global $product;
				$link = apply_filters( 'woocommerce_loop_product_link', get_the_permalink(), $product );
				echo '<a href="' . esc_url( $link ) . '" class="kadence-ele-builder-loop-title-wrap kadence-ele-builder-loop-title-link">';
			} else {
				echo '<span class="kadence-ele-builder-loop-title-wrap">';
			}
				woocommerce_template_loop_product_title();
			if ( 'product' === $settings['title_link'] ) {
				echo '</a>';
			} else {
				echo '</span>';
			}
		}
	}
	/**
	 * Element content template.
	 */
	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Product_Loop_Title_Element() );
