<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
\Elementor\Plugin::$instance->frontend->add_body_class( 'elementor-template-full-width' );

$theme = wp_get_theme(); // gets the current theme
if ( 'Virtue - Premium' == $theme->name || 'Virtue - Premium' == $theme->parent_theme ) {

} else {
	get_header( 'shop' );
}
/**
 * Before Header-Footer page template content.
 *
 * Fires before the content of Elementor Header-Footer page template.
 *
 * @since 2.0.0
 */
do_action( 'elementor/page_templates/header-footer/before_content' ); ?>

    <?php
		/**
		 * kt_woocommerce_archive_builder
		 *
		 */
		do_action( 'kadence_woocommerce_archive_builder' );
		?>

<?php 

/**
 * After Header-Footer page template content.
 *
 * Fires after the content of Elementor Header-Footer page template.
 *
 * @since 2.0.0
 */
do_action( 'elementor/page_templates/header-footer/after_content' );

if ( 'Virtue - Premium' == $theme->name || 'Virtue - Premium' == $theme->parent_theme ) {

} else {
 	get_footer( 'shop' ); 
 } ?>
