<?php
/**
 * Plugin Name: Analytify Authors Tracking
 * Plugin URI: https://analytify.io/add-ons/authors-tracking/?utm_source=analytify-authors&utm_medium=plugin-uri
 * Description: Analytify's Authors Tracking Addon will enable you to track the performance of various authors on your website. This will help in deciding  which Authors are performing the best for your website.
 * Version: 5.0.0
 * Author: WPBrigade
 * Author URI: https://wpbrigade.com/?utm_source=analytify-authors&utm_medium=author-uri
 * Text Domain: wp-analytify-authors
 * Domain Path: /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	die;
}

update_option( 'analytify_authors_license_status', 'valid' );
      update_option( 'analytify_authors_license_key' , 'B5E0B5F8DD8689E6ACA49DD6E6E1A930' );

// Currently plugin version.
define( 'ANALYTIFY_AUTHORS_DASHBOARD_VERSION', '5.0.0' );

// The URL of the plugin directory.
define( 'ANALYTIFY_AUTHORS_ROOT_PATH', dirname( __FILE__ ) );

// The minimum version of Analytify.
define( 'ANALYTIFY_AUTHORS_DASHBOARD_MIN_V_ANALYTIFY', '4.0.0' );

// The minimum version of Analytify Pro.
define( 'ANALYTIFY_AUTHORS_DASHBOARD_MIN_V_ANALYTIFY_PRO', '4.0.0' );

/**
 * Run Analytify Google Optimize.
 *
 * @return void
 */
function run_analytify_authors_dashboard() {

	if ( ! wpa_authors_dashboard_check_dependencies() ) {
		return;
	}

	// The core plugin class.
	require plugin_dir_path( __FILE__ ) . 'classes/analytify-author-tracking.php';
	require plugin_dir_path( __FILE__ ) . 'classes/class-analytify-author-rest-api.php';

	new Analytify_Authors();
}

add_action( 'plugins_loaded', 'run_analytify_authors_dashboard', 30 );

/**
 * Load the required dependencies for this plugin.
 *
 * @since    1.0.0
 *
 * @return bool
 */
function wpa_authors_dashboard_check_dependencies() {

	$prevent = false;

	if ( ! file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' ) ) {
		add_action( 'admin_notices', 'wpa_authors_dashboard_install_analytify_pro' );
		$prevent = true;
	} elseif ( ! class_exists( 'WP_Analytify_Pro_Base' ) ) {
		add_action( 'admin_notices', 'wpa_authors_dashboard_active_analytify_pro' );
		$prevent = true;
	}

	if ( $prevent ) {
		add_action( 'admin_enqueue_scripts', 'wpa_authors_dashboard_notices_scripts' );
		return false;
	}

	// Load the main plugin file.
	if ( ! function_exists( 'get_plugins' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}

	$plugins = get_plugins();

	// Check for the main plugin version.
	if ( ! isset( $plugins['wp-analytify/wp-analytify.php'] ) || version_compare( $plugins['wp-analytify/wp-analytify.php']['Version'], ANALYTIFY_AUTHORS_DASHBOARD_MIN_V_ANALYTIFY, '<' ) ) {
		add_action( 'admin_notices', 'wpa_authors_dashboard_notice_version_analytify' );
	}

	// Check for the pro version.
	if ( ! isset( $plugins['wp-analytify-pro/wp-analytify-pro.php'] ) || version_compare( $plugins['wp-analytify-pro/wp-analytify-pro.php']['Version'], ANALYTIFY_AUTHORS_DASHBOARD_MIN_V_ANALYTIFY_PRO, '<' ) ) {
		add_action( 'admin_notices', 'wpa_authors_dashboard_notice_version_analytify_pro' );
	}

	return true;
}

/**
 * Admin notices scripts.
 *
 * @return void
 */
function wpa_authors_dashboard_notices_scripts() {
	wp_enqueue_style( 'analytify_authors_dashboard_notices', plugins_url( 'assets/css/notices.css', __FILE__  ), ANALYTIFY_AUTHORS_DASHBOARD_VERSION );
}

/**
 * Check If Analytify Pro is installed.
 *
 * @since 1.0.0
 *
 * @return void
 */
function wpa_authors_dashboard_install_analytify_pro() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-authors' ) . '</strong> ' . esc_html__( 'Please Install Analytify Pro to use Analytify Authors Dashboard addon.', 'wp-analytify-authors' );
	wpa_authors_dashboard_notice_markup( $message, 'wp-analytify-danger' );
}

/**
 * Admin notices for the Analytify version.
 *
 * @return void
 */
function wpa_authors_dashboard_notice_version_analytify() {
	// translators: %s: analytify min supported version.
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-authors' ) . '</strong> ' . sprintf( esc_html__( 'The minimum version of Analytify required for Analytify Authors Dashboard addon is %s. You need to update Analytify Core (Free).', 'wp-analytify-authors' ), ANALYTIFY_AUTHORS_DASHBOARD_MIN_V_ANALYTIFY );
	wpa_authors_dashboard_notice_markup( $message, 'wp-analytify-danger' );
}

/**
 * Admin notices for the Analytify Pro version.
 *
 * @return void
 */
function wpa_authors_dashboard_notice_version_analytify_pro() {
	// translators: %s: analytify min supported version.
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-authors' ) . '</strong> ' . sprintf( esc_html__( 'The minimum version of Analytify Pro required for Analytify Authors Dashboard addon is %s. You need to update Analytify Pro.', 'wp-analytify-authors' ), ANALYTIFY_AUTHORS_DASHBOARD_MIN_V_ANALYTIFY );
	wpa_authors_dashboard_notice_markup( $message, 'wp-analytify-danger' );
}

/**
 * Check if Analytify Pro is activated.
 *
 * @since 1.0.0
 *
 * @return void
 */
function wpa_authors_dashboard_active_analytify_pro() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-authors' ) . '</strong> ' . esc_html__( 'Please activate Analytify Pro to use Analytify Authors Dashboard addon.', 'wp-analytify-authors' );
	wpa_authors_dashboard_notice_markup( $message, 'wp-analytify-danger' );
}

/**
 * Dashboard notices markup.
 *
 * @param string $message Message to display.
 * @param string $class   Class to add to the notice.
 *
 * @return void
 */
function wpa_authors_dashboard_notice_markup( $message, $class ) {
	echo '<div class="wp-analytify-notification ' . $class . '">
		<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
		<div class="wp-analytify-notice-logo">
			<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
		</div>
		<div class="wp-analytify-notice-discription">
			<p>' . $message . '</p>
		</div>
	</div>';
}

/**
 * Load TextDoamin
 *
 * @since 1.0
 */
function analytify_authors_load_textdomain() {
	$plugin_dir = basename( dirname( __FILE__ ) );
	load_plugin_textdomain( 'wp-analytify-authors', false, $plugin_dir . '/languages/' );
}
add_action( 'init', 'analytify_authors_load_textdomain' );
