jQuery(document).ready(function ($) {

    var doing_license_registration_ajax = false;
    var admin_url = ajaxurl.replace('/admin-ajax.php', ''),
        spinner_url = admin_url + '/images/spinner';

    if (2 < window.devicePixelRatio) {
        spinner_url += '-2x';
    }
    spinner_url += '.gif';

    var ajax_spinner = '<img src="' + spinner_url + '" alt="" class="ajax-spinner general-spinner" />';

    $(document).on('click', "#analytify_campaigns_license_activate", function (e) {

        e.preventDefault();

        if (doing_license_registration_ajax) {
            return;
        }

        $('#campaigns-license-status').removeClass('notification-message error-notice');

        var license_key = $.trim($("#analytify_campaigns_license_key").val());

        if ('' === license_key) {
            $('#campaigns-license-status').addClass('notification-message error-notice');
            $('#campaigns-license-status').html(wpanalytify_strings.enter_license_key);
            return;
        }

        $('#campaigns-license-status').empty().removeClass('success-notice');
        doing_license_registration_ajax = true;
        $('#analytify_campaigns_license_activate').after('<img src="' + spinner_url + '" alt="" class="register-license-ajax-spinner general-spinner" />');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            dataType: 'JSON',
            cache: false,
            data: {
                action: 'wpanalytify_campaigns_activate_license',
                campaigns_license_key: license_key,
                nonce: wpanalytify_data.nonces.activate_license,
                context: 'license'
            },
            error: function (jqXHR, textStatus, errorThrown) {
                doing_license_registration_ajax = false;
                $('.register-license-ajax-spinner').remove();
                $('#campaigns-license-status').html(wpanalytify_strings.register_license_problem);
            },
            success: function (data) {
                doing_license_registration_ajax = false;
                $('.register-license-ajax-spinner').remove();


                if ('undefined' !== typeof data.error) {

                    $('#campaigns-license-status').addClass('notification-message error-notice');
                    $('#campaigns-license-status').html(data.error);

                } else if (data == '0') {

                    $('#campaigns-license-status').addClass('notification-message error-notice');
                    $('#campaigns-license-status').html(wpanalytify_strings.register_license_problem);
                } else {
                    $('#campaigns-license-status').html(wpanalytify_strings.license_registered).delay(5000).fadeOut(1000);
                    $('#campaigns-license-status').addClass('notification-message success-notice');
                    $('#analytify_campaigns_license_key, #analytify_campaigns_license_activate').remove();
                    $('.campaigns-license-row').prepend(data.masked_license);

                }
            }
        });
    });


    wp_analytify_campaign_paginated = function () {

        $('table.wp_analytify_campaign_paginated').each(function () {
            var currentPage = 0;
            var numPerPage = $(this).data('product-per-page') ? $(this).data('product-per-page') : 5;
            var $table = $(this);
            var $pager = $('<div class="wp_analytify_pager"></div>');

            $(this).next('.wp_analytify_campaign_pagination_wraper').html($pager);
            $table.bind('repaginate', function () {
                $table.find('tbody tr').hide();

                $filteredRows = $table.find('tbody tr');

                $filteredRows.slice(currentPage * numPerPage, (currentPage + 1) * numPerPage).show();

                var numRows = $filteredRows.length;
                var numPages = Math.ceil(numRows / numPerPage);

                $pager.find('.page-number, .previous, .next').remove();
                // Show pagination if page is greate than 1.
                if (numPages > 1) {
                    for (var page = 0; page < numPages; page++) {
                        var $newPage = $('<span class="page-number"></span>').text(page + 1).bind('click', {
                            newPage: page
                        }, function (event) {
                            currentPage = event.data['newPage'];
                            $table.trigger('repaginate');
                        });
                        if (page == currentPage) {
                            $newPage.addClass('clickable wp_analytify_active');
                        } else {
                            $newPage.addClass('clickable');
                        }
                        $newPage.appendTo($pager);
                    }
                }
            });
            $table.trigger('repaginate');
        });

    };

    $(document).on('click', '.analytify-view-detail-campaings', function (event) {
        event.preventDefault();

        // don't send the request if already stats loaded.
        if ('disabled' == $(this).attr('disabled')) {
            return;
        }

        $(this).attr('disabled', 'disabled');
        const campaign_name = $(this).data('source');
        const parent_container = $(this).closest('.pa_campaigns_statistics');


        $.ajax({
            url: JSON.parse(analytify_campaigns.resturl),
            data: {
                'cn': campaign_name,
                'sd': $("#analytify_date_start").val(),
                'ed': $("#analytify_date_end").val(),
            },
            beforeSend: function (xhr) {
                xhr.setRequestHeader('X-WP-Nonce', analytify_campaigns.restnonce);
                parent_container.addClass("campaigns_statistics_active").find('.analytify-detail-campaings-container').addClass("stats_loading");
            },
        })
            .done(function (data) {
                parent_container.find('.analytify-detail-campaings-container').removeClass("stats_loading").html(data.body);
                wp_analytify_campaign_paginated();
            });

    });
});
