<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

ob_start();

$i = 0;

if ( ! empty( $stats['rows'] ) ) {
	foreach ( $stats['rows'] as $row ) {
		$i++;
		?>

		<div class="pa_campaigns_statistics">
			<div class="pa-tdo-left">
				<div class="pa_data_text_wraper">
					<span class="large-count"><?php echo $row['sessionCampaignName']; ?></span>
					<?php
					if ( '(not set)' === $row['sessionCampaignName'] ) {
						?>
						<span class="dashicons dashicons-editor-help analytify-campaings-tooltip" title="<?php esc_html_e( 'Not Set: The \'keyword\' (not set) simply identifies traffic that doesn\'t arrive via a particular keyword and hence may not come via any search at all. This includes traffic coming from email, referral sites, or even things like Google Images.', 'wp-analytify-campaings' ); ?>"></span>
						<?php
					}
					?>
					<br /><br />
					<?php
					if ( class_exists( 'WP_Analytify_WooCommerce' ) && '(not set)' !== $row['sessionCampaignName'] ) {
						?>
						<a href="<?php echo admin_url( 'admin.php?page=analytify-woocommerce&cn=' . $row['sessionCampaignName'] ); ?>" style="display:block;margin-top:10px;"><?php esc_html_e( 'View Sale Stats', 'wp-analytify-campaings' ); ?></a>
						<?php
					}
					?>
					<a href="#" class="analytify-view-detail-campaings" data-source="<?php echo $row['sessionCampaignName']; ?>"><?php esc_html_e( 'View Detail Stats', 'wp-analytify-campaings' ); ?></a>
				</div>
			</div>
			<div class="pa-tdo-right" id="pa-tdo-right">
				<div class="pa-bigtext">
					<span class="count-visits"><?php echo number_format( $row['sessions'] ); ?></span>
					<span class="source"><?php analytify_e( 'Sessions', 'wp-analytify' ); ?></span>
				</div>

				<div class="pa-bigtext">
					<span class="count-visits">
						<?php
						echo ! empty( $row['newUsers'] ) && ! empty( $row['sessions'] ) && $row['sessions'] > 0 ? number_format( round( ( $row['newUsers'] / $row['sessions'] ) * 100, 2 ), 2 ) : '0';
						?>
					</span>
					<span class="source"><?php analytify_e( '% New Sessions', 'wp-analytify' ); ?></span>
				</div>

				<div class="pa-bigtext">
					<span class="count-visits"><?php echo $row['newUsers']; ?></span>
					<span class="source"><?php esc_html_e( 'New Users', 'wp-analytify-campaings' ); ?></span>
				</div>
			</div>
			<div class="pa-tdo-rights" id="pa-tdo-rights">

				<div class="pa-bigtext">
					<span class="count-visits"><?php echo $row['bounceRate'] ? WPANALYTIFY_Utils::pretty_numbers( $row['bounceRate'] ) . '%' : '0%'; ?></span>
					<span class="source"><?php analytify_e( 'Bounce Rate', 'wp-analytify' ); ?></span>
				</div>

				<div class="pa-bigtext">
					<span class=" count-visits"><?php echo ! empty( $row['sessions'] ) ? number_format( round( $row['screenPageViews'] / $row['sessions'], 2 ), 2 ) : '0'; ?></span>
					<span class="source"><?php esc_html_e( 'Pages / Session', 'wp-analytify-campaings' ); ?></span>
				</div>

				<div class="pa-bigtext">
					<span class="count-visits"><?php echo WPANALYTIFY_Utils::pretty_time( $row['averageSessionDuration'] ); ?></span>
					<span class="source"><?php esc_html_e( 'Avg. Session duration', 'wp-analytify-campaings' ); ?></span>
				</div>
			</div>
			<div class="analytify-detail-campaings-container"></div>
		</div>

		<?php
	}
} else {
	esc_html_e( 'No Campaigns.', 'wp-analytify-campaings' );
}

$body = ob_get_clean();

echo wp_json_encode(
	array(
		'message' => $i,
		'body'    => $body,
	)
);

