<?php

// global $wpa_edd_currency_symbol;

$WP_Analytify   = $GLOBALS['WP_ANALYTIFY'];

$start_date_val = strtotime( "- 30 days" );
$end_date_val   = strtotime( "now" );
$start_date     = date( "Y-m-d", $start_date_val );
$end_date       = date( "Y-m-d", $end_date_val );

if ( isset( $_POST['analytify_date_start'] ) && ! empty( $_POST['analytify_date_start'] ) && isset( $_POST['analytify_date_end'] ) && ! empty( $_POST['analytify_date_end'] ) ) {
	$start_date	= sanitize_text_field( wp_unslash( $_POST['analytify_date_start'] ) );
	$end_date	= sanitize_text_field( wp_unslash( $_POST['analytify_date_end'] ) );
}

// Fetch Dashboard Profile ID.
$dashboard_profile_ID = $WP_Analytify->settings->get_option( 'profile_for_dashboard','wp-analytify-profile' );
$version = defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION;
$wp_analytify = $GLOBALS['WP_ANALYTIFY'];

	if( ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection('EDD') ) {

	/**
	 * Check with roles assigned at dashboard settings.
	 */
	$is_access_level = $WP_Analytify->settings->get_option( 'show_analytics_roles_dashboard', 'wp-analytify-dashboard', array() );

	if( $WP_Analytify->pa_check_roles( $is_access_level ) ) {

		$acces_token = get_option( "post_analytics_token" );

		if( $acces_token ) { ?>

			<div class="wpanalytify analytify-dashboard-nav">
				<div class="wpb_plugin_wraper">
					<div class="wpb_plugin_header_wraper">
						<div class="graph"></div>
						<div class="wpb_plugin_header">
							<div class="wpb_plugin_header_title"></div>
							<div class="wpb_plugin_header_info">
								<a href="https://analytify.io/changelog/" target="_blank" class="btn">Changelog - v<?php echo $version; ?></a>
							</div>
							<div class="wpb_plugin_header_logo">
								<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg'?>" alt="Analytify">
							</div>
						</div>
					</div>

					<div class="analytify-dashboard-body-container">
						<div class="wpb_plugin_body_wraper">
								<div class="wpb_plugin_body">
									<div class="wpa-tab-wrapper">
										<?php
										if ( method_exists( $GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation' ) ) {
											echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation();
										}
										?>
									</div>
									<div class="wpb_plugin_tabs_content analytify-dashboard-content">
									<div class="analytify_wraper">
										<div class="analytify_main_title_section">
											<div class="analytify_dashboard_title">
												<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'EDD Dashboard', 'wp-analytify' ); ?></h1>
												<?php is_callable( array('WPANALYTIFY_Utils', 'dashboard_subtitle_section') ) ? WPANALYTIFY_Utils::dashboard_subtitle_section() : ''; ?>
											</div>

											<div class="analytify_main_setting_bar">
												<div class="analytify_pull_right analytify_setting">
													<div class="analytify_select_date">
														<?php
														if ( method_exists( 'WPANALYTIFY_Utils', 'date_form' )  ) {
															WPANALYTIFY_Utils::date_form( $start_date, $end_date );
														}
														?>
													</div>
												</div>
											</div>
											<!-- <div class="analytify_select_dashboard analytify_pull_right"> <?php // do_action( 'analytify_dashboad_dropdown' ); ?> </div> -->
										</div>

										<?php
										// Shopping analysis (general stats).
										if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
											$stats = $WP_Analytify->get_reports(
												'edd-shopping-analysis-stats',
												array(
													'transactions',
													'totalRevenue',
													'averagePurchaseRevenue',
													//'ga:refundAmount, TODO: missing_ga4
													//'ga:transactionsPerSession, TODO: missing_ga4
													'addToCarts',
													//'ga:productRemovesFromCart, TODO: missing_ga4
													'checkouts',
													'itemViews',
													//'ga:totalRefunds, TODO: missing_ga4
												),
												array(
													'start' => $start_date,
													'end'   => $end_date,
												),
												array(),
												array(),
												array(),
												10
											);

											include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/shopping-analysis.php';
											pa_include_edd( $WP_Analytify, $stats );
										} else {
											$stats = $WP_Analytify->pa_get_analytics_dashboard(  'ga:transactions,ga:transactionRevenue,ga:revenuePerTransaction,ga:refundAmount,ga:transactionsPerSession,ga:productAddsToCart,ga:productRemovesFromCart,ga:productCheckouts,ga:productDetailViews,ga:totalRefunds', $start_date, $end_date , false , false, false, false, false, 'edd-shopping-analysis-stats' );

											if ( isset( $stats->totalsForAllResults ) ) {
												include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/shopping-analysis-deprecated.php';
												pa_include_edd( $WP_Analytify, $stats );
											}
										}

										// Country Stats
										if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
											$stats = $WP_Analytify->get_reports(
												'edd-country-performance-stats',
												array(
													'ecommercePurchases',
													'purchaseRevenue',
													'transactions',
												),
												array(
													'start' => $start_date,
													'end'   => $end_date,
												),
												array(
													'country',
												),
												array(
													'type'  => 'metric',
													'name'  => 'ecommercePurchases',
													'order' => 'desc',
												),
												array(
													/*'logic'   => 'AND',
													'filters' => array(
														array(
															'type'           => 'dimension',
															'name'           => 'country',
															'match_type'     => 4,
															'value'          => '(not set)',
															'not_expression' => true,
														),
													),*/
												),
												10
											);
											include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/country-performance.php';
											pa_include_country_performance( $WP_Analytify, $stats );
										} else {
											$stats = $WP_Analytify->pa_get_analytics_dashboard( 'ga:itemQuantity,ga:transactionRevenue', $start_date, $end_date,'ga:country','-ga:itemQuantity', 'ga:country!=(not set);ga:itemQuantity>0', 10, 'edd-country-performance-stats' );

											if ( isset( $stats->totalsForAllResults ) ) {
												include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/country-performance-deprecated.php';
												pa_include_country_performance( $WP_Analytify, $stats );
											}
										}

										if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
											$stats = $WP_Analytify->get_reports(
												'edd-roi-stats',
												array(
													'sessions',
													'bounceRate',
													'purchaseRevenue',
												),
												array(
													'start' => $start_date,
													'end'   => $end_date,
												),
												array(
													'sourceMedium',
												),
												array(
													'type'  => 'metric',
													'name'  => 'purchaseRevenue',
													'order' => 'desc',
												),
												array(),
												20
											);
											include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/measuring-roi.php';
											pa_include_edd_measuring_roi( $WP_Analytify, $stats );
										} else {
											$stats = $WP_Analytify->pa_get_analytics_dashboard( 'ga:sessions,ga:bounceRate,ga:transactions,ga:transactionRevenue', $start_date, $end_date,'ga:sourceMedium','-ga:transactionRevenue', 'ga:transactionRevenue>0', 20, 'edd-roi-stats' );
											if ( isset( $stats->totalsForAllResults ) ) {
												include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/measuring-roi-deprecated.php';
												pa_include_edd_measuring_roi( $WP_Analytify, $stats );
											}
										}

										if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
											$stats = $WP_Analytify->get_reports(
												'edd-products-performance-stats',
												array(
													'itemsViewed',
													'itemRevenue',
													'itemsPurchased',
													'cartToViewRate',
													'itemsAddedToCart',
												),
												array(
													'start' => $start_date,
													'end'   => $end_date,
												),
												array(
													'itemName',
												),
												array(
													'type'  => 'metric',
													'name'  => 'itemsPurchased',
													'order' => 'desc',
												),
												array(
													'logic'   => 'AND',
													'filters' => array(
														array(
															'type'           => 'dimension',
															'name'           => 'itemName',
															'match_type'     => 4,
															'value'          => '(not set)',
															'not_expression' => true,
														),
													),
												),
												50
											);

											include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/products-performance.php';
											pa_include_edd_products( $WP_Analytify, $stats );
										} else {
											$stats = $WP_Analytify->pa_get_analytics_dashboard( 'ga:productListViews,ga:productDetailViews,ga:itemRevenue,ga:uniquePurchases,ga:itemQuantity,ga:cartToDetailRate,ga:buyToDetailRate', $start_date, $end_date, 'ga:productName','-ga:itemQuantity', 'ga:productName!=(not set)', false, 'edd-products-performance-stats' );

											if ( isset( $stats->totalsForAllResults ) ) {
												include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/products-performance-deprecated.php';
												pa_include_edd_products( $WP_Analytify, $stats );
											}
										}

										// $stats = $WP_Analytify->pa_get_analytics_dashboard( 'ga:productListViews,ga:productListClicks,ga:productListCTR,ga:productAddsToCart,ga:productCheckouts,ga:uniquePurchases,ga:itemRevenue', $start_date, $end_date,'ga:productListName','-ga:itemRevenue' );
										// if ( isset( $stats->totalsForAllResults ) ) {
										// 	include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/lists-performance.php';
										// 	pa_include_edd_lists_performance( $WP_Analytify, $stats );
										//   }

										// $stats = $WP_Analytify->pa_get_analytics_dashboard( 'ga:itemRevenue,ga:uniquePurchases,ga:itemQuantity,ga:cartToDetailRate,ga:buyToDetailRate', $start_date, $end_date,'ga:productCategoryHierarchy','-ga:itemQuantity' );
										// if ( isset( $stats->totalsForAllResults ) ) {
										// 	include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/categories-performance.php';
										// 	pa_include_edd_categories_performance( $WP_Analytify, $stats );
										//   }

										if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
											$stats = $WP_Analytify->get_reports(
												'show-woo-coupons-analysis-stats',
												array(
													'purchaseRevenue',
													'transactions',
													'averagePurchaseRevenue',
												),
												array(
													'start' => $start_date,
													'end'   => $end_date,
												),
												array(
													'orderCoupon',
												),
												array(
													'type' => 'dimension',
													'name' => 'orderCoupon',
												),
												array(
													'logic'   => 'AND',
													'filters' => array(
														array(
															'type'           => 'dimension',
															'name'           => 'orderCoupon',
															'match_type'     => 4,
															'value'          => '(not set)',
															'not_expression' => true,
														),
													),
												),
												10
											);

											include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/coupons.php';
											pa_include_edd_coupons_performance( $WP_Analytify, $stats );
										} else {
											$stats = $WP_Analytify->pa_get_analytics_dashboard( 'ga:transactionRevenue,ga:transactions,ga:revenuePerTransaction', $start_date, $end_date, 'ga:orderCouponCode', '-ga:orderCouponCode', 'ga:orderCouponCode!=(not set)', 10, 'edd-coupons-stats' );

											if ( isset( $stats->totalsForAllResults ) ) {
												include EDD_ANALYTIFY_PLUGIN_DIR . '/views/default/coupons-deprecated.php';
												pa_include_edd_coupons_performance( $WP_Analytify, $stats );
											}
										}

								} else {
									esc_html_e( 'You must be logged in to see the Analytics Dashboard.', 'wp-analytify-edd' );
								}
							} else {
								esc_html_e( 'You don\'t have access to EDD Dashboard.', 'wp-analytify-edd' );
							}
						}
						?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>