<?php

	/**
	 *  Show Products performance order by sales quantity.
	 *
	 * @param  object $current Analytify Free Objext.
	 * @param  object $stats   Contains stats that are fetch from google.
	 *
	 * @since  1.0.0
	 */
function pa_include_edd_products( $current, $stats ) {

	 if ( isset( $stats['rows'] ) && isset( $stats['rows'][0]['itemName'] ) ) {
		$famous = $stats['rows'][0]['itemName']; 
	} 

	?>
	<div class="analytify_general_status analytify_status_box_wraper">
		<div class="analytify_status_header">
			<h3><?php esc_html_e( 'Products Performance', 'wp-analytify-edd' ); ?></h3>
		</div>
		<div class="analytify_status_body">

			<table class="analytify_data_tables">
				<thead>
					<tr>
						<th class="wd_1">
							#
						</th>
						<th>
							<?php esc_html_e( 'Name', 'wp-analytify-edd' ); ?>
						</th>
						<th>
							<?php esc_html_e( 'Product Revenue', 'wp-analytify-edd' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Product Views', 'wp-analytify-edd' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Unique Purchases', 'wp-analytify-edd' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Items Added To Cart', 'wp-analytify-edd' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Cart-to-Detail Rate', 'wp-analytify-edd' ); ?>
						</th>
						<!-- <th class="">
							<?php // esc_html_e( 'Buy-to-Detail Rate', 'wp-analytify-edd' ); ?>
						</th> -->
					</tr>
				</thead>
				<tbody>

					<?php if ( ! empty( $stats["rows"] ) ) {
						$i=0;
						foreach ( $stats["rows"] as $stat ) {
							$i++;
							?>
							<tr>
								<td>
									<?php echo $i; ?>
								</td>
								<td>
									<?php echo $stat['itemName']; ?>
								</td>
								<td class="analytify_txt_center">
									<?php echo edd_currency_symbol() . number_format( $stat['itemRevenue'], 2 ) ?>
								</td>
								<td class="analytify_txt_center">
									<?php echo $stat['itemsViewed']; ?>
								</td>
								<td class="analytify_txt_center">
									<?php echo $stat['itemsPurchased']; ?>
								</td>
								<td class="analytify_txt_center">
									<?php echo $stat['itemsAddedToCart']; ?>
								</td>
								<td>
									<?php echo round( $stat['cartToViewRate'], 2 ); ?> %
									<span class="analytify_bar_graph">
										<span style="width: <?php echo WPANALYTIFY_Utils::fraction_to_percentage( $stat['cartToViewRate'] ); ?>%;"></span>
									</span>
								</td>
								<!-- <td>
									<?php // $percent_quantity = number_format( $stat[5], 2 );?>
									<?php // echo round( $stat[7], 2 ); ?> %
									<span class="analytify_bar_graph">
										<span style="width: <?php // echo $stat[7] ?>%;"></span>
									</span>
								</td> -->
							</tr>
							<?php
						}
					} else { ?>
						<tr>
							<td class="analytify_td_error_msg" colspan="7">
								<?php $current->no_records(); ?>
							</td>
						</tr>
					<?php }
					?>
				</tbody>
			</table>
		</div>
		<div class="analytify_status_footer">
			<?php if( isset( $stat['itemName'] ) ) : ?>
				<span class="analytify_info_stats">
					<?php
					echo sprintf( esc_html__( 'Did you know the most selling product (quantity wise) in your store is %1$s %2$s %3$s', 'wp-analytify-edd' ), '<strong>' , $famous , '</strong>' );
					?>
				</span>
			<?php endif; ?>
		</div>
	</div>
<?php } ?>
