<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


class WP_Analytify_Edd extends WP_Analytify_Pro_Base {


	public $google_measurement_url 		 	 = 'https://www.google-analytics.com/collect';
	public $google_debug_measurement_url 	 = 'https://www.google-analytics.com/debug/collect';
	public $track_detail_view 				 = array();
	private $impressions 					 = array();
	public $has_cart_page 					 = false;

	/**
	 * __construct
	 */
	function __construct() {

		parent::__construct();
		$this->includes();
		$this->_hooks();
		$this->setup_constants();
	}

	/**
	 * collection of all hooks
	 */
	private function _hooks() {

		add_action( 'analytify_add_submenu', 		array( $this, 'add_menu_edd' ), 20 );
		add_action( 'admin_enqueue_scripts', 		array( $this, 'admin_scipts' ) );

		// for modifing the meta links
		add_action( 'plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 2 );

		$roles = wp_get_current_user()->roles;

		// if ( ! in_array( @$roles[0], $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'exclude_users_tracking','wp-analytify-profile', array() ) ) ) {

			add_action( 'edd_purchase_link_end', 		array( $this, 'product_detail' ), 10, 2 );
			add_action( 'edd_pre_add_to_cart', 			array( $this, 'add_to_cart' ), 10, 2 );
			add_action( 'edd_pre_remove_from_cart', 	array( $this, 'remove_from_cart' ), 10, 1 );
			//add_action( 'edd_before_cart', 				array( $this, 'checkout_cart_step1' ) );
			add_action( 'edd_before_checkout_cart', 	array( $this, 'checkout_page_step' ) );
			add_action( 'edd_complete_purchase', 		array( $this, 'checkout_complete_step' ) );
			add_action( 'edd_update_payment_status', 	array( $this, 'transaction' ), 10, 3 );
			add_action( 'edd_update_payment_status', 	array( $this, 'refund' ), 10, 3 );
			add_action( 'edd_insert_payment', 			array( $this, 'save_user_cid' ), 10, 2 );
			add_action( 'edd_purchase_link_end', 		array( $this, 'add_impression' ), 10, 2 );
			add_action( 'wp_footer', 					array( $this, 'track_impressions' ) );

		// }

			add_action( 'admin_init', 					 array( $this, '_plugin_updater' ), 0 );
			add_action( 'edd_license_key', 				 array( $this, 'display_license_form' ) , 11 );
			add_action( 'admin_init', 					 array( $this, 'wp_analytify_edd_register_option' ) );
			// add_action( 'admin_init', 					 array( $this, 'analytify_activate_license' ) );
			// add_action( 'admin_init', 					 array( $this, 'analytify_deactivate_license' ) );
			add_action( 'wp_ajax_wpanalytifyedd_activate_license', array( $this, 'ajax_activate_license' ) );

			add_action( 'analytify_dashboad_dropdown_option' , array( $this, 'dashboad_dropdown_option' ) );

			add_action( 'edd_view_order_details_totals_after', array( $this, 'order_detail_stats' ) );
			add_filter( 'edd_payments_table_columns', array( $this, 'payment_source_column' ) );
			add_filter( 'edd_payments_table_column', array( $this, 'payment_source_value' ), 10, 3 );
			add_action( 'edd_payment_advanced_filters_row', array( $this, 'fetch_sale_source' ) );
			add_filter( 'analytify_admin_bar_menu', array( $this, 'add_admin_bar_menu' ), 20, 1 );

	}

	/**
	 * Plugin row meta links
	 * 
	 * @param array  $input already defined meta links
	 * @param string $file plugin file path and name being processed
	 * @return array $input
	 */
	function plugin_row_meta( $input, $file ) {

		// exit if its other plugins
		if ( 'wp-analytify-edd/wp-analytify-edd.php' !== $file ) { return $input; }

		// remove the 'view details' org link
		unset( $input[2] );

		// add the plugin site link
		$input[] = '<a target="_blank" href="https://analytify.io/add-ons/easy-digital-downloads/">Visit plugin site</a>';

		return $input;

	}


	/**
	* Add dropdown option for edd dashboard.
	*
	* @since 1.0.0
	*
	*/
	function dashboad_dropdown_option() {
		echo  '<li><a href="'. admin_url( 'admin.php?page=edd-dashboard' ) .'">EDD</a></li>';
	}


	/**
	 * Include necessary files
	 *
	 * @access      private
	 * @since       1.0.0
	 * @return      void
	 */
	private function includes() {

		// if ( !class_exists( 'ANALYTIFY_SL_Plugin_Updater' ) ) {
		// 	// load plugin updater
		// 	include_once( ANALYTIFY_PRO_ROOT_PATH . '/lib/ANALYTIFY_SL_Plugin_Updater.php' );
		// }
	}


	/**
	 * Setup plugin constants
	 *
	 * @access      private
	 * @since       1.0.0
	 * @return      void
	 */
	private function setup_constants() {

		// Setting Global Values
		$this->define( 'EDD_ANALYTIFY_PLUGIN_FILE', __FILE__ );
		$this->define( 'EDD_ANALYTIFY_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		$this->define( 'EDD_ANALYTIFY_PLUGIN_DIR', dirname( __FILE__ ) );
		$this->define( 'EDD_ANALYTIFY_PRODUCT_NAME', "Enhanced Ecommerce Google Analytics for Easy Digital Downloads Addon" );
		$this->define( 'EDD_ANALYTIFY_PRODUCT_ID', 1352 );
		$this->define( 'EDD_ANALYTIFY_STORE_URL', "https://analytify.io" );

	}

	/**
	 * Define constant if not already set
	 * @param  string $name
	 * @param  string|bool $value
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}


	/**
	 *
	 *  Include admin JS scripts.
	 *
	 *  @since 1.0.0
	 */
	function admin_scipts() {
		wp_enqueue_script( 'analytify_edd_main_js',  plugins_url( 'assets/js/main.js', __FILE__ ) );
	}

	/**
	 *
	 * Deactivate EDD License.
	 *
	 * @since 1.0.0
	 */
	// function analytify_deactivate_license() {

	// 	// Listen for our activate button to be clicked.
	// 	if ( isset( $_POST['analytify_woo_license_deactivate'] ) ) {

	// 		// Run a quick security check.
	// 		if ( ! check_admin_referer( 'analytify_nonce', 'analytify_nonce' ) ) {
	// 			return; // get out if we didn't click the Activate button
	// 		}
	// 		// Retrieve the license from the database.
	// 		$license = trim( get_option( 'analytify_edd_license_key' ) );

	// 		// Data to send in our API request.
	// 		$api_params = array(
	// 		'edd_action' => 'deactivate_license',
	// 		'license'   => $license,
	// 		'item_id' => EDD_ANALYTIFY_PRODUCT_ID, // The name of our product in EDD.
	// 		'url'       => home_url(),
	// 		);

	// 		// Call the custom API.
	// 		$response = wp_remote_get( esc_url_raw( add_query_arg( $api_params, EDD_ANALYTIFY_STORE_URL ) ), array( 'timeout' => 30, 'sslverify' => false ) );

	// 		// make sure the response came back okay
	// 		if ( is_wp_error( $response ) ) {
	// 			return false; }

	// 		// decode the license data
	// 		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	// 		// $license_data->license will be either "deactivated" or "failed"
	// 		if ( $license_data->license == 'deactivated' ) {

	// 			  delete_option( 'analytify_edd_license_key' );
	// 			  unset( $license );
	// 			  delete_option( 'analytify_edd_license_status' );

	// 		}
	// 	}
	// }

	/**
	 *
	 * Send Ajax on Active license.
	 *
	 * @since 1.0.0
	 */
	public function ajax_activate_license() {

		$this->check_ajax_referer( 'activate-license' );

		$key_rules = array(
		'action'          => 'key',
		'edd_license_key' => 'string',
		'context'         => 'key',
		'nonce'           => 'key',
		);
		$this->set_post_data( $key_rules );

		$api_params = array(
			'edd_action' => 'activate_license',
			'license'    => $this->state_data['edd_license_key'],
			'item_id'  => EDD_ANALYTIFY_PRODUCT_ID, // the name of our product in EDD
			'url'        => home_url(),
		);

		$response = wp_remote_get( esc_url_raw( add_query_arg( $api_params, EDD_ANALYTIFY_STORE_URL ) ), array( 'timeout' => 15, 'sslverify' => false ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) ) {
			return false;
		}

		$license_response = json_decode( wp_remote_retrieve_body( $response ) );

		if ( 'valid' === $license_response->license ) {
			$this->set_edd_license_key( $this->state_data['edd_license_key'] );
			$license_response->masked_license = $this->get_formatted_masked_edd_license( $this->state_data['edd_license_key'] );
		} else {

			if ( 'invalid' === $license_response->license ) {

				set_site_transient( 'wpanalytify_edd_license_response', $license_response, $this->transient_timeout );
				$license_response->error = $this->get_edd_license_status_message( $license_response, $this->state_data['context'] );

			}
		}

		// $license_response->license will be either "valid" or "invalid"
		update_option( 'analytify_edd_license_status', $license_response->license );
		update_option( 'analytify_edd_license_key' , $this->state_data['edd_license_key'] );

		$result = $this->end_ajax( json_encode( $license_response ) );

		return $result;
	}

	/**
	 *
	 * Activate EDD Addon Licence.
	 *
	 * @since 1.0.0
	 */
	// function analytify_activate_license() {

	// 	// listen for our activate button to be clicked
	// 	if ( isset( $_POST['analytify_edd_license_activate'] ) ) {

	// 		// run a quick security check
	// 		if ( ! check_admin_referer( 'analytify_nonce', 'analytify_nonce' ) ) {

	// 			return; // get out if we didn't click the Activate button
	// 		}
	// 		// retrieve the license from the database
	// 		$license = trim( get_option( 'analytify_edd_license_key' ) );

	// 		// data to send in our API request
	// 		$api_params = array(
	// 			'edd_action' => 'activate_license',
	// 			'license'    => $license,
	// 			'item_id'  => EDD_ANALYTIFY_PRODUCT_ID, // the name of our product in EDD
	// 			'url'        => home_url(),
	// 		);

	// 		// Call the custom API.
	// 		$response = wp_remote_get( esc_url_raw( add_query_arg( $api_params, EDD_ANALYTIFY_STORE_URL ) ), array( 'timeout' => 15, 'sslverify' => false ) );
	// 		// print_r($response);
	// 		// make sure the response came back okay
	// 		if ( is_wp_error( $response ) ) {

	// 			return false; }

	// 		// decode the license data
	// 		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	// 		// $license_data->license will be either "valid" or "invalid"
	// 		update_option( 'analytify_edd_license_status', $license_data->license );

	// 	}
	// }


	function wp_analytify_edd_register_option() {
		// creates our settings in the options table
		register_setting( 'analytify-settings', 'analytify_edd_license_key', array( $this, 'analytify_edd_sanitize_license' ) );
	}

	function analytify_edd_sanitize_license( $new ) {

		$old = get_option( 'analytify_edd_license_key' );

		if( $old && $old != $new ) {

			delete_option( 'analytify_edd_license_status' ); // new license has been entered, so must reactivate

		}
		  return $new;
	}

	/**
	 *
	 * To autoupdate addon.
	 *
	 * @since 1.0.0
	 */
	function _plugin_updater() {

		// retrieve our license key from the DB
		$wpa_license_key = trim( get_option( 'analytify_edd_license_key' ) );

		// setup the updater
		if ( class_exists( 'ANALYTIFY_SL_Plugin_Updater' ) ) {
			$edd_updater = new ANALYTIFY_SL_Plugin_Updater( EDD_ANALYTIFY_STORE_URL, 'wp-analytify-edd/wp-analytify-edd.php', array(
				'version' => '5.0.0', // current version number
				'license' => $wpa_license_key, // license key (used get_option above to retrieve from DB)
				'item_id' => EDD_ANALYTIFY_PRODUCT_ID, // name of this plugin
				'author'  => 'Muhammad Adnan',// author of this plugin
			) );
		}
	}


	/**
	* Output Analytify for eddCommerce license activation key fields/inputs
	*
	* @since 1.0.0
	*
	*/
	function display_license_form() {

		$license_edd  = get_option( 'analytify_edd_license_key' );
		$status_edd   = get_option( 'analytify_edd_license_status' );
		  //var_dump( delete_option( 'analytify_edd_license_status' ) );
		  //var_dump($license_edd);
		?>

		<tr valign="top">
		<th scope="row" valign="top">
			<?php esc_html_e( 'Easy Digital Downloads Tracking:', 'wp-analytify-edd' ); ?>
		</th>

		<?php  if ( 'valid' === $status_edd ) : ?>

		<td class="edd-license-row">

		<?php echo $this->get_formatted_masked_edd_license( $license_edd ); ?>

		</td>

		<?php else : ?>

		  <td class="edd-license-row">
			<input id="analytify_edd_license_key" name="analytify_edd_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license_edd ); ?>" />

			  <input type="submit" class="button-secondary" id="analytify_edd_license_activate" name="analytify_license_activate" value="<?php esc_html_e( 'Activate License', 'wp-analytify-edd' ); ?>"/>

			<br /><p id="edd-license-status"><?php if ( $status_edd ) { echo $status_edd; } ?></p>

		  </td>

		<?php
		  endif; ?>
		  </tr>

		<?php
	}

	/**
	 * Single item tracking info for GA4
	 *
	 * @param int   $download_id       Download ID.
	 * @param array $item_options      Item options.
	 * @param int   $override_quantity Override quantity.
	 * @param int   $override_price    Override price.
	 * @return array
	 */
	private function single_item_info_ga4( $download_id, $item_options, $override_quantity = null, $override_price = null ) {
		$download       = new EDD_Download( $download_id );
		$categories     = get_the_terms( $download->ID, 'download_category' );
		$category_names = is_array( $categories ) ? wp_list_pluck( $categories, 'name' ) : array();
		$first_category = reset( $category_names );
		$price_options  = $download->get_prices();
		$price_id       = isset( $item_options['price_id'] ) ? $item_options['price_id'] : null;
		$variation      = isset( $price_id ) && isset( $price_options[ $price_id ] ) ? $price_options[ $price_id ]['name'] : '';

		if ( is_null( $override_price ) ) {
			$price = isset( $price_id ) && isset( $price_options[ $price_id ] ) ? $price_options[ $price_id ]['amount'] : '';
			$price = empty( $price ) ? $download->get_price() : $price;
		} else {
			$price = $override_price;
		}

		if ( empty( $override_quantity ) ) {
			$quantity = isset( $item_options['quantity'] ) ? (int) $item_options['quantity'] : 1;
		} else {
			$quantity = $override_quantity;
		}

		$currency = edd_get_currency();

		return array(
			'item_id'       => $download->ID,
			'item_name'     => $download->post_title,
			'item_category' => $first_category,
			'item_variant'  => $variation,
			'price'         => $price,
			'quantity'      => $quantity,
			'currency'      => $currency,
		);
	}

	/**
	 * Get the price of a single item.
	 *
	 * @param integer $download_id Download ID.
	 * @param integer $variation   Variation/Price ID.
	 * @return string
	 */
	private function get_item_price( $download_id = 0, $variation = 0 ) {
		$prices = edd_get_variable_prices( $download_id );
		$amount = 0.00;
		if ( $prices && is_array( $prices ) ) {
			if ( isset( $prices[ $variation ] ) ) {
				$amount = $prices[ $variation ]['amount'];
			} else {
				$amount = edd_get_download_price( $download_id );
			}
		}
		return edd_sanitize_amount( $amount );
	}

	/**
	 * Track when product is removed from the cart.
	 *
	 * @since 1.0.0
	 */
	public function remove_from_cart( $cart_key ) {

		$cart_contents = edd_get_cart_contents();

		// Return if cart_key not available.
		if ( ! isset( $cart_contents[ $cart_key ] ) ) {
			return;
		}

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$item = $this->single_item_info_ga4( $cart_contents[ $cart_key ]['id'], $cart_contents[ $cart_key ]['options'] );

			$event[] = array(
				'name'   => 'remove_from_cart',
				'params' => array(
					'currency' => $item['currency'],
					'value'    => $item['quantity'] * $item['price'],
					'items'    => array( $item ),
				),
			);

			analytify_mp_ga4( $event );

		} else {

			$download       = new EDD_Download( $cart_contents[ $cart_key ]['id'] );
			$price_options  = $download->get_prices();
			$price_id       = isset( $cart_contents[ $cart_key ]['options']['price_id'] ) ? $cart_contents[ $cart_key ]['options']['price_id'] : null;
			$variation      = isset( $price_id ) && isset( $price_options[ $price_id ] ) ? $price_options[ $price_id ]['name'] : '';
			$price          = isset( $price_id ) && isset( $price_options[ $price_id ] ) ? $price_options[ $price_id ]['amount'] : '';
			$price          = empty( $price ) ? $download->get_price() : $price;
			$quantity       = isset( $cart_contents[ $cart_key ]['quantity'] ) ? $cart_contents[ $cart_key ]['quantity'] : 1;
			$categories     = (array) get_the_terms( $download->ID, 'download_category' );
			$category_names = wp_list_pluck( $categories, 'name' );
			$first_category = reset( $category_names );
			$list           = $this->get_the_list();

			$attr = array(
				't'     => 'event',
				'ec'    => 'Tracking by Analytify EDD',
				'ea'    => 'Remove',
				'el'    => __('Remove From Cart', 'wp-analytify-edd'),
				'ev'    => $quantity,
				'pa'    => 'remove',
				'pal'   => '',
				'pr1id' => $download->ID, // ID
				'pr1nm' => $download->post_title, // Name
				'pr1ca' => $first_category, // Category
				'pr1va' => $variation, // Variant
				'pr1pr' => $price, // Price
				'pr1qt' => $quantity, // Quantity
			);

			$this->hit( $attr );
		}
	}

	/**
	 * Track Cart Page - Step 1.
	 *
	 *
	 * @since 1.0.0
	 */
	// public function checkout_cart_step1() {

	// 	$items = $this->get_cart_items();

	// 	$attr = array_merge( array(
	// 		't'   => 'event',
	// 		'ec'  => 'Tracking by Analytify EDD',
	// 		'ea'  => 'Checkout',
	// 		'el'  => 'cart',
	// 		'pa'  => 'checkout',
	// 		'cos' => '1',
	// 		'col' => '',
	// 	), $items );

	// 	$this->hit( $attr );

	// }


	/**
	 * Checkout page - Step 2.
	 *
	 * @since 1.0.0
	 */
	public function checkout_page_step() {

		// Return if its not the checkout page.
		if ( ! edd_is_checkout() ) {
			return;
		}

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$cart_contents = edd_get_cart_content_details();
			$items         = array();

			foreach ( $cart_contents as $key => $item ) {
				$override_price = empty( $item['price'] ) ? 0 : $item['price'];
				$items[]        = $this->single_item_info_ga4( $item['id'], $item['item_number']['options'], $item['quantity'], $override_price );
			}

			$event[] = array(
				'name'   => 'begin_checkout',
				'params' => array(
					'items' => $items,
				),
			);

			analytify_mp_ga4( $event );

		} else {

			$items = $this->get_cart_items();

			$attr = array_merge( array(
				't'   => 'event',
				'ec'  => 'Tracking by Analytify EDD',
				'ea'  => 'Checkout',
				'el'  => 'checkout page',
				'pa'  => 'checkout',
				'cos' => '1',
				'col' => edd_get_gateway_admin_label( edd_get_chosen_gateway() ),

			), $items );

			$this->hit( $attr );
		}
	}


	/**
	 * Checkout complete - Step 3.
	 *
	 * @since 1.0.0
	 *
	 * @param int $payment_id ID of the payment that is just completed.
	 */
	public function checkout_complete_step( $payment_id ) {

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$items        = array();
			$payment_meta = edd_get_payment_meta( $payment_id );
			if ( $payment_meta['cart_details'] ) {
				foreach ( $payment_meta['cart_details'] as $key => $item ) {
					$items[]  = $this->single_item_info_ga4( $item['id'], $item['item_number']['options'], $item['quantity'], $item['price'] );
				}
			}

			$event_shipping[] = array(
				'name'   => 'add_shipping_info',
				'params' => array(
					'items' => $items,
				),
			);
			analytify_mp_ga4( $event_shipping );

			$event_payment[] = array(
				'name'   => 'add_payment_info',
				'params' => array(
					'items' => $items,
				),
			);
			analytify_mp_ga4( $event_payment );

		} else {
			$items = $this->fetch_download_items( $payment_id );

			$attr = array_merge( array(
				't'   => 'event',
				'ec'  => 'Tracking by Analytify EDD',
				'ea'  => 'Checkout',
				'el'  => 'complete',
				'cid' => $this->get_cid( $payment_id ),
				'pa'  => 'checkout',
				'cos' => '2',
				'col' => '',

			), $items );

			$this->hit( $attr );
		}
	}

	/**
	 *
	 * Track when product is added in the cart.
	 *
	 * @since 1.0.0
	 */
	public function add_to_cart( $download_id, $options ) {

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$item = $this->single_item_info_ga4( $download_id, $options );

			$event[] = array(
				'name'   => 'add_to_cart',
				'params' => array(
					'currency' => $item['currency'],
					'value'    => $item['quantity'] * $item['price'],
					'items'    => array( $item ),
				),
			);

			analytify_mp_ga4( $event );

		} else {

			$download       = new EDD_Download( $download_id );
			$price_options  = $download->get_prices();
			$variation      = isset( $options['price_id'] ) && isset( $price_options[ $options['price_id'] ] ) ? $price_options[ $options['price_id'] ]['name'] : '';
			$price          = isset( $options['price_id'] ) && isset( $price_options[ $options['price_id'] ] ) ? $price_options[ $options['price_id'] ]['amount'] : '';
			$price          = empty( $price ) ? $download->get_price() : $price;
			$quantity       = isset( $options['quantity'] ) ? $options['quantity'] : 1;
			$categories     = (array) get_the_terms( $download->ID, 'download_category' );
			$category_names = wp_list_pluck( $categories, 'name' );
			$first_category = reset( $category_names );
			$list           = $this->get_the_list();

			$attr = array(
				't'     => 'event',
				'ec'    => 'Tracking by Analytify EDD',
				'ea'    => 'Add',
				'el'    => edd_get_option( 'add_to_cart_text', __( 'Add To Cart', 'wp-analytify-edd' ) ),
				'ev'    => $quantity,
				'pa'    => 'add',
				'pal'   => '',
				'pr1id' => $download->ID, // ID
				'pr1nm' => $download->post_title, // Name
				'pr1ca' => $first_category, // Category
				'pr1va' => $variation, // Variant
				'pr1pr' => $price, // Price
				'pr1qt' => $quantity, // Quantity
			);

			$this->hit( $attr );

		}
	}

	/**
	 * Track Transaction when it changes its status. This works even admin changes status from backend.
	 */
	public function transaction( $payment_id, $new_status, $old_status ) {

		//delete_post_meta( $payment_id, 'track_eega_edd_payment_complete_analytify' );

		// return if the current status update isn't for completion.
		if ( 'publish' !== $new_status && 'complete' !== $new_status ) {
			return;
		}

		// Bail if payment is already tracked
		if ( 'yes' == get_post_meta( $payment_id, 'track_eega_edd_payment_complete_analytify', true ) ) {
	  		return;
		}

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$payment_meta = edd_get_payment_meta( $payment_id );

			if ( empty( $payment_meta['cart_details'] ) ) {
				return;
			}

			$discount      = ! empty( $payment_meta['user_info']['discount'] ) ? $payment_meta['user_info']['discount'] : 'none';
			$discount      = $discount != 'none' ? explode( ',', $discount ) : null;
			$discount      = is_array( $discount ) ? reset( $discount ) : $discount;
			$cart_contents = $payment_meta['cart_details'];

			$items = array();

			foreach ( $cart_contents as $item ) {
				$items[] = $this->single_item_info_ga4( $item['id'], $item, null, null );
			}

			$event[] = array(
				'name'   => 'purchase',
				'params' => array(
					'transaction_id' => $payment_id,
					'value'          => edd_get_payment_amount( $payment_id ),
					'tax'            => edd_use_taxes() ? edd_get_payment_tax( $payment_id ) : 0,
					'coupon'         => empty( $discount ) ? '' : $discount,
					'currency'       => edd_get_currency(),
					'items'          => $items,
				),
			);

			analytify_mp_ga4( $event );

		} else {

			$payment_meta = edd_get_payment_meta( $payment_id );
			$items        = $this->fetch_download_items( $payment_id ); // fetch details of items bought.
			$discount     = $payment_meta['user_info']['discount'];
			$discount     = $discount != 'none' ? explode( ',', $discount ) : null;
			$discount     = is_array( $discount ) ? reset( $discount ) : $discount;

			$attr  = array_merge( array(
				't'   => 'event',
				'ec'  => 'Tracking by Analytify EDD', // category
				'ea'  => 'Checkout',
				'el'  => 'Transaction',
				'cid' => $this->get_cid( $payment_id ),
				'ti'  => edd_get_payment_number( $payment_id ), // Transaction ID
				'ta'  => null, // Affiliation
				'tr'  => edd_get_payment_amount( $payment_id ), // Revenue
				'tt'  => edd_use_taxes() ? edd_get_payment_tax( $payment_id ) : null, // Taxes
				'ts'  => null, // Shipping
				'tcc' => $discount, // Discount code
				'pa'  => 'purchase',
			) ,  $items ) ;

			$this->hit( $attr );
		}

		update_post_meta( $payment_id , 'track_eega_edd_payment_complete_analytify' , 'yes' );
	}


	/**
	 * Track refunds.
	 *
	 * @since 1.0.0
	 */
	public function refund( $payment_id, $new_status, $old_status ) {

		// return if purchase is not being refunded or its alreadt refunded.
		if ( 'refunded' != $new_status || 'yes' == get_post_meta( $payment_id, 'track_eega_edd_payment_refund_analytify', true ) ) {
			return;
		}

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$payment_meta  = edd_get_payment_meta( $payment_id );
			$cart_contents = $payment_meta['cart_details'];

			$items = array();

			foreach ( $cart_contents as $key => $item ) {
				$items[] = array(
					'item_id'  => $item['id'],
					'quantity' => $item['quantity'],
				);
			}

			$event[] = array(
				'name'   => 'refund',
				'params' => array(
					'transaction_id' => $payment_id,
					'value'          => edd_get_payment_amount( $payment_id ),
					'items'          => $items,
				),
			);

			analytify_mp_ga4( $event );

		} else {
			$attr = array(
				't'  => 'event',
				'ec' => 'Tracking by Analytify EDD', // category
				'ea' => 'Refund',
				'ti' => edd_get_payment_number( $payment_id ), // Transaction ID
				'pa' => 'refund',
			);

			$this->hit( $attr );
		}

		update_post_meta( $payment_id, 'track_eega_edd_payment_refund_analytify', 'yes' );

	}

	/**
	 * Add all products data in array which show on page.
	 * @param $download_id
	 * @param  $args
	 *
	 * @since 1.0.0
	 */
	public function add_impression( $download_id, $args ) {

		// Return if its detail single page.
		if ( is_singular( 'download' ) ) {
			return;
		}

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$this->impressions[ $download_id ] = $this->single_item_info_ga4( $download_id, null, null, null );

		} else {
			$download       = new EDD_Download( $download_id );
			$categories     = (array) get_the_terms( $download->ID, 'download_category' );
			$category_names = wp_list_pluck( $categories, 'name' );
			$first_category = reset( $category_names );
			$list           = $this->get_the_list();
			$c              = count( $this->impressions ) + 1;

			// Prevent duplicate impressions on one page
			if ( isset( $this->impressions[ $download->ID ] ) ) {
				return;
			}

			$this->impressions[ $download->ID ] = array(
				"il{$c}nm"     => 'Complete_List',
				"il{$c}pi1id"  => $download->ID,
				"il{$c}pi1nm"  => $download->post_title,
				"il{$c}pi1ca"  => $first_category,
				"il{$c}pi1br"  => '', // Brands.
				"il{$c}pi1va"  => '', // Product Impression Variant.
				"il{$c}pi1ps"  => '', // Product Impression Position.
				"il{$c}pi1cd1" => get_the_author_meta( 'display_name', $download->post_author ), // Product Impression Custom Dimension.
			);
		}

	}


	/**
	 * Send Impressions to Google that already collected.
	 *
	 *
	 * @since 1.0.0
	 */
	public function track_impressions() {

		// Return if its detail page.
		if ( is_singular( 'download' ) ) {
			return;
		}

		// Return if impressions are empty
		if ( empty( $this->impressions ) ) {
			return;
		}

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$event[] = array(
				'name'   => 'view_item_list',
				'params' => array(
					'item_list_id' => 'Complete_List',
					'items'    => $this->impressions,
				),
			);

			analytify_mp_ga4( $event );

		} else {
			$impressions = array();
			foreach ( $this->impressions as $key => $value ) {
				$impressions = array_merge( $impressions, $value );
			}

			$attr =  array_merge( array(
				't'  => 'event',
				'ec' => 'Tracking by Analytify EDD',
				'ea' => 'Impression',
				'el' => 'Impression',
			), $impressions ) ;

			$this->hit( $attr );
		}
	}


	// http://www.stumiller.me/implementing-google-analytics-measurement-protocol-in-php-and-wordpress/
	public function save_user_cid( $payment_id, $payment_data ) {

		if ( isset( $_COOKIE['_ga'] ) ) {
			list( $version, $domainDepth, $cid1, $cid2 ) = preg_split( '[\.]', $_COOKIE['_ga'], 4 );
			$contents = array( 'version' => $version, 'domainDepth' => $domainDepth, 'cid' => $cid1 . '.' . $cid2 );
			$cid      = $contents['cid'];
			update_post_meta( $payment_id, 'analytify_edd_cid', $cid );
		}

	}


	public function get_cid( $payment_id = '' ) {

		$saved_cid = get_post_meta( $payment_id, 'analytify_edd_cid' );

		if ( ! empty( $_COOKIE['_ga'] ) ) {
				list( $version, $domainDepth, $cid1, $cid2 ) = preg_split( '[\.]', $_COOKIE['_ga'], 4 );
				$contents = array( 'version' => $version, 'domainDepth' => $domainDepth, 'cid' => $cid1 . '.' . $cid2 );
				$cid      = $contents['cid'];

				return $cid;
		} elseif ( ! empty( $payment_id ) && ! empty( $saved_cid ) ) {

			return $saved_cid;
		} else {

			return $this->generate_uuid();
		}

	}

	/**
	 * Fetch Transaction Downloads.
	 *
	 * @since 1.0.0
	 *
	 * @param  int $payment_id ID of the payment made.
	 *
	 * @return array           List of download items that are bought.
	 */
	public function fetch_download_items( $payment_id ) {

		$c            = 0;
		$items        = array();
		$payment_meta = edd_get_payment_meta( $payment_id );

		if ( $payment_meta['cart_details'] ) :
			foreach ( $payment_meta['cart_details'] as $key => $item ) :

				$download       = new EDD_Download( $item['id'] );
				$price_options  = $download->get_prices();
				$price_id       = isset( $item['item_number']['options']['price_id'] ) ? $item['item_number']['options']['price_id'] : null;
				$variation      = ! empty( $price_id ) && isset( $price_options[ $price_id ] ) ? $price_options[ $price_id ]['name'] : '';
				$categories     = (array) get_the_terms( $item['id'], 'download_category' );
				$category_names = wp_list_pluck( $categories, 'name' );
				$first_category = reset( $category_names );
				$author         = get_the_author_meta( 'display_name', $download->post_author );

				$c++;
				$items[ "pr{$c}id" ] 	= $item['id'];			// ID
				$items[ "pr{$c}nm" ] 	= $item['name'];		// Name
				$items[ "pr{$c}ca" ] 	= $first_category;		// Category
				$items[ "pr{$c}pr" ] 	= $item['price'];		// Price
				$items[ "pr{$c}qt" ] 	= $item['quantity'];	// Quantity
				$items[ "pr{$c}va" ] 	= $variation;			// Variation
				$items[ "pr{$c}cd1" ]   = $author;				// Author name

			endforeach;
	  	endif;

		return $items;
	}

	/**
	 * Fetch Cart content
	 *
	 * @since 1.0.0
	 */
	public function get_cart_items() {

		$c             = 0;
		$items         = array();
		$cart_contents = edd_get_cart_content_details();

		if ( $cart_contents ) :
			foreach ( $cart_contents as $key => $item ) :

				$download       = new EDD_Download( $item['id'] );
				$price_options  = $download->get_prices();
				$price_id       = isset( $item['item_number']['options']['price_id'] ) ? $item['item_number']['options']['price_id'] : null;
				$variation      = ! empty( $price_id ) && isset( $price_options[ $price_id ] ) ? $price_options[ $price_id ]['name'] : '';
				$categories     = (array) get_the_terms( $item['id'], 'download_category' );
				$category_names = wp_list_pluck( $categories, 'name' );
				$first_category = reset( $category_names );
				$author         = get_the_author_meta( 'display_name', $download->post_author );

				$c++;
				$items["pr{$c}id"] 	= $item['id'];			// ID
				$items["pr{$c}nm"] 	= $item['name'];		// Name
				$items["pr{$c}ca"] 	= $first_category;		// Category
				$items["pr{$c}pr"] 	= $item['price'];		// Price
				$items["pr{$c}qt"] 	= $item['quantity'];	// Category
				$items["pr{$c}va"] 	= $variation;			// Variation
				$items["pr{$c}cd1"] = $author;				// Author name
			endforeach;
		endif;

		return $items;

	}

	public function product_detail( $download_id, $args ) {
		
		// Return if NOT a detail page
		if ( ! is_singular( 'download' ) ) {
			return;
		}

		// Return if this product detail is already tracked. Prevents
		// double tracking as there could be multiple buy buttons on the page.
		if ( in_array( $download_id, array_keys( $this->track_detail_view ), false ) && $this->track_detail_view[ $download_id ] > 1 ) {
			return;
		}

		$this->track_detail_view[ $download_id ] = isset( $this->track_detail_view[ $download_id ] ) ? $this->track_detail_view[ $download_id ] + 1 : 1;

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {

			$event[] = array(
				'name'   => 'view_item',
				'params' => array(
					'currency' => edd_get_currency(),
					'items'    => array(
						$this->single_item_info_ga4( $download_id, null, null, null )
					),
				),
			);

			analytify_mp_ga4( $event );

		} else {

			$download       = new EDD_Download( $download_id );
			$categories     = (array) get_the_terms( $download->ID, 'download_category' );
			$category_names = wp_list_pluck( $categories, 'name' );
			$first_category = reset( $category_names );
			$list           = $this->get_the_list();

			$attr  = array(
				't'     => 'event',
				'ec'    => 'Tracking by Analytify EDD', // category
				'ea'    => 'Detail',
				'el'    => 'Product Detail View',
				'pa'    => 'detail',
				'pal'   => '',
				'pr1id' => $download->ID, // Prouct Sku
				'pr1nm' => $download->post_title, // Product Name
				'pr1ca' => $first_category, // Product Category
			);

			$this->hit( $attr );

		}
	}


	public function get_the_list() {

		global $wp_query;

		$list = 'Default';

		if ( is_search() ) :
			$list = __( 'Search results', 'wp-analytify-edd' );
		  elseif ( true ) :

		  endif;

			return urlencode( $list );

	}

	/**
	 * Display EDD Dashboard link in menu under Analytidy
	 */
	function add_menu_edd() {
		add_submenu_page( 'analytify-dashboard', esc_html__( 'Track everything in EDD with Analytify.', 'wp-analytify-edd' ), esc_html__( 'EDD', 'wp-analytify-edd' ), 'edit_posts', 'edd-dashboard', array(
			__CLASS__,
			'menu_page',
		), 17 );
	}

	/**
	 * Include file for EDD dashboard page
	 *
	 * @access public
	 * @return void
	 */
	public static function menu_page() {

		$screen = get_current_screen();

		if ( strpos( $screen->base, 'edd-dashboard' ) !== false ) {
			include( EDD_ANALYTIFY_PLUGIN_DIR . '/includes/edd-dashboard.php' );
		}
	}

	/**
	 * Generate UUID v4 function - needed to generate a CID when one isn't available
	 *
	 * @link http://www.stumiller.me/implementing-google-analytics-measurement-protocol-in-php-and-wordpress/
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function generate_uuid() {

		return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
			// 32 bits for "time_low"
			mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),
			// 16 bits for "time_mid"
			mt_rand( 0, 0xffff ),
			// 16 bits for "time_hi_and_version",
			// four most significant bits holds version number 4
			mt_rand( 0, 0x0fff ) | 0x4000,
			// 16 bits, 8 bits for "clk_seq_hi_res",
			// 8 bits for "clk_seq_low",
			// two most significant bits holds zero and one for variant DCE1.1
			mt_rand( 0, 0x3fff ) | 0x8000,
			// 48 bits for "node"
			mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
		);
	}

	/**
	 * Set MP parameters, form a validate hit and push to GA.
	 *
	 * @param  array $attr consist all required parameters
	 *
	 * @since 1.0.0
	 */
	function hit( $attr, $debug = false ) {

		$default_args = array(
			't'  => 'event', // Required - Hit type
			'ec' => '', // Event category
			'ea' => '', // Event Action
			'el' => '', // Event Label
			'ev' => null, // Event Value
		);

		$body  = array_merge( $default_args , $attr );

		if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			$ip = $_SERVER['REMOTE_ADDR'];
		}

		$user_language = isset( $_SERVER['HTTP_ACCEPT_LANGUAGE'] ) ? explode( ',', $_SERVER['HTTP_ACCEPT_LANGUAGE'] ) : array();
		$user_language = reset( $user_language );

		$UA_id = WP_ANALYTIFY_FUNCTIONS::search_profile_info( $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'profile_for_posts', 'wp-analytify-profile' ), 'webPropertyId' ) ;

		$default_body = array(
			'v'   => '1', // Required - Version
			'tid' => $UA_id, // Required - UA code
			'cid' => $this->get_cid(), // Required - Unique (anonymous) visitor ID
			't'   => 'pageview', // Required - Hit type
			'ni'  => true, // Non interaction

			'dh'  => str_replace( array( 'http://', 'https://' ), '', site_url() ),
			'dp'  => $_SERVER['REQUEST_URI'],
			'dt'  => get_the_title(),

			// Hits that usually also go with JS
			'ul'  => $user_language, // Optional - User language

			'uip' => $ip, // Optional - User IP, to make sure its not the servers'
			'ua'  => $_SERVER['HTTP_USER_AGENT'], // Optional - User Agent

		);

		$body = wp_parse_args( $body, $default_body );

		// Requests without ID are ignored by GA
		if ( false == $body['cid'] ) {
			return false;
		}

		if( $debug ) {

			$response = wp_remote_post( $this->google_debug_measurement_url, array(
				'method'   => 'POST',
				'timeout'  => '5',
				'blocking' => true,
				'body'     => array_merge( $body, array( 'z' => time() ) ),
			) );

			print "<pre>";
			print_r($response);
			print "</pre>";

		}else{

			$response = wp_remote_post( $this->google_measurement_url, array(
				'method'   => 'POST',
				'timeout'  => '5',
				'blocking' => false,
				'body'     => array_merge( $body, array( 'z' => time() ) ),
			) );
		}
	}

	/**
	 * Get Source/Medium of order
	 * @param  [string] $payment_id [current otder id].
	 *
	 * @since 1.0.1
	 */
	function order_detail_stats( $payment_id ) {

			$source_medium = get_post_meta( $payment_id, 'analytify_edd_single_source', true );
			if ( ! $source_medium ) {

				$post_date  = get_the_date( 'Y-m-d', $payment_id );
				$start_date = date( 'Y-m-d', strtotime( $post_date. ' - 5 days' ) );
				$end_date   = date( 'Y-m-d', strtotime( $post_date. ' + 5 days' ) );

				$stats = $GLOBALS['WP_ANALYTIFY']->pa_get_analytics_dashboard( 'ga:transactions', $start_date, $end_date,'ga:sourceMedium', false, 'ga:transactionId=='. edd_get_payment_number( $payment_id ) );
				$source_medium = 'None';
				if ( isset( $stats['rows'][0][0] ) ) {
					$source_medium = $stats['rows'][0][0];
					update_post_meta( $payment_id, 'analytify_edd_single_source', $source_medium );
				}
			}

		?>
		<div class="edd-order-payment edd-admin-box-inside">
			<p>
				<span class="label"><?php _e( 'Source/Medium', 'wp-analytify-edds' ); ?>:</span>&nbsp;
				<span><?php echo $source_medium; ?></span>
			</p>
		</div>
		<?php
	}

	/**
	 * Add new column payment history page.
	 * @param  [array] $columns [list of all columns].
	 *
	 * @since 1.0.1
	 */
	function payment_source_column( $columns ) {

		$columns['analytify_source'] = 'Source/Medium';
		return $columns;
	}

	/**
	 * Show the source/medium value on specific column.
	 * @param  [string] $value
	 * @param  [string] $payment_ID
	 * @param  [string] $column_name
	 *
	 * @since 1.0.1
	 */
	function payment_source_value( $value, $payment_ID, $column_name ) {

		if ( 'analytify_source' == $column_name ) {
			$source_medium = get_post_meta( $payment_ID, 'analytify_edd_single_source', true );
			$value = $source_medium ? $source_medium : 'None';

			if ( isset( $_GET['fetch_sale_source'] ) && ! $source_medium ) {
				$post_date  = get_the_date( 'Y-m-d', $payment_ID );
				$start_date = date( 'Y-m-d', strtotime( $post_date. ' - 5 days' ) );
				$end_date   = date( 'Y-m-d', strtotime( $post_date. ' + 5 days' ) );

				$stats = $GLOBALS['WP_ANALYTIFY']->pa_get_analytics_dashboard( 'ga:transactions', $start_date, $end_date,'ga:sourceMedium', false, 'ga:transactionId=='. edd_get_payment_number( $payment_ID ) );
				$source_medium = 'None';
				if ( isset( $stats['rows'][0][0] ) ) {
					$source_medium = $stats['rows'][0][0];
					update_post_meta( $payment_ID, 'analytify_edd_single_source', $source_medium );
					$value = $source_medium;
				}
			}

		}
		return $value;
	}

	function fetch_sale_source() {
		echo "<input type='submit' class='button-secondary' value='Fetch Traffic Sources' name='fetch_sale_source' />";
	}

	/**
	* Add option in admin bar.
	* @param [array] $menus.
	*
	* @since 1.1.1
	*/
	function add_admin_bar_menu( $menus ) {

		$menus['page=edd-dashboard'] = __( 'EDD', 'wp-analytify-edd' );
		return $menus;
	}

}//end class


?>
