<?php
/**
 * Plugin Name: Analytify Email Notifications
 * Plugin URI: https://analytify.io/add-ons/email-notifications/
 * Description: Our Email Notifications add-on will deliver your website analytics right in your inbox on a weekly and monthly basis.
 * Version: 5.0.0
 * Author: WPBrigade
 * Author URI: https://wpbrigade.com/
 * License: GPLv2+
 * Text Domain: wp-analytify-email
 * Domain Path: /languages
 *
 * @package wp-analytify-email
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

update_option( 'analytify_email_license_key' , 'B5E0B5F8DD8689E6ACA49DD6E6E1A930' );
update_option( 'analytify_email_license_status', 'valid' );

define( 'ANALTYIFY_EMAIL_VERSION', '5.0.0' );
define( 'ANALYTIFY_EMAIL_ROOT_PATH', dirname( __FILE__ ) . '/' );

if ( ! defined( 'ANALYTIFY_IMAGES_PATH' ) ) {
	define( 'ANALYTIFY_IMAGES_PATH', 'https://analytify.io/assets/email/' );
}

define( 'ANALYTIFY_EMAIL_UPGRADE_PATH', __FILE__ );

add_action( 'plugins_loaded', 'analytify_email_instance', 25 );

/**
 * Loads the plugin.
 *
 * @return void
 */
function analytify_email_instance() {
	$prevent = false;

	if ( ! file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' ) ) {
		// Check if Pro is installed.
		add_action( 'admin_notices', 'wpa_email_install_analytify_pro' );
		$prevent = true;

	} elseif ( ! function_exists( 'wp_analytify_pro_load' ) ) {
		// Check if Pro is loaded.
		add_action( 'admin_notices', 'wpa_email_active_analytify_pro' );
		$prevent = true;

	} elseif ( ! class_exists( 'Analytify_Email_Core' ) ) {
		// Check if base class exists.
		add_action( 'admin_notices', 'wpa_email_update_analytify_free' );
		$prevent = true;
	}

	if ( $prevent ) {
		add_action( 'admin_notices', 'wpa_email_notices_scripts' );
		return;
	}

	include_once ANALYTIFY_EMAIL_ROOT_PATH . 'wp-analytify-email-class.php';
	$WP_Analytify_Email_instance = new WP_Analytify_Email();
}

/**
 * Shows notice that Pro needs to be installed.
 *
 * @return void
 */
function wpa_email_install_analytify_pro() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-email' ) . '</strong> ' . esc_html__( 'Please Install Analytify Pro to use Analytify Email Notifications addon.', 'wp-analytify-email' );
	wpa_email_notice( $message, 'wp-analytify-danger' );
}

/**
 * Shows notice that Pro needs to be active.
 *
 * @return void
 */
function wpa_email_active_analytify_pro() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-email' ) . '</strong> ' . esc_html__( '<strong>Attention:</strong> Please activate Analytify Pro to use Analytify Email Notifications addon.', 'wp-analytify-email' );
	wpa_email_notice( $message, 'wp-analytify-danger' );
}

/**
 * Shows notice that Free needs to be active and updated.
 *
 * @return void
 */
function wpa_email_update_analytify_free() {
	if ( ! isset( $_GET['page'] ) || 'analytify-settings' !== $_GET['page'] ) {
		return;
	}
	$message = esc_html__( 'Please Update Analytify Free to use Analytify Email Notifications addon.', 'wp-analytify-email' );
	wpa_email_notice( $message, 'wp-analytify-danger' );
}

register_activation_hook( __FILE__, 'wp_analytify_email_activation' );

/**
 * Post activation house-keeping.
 *
 * @return void
 */
function wp_analytify_email_activation() {

	$_analytify_email = get_option( 'wp-analytify-email' );

	if ( empty( $_analytify_email ) || ! isset( $_analytify_email['analytif_email_cron_time'] ) ) {

		$default['analytify_email_stats'] = array(
			'show-overall-general',
			'show-top-pages',
			'show-geographics',
			'show-system',
			'show-system',
			'show-keywords',
			'show-social',
			'show-whats-happen',
			'show-referrer',
		);

		$default['analytify_email_user_email'] = get_bloginfo( 'admin_email' );
		$default['analytif_email_cron_time']   = array(
			'week'  => 'Monday',
			'month' => 'false',
		);

		update_option( 'wp-analytify-email', $default );
	}

	// Set default month option.
	if ( ! isset( $_analytify_email['analytif_email_cron_time']['month'] ) ) {
		$_analytify_email['analytif_email_cron_time']['month'] = 'false';

		update_option( 'wp-analytify-email', $_analytify_email );
	}
	// Set deafault week option.
	if ( ! isset( $_analytify_email['analytif_email_cron_time']['week'] ) ) {
		$_analytify_email['analytif_email_cron_time']['week'] = 'Monday';

		update_option( 'wp-analytify-email', $_analytify_email );
	}

}

register_deactivation_hook( __FILE__, 'wp_analytify_email_deactivation' );

/**
 * Post deactivation house-keeping.
 *
 * @return void
 */
function wp_analytify_email_deactivation() {

	wp_clear_scheduled_hook( 'analytify_email_cron_function' );
}

/**
 * Admin notices scripts.
 */
function wpa_email_notices_scripts() {
	wp_enqueue_style( 'wpa-email-notices', plugins_url( 'assets/css/notices.css', __FILE__ ), '', ANALTYIFY_EMAIL_VERSION );
}

/**
 * Add custom admin notice
 *
 * @param  string $message Custom Message
 * @param  string $class wp-analytify-success,wp-analytify-danger
 */
function wpa_email_notice( $message, $class ) {
	echo '<div class="wp-analytify-notification ' . $class . '">
	<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
	<div class="wp-analytify-notice-logo">
	<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
	</div>
	<div class="wp-analytify-notice-discription">
	<p>' . $message . '</p>
	</div>
	</div>';
}

/**
 * Helper function for translation.
 */
if ( ! function_exists( 'analytify__' ) ) {
	/**
	 * Wrapper for __() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify__( $string, $textdomain = 'wp-analytify' ) {
		return __( $string, $textdomain );
	}
}

if ( ! function_exists( 'analytify_e' ) ) {
	/**
	 * Wrapper for _e() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify_e( $string, $textdomain = 'wp-analytify' ) {
		echo __( $string, $textdomain );
	}
}

/**
 * Load TextDoamin
 *
 * @since 1.0.2
 */
function wp_analytify_email_addon_load_text_domain() {
	$plugin_dir = basename( dirname( __FILE__ ) );
	load_plugin_textdomain( 'wp-analytify-email', false, $plugin_dir . '/languages/' );
}
add_action( 'init', 'wp_analytify_email_addon_load_text_domain' );
