<?php
$Analytify      = $GLOBALS['WP_ANALYTIFY'];
$start_date_val = strtotime( '- 30 days' );
$end_date_val   = strtotime( 'now' );
$start_date     = date( 'Y-m-d', $start_date_val );
$end_date       = date( 'Y-m-d', $end_date_val );
$wp_analytify   = $GLOBALS['WP_ANALYTIFY'];
$acces_token  = get_option( 'post_analytics_token' );

if ( isset( $_POST['analytify_date_start'] ) && ! empty( $_POST['analytify_date_start'] ) && isset( $_POST['analytify_date_end'] ) && ! empty( $_POST['analytify_date_end'] ) ) {
	$start_date	= sanitize_text_field( wp_unslash( $_POST['analytify_date_start'] ) );
	$end_date	= sanitize_text_field( wp_unslash( $_POST['analytify_date_end'] ) );
}

// get the title of from from ID
function analytify_get_form_name( $ID, $category ) {

	switch( $category ) {

		// for CF7
		case 'analytify_form_wpcf7':
			if ( is_callable( 'WPCF7_ContactForm::get_instance' ) ) {
				$WPCF7 = WPCF7_ContactForm::get_instance( $ID );
				echo ( $WPCF7 AND $WPCF7->title() ) ? $WPCF7->title() : '-';
			} else {
				//echo 'Form ID: ' . $ID;
			}
			break;

		// for WP Forms
		case 'analytify_form_wpforms':
			if( get_post( $ID ) ) {
				echo get_the_title( $ID );
			}else{
				//echo 'Form ID: ' . $ID;
			}
			break;

		// Ninja Forms
		case 'analytify_form_ninja_forms':
			if( method_exists ( 'Ninja_Forms', 'get_setting' ) ) {
				echo Ninja_Forms()->form( $ID )->get()->get_setting( 'title' );
			}else{
				//echo 'Form ID: ' . $ID;
			}
			break;

		// Gravity Forms
		case 'analytify_form_gf':
			if ( is_callable( 'GFAPI::get_form' ) ) {
				$GF = GFAPI::get_form( $ID );
				echo ( $GF && isset($GF['title']) && !empty($GF['title']) ) ? $GF['title'] : '';
			} else {
				//echo 'Form ID: ' . $ID;
			}
			break;

		// Formidable Forms
		case 'analytify_form_formidable':
			if ( is_callable( 'FrmForm::getName' ) ) {
				$formidable_name = FrmForm::getName( $ID );
				echo ( isset($formidable_name) && !empty($formidable_name) ) ? $formidable_name : '';
			} else {
				//echo 'Form ID: ' . $ID;
			}
			break;

		// Fluent Forms
		case 'analytify_form_fluentforms':
			if ( function_exists( 'wpFluent' ) ) {
				$fluent_form = wpFluent()->table( 'fluentform_forms' )->find( $ID );
				echo ( $fluent_form && isset( $fluent_form->title ) && !empty( $fluent_form->title ) ) ? $fluent_form->title : '';
			} else {
				//
			}
			break;

		// Custom Forms
		default:
			echo $ID;
	}
}


// Fetch Dashboard Profile ID.
$dashboard_profile_ID = $Analytify->settings->get_option( 'profile_for_dashboard','wp-analytify-profile' );
$version = defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION; 

/*
* Check with roles assigned at dashboard settings.
*/
$is_access_level = $Analytify->settings->get_option( 'show_analytics_roles_dashboard','wp-analytify-dashboard' );

$_analytify_profile = get_option( 'wp-analytify-profile' );
?>

<div class="wpanalytify analytify-dashboard-nav">
	<div class="wpb_plugin_wraper">
		<div class="wpb_plugin_header_wraper">
			<div class="graph"></div>
			<div class="wpb_plugin_header">
				<div class="wpb_plugin_header_title"></div>
				<div class="wpb_plugin_header_info">
					<a href="https://analytify.io/changelog/" target="_blank" class="btn">Changelog - v<?php echo $version; ?></a>
				</div>
				<div class="wpb_plugin_header_logo">
					<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/images/logo.svg'?>" alt="Analytify">
				</div>
			</div>
		</div>
				
		<div class="analytify-dashboard-body-container">
			<div class="wpb_plugin_body_wraper">
				<div class="wpb_plugin_body">
					<div class="wpa-tab-wrapper">
						
						<?php 
						if ( method_exists( $GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation' ) ) {
							echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation();
						} ?>

					</div>
					<div class="wpb_plugin_tabs_content analytify-dashboard-content">
						<div class="analytify_wraper">
							<div class="analytify_main_title_section">
								<div class="analytify_dashboard_title">
									<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Forms Tracking Dashboard', 'wp-analytify-forms' ); ?></h1>
																		
									<?php
									if ( $dashboard_profile_ID ) {
										if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
											if ( $acces_token ) {
												if ( $acces_token && isset( $_analytify_profile['profile_for_dashboard'] ) && ! empty( $_analytify_profile['profile_for_dashboard'] ) ) { ?>
												
													<span class="analytify_stats_of"><a href="<?php echo WP_ANALYTIFY_FUNCTIONS::search_profile_info( $dashboard_profile_ID, 'websiteUrl' ) ?>" target="_blank"><?php echo WP_ANALYTIFY_FUNCTIONS::search_profile_info( $dashboard_profile_ID, 'websiteUrl' ) ?></a> (<?php echo WP_ANALYTIFY_FUNCTIONS::search_profile_info( $dashboard_profile_ID, 'name' ) ?>)</span>
												
												<?php 
												} 
											}
										}
									} 
									?>


								</div>

								<div class="analytify_main_setting_bar">
									<div class="analytify_pull_right analytify_setting">
										<div class="analytify_select_date">

											<?php 
											if ( $dashboard_profile_ID ) {
												if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
													if ( $acces_token ) {
														if ( method_exists( 'WPANALYTIFY_Utils', 'date_form' )  ) {
															WPANALYTIFY_Utils::date_form( $start_date, $end_date );
														} 
													}
												}
											} ?>

										</div>
									</div>
								</div>

							</div>
			
							<?php

							if ( ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Forms Tracking' ) ) {
								if ( $Analytify->pa_check_roles( $is_access_level ) ) {
									if ( $acces_token ) {
										// hold all the forms that have tracking enabled from settings and have active plgins 
										$analytify_tracking_forms = array();

										// check for Contact Form 7
										if ( 'on' === $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'track_cf7', 'wp-analytify-forms' ) AND is_plugin_active( 'contact-form-7/wp-contact-form-7.php' ) ) {
											array_push( $analytify_tracking_forms, array( 'title'=>'Contact Form 7', 'category'=>'analytify_form_wpcf7' ) );
										}

										// check for WPForms
										if ( 'on' === $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'track_wpforms', 'wp-analytify-forms' ) AND (is_plugin_active( 'wpforms-lite/wpforms.php' ) OR is_plugin_active( 'wpforms/wpforms.php' ) ) ) {
											array_push( $analytify_tracking_forms, array( 'title'=>'WPForms', 'category'=>'analytify_form_wpforms' ) );
										}

										// check for Ninja Forms
										if ( 'on' === $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'track_ninjaforms', 'wp-analytify-forms' ) AND is_plugin_active( 'ninja-forms/ninja-forms.php' ) ) {
											array_push( $analytify_tracking_forms, array( 'title'=>'Ninja Forms', 'category'=>'analytify_form_ninja_forms' ) );
										}

										// check for Gravity Forms
										if ( 'on' === $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'track_gravityforms', 'wp-analytify-forms' ) AND is_plugin_active( 'gravityforms/gravityforms.php' ) ) {
											array_push( $analytify_tracking_forms, array( 'title'=>'Gravity Forms', 'category'=>'analytify_form_gf' ) );
										}

										// check for Formidable Forms
										if ( 'on' === $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'track_formidable', 'wp-analytify-forms' ) AND is_plugin_active( 'formidable/formidable.php' ) ) {
											array_push( $analytify_tracking_forms, array( 'title'=>'Formidable Forms', 'category'=>'analytify_form_formidable' ) );
										}
										
										
										// check for Fluent Forms
										if ( 'on' === $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'track_fluentforms', 'wp-analytify-forms' ) AND is_plugin_active( 'fluentform/fluentform.php' ) ) {
											array_push( $analytify_tracking_forms, array( 'title'=>'Fluent Forms', 'category'=>'analytify_form_fluentforms' ) );
										}

										// check for custom forms
										if ( 'on' === $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'custom_form', 'wp-analytify-forms' ) ) {
											array_push( $analytify_tracking_forms, array( 'title'=>'Custom Forms', 'category'=>'analytify_form_custom' ) );
										}

										// check for the forms active and installed
										if( ! empty( $analytify_tracking_forms ) ) {

											foreach( $analytify_tracking_forms as $form ){ ?>
												<div class="analytify_general_status analytify_status_box_wraper">
													<div class="analytify_status_header">
														<h3><?php esc_html_e( "'". $form['title'] . "' Stats", 'wp-analytify-forms' ); ?></h3>
													</div>
													<div class="analytify_status_body">
														
														<?php
														$stats = $Analytify->pa_get_analytics_dashboard( 'ga:totalEvents', $start_date, $end_date, 'ga:eventCategory,ga:eventAction,ga:eventLabel', '-ga:totalEvents', 'ga:eventCategory=@'. $form['category'], 50 );
														if ( isset( $stats->totalsForAllResults ) ) { ?>
															
															<table class="analytify_data_tables">
																<thead>
																	<tr>
																		<?php if( 'analytify_form_custom' !== $form['category'] ) { ?><th class="analytify_num_row">ID</th><?php } ?>
																		<th class="analytify_txt_left"><?php esc_html_e( 'Form Name', 'wp-analytify-forms' ); ?></th>
																		<th class="analytify_txt_center analytify_num_row"><?php esc_html_e( 'Impressions', 'wp-analytify-forms' ); ?></th>
																		<th class="analytify_txt_center analytify_num_row"><?php esc_html_e( 'Submissions', 'wp-analytify-forms' ); ?></th>
																	</tr>
																</thead>
																<tbody>
																	<?php if ( isset( $stats['rows'] ) && $stats['rows'] > 0 ) {

																		// join impressions and submission based on form ID [eventLabel]
																		$form_single_data = array();
																		foreach( $stats['rows'] as $stat ){

																			if( !isset($form_single_data[$stat[2]]) ){
																				$form_single_data[$stat[2]] = array( 'impression'=>0, 'submission'=>0 );
																			}

																			$form_single_data[$stat[2]][$stat[1]] = $form_single_data[$stat[2]][$stat[1]] + $stat[3];

																		}

																		foreach($form_single_data as $form_ID => $form_data){ $k=1;
																		?>
																		<tr>
																			<?php if( 'analytify_form_custom' !== $form['category'] ) { ?><td class="analytify_txt_center"><?php echo $form_ID; ?></td><?php } ?>
																			<td><?php analytify_get_form_name( $form_ID, $form['category'] ); ?></td>
																			<td class="analytify_txt_center"><?php echo $form_data['impression']; ?></td>
																			<td class="analytify_txt_center"><?php echo $form_data['submission']; ?></td>
																		</tr>
																		<?php $k++; } ?>

																	<?php }else{ ?>
																	<tr>
																		<td  class="analytify_td_error_msg" colspan="4"><?php $Analytify->no_records(); ?></td>
																	</tr>
																<?php } ?>

																</tbody>
															</table>

														<?php } ?>

													</div>
													<div class="analytify_status_footer">
														<span class="analytify_info_stats"><?php esc_html_e( 'List of ' . $form['title'] .' hits.', 'wp-analytify-forms' ); ?></span>
													</div>
												</div>
											<?php }

										} else {

											?>
											<div class="analytify-stats-error-msg">
												<div class="wpb-error-box">
													<span class="blk">
														<span class="line"></span>
														<span class="dot"></span>
													</span>
													<span class="information-txt">No forms installed or activated.</span>
												</div>
											</div>
											<?php

										}

									} else {
										esc_html_e( 'You must be logged in to see the Analytics Dashboard.', 'wp-analytify-forms' );
									}
								} else {
									esc_html_e( 'You don\'t have access to Forms Dashboard.', 'wp-analytify-forms' );
								}
							} ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
