<?php

if (!defined('ABSPATH')) {
	exit;
}
class Analytify_Campaigns_Loader
{
	public static $instance;
	public $version;

	public static function get_instance()
	{
		if (!isset(self::$instance)) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __construct()
	{
		$this->version = '6.1.0';
		$this->define_constants();
		$this->hooks();
		$this->may_be_load_addon();
	}
	public function may_be_load_addon()
	{
		if (
			file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' )
			&& function_exists( 'wp_analytify_pro_load' )
			&& class_exists( 'WP_Analytify_Pro_Base' )
		) {
			include_once ANALYTIFY_PRO_CAMPAIGNS_ADDON_ROOT_PATH . '/classes/class-campaigns.php';
			include_once ANALYTIFY_PRO_CAMPAIGNS_ADDON_ROOT_PATH . '/classes/class-campaign-rest-api.php';
		} else {
			add_action('admin_enqueue_scripts', array($this, 'wp_analytify_campaigns_notices_scripts'));
		}
	}

	public function define_constants()
	{
		define('ANALTYIFY_PRO_CAMPAIGNS_ADDON_VERSION', '6.1.0');
		define('ANALYTIFY_PRO_CAMPAIGNS_ADDON_ROOT_PATH', dirname(__FILE__));
		define('ANALYTIFY_PRO_CAMPAIGNS_UPGRADE_PATH', __FILE__);
	}
	public function hooks()
	{
		add_action('admin_notices', array($this, 'install_analytify_pro_campaigns'));
		add_action('admin_notices', array($this, 'active_analytify_pro_campaigns'));
		add_action('init', array($this, 'wp_analytify_campaigns_load_text_domain'));
	}
	/**
	 * Generates ad admin message if Pro version is not installed.
	 *
	 * @return void
	 */
	public function install_analytify_pro_campaigns()
	{
		if (!file_exists(WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php')) {
			$message = '<strong>' . esc_html__('Attention:', 'wp-analytify-campaigns') . ' </strong>' . esc_html__('Please install Analytify Pro to use Analytify for Campaigns addon.', 'wp-analytify-campaigns');

			$this->wp_analytify_campaigns_notice($message, 'wp-analytify-danger');
		}
	}

	/**
	 * Generates ad admin message if Pro version is installed, but not active.
	 *
	 * @return void
	 */
	public function active_analytify_pro_campaigns()
	{
		if (!class_exists('WP_Analytify_Pro_Base')) {
			$message = '<strong>' . esc_html__('Attention:', 'wp-analytify-campaigns') . ' </strong>' . esc_html__('Please active Analytify Pro to use Analytify for Campaigns addon.', 'wp-analytify-campaigns');

			$this->wp_analytify_campaigns_notice($message, 'wp-analytify-danger');
		}
	}
	/**
	 * Admin notices scripts.
	 */
	public function wp_analytify_campaigns_notices_scripts()
	{
		wp_enqueue_style('wp-analytify-campaigns-notices-css', plugins_url('assets/css/notices.css', __FILE__), '', ANALTYIFY_PRO_CAMPAIGNS_ADDON_VERSION);
	}
	/**
	 * Load TextDoamin
	 *
	 * @since 1.0.2
	 */
	public function wp_analytify_campaigns_load_text_domain()
	{
		$plugin_dir = basename(dirname(__FILE__));
		load_plugin_textdomain('wp-analytify-campaigns', false, $plugin_dir . '/languages/');
	}

	/**
	 * Add custom admin notice
	 *
	 * @param  string $message Custom Message
	 * @param  string $class wp-analytify-success,wp-analytify-danger
	 */
	function wp_analytify_campaigns_notice( $message, $class = 'wp-analytify-success' ) {
		// Only show notices on allowed pages.
		$screen = get_current_screen();
		
		if ( ! $screen ) {
			return;
		}
		
		$allowed_parent_bases = array(
			'analytify-dashboard',
			'plugins',
			'analytify-settings',
			'analytify-license',
			'analytify-addons',
			'dashboard',
		);
		
		$allowed_screen_ids = array(
			'plugins',
			'dashboard',
		);
		
		// Check if we're on an allowed page.
		$is_allowed = in_array( $screen->parent_base, $allowed_parent_bases, true )
			|| in_array( $screen->id, $allowed_screen_ids, true )
			|| ( isset( $_GET['page'] ) && strpos( $_GET['page'], 'analytify' ) === 0 );
		
		// Don't show notice if not on allowed page.
		if ( ! $is_allowed ) {
			return;
		}
		
		$notice_id = 'analytify_notice_' . md5( $message );
		if ( ! get_option( $notice_id ) ) {
			echo '<div class="wp-analytify-notification '. $class .'" id="'. $notice_id .'">
					<a class="wp-analytify-notice-dismiss" href="#" aria-label="Dismiss the notice" onclick="dismissAnalytifyNotice(\''. $notice_id .'\'); return false;">&times;</a>
					<div class="wp-analytify-notice-logo">
						<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="notice">
					</div>
					<div class="wp-analytify-notice-discription">
						<p>' . $message .'</p>
					</div>
				</div>';
		}
	}
    
    public function wp_analytify_campaigns_notice_script() {
        ?>
        <script type="text/javascript">
            function dismissAnalytifyNotice(noticeId) {
                document.getElementById(noticeId).style.display = 'none';
                localStorage.setItem('analytify_stats_refreshed_dismissed', '1');
                var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
                var data = {
                    'action': 'dismiss_analytify_notice',
                    'notice_id': noticeId
                };
                jQuery.post(ajaxurl, data, function(response) {
                    console.log(response);
                });
            }
        </script>
        <?php
    }
    
    public function dismiss_analytify_campaigns_notice() {
        if ( isset( $_POST['notice_id'] ) ) {
            update_option( sanitize_text_field( $_POST['notice_id'] ), true );
            wp_send_json_success();
        } else {
            wp_send_json_error();
        }
    }
}

Analytify_Campaigns_Loader::get_instance();