<?php
// View of General Statistics

function pa_include_edd_categories_performance( $current, $stats ) {

  if ( isset( $stats['rows'] ) && isset( $stats['rows'][0][0] ) ) {
  $famous = $stats['rows'][0][0]; }

  ?>
  <div class="analytify_general_status analytify_status_box_wraper">
    <div class="analytify_status_header">
      <h3><?php esc_html_e( 'Product Categories Analysis', 'wp-analytify-edd' ); ?></h3>
    </div>
    <div class="analytify_status_body">

      <table class="analytify_data_tables">
        <thead>
          <tr>
            <th class="analytify_table_header_no_events">
              #
            </th>
            <th>
              <?php esc_html_e( 'Name',  'wp-analytify-edd' ); ?>
            </th>
            <th>
              <?php esc_html_e( 'Product Revenue', 'wp-analytify-edd' ); ?>
            </th>
            <th class="">
              <?php esc_html_e( 'Unique Purchases', 'wp-analytify-edd' ); ?>
            </th>
            <th class="">
              <?php esc_html_e( 'Quantity', 'wp-analytify-edd' ); ?>
            </th>
            <th class="">
              <?php esc_html_e( 'Cart-to-Detail Rate', 'wp-analytify-edd' ); ?>
            </th>
            <th class="">
              <?php esc_html_e( 'Buy-to-Detail Rate', 'wp-analytify-edd' ); ?>
            </th>
          </tr>
        </thead>
        <tbody>
          <?php if ( ! empty( $stats['rows'] ) ) {
            $i = 0;
            foreach ( $stats['rows'] as $stat ) {
              $i++;
              ?>
              <tr>
                <td data-heading="#">
                  <?php echo $i; ?>
                </td>
                <td data-heading="<?php esc_html_e( 'Name',  'wp-analytify-edd' ); ?>">
                  <?php echo $stat[0]; ?>
                </td>
                <td data-heading="<?php esc_html_e( 'Product Revenue', 'wp-analytify-edd' ); ?>" class="analytify_txt_center">
                  <?php echo edd_currency_symbol() . number_format( $stat[1], 2 ) ?>
                </td>
                <td data-heading="<?php esc_html_e( 'Unique Purchases', 'wp-analytify-edd' ); ?>" class="analytify_txt_center">
                  <?php echo $stat[2]; ?>
                </td>
                <td data-heading="<?php esc_html_e( 'Quantity', 'wp-analytify-edd' ); ?>" class="analytify_txt_center">
                  <?php echo $stat[3]; ?>
                </td>
                <td data-heading="<?php esc_html_e( 'Cart-to-Detail Rate', 'wp-analytify-edd' ); ?>">
                  <?php $percent_quantity = number_format( $stat[4], 2 );?>
                  <?php echo $percent_quantity; ?> %
                  <span class="analytify_bar_graph">
                    <span style="width: <?php echo $percent_quantity ?>%;"></span>
                  </span>
                </td>
                <td data-heading="<?php esc_html_e( 'Buy-to-Detail Rate', 'wp-analytify-edd' ); ?>">
                  <?php $percent_quantity = number_format( $stat[5], 2 );?>
                  <?php echo $percent_quantity; ?> %
                  <span class="analytify_bar_graph">
                    <span style="width: <?php echo $percent_quantity ?>%;"></span>
                  </span>
                </td>
              </tr>
              <?php
            }
          } else { ?>
            <tr>
              <td  class="analytify_td_error_msg" colspan="7">
                <?php $current->no_records(); ?>
              </td>
            </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
      <div class="analytify_status_footer">

        <?php if ( isset( $stat[0] ) ) : ?>
          <span class="analytify_info_stats">
            <?php
            echo sprintf( esc_html__( 'Did you know the famous Product Category in your store is %1$s %2$s %3$s', 'wp-analytify-edd' ), '<strong>' , $famous , '</strong>' );
            ?>
          </span>
        <?php endif; ?>

      </div>
    </div>
<?php } ?>
