jQuery(document).ready(function($) {

    var doing_license_registration_ajax = false;
    var admin_url = ajaxurl.replace( '/admin-ajax.php', '' ), spinner_url = admin_url + '/images/spinner';
  
    if ( 2 < window.devicePixelRatio ) {
      spinner_url += '-2x';
    }
    spinner_url += '.gif';
  
    var ajax_spinner = '<img src="' + spinner_url + '" alt="" class="ajax-spinner general-spinner" />';
  
    $( document ).on( 'click', "#analytify_forms_license_activate", function(e) {
  
      e.preventDefault();
  
      if ( doing_license_registration_ajax ) {
        return;
      }
  
      $( '#forms-license-status' ).removeClass( 'notification-message error-notice' );
  
      var license_key = $.trim( $( "#analytify_forms_license_key" ).val() );
  
      if ( '' === license_key ) {
        $( '#forms-license-status' ).addClass( 'notification-message error-notice' );
        $( '#forms-license-status' ).html( wpanalytify_strings.enter_license_key );
        return;
      }
  
      $( '#forms-license-status' ).empty().removeClass( 'success-notice' );
      doing_license_registration_ajax = true;
      $( '#analytify_forms_license_activate' ).after( '<img src="' + spinner_url + '" alt="" class="register-license-ajax-spinner general-spinner" />' );
  
      $.ajax( {
        url: ajaxurl,
        type: 'POST',
        dataType: 'JSON',
        cache: false,
        data: {
          action: 'wpanalytify_forms_activate_license',
          forms_license_key: license_key,
          nonce: wpanalytify_data.nonces.activate_license,
          context: 'license'
        },
        error: function( jqXHR, textStatus, errorThrown ) {
          doing_license_registration_ajax = false;
          $( '.register-license-ajax-spinner' ).remove();
          $( '#forms-license-status' ).html( wpanalytify_strings.register_license_problem );
        },
        success: function( data ) {
          doing_license_registration_ajax = false;
          $( '.register-license-ajax-spinner' ).remove();
  
  
          if ( 'undefined' !== typeof data.error ) {
  
            $( '#forms-license-status' ).addClass( 'notification-message error-notice' );
            $( '#forms-license-status' ).html( data.error );
  
          } else if ( data == '0' ){
  
            $( '#forms-license-status' ).addClass( 'notification-message error-notice' );
            $( '#forms-license-status' ).html( wpanalytify_strings.register_license_problem );
          }else {
            $( '#forms-license-status' ).html( wpanalytify_strings.license_registered ).delay( 5000 ).fadeOut( 1000 );
            $( '#forms-license-status' ).addClass( 'notification-message success-notice' );
            $( '#analytify_forms_license_key, #analytify_forms_license_activate' ).remove();
            $( '.forms-license-row' ).prepend( data.masked_license );
  
          }
        }
      } );
    });
  });
  