<?php
/**
 * Analytify Dashboard file.
 *
 * @package WP_Analytify
 */

if (!defined('ABSPATH')) {
	exit; 
}

$wp_analytify = $GLOBALS['WP_ANALYTIFY'];

$selected_stats = $wp_analytify->settings->get_option('show_analytics_panels_dashboard', 'wp-analytify-dashboard', array());

if (function_exists('analytify_datepicker_dates')) {
	extract(analytify_datepicker_dates());  
} else {
	$start_date = wp_date('Y-m-d', strtotime('-1 month'));
	$end_date   = wp_date('Y-m-d', strtotime('now'));
}

$date1 = date_create($start_date);
$date2 = date_create($end_date);
$diff  = date_diff($date2, $date1);


$compare_start_date = strtotime($start_date . $diff->format('%R%a days'));
$compare_start_date = date('Y-m-d', $compare_start_date);
$compare_end_date   = $start_date;

$dashboard_profile_ID = $wp_analytify->settings->get_option('profile_for_dashboard', 'wp-analytify-profile');

$fetch_fresh = $wp_analytify->settings->get_option('delete_dashboard_cache', 'wp-analytify-dashboard');

// Add your key events logic here
if (method_exists('WPANALYTIFY_Utils', 'get_ga_mode') && 'ga4' === WPANALYTIFY_Utils::get_ga_mode()) {
	$keyevents = $wp_analytify->get_reports(
		'analytify_keyevents-dashboard',
		array(
			'keyEvents',
			'eventCount',
			'eventValue',
			'bounceRate',
		),
		array(
			'start' => $start_date,
			'end' => $end_date,
		),
		array(
			'isKeyEvent',
			'eventName',
		),
		array(
			'type' => 'metric',
			'name' => 'eventCount',
			'order' => 'desc',
		),
		array(
			'logic' => 'AND',
			'filters' => array(
				array(
					'type' => 'dimension',
					'name' => 'isKeyEvent',
					'match_type' => 1,
					'value' => 'true',
				),
			),
		),
		10
	);
}
$acces_token = get_option( 'post_analytics_token' );

if ( ! $acces_token ) {
	return;
} else {
	if ( WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Analytify' ) ) {
		return; 
	}
}

$is_access_level = $wp_analytify->settings->get_option('show_analytics_roles_dashboard', 'wp-analytify-dashboard');

if (empty($is_access_level)) {
	$is_access_level = array('Administrator');
}

$version = defined('ANALYTIFY_PRO_VERSION') ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION;

if ($wp_analytify->pa_check_roles($is_access_level)) {
	wp_dequeue_script('tribe-common'); ?>

<div class="wpanalytify analytify-dashboard-nav">
	<div class="wpb_plugin_wraper">
		<div class="wpb_plugin_header_wraper">
		<div class="graph"></div>
			<div class="wpb_plugin_header">
				<div class="wpb_plugin_header_title"></div>
				<div class="wpb_plugin_header_info">
					<a href="https://analytify.io/changelog/" target="_blank" class="btn">View Changelog</a>
				</div>
				<div class="wpb_plugin_header_logo">
					<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg' ?>" alt="Analytify">
				</div>
			</div>
		</div>
		<div class="analytify-dashboard-body-container">
			<div class="wpb_plugin_body_wraper">
				<div class="wpb_plugin_body">
					<div class="wpa-tab-wrapper">
						<?php if (method_exists($GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation')) {
							echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation();
						} ?>
					</div>
					<div class="wpb_plugin_tabs_content analytify-dashboard-content">
						<div class="analytify_wraper">
							<div class="analytify_main_title_section">
								<div class="analytify_dashboard_title">
									<h1 class="analytify_pull_left analytify_main_title">
										<?php esc_html_e('Goals (Key Events) Dashboard', 'wp-analytify'); ?>
									</h1>

									<?php if ($acces_token && method_exists('WPANALYTIFY_Utils', 'dashboard_subtitle_section')) {
										echo WPANALYTIFY_Utils::dashboard_subtitle_section();
									} ?>
								</div>
								<div class="analytify_main_setting_bar">
									<div class="analytify_pull_right analytify_setting">
										<div class="analytify_select_date">
											<?php if (method_exists('WPANALYTIFY_Utils', 'date_form')) {
												WPANALYTIFY_Utils::date_form($start_date, $end_date);
											} ?>
										</div>
									</div>
								</div>
							</div>

							<!-- New table structure matching your initial design -->
							<div class="analytify_general_status analytify_status_box_wraper" data-endpoint-pro="demographics">
								<div class="analytify_status_body">
									<div class="stats-wrapper">
										<table class="analytify_data_tables">
											<thead>
												<tr>
													<th class="analytify_num_row"><p>Event Name</p></th>
													<th class="analytify_num_row"><p>Event Count</p></th>
													<th class="analytify_num_row"><p>Event Value</p></th>
													<th class="analytify_num_row"><p>Bounce Rate</p></th>
												</tr>
											</thead>
											<tbody>
												<?php foreach ($keyevents['rows'] as $row): ?>
													<tr>
														<td class="analytify_txt_center"><?php echo esc_html($row['eventName']); ?></td>
														<td class="analytify_txt_center"><?php echo esc_html($row['eventCount']); ?></td>
														<td class="analytify_txt_center"><?php echo esc_html($row['eventValue']); ?></td>
														<td class="analytify_txt_center"><?php echo round(esc_html($row['bounceRate']),2); ?>%</td>
													</tr>
												<?php endforeach; ?>
											</tbody>
											<tfoot>
												<tr>
												<td class="total-label analytify_txt_center"><strong>Total</strong></td>
												<td class="analytify_txt_center"><strong><?php echo isset($keyevents['aggregations']['eventCount']) ? number_format(esc_html($keyevents['aggregations']['eventCount'])) : esc_html__('0', 'wp-analytify'); ?></strong></td>
												<td class="analytify_txt_center"><strong><?php echo isset($keyevents['aggregations']['eventValue']) ? number_format(round($keyevents['aggregations']['eventValue'], 1), 1) : esc_html__('0', 'wp-analytify'); ?></strong></td>
												<td class="analytify_txt_center"><strong><?php echo isset($keyevents['aggregations']['bounceRate']) ? round($keyevents['aggregations']['bounceRate']) . '%' : esc_html__('0', 'wp-analytify'); ?></strong></td>
												</tr>
											</tfoot>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php
} else {
	esc_html_e('You don\'t have access to Analytify Dashboard.', 'wp-analytify');
}
?>