<?php
/*
* Plugin Name: Analytify Pro
* Plugin URI: https://analytify.io/?utm_source=analytify-pro&utm_medium=plugins&utm_campaign=analytify-home&utm_content=plugin-uri
* Description: Analytify Pro is a feature rich plugin that adds advanced tracking capabilities of GA4 and displays analytics in a simple, beautiful format.
* Version: 7.1.1
* Author: Analytify
* Author URI: https://analytify.io/?utm_source=analytify-pro&utm_medium=plugins&utm_campaign=analytify-home&utm_content=author-uri
* License: GPLv2+
* Text Domain: wp-analytify-pro
* Domain Path: /languages
* Requires Plugins: wp-analytify
* GitHub Plugin URI: https://github.com/WPBrigade/wp-analytify-pro
*/


// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

define('ANALYTIFY_PRO_ROOT_PATH', dirname(__FILE__));
define('ANALYTIFY_PRO_UPGRADE_PATH', __FILE__);
define('ANALYTIFY_PRO_VERSION', '7.1.1');

update_option( 'analytify_license_key', 'WEADOWN000000005603B1EBE59708542' );
update_option( 'analytify_license_status', 'valid' );

add_filter('pre_http_request', function($preempt, $r, $url) {
    if (strpos($url, 'https://analytify.io?edd_action=check_license') !== false) {
        return array(
            'headers'  => array(),
            'body'     => json_encode(array(
                "success" => true,
                "license" => "valid",
                "item_id" => 10,
                "item_name" => "Analytify WordPress Plugin",
                "license_limit" => 10,
                "site_count" => 1,
                "expires" => "2050-01-01 23:59:59",
                "activations_left" => 9,
                "checksum" => "WEADOWN000000005603B1EBE59708542",
                "payment_id" => 123321,
                "customer_name" => "WEADOWN",
                "customer_email" => "noreply@weadown.com",
                "price_id" => "1"
            )),
            'response' => array(
                'code'    => 200,
                'message' => 'OK'
            ),
        );
    }
    return $preempt;
}, 10, 3);

add_action('plugins_loaded', 'wp_analytify_pro_load', 15);

// Run the function on plugin activation.
register_activation_hook(__FILE__, 'wp_analytify_check_external_plugins');

/**
 * Handle plugin updates and manage external plugins for WP Analytify.
 */
function wp_analytify_pro_handle_updates() {
	if (!function_exists('is_plugin_active')) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}

	if (!defined('ANALYTIFY_PRO_VERSION') || !file_exists(__DIR__ . '/wp-analytify-pro.php')) {
		return;
	}

	$saved_version = get_option('analytify_pro_current_version');
	$current_version = ANALYTIFY_PRO_VERSION;

	if ($current_version && $saved_version !== $current_version) {
		wp_analytify_check_external_plugins();
		update_option('analytify_pro_current_version', $current_version);
	}
}
add_action('plugins_loaded', 'wp_analytify_pro_handle_updates');

/**
 * Hook into the upgrader process for plugin updates.
 */
function wp_analytify_pro_upgrader_hook($upgrader, $options) {
	if ($options['type'] === 'plugin' && isset($options['plugins'])) {
		foreach ($options['plugins'] as $plugin) {
			if ($plugin === plugin_basename(__FILE__)) {
				update_option('wp_analytify_check_external_plugins_flag', true);
				break;
			}
		}
	}
}
add_action('upgrader_process_complete', 'wp_analytify_pro_upgrader_hook', 10, 2);

/**
 * Execute external plugin checks after a plugin update.
 */
function wp_analytify_pro_init_check() {
	if (get_option('wp_analytify_check_external_plugins_flag')) {
		wp_analytify_check_external_plugins();
		delete_option('wp_analytify_check_external_plugins_flag');
	}
}
add_action('init', 'wp_analytify_pro_init_check', 9999);


function wp_analytify_pro_load()
{
	$prevent = false;

	if (!file_exists(WP_PLUGIN_DIR . '/wp-analytify/analytify-general.php')) {
		add_action('admin_notices', 'pa_install_free');
		$prevent = true;
		// return;
	} else if (!class_exists('WP_Analytify')) {
		add_action('admin_notices', 'pa_activate_free_plugin');
		$prevent = true;
		// return;
	} else if (!class_exists('Analytify_General')) {
		add_action('admin_notices', 'pa_update_free');
		$prevent = true;
		// return;
	}
	// if ( ! defined( 'ANALYTIFY_FORMS_VERSION' ) ) {
	// 	define( 'ANALYTIFY_FORMS_VERSION', '5.0.0' );
	// }
	if (!defined('ANALYTIFY_WOOCOMMERCE_VERSION')) { 
		define('ANALYTIFY_WOOCOMMERCE_VERSION', '6.1.0');
	}
	// Enqueue admin scripts if needed for notices
	if ($prevent) {
		add_action('admin_enqueue_scripts', 'pa_notices_scripts');
		return;
	}

	if (!defined( 'ANALYTIFY_FORMS_ADDON_CUSTOM_FORM_CLASS')){
		define( 'ANALYTIFY_FORMS_ADDON_CUSTOM_FORM_CLASS', 'analytify_form_custom' );
	}


	add_action('admin_menu', 'remove_go_pro_menu');

	// Set to default if tracking mode not set.
	if (!defined('ANALYTIFY_TRACKING_MODE')) {
		define('ANALYTIFY_TRACKING_MODE', 'ga');
	}

	// loads the pro core files.
	include_once ANALYTIFY_PRO_ROOT_PATH . '/classes/analytifypro_base.php';
	include_once ANALYTIFY_PRO_ROOT_PATH . '/classes/class-wp-analytify-pro.php';
	if (class_exists('WP_Analytify_Pro')) {
		WP_Analytify_Pro::instance();
	} else {
		error_log('Class WP_Analytify_Pro not found.');
	}

	// Loads the addons available in pro.
	require_once ANALYTIFY_PRO_ROOT_PATH . '/inc/wpa-addons-manager.php';
	(new Analytify_Addons_Manager())->load_addons();

}

/**
 * Check and manage external plugins for WP Analytify.
 *
 * Ensures specific WP Analytify addons are recognized, saved in the options table,
 * and updated with their current status. Deactivates matching plugins if active.
 *
 * @return void
 */
function wp_analytify_check_external_plugins()
{
	if (!function_exists('deactivate_plugins') || !defined('ABSPATH')) {
		return;
	}

	$addons_default = array(
		'wp-analytify-authors' => array(
			'name' => 'Authors Tracking',
			'url' => 'https://analytify.io/add-ons/authors-tracking/',
			'description' => 'Analytify’s Authors Dashboard Addon will enable you to track the performance of various authors on your website. This will help in deciding which Authors are performing the best for your website.',
			'status' => 'pending',
		),
		'wp-analytify-campaigns' => array(
			'name' => 'Campaigns Tracking',
			'url' => 'https://analytify.io/add-ons/campaigns/',
			'description' => 'Our Campaigns Tracking addon will help you track your marketing efforts. This addon will provide data in a beautiful dashboard which can help in better decision making.',
			'status' => 'pending',
		),
		'wp-analytify-edd' => array(
			'name' => 'Enhanced E-Commerce Tracking for Easy Digital Downloads',
			'url' => 'https://analytify.io/add-ons/easy-digital-downloads/',
			'description' => 'The Add-on will track e-commerce User behavior, Digital sales, Transactions, and Revenue of WordPress Digital Store using Easy Digital Downloads in Google Analytics. This data is displayed in a unique and intuitive manner which is pretty easy to understand even for non-technical WordPress users.',
			'status' => null,
		),
		'wp-analytify-woocommerce' => array(
			'name' => 'Enhanced E-Commerce Tracking for WooCommerce',
			'url' => 'https://analytify.io/add-ons/woocommerce/',
			'description' => 'This add-on will let you make the most of the e-commerce data in Google Analytics. With Enhanced WooCommerce tracking you can easily track the entire user journey on your eCommerce store or a business website based on WooCommerce WordPress.',
			'status' => null,
		),
	);

	if (version_compare(ANALYTIFY_PRO_VERSION, '6.1.0', '>=')) {
		$addons_default['wp-analytify-forms'] = array(
			'name' => 'Google Analytics Forms Tracking in WordPress',
			'url' => 'https://analytify.io/add-ons/forms-tracking/',
			'description' => 'With our Forms Tracking Addon, you can get the right statistics for improving your forms to generate more leads. This add-on supports all the popular Forms including Gravity Forms, Contact Form 7, WPForms, Formidable Forms, etc.',
			'status' => 'pending',
		);
		$addons_default['wp-analytify-email'] = array(
			'name' => 'Email Notifications',
			'url' => 'https://analytify.io/add-ons/email-notifications/',
			'description' => 'Our Email Notifications add-on will deliver your website analytics right in your inbox on a weekly and monthly basis.',
			'status' => 'pending',
		);
		$addons_default['wp-analytify-goals'] = array(
			'name' => 'Google Analytics Goals (Key Events) for WordPress',
			'url' => 'https://analytify.io/add-ons/google-analytics-goals-wordpress/',
			'description' => 'Whether you are an internet marketer or a business owner; Goals tracking will come in handy to make the right decisions. Our goals add-on provides key business analytics within WordPress. You can view all your Google Analytics Goals inside the dashboard in an instance.',
			'status' => 'pending',
		);
	}

	$saved_addons = get_option('wp_analytify_pro_addons', array());

	// Merge new addons while preserving statuses of existing ones
	foreach ($addons_default as $addon_key => $addon_value) {
		if (isset($saved_addons[$addon_key])) {
			// Preserve existing status
			$addons_default[$addon_key]['status'] = $saved_addons[$addon_key]['status'];
		} else {
			// Set status for newly added addons
			if (in_array($addon_key, ['wp-analytify-edd', 'wp-analytify-woocommerce'])) {
				// WooCommerce and EDD addons should be inactive by default on fresh installs
				$addons_default[$addon_key]['status'] = 'inactive';
			} else {
				// Other addons can be active by default
				$addons_default[$addon_key]['status'] = 'active';
			}
		}
	}
	
	// Save the updated list
	update_option('wp_analytify_pro_addons', $addons_default);
	

	$active_plugins = get_option('active_plugins');
	$active_addons = array(); // Track addons active before deactivation

if (is_array($active_plugins)) {
    foreach ($active_plugins as $plugin) {
        $active_folder = explode('/', $plugin)[0];

        // Check if the plugin is part of the addons
        if (array_key_exists($active_folder, $addons_default)) {
            $active_addons[] = $active_folder; // Add to active addons list
            deactivate_plugins($plugin, true); // Deactivate the standalone plugin
        }
    }

    wp_cache_flush();

    if (function_exists('opcache_reset')) {
        opcache_reset();
    }

	register_shutdown_function(
		function () use ($addons_default, $active_plugins) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
			wp_clean_plugins_cache();

			// Reactivate the main plugin
			activate_plugin(plugin_basename(__FILE__), '', false, true);

			// Fetch saved addons
			$addons_saved = get_option('wp_analytify_pro_addons', []);

			// Define your old external plugin paths
			$external_plugins = [
				'wp-analytify-edd/wp-analytify-edd.php' => 'wp-analytify-edd',
				'wp-analytify-woocommerce/wp-analytify-woocommerce.php' => 'wp-analytify-woocommerce',
			];

			foreach ($external_plugins as $plugin_path => $addon_key) {
				if (in_array($plugin_path, $active_plugins)) {
					// Old external plugin is active — deactivate it
					deactivate_plugins($plugin_path, true);

					// Activate the new addon
					$addons_saved[$addon_key]['status'] = 'active';
				} else {
					// External plugin is NOT active

					// If addon is already marked active in saved settings, keep it active
					if (isset($addons_saved[$addon_key]['status']) && $addons_saved[$addon_key]['status'] === 'active') {
						// Do nothing — keep it active
					} else {
						// Fresh install or not set — keep it inactive (let user decide)
						$addons_saved[$addon_key]['status'] = 'inactive';
					}
				}
			}

			// For all other addons (not Woo or EDD), keep them active
			foreach ($addons_saved as $addon_key => &$addon_value) {
				if (!in_array($addon_key, ['wp-analytify-edd', 'wp-analytify-woocommerce'])) {
					$addon_value['status'] = 'active';
				}
			}

			update_option('wp_analytify_pro_addons', $addons_saved);
        }
    );
}
	
}


/**
 * Admin notices scripts.
 */
if (!function_exists('pa_notices_scripts')) {
	function pa_notices_scripts()
	{
		wp_enqueue_style('wp-analytify-pro-notices', plugins_url('wp-analytify-pro/assets/css/wp-analytify-pro-notices.css', dirname(__FILE__)), '', ANALYTIFY_PRO_VERSION);
	}
}

/**
 * Hide Go Pro submenu when Pro is activated.
 *
 * @since 2.0.5
 */
function remove_go_pro_menu()
{

	remove_submenu_page('analytify-dashboard', 'analytify-go-pro');
}

function pa_activate_free_plugin()
{

	// Hide notice on plugin install screen.
	if (isset($_GET['action']) && 'install-plugin' == $_GET['action']) {
		return;
	}

	$action = 'activate';
	$slug = 'wp-analytify/wp-analytify.php';
	$link = wp_nonce_url(add_query_arg(array('action' => $action, 'plugin' => $slug), admin_url('plugins.php')), $action . '-plugin_' . $slug);

	$message = sprintf('%1$s <a href="%2$s">%3$s</a>', esc_html__('The following required plugin is currently inactive &mdash;', 'wp-analytify-pro'), $link, esc_html__('Click here to activate Analytify Core (Free).', 'wp-analytify-pro'));

	wp_analytify_pro_notice($message, 'wp-analytify-danger');

	// printf('<div class="notice notice-error is-dismissible">
	// <p>%1$s<a href="%2$s" style="text-decoration:none">%3$s</a></p></div>' , esc_html__( 'The following required plugin is currently inactive &mdash; ', 'wp-analytify-pro' ), $link, esc_html__( 'Click here to activate Analytify Core (Free)', 'wp-analytify-pro' ) );
}

function pa_update_free()
{

	// Hide notice on plugin install screen.
	if (isset($_GET['action']) && 'install-plugin' == $_GET['action']) {
		return;
	}

	$action = 'upgrade-plugin';
	$slug = 'wp-analytify';
	$link = wp_nonce_url(add_query_arg(array('action' => $action, 'plugin' => $slug), admin_url('update.php')), $action . '_' . $slug);

	// printf('<div class="notice notice-error is-dismissible">
	// <p>%1$s<a href="%2$s" style="text-decoration:none">%3$s</a></p></div>' , esc_html__( 'Please update Analytify Core to latest Free version to enable PRO features &mdash; ', 'wp-analytify-pro' ), $link, esc_html__( 'Update now' ), 'wp-analytify-pro' );

	$message = sprintf('%1$s <a href="%2$s">%3$s</a>', esc_html__('Please update Analytify Core to latest Free version to enable PRO features. &mdash; ', 'wp-analytify-pro'), $link, esc_html__('Update now', 'wp-analytify-pro'));

	wp_analytify_pro_notice($message, 'wp-analytify-danger');
}


function pa_install_free()
{

	// Hide notice on plugin install screen.
	if (isset($_GET['action']) && 'install-plugin' == $_GET['action']) {
		return;
	}

	$action = 'install-plugin';
	$slug = 'wp-analytify';
	$link = wp_nonce_url(add_query_arg(array('action' => $action, 'plugin' => $slug), admin_url('update.php')), $action . '_' . $slug);

	// printf('<div class="notice notice-warning">
	// <p>%1$s<a href="%2$s" style="text-decoration:none">%3$s</a></p></div>' , esc_html__( 'The following required plugin is not installed &mdash; ', 'wp-analytify-pro' ), $link, esc_html__( 'Install Analytify Core (Free) now', 'wp-analytify-pro' ) );

	$message = sprintf('%1$s <a href="%2$s">%3$s</a>', esc_html__('The following required plugin is not installed &mdash;', 'wp-analytify-pro'), $link, esc_html__('Install Analytify Core (Free).', 'wp-analytify-pro'));

	wp_analytify_pro_notice($message, 'wp-analytify-danger');
}

/**
 * Add custom admin notice
 * @param  string $message Custom Message
 * @param  string $class wp-analytify-success,wp-analytify-danger
 *
 */
function wp_analytify_pro_notice( $message, $class = 'wp-analytify-success' ) {
	$notice_id = 'analytify_notice_' . md5( $message );
	if ( ! get_option( $notice_id ) ) {
		echo '<div class="wp-analytify-notification '. $class .'" id="'. $notice_id .'">
				<a class="wp-analytify-notice-dismiss"  href="#" aria-label="Dismiss the notice" onclick="dismissAnalytifyNotice(\''. $notice_id .'\'); return false;" style="position: absolute; top: 46%; right: 10px; transform: translateY(-50%); font-size: 18px; text-decoration: none; font-weight: bold; cursor: pointer;">&times;</a>
				<div class="wp-analytify-notice-logo">
					<img src="' . plugins_url('assets/images/logo.svg', __FILE__) . '" alt="analytify logo">
				</div>
				<div class="wp-analytify-notice-discription">
					<p>' . $message .'</p>
				</div>
			</div>';
	}
}

add_action( 'admin_footer', 'wp_analytify_pro_notice_script' );
function wp_analytify_pro_notice_script() {
	?>
	<script type="text/javascript">
		function dismissAnalytifyNotice(noticeId) {
			document.getElementById(noticeId).style.display = 'none';
			localStorage.setItem('analytify_stats_refreshed_dismissed', '1');
			var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
			var data = {
				'action': 'dismiss_analytify_notice',
				'notice_id': noticeId
			};
			jQuery.post(ajaxurl, data, function(response) {
				console.log(response);
			});
		}
	</script>
	<?php
}

add_action( 'wp_ajax_dismiss_analytify_notice', 'dismiss_analytify_pro_notice' );
function dismiss_analytify_pro_notice() {
	if ( isset( $_POST['notice_id'] ) ) {
		$notice_id = sanitize_text_field( $_POST['notice_id'] );
		set_transient( $notice_id . '_dismissed', time(), 86400 );
		wp_send_json_success();
	} else {
		wp_send_json_error();
	}
}

/**
 *
 * @since       1.2.2
 * @return      void
 */
function wp_analytify_pro_activation()
{

	// Attempt to install core plugin. disabled on version equal to or above 5.0.0
	// include ANALYTIFY_PRO_ROOT_PATH . '/classes/class-install-core.php';
	// new WP_Analytify_Pro_Core_Installer();

	// Load default settings in Pro plugin.
	if (!get_option('analytify_pro_default_settings')) {

		$front_tab_settings = array(
			'disable_front_end' => 'on',
			'show_analytics_roles_front_end' => array('administrator', 'editor'),
			'show_analytics_post_types_front_end' => array('post', 'page'),
			'show_panels_front_end' => array('show-overall-front', 'show-country-front', 'show-keywords-front', 'show-social-front', 'show-browser-front', 'show-referrer-front', 'show-mobile-front', 'show-os-front', 'show-city-front')
		);

		update_option('analytify_pro_default_settings', 'done');

		update_option('analytify_pro_active_date', date('l jS F Y h:i:s A') . date_default_timezone_get());
	}
}
register_activation_hook(__FILE__, 'wp_analytify_pro_activation');

/**
 *
 * @since       1.2.2
 * @return      void
 */
function wp_analytify_pro_de_activation()
{

}
register_deactivation_hook(__FILE__, 'wp_analytify_pro_de_activation');

/**
 * Delete settings on uninstall.
 *
 * @since 2.0.4
 */
function wp_analytify_pro_un_install()
{

	// delete default settings check. So on installing it again. Default settings could be loaded again.
	delete_option('analytify_pro_default_settings');
}
register_uninstall_hook(__FILE__, 'wp_analytify_pro_un_install');

/**
 * Load TextDoamin
 *
 * @since 2.0.7
 */
function wp_analytify_pro_load_text_domain()
{
	$plugin_dir = basename(dirname(__FILE__));
	load_plugin_textdomain('wp-analytify-pro', false, $plugin_dir . '/languages/');
}
add_action('init', 'wp_analytify_pro_load_text_domain');
