<?php
/**
 * Template Name: SityCloud Client Dashboard
 * Description: لوحة تحكم عملاء Sity Cloud – تعرض اسم العميل، الإيميل، IBAN، رصيد المحفظة، وعدد المواقع.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

get_header();

// لو المستخدم مش مسجل دخول
if ( ! is_user_logged_in() ) : ?>
    <div class="sitycloud-dashboard sitycloud-dashboard-not-logged-in" dir="rtl">
        <div class="sitycloud-dashboard-container">
            <div class="sitycloud-dashboard-card">
                <h2 class="sitycloud-dashboard-title">مرحباً 👋</h2>
                <p class="sitycloud-dashboard-text">
                    هذه الصفحة مخصّصة لعملاء <strong>Sity Cloud</strong>. يرجى تسجيل الدخول لعرض لوحة التحكم الخاصة بك.
                </p>
                <a class="sitycloud-dashboard-btn sitycloud-dashboard-btn-primary"
                   href="<?php echo esc_url( wp_login_url( get_permalink() ) ); ?>">
                    تسجيل الدخول إلى حسابك
                </a>
            </div>
        </div>
    </div>
    <?php
    get_footer();
    return;
endif;

// ======================
//  جلب بيانات المستخدم
// ======================

$current_user = wp_get_current_user();
$user_id      = $current_user->ID;

$display_name = $current_user->display_name ? $current_user->display_name : $current_user->user_login;
$email        = $current_user->user_email;

// IBAN من بلجن fawry (الميتا fawry_iban)
$iban = get_user_meta( $user_id, 'fawry_iban', true );
if ( empty( $iban ) ) {
    $iban = 'لم يتم توليد IBAN بعد';
}

// عدد المواقع – من دالة fawry_get_user_sites_count إن وُجدت
if ( function_exists( 'fawry_get_user_sites_count' ) ) {
    $sites_count = fawry_get_user_sites_count( $user_id );
} else {
    // احتياطي: عدّ المواقع في ملتي سايت
    if ( is_multisite() ) {
        $sites = get_blogs_of_user( $user_id );
        $sites_count = is_array( $sites ) ? count( $sites ) : 0;
    } else {
        $sites_count = 0;
    }
}

// رصيد المحفظة – من بلجن SityCloud Wallet & Payments
$wallet_balance = 0.0;
if ( class_exists( 'SityCloud_Wallet_Plugin' ) ) {
    $wallet_plugin = SityCloud_Wallet_Plugin::get_instance();
    if ( $wallet_plugin && method_exists( $wallet_plugin, 'get_user_balance' ) ) {
        $wallet_balance = $wallet_plugin->get_user_balance( $user_id );
    }
}
$wallet_balance = floatval( $wallet_balance );

?>
<div class="sitycloud-dashboard" dir="rtl">
    <div class="sitycloud-dashboard-overlay"></div>

    <div class="sitycloud-dashboard-container">
        <!-- ترويسة اللوحة -->
        <header class="sitycloud-dashboard-header">
            <div class="sitycloud-dashboard-title-wrap">
                 <h1>أهلاً <?php echo esc_html( $display_name ); ?> </h1> 
                <p class="sitycloud-dashboard-subtitle">
                    
                    من هنا تقدر تتابع بيانات حسابك، رصيد محفظتك، وعدد المواقع اللي شغّالة على Sity Cloud.
                </p>
            </div>

            <div class="sitycloud-dashboard-quick-actions">
                <span class="sitycloud-dashboard-chip">
                    عميل Sity Cloud 💜
                </span>
                <span class="sitycloud-dashboard-chip sitycloud-dashboard-chip-soft">
                    آخر تحديث: <?php echo esc_html( date_i18n( 'Y-m-d H:i' ) ); ?>
                </span>
            </div>
        </header>

        <!-- الكروت الأساسية -->
        <section class="sitycloud-dashboard-grid">
            <!-- بيانات الحساب -->
            <div class="sitycloud-dashboard-card sitycloud-dashboard-card-main">
                <div class="sitycloud-card-header">
                    <div>
                        <h2 class="sitycloud-card-title">بيانات حسابك</h2>
                        <p class="sitycloud-card-description">
                            التفاصيل الأساسية المرتبطة بحسابك في Sity Cloud.
                        </p>
                    </div>
                    <div class="sitycloud-avatar">
                        <span><?php echo esc_html( mb_substr( $display_name, 0, 1 ) ); ?></span>
                    </div>
                </div>

                <div class="sitycloud-card-body">
                    <div class="sitycloud-info-row">
                        <span class="sitycloud-info-label">الاسم:</span>
                        <span class="sitycloud-info-value">
                            <?php echo esc_html( $display_name ); ?>
                        </span>
                    </div>
                    <div class="sitycloud-info-row">
                        <span class="sitycloud-info-label">البريد الإلكتروني:</span>
                        <span class="sitycloud-info-value">
                            <?php echo esc_html( $email ); ?>
                        </span>
                    </div>
                    <div class="sitycloud-info-row">
                        <span class="sitycloud-info-label">رقم IBAN:</span>
                        <span class="sitycloud-info-value">
                            <?php echo esc_html( $iban ); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- رصيد المحفظة -->
            <div class="sitycloud-dashboard-card sitycloud-dashboard-card-stat">
                <h3 class="sitycloud-stat-label">رصيد المحفظة</h3>
                <div class="sitycloud-stat-value-wrap">
                    <span class="sitycloud-stat-currency">ج.م</span>
                    <span class="sitycloud-stat-value sitycloud-stat-value-lg">
                        <?php echo esc_html( number_format_i18n( $wallet_balance, 2 ) ); ?>
                    </span>
                </div>
                <p class="sitycloud-stat-hint">
                    رصيدك المتاح في محفظة Sity Cloud ويمكنك استخدامه للمدفوعات وترقية الباقات.
                </p>
                <a href="https://sity.cloud/payments/"
                   class="sitycloud-dashboard-btn sitycloud-dashboard-btn-outline">
                    شحن الرصيد / ترقية الباقة
                </a>
            </div>

            <!-- عدد المواقع -->
            <div class="sitycloud-dashboard-card sitycloud-dashboard-card-stat">
                <h3 class="sitycloud-stat-label">عدد مواقعك</h3>
                <div class="sitycloud-stat-value-wrap">
                    <span class="sitycloud-stat-value sitycloud-stat-value-lg">
                        <?php echo esc_html( intval( $sites_count ) ); ?>
                    </span>
                </div>
                <p class="sitycloud-stat-hint">
                    إجمالي المواقع المرتبطة بحسابك على شبكة Sity Cloud.
                </p>
                <a href="https://sity.cloud/mysites"
                   class="sitycloud-dashboard-btn sitycloud-dashboard-btn-outline">
                    إدارة مواقعي
                </a>
            </div>
        </section>

        <!-- اختصارات التنقل -->
        <section class="sitycloud-dashboard-actions">
            <h2 class="sitycloud-actions-title">اختصارات سريعة</h2>
            <p class="sitycloud-actions-subtitle">
                تحكم في مواقعك ومدفوعاتك ودعمك الفني من مكان واحد.
            </p>

            <div class="sitycloud-actions-grid">
                <a href="https://sity.cloud/mysites" class="sitycloud-action-card">
                    <div class="sitycloud-action-icon">🌐</div>
                    <div class="sitycloud-action-content">
                        <h3>مواقعي</h3>
                        <p>عرض وإدارة المواقع التي أنشأتها على Sity Cloud.</p>
                    </div>
                </a>

                <a href="https://sity.cloud/paket" class="sitycloud-action-card">
                    <div class="sitycloud-action-icon">💳</div>
                    <div class="sitycloud-action-content">
                        <h3>نظام باقتي</h3>
                       <p>عرض نظام باقتك لكي تمكن من الترقيه</p>
                    </div>
                </a>

                <a href="https://sity.cloud/websub" class="sitycloud-action-card sitycloud-action-card-primary">
                    <div class="sitycloud-action-icon">⚡</div>
                    <div class="sitycloud-action-content">
                        <h3>إنشاء موقع جديد</h3>
                        <p>ابدأ موقع جديد لعلامتك التجارية في دقائق وبنفس رصيدك.</p>
                    </div>
                </a>

                <a href="https://sity.cloud/support" class="sitycloud-action-card">
                    <div class="sitycloud-action-icon">💬</div>
                    <div class="sitycloud-action-content">
                        <h3>الدعم الفني</h3>
                        <p>تواصل مع فريق الدعم أو افتح تذكرة جديدة لمشكلتك.</p>
                    </div>
                </a>
            </div>
        </section>
    </div>
</div>

<style>
/* ================================
   Sity Cloud Dashboard – Scoped Styles
   ================================ */

.sitycloud-dashboard {
    position: relative;
    padding: 40px 0 60px;
    min-height: calc(100vh - 160px);
    display: flex;
    align-items: flex-start;
    justify-content: center;
    background:
        radial-gradient(circle at top right, rgba(186, 104, 255, 0.10), transparent 55%),
        radial-gradient(circle at bottom left, rgba(124, 77, 255, 0.15), transparent 55%),
        #f5f3ff;
    box-sizing: border-box;
    font-family: inherit;
}

.sitycloud-dashboard-overlay {
    position: absolute;
    inset: 0;
    pointer-events: none;
    background: linear-gradient(to bottom, rgba(255, 255, 255, 0.70), rgba(255, 255, 255, 0.92));
    z-index: 0;
}

.sitycloud-dashboard-container {
    position: relative;
    z-index: 1;
    width: 100%;
    max-width: 1200px;
    padding: 0 20px;
    box-sizing: border-box;
}

/* Header */
.sitycloud-dashboard-header {
    display: flex;
    flex-wrap: wrap;
    gap: 16px;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 28px;
}

.sitycloud-dashboard-heading {
    margin: 0 0 6px;
    font-size: 28px;
    font-weight: 700;
    color: #261447;
}

.sitycloud-dashboard-subtitle {
    margin: 0;
    font-size: 14px;
    color: #5f5a7a;
    line-height: 1.6;
}

.sitycloud-dashboard-quick-actions {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    justify-content: flex-start;
}

.sitycloud-dashboard-chip {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    border-radius: 999px;
    background: rgba(124, 77, 255, 0.16);
    color: #3d2c8d;
    font-size: 12px;
    font-weight: 500;
    border: 1px solid rgba(124, 77, 255, 0.28);
}

.sitycloud-dashboard-chip-soft {
    background: rgba(38, 20, 71, 0.06);
    color: #4a425f;
    border-color: transparent;
}

/* Main grid */
.sitycloud-dashboard-grid {
    display: grid;
    grid-template-columns: minmax(0, 2fr) minmax(0, 1.1fr) minmax(0, 1.1fr);
    gap: 18px;
    margin-bottom: 32px;
}

@media (max-width: 992px) {
    .sitycloud-dashboard-grid {
        grid-template-columns: minmax(0, 1fr) minmax(0, 1fr);
    }
}

@media (max-width: 768px) {
    .sitycloud-dashboard-grid {
        grid-template-columns: minmax(0, 1fr);
    }
}

/* Cards */
.sitycloud-dashboard-card {
    position: relative;
    border-radius: 18px;
    padding: 18px 18px 20px;
    background: linear-gradient(135deg,
        rgba(255, 255, 255, 0.95),
        rgba(247, 243, 255, 0.99)
    );
    box-shadow:
        0 18px 40px rgba(40, 12, 88, 0.08),
        0 0 0 1px rgba(255, 255, 255, 0.6);
    backdrop-filter: blur(18px);
    -webkit-backdrop-filter: blur(18px);
    border: 1px solid rgba(156, 120, 255, 0.20);
    box-sizing: border-box;
}

.sitycloud-card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 12px;
    margin-bottom: 14px;
}

.sitycloud-card-title {
    margin: 0 0 4px;
    font-size: 18px;
    font-weight: 600;
    color: #2c1b5a;
}

.sitycloud-card-description {
    margin: 0;
    font-size: 13px;
    color: #6b6288;
}

/* Avatar */
.sitycloud-avatar {
    width: 42px;
    height: 42px;
    border-radius: 50%;
    background: radial-gradient(circle at 30% 20%, #ffffff, #b388ff);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #2c1153;
    font-weight: 700;
    font-size: 18px;
    box-shadow: 0 10px 20px rgba(86, 40, 171, 0.35);
}

/* Info rows */
.sitycloud-card-body {
    margin-top: 4px;
}

.sitycloud-info-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 8px;
    padding: 8px 10px;
    border-radius: 10px;
    background: rgba(242, 238, 255, 0.7);
    margin-bottom: 6px;
}

.sitycloud-info-label {
    font-size: 13px;
    color: #5b4a86;
    font-weight: 500;
}

.sitycloud-info-value {
    font-size: 13px;
    color: #2d2347;
    font-weight: 600;
    word-break: break-word;
}

/* Stat cards */
.sitycloud-dashboard-card-stat {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.sitycloud-stat-label {
    margin: 0 0 6px;
    font-size: 14px;
    color: #4a3a7c;
    font-weight: 600;
}

.sitycloud-stat-value-wrap {
    display: flex;
    align-items: flex-end;
    gap: 4px;
    margin-bottom: 6px;
}

.sitycloud-stat-currency {
    font-size: 13px;
    color: #6a5aa0;
}

.sitycloud-stat-value {
    font-size: 22px;
    font-weight: 700;
    color: #2c174f;
}

.sitycloud-stat-value-lg {
    font-size: 26px;
}

.sitycloud-stat-hint {
    margin: 0 0 10px;
    font-size: 12px;
    color: #7a709b;
    line-height: 1.6;
}

/* Buttons */
.sitycloud-dashboard-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    padding: 8px 14px;
    border-radius: 999px;
    font-size: 13px;
    font-weight: 600;
    text-decoration: none;
    cursor: pointer;
    border: none;
    transition: transform 0.14s ease, box-shadow 0.14s ease, background 0.14s ease, color 0.14s ease;
    box-sizing: border-box;
}

.sitycloud-dashboard-btn-primary {
    background: linear-gradient(135deg, #7c4dff, #b388ff);
    color: #ffffff;
    box-shadow: 0 10px 25px rgba(85, 47, 171, 0.35);
}

.sitycloud-dashboard-btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 14px 30px rgba(85, 47, 171, 0.40);
}

.sitycloud-dashboard-btn-outline {
    border: 1px solid rgba(124, 77, 255, 0.60);
    background: transparent;
    color: #4a2f95;
}

.sitycloud-dashboard-btn-outline:hover {
    background: rgba(124, 77, 255, 0.08);
}

/* Not logged in */
.sitycloud-dashboard-not-logged-in {
    background: linear-gradient(135deg, #ede7ff, #ffffff);
}

.sitycloud-dashboard-not-logged-in .sitycloud-dashboard-card {
    text-align: center;
}

.sitycloud-dashboard-title {
    margin: 0 0 8px;
    font-size: 22px;
    color: #261447;
}

.sitycloud-dashboard-text {
    font-size: 14px;
    color: #4c3b73;
    margin-bottom: 16px;
}

/* Quick actions section */
.sitycloud-dashboard-actions {
    margin-top: 4px;
}

.sitycloud-actions-title {
    margin: 0 0 4px;
    font-size: 18px;
    color: #2b1f56;
}

.sitycloud-actions-subtitle {
    margin: 0 0 14px;
    font-size: 13px;
    color: #6c648b;
}

/* Action cards grid */
.sitycloud-actions-grid {
    display: grid;
    grid-template-columns: repeat(4, minmax(0, 1fr));
    gap: 16px;
}

@media (max-width: 992px) {
    .sitycloud-actions-grid {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

@media (max-width: 600px) {
    .sitycloud-actions-grid {
        grid-template-columns: minmax(0, 1fr);
    }
}

.sitycloud-action-card {
    position: relative;
    display: flex;
    gap: 10px;
    align-items: flex-start;
    padding: 14px 14px 16px;
    border-radius: 16px;
    background: rgba(255, 255, 255, 0.97);
    text-decoration: none;
    border: 1px solid rgba(197, 179, 255, 0.6);
    box-shadow: 0 10px 26px rgba(36, 6, 74, 0.06);
    transition: transform 0.15s ease, box-shadow 0.15s ease, background 0.15s ease, border-color 0.15s ease;
    box-sizing: border-box;
}

.sitycloud-action-card-primary {
    background: radial-gradient(circle at top left, rgba(255, 255, 255, 0.95), #c8a8ff);
    border-color: rgba(124, 77, 255, 0.70);
}

.sitycloud-action-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 18px 40px rgba(36, 6, 74, 0.12);
    background: #ffffff;
}

.sitycloud-action-icon {
    width: 34px;
    height: 34px;
    border-radius: 999px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(124, 77, 255, 0.12);
    font-size: 18px;
}

.sitycloud-action-content h3 {
    margin: 0 0 4px;
    font-size: 14px;
    font-weight: 600;
    color: #331b65;
}

.sitycloud-action-content p {
    margin: 0;
    font-size: 12px;
    color: #6b618a;
    line-height: 1.6;
}
</style>

<?php
get_footer();
